/* $XConsortium: Login.c,v 1.42 94/04/17 20:03:53 gildea Exp $ */
/*

   Copyright (c) 1988  X Consortium

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of the X Consortium shall
   not be used in advertising or otherwise to promote the sale, use or
   other dealings in this Software without prior written authorization
   from the X Consortium.

 */

/*
   xdm          -       display manager daemon
   Author:              Keith Packard, MIT X Consortium

   Login.c

   xdm3d        -       3d wrapping
   Author:              ?

   xdm          -       AfterStep/OpenStep login widget
   Author:              mitch@redback.com.au
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Xfuncs.h>

#include <stdio.h>

#include "dm.h"
#include "greet.h"
#include "greeter/LoginP.h"

#ifdef AFTERSTEP
#include "greeter/afterstep.xpm"
#else
#include "greeter/gnustep.xpm"
#endif

#define offset(field) XtOffsetOf(LoginRec, login.field)
#define goffset(field) XtOffsetOf(WidgetRec, core.field)

extern Debug (), ResetLogin (), LogOutOfMem (), RedrawFail ();

static XtResource resources[] =
{
  {XtNwidth, XtCWidth, XtRDimension, sizeof (Dimension),
   goffset (width), XtRImmediate, (XtPointer) 0},
  {XtNheight, XtCHeight, XtRDimension, sizeof (Dimension),
   goffset (height), XtRImmediate, (XtPointer) 0},
  {XtNx, XtCX, XtRPosition, sizeof (Position),
   goffset (x), XtRImmediate, (XtPointer) - 1},
  {XtNy, XtCY, XtRPosition, sizeof (Position),
   goffset (y), XtRImmediate, (XtPointer) - 1},
  {XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (textpixel), XtRString, XtDefaultForeground},
  {XtNpromptColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (promptpixel), XtRString, XtDefaultForeground},
  {XtNgreetColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (greetpixel), XtRString, XtDefaultForeground},
  {XtNfailColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (failpixel), XtRString, XtDefaultForeground},

/* Added by Amit Margalit. */
  {XtNhiColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (hipixel), XtRString, XtDefaultForeground},
  {XtNshdColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (shdpixel), XtRString, XtDefaultForeground},

/* ... and ... */
  {XtNtextBackgroundColor, XtCForeground, XtRPixel, sizeof (Pixel),
   offset (textBgpixel), XtRString, XtDefaultForeground},
  {XtNdisplayLogo, XtCDisplayLogo, XtRBoolean, sizeof (Boolean),
   offset (display_logo), XtRImmediate, (XtPointer) True},

  {XtNframeWidth, XtCFrameWidth, XtRInt, sizeof (int),
   offset (outframewidth), XtRImmediate, (XtPointer) 2},
  {XtNinnerFramesWidth, XtCFrameWidth, XtRInt, sizeof (int),
   offset (inframeswidth), XtRImmediate, (XtPointer) 2},
  {XtNsepWidth, XtCFrameWidth, XtRInt, sizeof (int),
   offset (sepwidth), XtRImmediate, (XtPointer) 2},
  {XtNfont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
   offset (font), XtRString, "*-helvetica-medium-r-normal-*-180-*"},
  {XtNpromptFont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
   offset (promptFont), XtRString, "*-helvetica-bold-r-normal-*-180-*"},
  {XtNgreetFont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
   offset (greetFont), XtRString, "*-helvetica-bold-i-normal-*-240-*"},
  {XtNfailFont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
   offset (failFont), XtRString, "*-helvetica-bold-r-normal-*-180-*"},
#ifdef AFTERSTEP
  {XtNgreeting, XtCGreeting, XtRString, sizeof (char *),
   offset (greeting), XtRString, "AfterStep"},
#else
  {XtNgreeting, XtCGreeting, XtRString, sizeof (char *),
   offset (greeting), XtRString, "GNUStep"},
#endif
  {XtNunsecureGreeting, XtCGreeting, XtRString, sizeof (char *),
   offset (unsecure_greet), XtRString, "This is an unsecure session"},
  {XtNnamePrompt, XtCNamePrompt, XtRString, sizeof (char *),
   offset (namePrompt), XtRString, "   Login  "},
  {XtNpasswdPrompt, XtCPasswdPrompt, XtRString, sizeof (char *),
   offset (passwdPrompt), XtRString, "Password  "},
  {XtNfail, XtCFail, XtRString, sizeof (char *),
   offset (fail), XtRString, "Login incorrect"},
  {XtNfailTimeout, XtCFailTimeout, XtRInt, sizeof (int),
   offset (failTimeout), XtRImmediate, (XtPointer) 10},
  {XtNnotifyDone, XtCCallback, XtRFunction, sizeof (XtPointer),
   offset (notify_done), XtRFunction, (XtPointer) 0},
  {XtNsessionArgument, XtCSessionArgument, XtRString, sizeof (char *),
   offset (sessionArg), XtRString, (XtPointer) 0},
  {XtNsecureSession, XtCSecureSession, XtRBoolean, sizeof (Boolean),
   offset (secure_session), XtRImmediate, False},
  {XtNallowAccess, XtCAllowAccess, XtRBoolean, sizeof (Boolean),
   offset (allow_access), XtRImmediate, False}
};

#undef offset
#undef goffset

#define TEXT_X_INC(w)	((w)->login.font->max_bounds.width)
#define TEXT_Y_INC(w)	((w)->login.font->max_bounds.ascent +\
	(w)->login.font->max_bounds.descent)

#define PROMPT_X_INC(w)	((w)->login.promptFont->max_bounds.width)
#define PROMPT_Y_INC(w)	((w)->login.promptFont->max_bounds.ascent +\
	(w)->login.promptFont->max_bounds.descent)

#define GREET_X_INC(w)	((w)->login.greetFont->max_bounds.width)
/* Adding division. #### */
#define GREET_Y_INC(w)	((((w)->login.greetFont->max_bounds.ascent +\
	(w)->login.greetFont->max_bounds.descent)) / 2)

#define FAIL_X_INC(w)	((w)->login.failFont->max_bounds.width)
#define FAIL_Y_INC(w)	((w)->login.failFont->max_bounds.ascent +\
	(w)->login.failFont->max_bounds.descent)

#define Y_INC(w)	max (TEXT_Y_INC(w), PROMPT_Y_INC(w))

#define LOGIN_PROMPT_W(w) (XTextWidth(w->login.promptFont,\
	w->login.namePrompt,\
	strlen(w->login.namePrompt)) + \
	w->login.inframeswidth)
#define PASS_PROMPT_W(w) (XTextWidth(w->login.promptFont,\
	w->login.passwdPrompt,\
	strlen(w->login.passwdPrompt)) + \
	w->login.inframeswidth)
#define PROMPT_W(w)	(max(LOGIN_PROMPT_W(w), PASS_PROMPT_W(w)))

#define GREETING(w)	((w)->login.secure_session  && !(w)->login.allow_access ?\
	(w)->login.greeting : (w)->login.unsecure_greet)
#define GREET_X(w)	((int)(w->core.width - XTextWidth(w->login.greetFont,\
	GREETING(w), strlen(GREETING(w)))) / 2)
#define GREET_Y(w)	(max(GREETING(w)[0] ? 2 * GREET_Y_INC (w) : 0), \
	(w)->login.logo_xpma.height)
#define GREET_W(w)	(max (XTextWidth(w->login.greetFont,\
	w->login.greeting, strlen(w->login.greeting)), \
	XTextWidth(w->login.greetFont,\
	w->login.unsecure_greet, strlen(w->login.unsecure_greet))))

#define LOGIN_X(w)	(2 * PROMPT_X_INC(w))
#define LOGIN_Y(w)	(GREET_Y(w) + GREET_Y_INC(w) +\
	w->login.greetFont->max_bounds.ascent + Y_INC(w))
#define LOGIN_W(w)	(w->core.width - 6 * TEXT_X_INC(w))
#define LOGIN_H(w)	(3 * Y_INC(w) / 2)
#define LOGIN_TEXT_X(w)(LOGIN_X(w) + PROMPT_W(w))

#define PASS_X(w)	(LOGIN_X(w))
/*
   #define PASS_X(w)    ((max(XTextWidth(w->login.promptFont,\
   w->login.namePrompt,\
   strlen(w->login.namePrompt)),\
   XTextWidth(w->login.promptFont,\
   w->login.passwdPrompt,\
   strlen(w->login.passwdPrompt)))) -\
   XTextWidth(w->login.promptFont,\
   w->login.passwdPrompt,\
   strlen(w->login.namePrompt)) +\
   (2 * PROMPT_X_INC(w)))
 */

#define PASS_Y(w)	(LOGIN_Y(w) + 10 * Y_INC(w) / 5)
#define PASS_Y_INC(w)	((w)->login.failFont->max_bounds.ascent +\
	(w)->login.failFont->max_bounds.descent)
#define PASS_W(w)	(LOGIN_W(w))
#define PASS_H(w)	(LOGIN_H(w))
#define PASS_TEXT_X(w)	(PASS_X(w) + PROMPT_W(w))
#define FAIL_X(w)	((int)(w->core.width - XTextWidth (w->login.failFont,\
	w->login.fail, strlen (w->login.fail))) / 2)
#define FAIL_Y(w)	(PASS_Y(w) + 2 * FAIL_Y_INC (w) +\
	w->login.failFont->max_bounds.ascent)
#define FAIL_W(w)	(XTextWidth (w->login.failFont,\
	w->login.fail, strlen (w->login.fail)))

#define PAD_X(w)	(2 * (LOGIN_X(w) + max(GREET_X_INC(w), FAIL_X_INC(w))))
#define PAD_Y(w)	(max (max(Y_INC(w), GREET_Y_INC(w)), FAIL_Y_INC(w)))

static void Initialize ();
static void Realize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();
static void DrawIt ();

static int 
max (a, b)
{
  return a > b ? a : b;
}

/* Should actually calculate the offset from the stem width of the font. */

static void 
DrawEmboss (LoginWidget w, GC normalGC, GC highlightGC, GC shadeGC,
	    char *str, int x, int y, Boolean raised)
{
  XDrawString (XtDisplay (w),
	       XtWindow (w),
	       shadeGC,
	       (raised == True) ? x + 2 : x - 2,
	       (raised == True) ? y + 2 : y - 2,
	       str,
	       strlen (str));

  XDrawString (XtDisplay (w),
	       XtWindow (w),
	       highlightGC,
	       (raised == True) ? x - 2 : x + 2,
	       (raised == True) ? y - 2 : y + 2,
	       str,
	       strlen (str));

  XDrawString (XtDisplay (w),
	       XtWindow (w),
	       normalGC,
	       x,
	       y,
	       str,
	       strlen (str));
}

/* Adding textGbGC for white background. #### */
/* w->login.textBgGC for erase, w->login.textGC for drawing. */

static void 
RenderField (LoginWidget w, GC currGC, int cursor, char *str,
	     int yoffset)
{
  int x;

  x = LOGIN_TEXT_X (w);
  if (cursor > 0)
    {
      x += XTextWidth (w->login.font, str, cursor);
    }

  XDrawString (XtDisplay (w),
	       XtWindow (w),
	       currGC,
	       x,
	       yoffset,
	       str + cursor,
	       strlen (str + cursor));
}

static void 
RenderSeparator (LoginWidget w, GC hiGC, GC shdGC, int x, int y,
		 int width)
{
  int i;

  for (i = 1; i <= (w->login.sepwidth); i++)
    {
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 shdGC,
		 x,
		 y + i - 1,
		 x + width,
		 y + i - 1);
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 hiGC,
		 x,
		 y + 2 * (w->login.inframeswidth) - i,
		 x + width,
		 y + 2 * (w->login.inframeswidth) - i);
    }
}

static void 
realizeCursor (LoginWidget w, GC gc)
{
  int x;
  int y;
  int height;
  int width;
  char *str;

  switch (w->login.state)
    {
    case GET_NAME:
      x = LOGIN_TEXT_X (w);
      y = LOGIN_Y (w);
      str = w->login.data.name;
      break;
    case GET_PASSWD:
      x = PASS_TEXT_X (w);
      y = PASS_Y (w);
      /* Adding for cursor movement in password field. #### */
      str = w->login.data.bogus;
      break;
    default:
      return;
    }

  if (w->login.cursor > 0)
    {
      x += XTextWidth (w->login.font, str, w->login.cursor);
    }

  /* Extracted these from above. Merely repetitious. */
  height = w->login.font->max_bounds.ascent +
    w->login.font->max_bounds.descent;
  width = 1;

  /* Draw cursor? */

  XFillRectangle (XtDisplay (w),
		  XtWindow (w),
		  gc,
		  x,
		  y + 1 - w->login.font->max_bounds.ascent,
		  width,
		  height - 1);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x - 1,
	      y - w->login.font->max_bounds.ascent);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x + 1,
	      y - w->login.font->max_bounds.ascent);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x - 1,
	      y - w->login.font->max_bounds.ascent + height);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x + 1,
	      y - w->login.font->max_bounds.ascent + height);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x - 2,
	      y - w->login.font->max_bounds.ascent);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x + 2,
	      y - w->login.font->max_bounds.ascent);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x - 2,
	      y - w->login.font->max_bounds.ascent + height);
  XDrawPoint (XtDisplay (w),
	      XtWindow (w),
	      gc,
	      x + 2,
	      y - w->login.font->max_bounds.ascent + height);
}

static void 
EraseFail (LoginWidget w)
{
  int x = FAIL_X (w);
  int y = FAIL_Y (w);

  XSetForeground (XtDisplay (w),
		  w->login.failGC,
		  w->core.background_pixel);

  XDrawString (XtDisplay (w),
	       XtWindow (w),
	       w->login.failGC,
	       x,
	       y,
	       w->login.fail,
	       strlen (w->login.fail));

  w->login.failUp = 0;

  XSetForeground (XtDisplay (w),
		  w->login.failGC,
		  w->login.failpixel);
}

static void 
XorCursor (LoginWidget w)
{
  realizeCursor (w, w->login.xorGC);
}

static void 
RemoveFail (LoginWidget w)
{
  if (w->login.failUp)
    {
      EraseFail (w);
    }
}

static void 
EraseCursor (LoginWidget w)
{
  realizeCursor (w, w->login.bgGC);
}

/*ARGSUSED */
void 
failTimeout (XtPointer client_data, XtIntervalId * id)
{
  LoginWidget w = (LoginWidget) client_data;

  Debug ("failTimeout\n");
  EraseFail (w);
}

int 
DrawFail (Widget ctx)
{
  LoginWidget w;

  w = (LoginWidget) ctx;
  XorCursor (w);
  ResetLogin (w);
  XorCursor (w);
  w->login.failUp = 1;
  RedrawFail (w);

  if (w->login.failTimeout > 0)
    {
      Debug ("failTimeout: %d\n", w->login.failTimeout);
      XtAppAddTimeOut (XtWidgetToApplicationContext ((Widget) w),
		       w->login.failTimeout * 1000,
		       failTimeout,
		       (XtPointer) w);
    }
  return 0;
}

/* Alter fail done here? */

int 
RedrawFail (LoginWidget w)
{
  int x = FAIL_X (w);
  int y = FAIL_Y (w);

  if (w->login.failUp)
    {
      XDrawString (XtDisplay (w),
		   XtWindow (w),
		   w->login.failGC,
		   x,
		   y,
		   w->login.fail,
		   strlen (w->login.fail));
    }
  return 0;
}

static void 
DrawIt (LoginWidget w)
{
  int i;
  int in_frame_x, in_login_y, in_pass_y, in_width, in_height;
  int gr_line_x, gr_line_y, gr_line_w;

  EraseCursor (w);

  if ((w->login.outframewidth) < 1)
    {
      w->login.outframewidth = 1;
    }

  /* Top level window. */
  for (i = 1; i <= (w->login.outframewidth); i++)
    {
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 i - 1,
		 i - 1,
		 w->core.width - i,
		 i - 1);
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 i - 1,
		 i - 1,
		 i - 1,
		 w->core.height - i);
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 w->core.width - i,
		 i - 1,
		 w->core.width - i,
		 w->core.height - i);
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 i - 1,
		 w->core.height - i,
		 w->core.width - i,
		 w->core.height - i);
    }

  /* Make separator line. #### */
  RenderSeparator (w,
		   w->login.hiGC,
		   w->login.shdGC,
		   w->login.outframewidth,
		   GREET_Y (w) + GREET_Y_INC (w),
		   w->core.width - 2 * (w->login.outframewidth));

  in_frame_x = LOGIN_TEXT_X (w) - w->login.inframeswidth - 3;
  in_login_y = LOGIN_Y (w) - w->login.inframeswidth - 1 - TEXT_Y_INC (w);
  in_pass_y = PASS_Y (w) - w->login.inframeswidth - 1 - TEXT_Y_INC (w);

  in_width = LOGIN_W (w) - PROMPT_W (w);
  in_height = LOGIN_H (w) + w->login.inframeswidth + 2;

  /* Draw login/password boxes. */
  for (i = 1; i <= (w->login.inframeswidth); i++)
    {
      /* Make top/left sides */
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 in_frame_x + i - 1,
		 in_login_y + i - 1,
		 in_frame_x + in_width - i,
		 in_login_y + i - 1);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 in_frame_x + i - 1,
		 in_login_y + i - 1,
		 in_frame_x + i - 1,
		 in_login_y + in_height - i);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 in_frame_x + in_width - i,
		 in_login_y + i - 1,
		 in_frame_x + in_width - i,
		 in_login_y + in_height - i);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 in_frame_x + i - 1,
		 in_login_y + in_height - i,
		 in_frame_x + in_width - i,
		 in_login_y + in_height - i);

      /* Make bottom/right sides */
      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 in_frame_x + i - 1,
		 in_pass_y + i - 1,
		 in_frame_x + in_width - i,
		 in_pass_y + i - 1);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.shdGC,
		 in_frame_x + i - 1,
		 in_pass_y + i - 1,
		 in_frame_x + i - 1,
		 in_pass_y + in_height - i);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 in_frame_x + in_width - i,
		 in_pass_y + i - 1,
		 in_frame_x + in_width - i,
		 in_pass_y + in_height - i);

      XDrawLine (XtDisplay (w),
		 XtWindow (w),
		 w->login.hiGC,
		 in_frame_x + i - 1,
		 in_pass_y + in_height - i,
		 in_frame_x + in_width - i,
		 in_pass_y + in_height - i);
    }

  /* Adding pixmap logo. */
  if (w->login.display_logo)
    {
      XCopyArea (XtDisplay (w),
		 w->login.logopixmap,
		 XtWindow (w),
		 w->login.logoGC,
		 0,
		 0,
		 w->login.logo_xpma.width,
		 w->login.logo_xpma.height,
		 w->login.inframeswidth,
		 w->login.inframeswidth);
    }

  /* Adding login background. #### */
  XFillRectangle (XtDisplay (w),
		  XtWindow (w),
		  w->login.textBgGC,
		  in_frame_x + w->login.inframeswidth,
		  in_login_y + w->login.inframeswidth,
		  in_width - (2 * w->login.inframeswidth),
		  in_height - (2 * w->login.inframeswidth));

  /* Adding password background. #### */
  XFillRectangle (XtDisplay (w),
		  XtWindow (w),
		  w->login.textBgGC,
		  in_frame_x + w->login.inframeswidth,
		  in_pass_y + w->login.inframeswidth,
		  in_width - (2 * w->login.inframeswidth),
		  in_height - (2 * w->login.inframeswidth));

  /* Try to make the header embossed 3D. #### */

  if (GREETING (w)[0])
    {
      DrawEmboss (w,
		  w->login.greetGC,
		  w->login.greetHiGC,
		  w->login.greetShdGC,
		  GREETING (w),
		  GREET_X (w),
		  GREET_Y (w),
		  True);
    }

  DrawEmboss (w,
	      w->login.promptGC,
	      w->login.promptHiGC,
	      w->login.promptShdGC,
	      w->login.namePrompt,
	      LOGIN_X (w),
	      LOGIN_Y (w),
	      False);

  DrawEmboss (w,
	      w->login.promptGC,
	      w->login.promptHiGC,
	      w->login.promptShdGC,
	      w->login.passwdPrompt,
	      PASS_X (w),
	      PASS_Y (w),
	      False);

  /* Try drawing a second spearator here. #### */
  RenderSeparator (w,
		   w->login.hiGC,
		   w->login.shdGC,
		   w->login.outframewidth,
		   PASS_Y (w) + PASS_Y_INC (w),
		   w->core.width - 2 * (w->login.outframewidth));

  RedrawFail (w);
  RenderField (w, w->login.textGC, 0, w->login.data.name, LOGIN_Y (w));
  XorCursor (w);

  /*
     The GrabKeyboard here is needed only because of a bug in the R3 
     server -- the keyboard is grabbed on the root window, and the 
     server won't dispatch events to the focus window unless the focus 
     window is a ancestor of the grab window. Bug in server already 
     found and fixed, compatibility until at least R4.
   */

  if (XGrabKeyboard (XtDisplay (w), XtWindow (w), False, GrabModeAsync,
		     GrabModeAsync, CurrentTime) != GrabSuccess)
    {
      XSetInputFocus (XtDisplay (w),
		      XtWindow (w),
		      RevertToPointerRoot,
		      CurrentTime);
    }
}

/*ARGSUSED */
static void 
DeleteBackwardChar (Widget ctxw, XEvent * event, String * params,
		    Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;
  char *str;
  int yoffset;

  XorCursor (ctx);
  RemoveFail (ctx);

  if (ctx->login.cursor > 0)
    {
      ctx->login.cursor--;
      switch (ctx->login.state)
	{
	case GET_NAME:
	  str = ctx->login.data.name;
	  yoffset = LOGIN_Y (ctx);
	  break;
	case GET_PASSWD:
	  strcpy (ctx->login.data.passwd + ctx->login.cursor,
		  ctx->login.data.passwd + ctx->login.cursor + 1);
	  str = ctx->login.data.bogus;
	  yoffset = PASS_Y (ctx);
	  break;
	}

      /* Assuming login.state can only have these 2 values. */
      /* Adding for '*' #### */
      RenderField (ctx,
		   ctx->login.textBgGC,
		   ctx->login.cursor,
		   str,
		   yoffset);
      strcpy (str + ctx->login.cursor, str + ctx->login.cursor + 1);
      RenderField (ctx,
		   ctx->login.textGC,
		   ctx->login.cursor,
		   str,
		   yoffset);
    }

  XorCursor (ctx);
}

/*ARGSUSED */
static void 
DeleteForwardChar (Widget ctxw, XEvent * event, String * params,
		   Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;
  char *str;
  int yoffset;

  XorCursor (ctx);
  RemoveFail (ctx);

  switch (ctx->login.state)
    {
    case GET_NAME:
      if (ctx->login.cursor < (int) strlen (ctx->login.data.name))
	{
	  str = ctx->login.data.name;
	  yoffset = PASS_Y (ctx);
	}
      break;
    case GET_PASSWD:
      if (ctx->login.cursor < (int) strlen (ctx->login.data.passwd))
	{
	  strcpy (ctx->login.data.passwd + ctx->login.cursor,
		  ctx->login.data.passwd + ctx->login.cursor + 1);
	  /* Adding for '*' #### */
	  str = ctx->login.data.bogus;
	  yoffset = PASS_Y (ctx);
	}
      break;
    }

  if (ctx->login.cursor < (int) strlen (str))
    {
      RenderField (ctx,
		   ctx->login.textBgGC,
		   ctx->login.cursor,
		   str,
		   yoffset);
      strcpy (str + ctx->login.cursor, str + ctx->login.cursor + 1);
      RenderField (ctx,
		   ctx->login.textGC,
		   ctx->login.cursor,
		   str,
		   yoffset);
    }

  XorCursor (ctx);
}

/*ARGSUSED */
static void 
MoveBackwardChar (Widget ctxw, XEvent * event, String * params,
		  Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  if (ctx->login.cursor > 0)
    {
      ctx->login.cursor--;
    }
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
MoveForwardChar (Widget ctxw, XEvent * event, String * params,
		 Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);

  switch (ctx->login.state)
    {
    case GET_NAME:
      if (ctx->login.cursor < (int) strlen (ctx->login.data.name))
	{
	  ++ctx->login.cursor;
	}
      break;
    case GET_PASSWD:
      if (ctx->login.cursor < (int) strlen (ctx->login.data.passwd))
	{
	  ++ctx->login.cursor;
	}
      break;
    }

  XorCursor (ctx);
}

/*ARGSUSED */
static void 
MoveToBegining (Widget ctxw, XEvent * event, String * params,
		Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  ctx->login.cursor = 0;
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
MoveToEnd (Widget ctxw, XEvent * event, String * params,
	   Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);

  switch (ctx->login.state)
    {
    case GET_NAME:
      ctx->login.cursor = strlen (ctx->login.data.name);
      break;
    case GET_PASSWD:
      ctx->login.cursor = strlen (ctx->login.data.passwd);
      break;
    }

  XorCursor (ctx);
}

/*ARGSUSED */
static void 
EraseToEndOfLine (Widget ctxw, XEvent * event, String * params,
		  Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);

  switch (ctx->login.state)
    {
    case GET_NAME:
      RenderField (ctx, ctx->login.textBgGC, ctx->login.cursor,
		   ctx->login.data.name, LOGIN_Y (ctx));
      ctx->login.data.name[ctx->login.cursor] = '\0';
      break;
    case GET_PASSWD:
      ctx->login.data.passwd[ctx->login.cursor] = '\0';

      /* Adding for '*' #### */
      RenderField (ctx, ctx->login.textBgGC, ctx->login.cursor,
		   ctx->login.data.bogus, PASS_Y (ctx));
      ctx->login.data.bogus[ctx->login.cursor] = '\0';

      break;
    }
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
EraseLine (Widget ctxw, XEvent * event, String * params,
	   Cardinal * num_params)
{
  MoveToBegining (ctxw, event, params, num_params);
  EraseToEndOfLine (ctxw, event, params, num_params);
}

/*ARGSUSED */
static void 
FinishField (Widget ctxw, XEvent * event, String * params,
	     Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  switch (ctx->login.state)
    {
    case GET_NAME:
      ctx->login.state = GET_PASSWD;
      ctx->login.cursor = 0;
      break;
    case GET_PASSWD:
      ctx->login.state = DONE;
      ctx->login.cursor = 0;
      (*ctx->login.notify_done) (ctx, &ctx->login.data, NOTIFY_OK);
      break;
    }
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
AllowAccess (Widget ctxw, XEvent * event, String * params,
	     Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;
  Arg arglist[1];
  Boolean allow;

  RemoveFail (ctx);
  XtSetArg (arglist[0], XtNallowAccess, (char *) &allow);
  XtGetValues ((Widget) ctx, arglist, 1);
  XtSetArg (arglist[0], XtNallowAccess, !allow);
  XtSetValues ((Widget) ctx, arglist, 1);
}

/*ARGSUSED */
static void 
SetSessionArgument (Widget ctxw, XEvent * event, String * params,
		    Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  RemoveFail (ctx);
  if (ctx->login.sessionArg)
    {
      XtFree (ctx->login.sessionArg);
    }
  ctx->login.sessionArg = 0;

  if (*num_params > 0)
    {
      ctx->login.sessionArg = XtMalloc (strlen (params[0]) + 1);
      if (ctx->login.sessionArg)
	{
	  strcpy (ctx->login.sessionArg, params[0]);
	}
      else
	{
	  LogOutOfMem ("set session argument");
	}
    }
}

/*ARGSUSED */
static void 
RestartSession (Widget ctxw, XEvent * event, String * params,
		Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  ctx->login.state = DONE;
  ctx->login.cursor = 0;
  (*ctx->login.notify_done) (ctx, &ctx->login.data, NOTIFY_RESTART);
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
AbortSession (Widget ctxw, XEvent * event, String * params,
	      Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  ctx->login.state = DONE;
  ctx->login.cursor = 0;
  (*ctx->login.notify_done) (ctx, &ctx->login.data, NOTIFY_ABORT);
  XorCursor (ctx);
}

/*ARGSUSED */
static void 
AbortDisplay (Widget ctxw, XEvent * event, String * params,
	      Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;

  XorCursor (ctx);
  RemoveFail (ctx);
  ctx->login.state = DONE;
  ctx->login.cursor = 0;
  (*ctx->login.notify_done) (ctx, &ctx->login.data, NOTIFY_ABORT_DISPLAY);
  XorCursor (ctx);
}

int 
ResetLogin (LoginWidget w)
{
  RenderField (w, w->login.textBgGC, 0, w->login.data.name, LOGIN_Y (w));
  w->login.cursor = 0;
  w->login.data.name[0] = '\0';
  w->login.data.passwd[0] = '\0';

  /* Adding for '*' #### */
  RenderField (w, w->login.textBgGC, 0, w->login.data.bogus, PASS_Y (w));
  w->login.data.bogus[0] = '\0';

  w->login.state = GET_NAME;

  return 0;
}

/* ARGSUSED */
static void 
InsertChar (Widget ctxw, XEvent * event, String * params,
	    Cardinal * num_params)
{
  LoginWidget ctx = (LoginWidget) ctxw;
  char strbuf[128];
  int len;
  int pixels;

  len = XLookupString (&event->xkey, strbuf, sizeof (strbuf), 0, 0);
  strbuf[len] = '\0';

  pixels = 3 + ctx->login.font->max_bounds.width * len +
    XTextWidth (ctx->login.font,
		ctx->login.data.name,
		strlen (ctx->login.data.name));

  /* pixels to be added */

  switch (ctx->login.state)
    {
    case GET_NAME:
      /* && (pixels <= LOGIN_W(ctx) - PROMPT_W(ctx)) */
      if ((len + (int) strlen (ctx->login.data.name) >= NAME_LEN - 1))
	{
	  len = NAME_LEN - strlen (ctx->login.data.name) - 2;
	}
    case GET_PASSWD:
      if (len + (int) strlen (ctx->login.data.passwd) >= NAME_LEN - 1)
	{
	  len = NAME_LEN - strlen (ctx->login.data.passwd) - 2;
	}
    }

  if (len == 0 || pixels >= LOGIN_W (ctx) - PROMPT_W (ctx))
    {
      return;
    }

  XorCursor (ctx);
  RemoveFail (ctx);

  switch (ctx->login.state)
    {
    case GET_NAME:
      RenderField (ctx, ctx->login.textBgGC, ctx->login.cursor,
		   ctx->login.data.name, LOGIN_Y (ctx));
      ctx->login.data.name[ctx->login.cursor] = '\0';
      memmove (ctx->login.data.name + ctx->login.cursor + len,
	       ctx->login.data.name + ctx->login.cursor,
	       strlen (ctx->login.data.name + ctx->login.cursor) + 1);
      memmove (ctx->login.data.name + ctx->login.cursor, strbuf, len);
      RenderField (ctx, ctx->login.textGC, ctx->login.cursor,
		   ctx->login.data.name, LOGIN_Y (ctx));
      ctx->login.cursor += len;
      break;
    case GET_PASSWD:
      memmove (ctx->login.data.passwd + ctx->login.cursor + len,
	       ctx->login.data.passwd + ctx->login.cursor,
	       strlen (ctx->login.data.passwd + ctx->login.cursor) + 1);
      memmove (ctx->login.data.passwd + ctx->login.cursor, strbuf, len);

      /* Adding for '*' #### */
      RenderField (ctx, ctx->login.textBgGC, ctx->login.cursor,
		   ctx->login.data.bogus, PASS_Y (ctx));
      memmove (ctx->login.data.bogus + ctx->login.cursor + len,
	       ctx->login.data.bogus + ctx->login.cursor,
	       strlen (ctx->login.data.bogus + ctx->login.cursor) + 1);
      memset (strbuf, '*', len);
      strbuf[len] = '\0';
      memmove (ctx->login.data.bogus + ctx->login.cursor, strbuf, len);
      RenderField (ctx, ctx->login.textGC, ctx->login.cursor,
		   ctx->login.data.bogus, PASS_Y (ctx));
      ctx->login.cursor += len;
      break;
    }

  XorCursor (ctx);
}

/* ARGSUSED */
static void 
Initialize (Widget greq, Widget gnew, ArgList args,
	    Cardinal * num_args)
{
  LoginWidget w = (LoginWidget) gnew;
  XtGCMask valuemask, xvaluemask;
  XGCValues myXGCV;
  Arg position[2];
  Position x;
  Position y;

  /* Adding for text background. #### */
  Display *dpy = XtDisplay (w);
  int screen = DefaultScreen (dpy);

  myXGCV.foreground = w->login.hipixel;
  myXGCV.background = w->core.background_pixel;
  valuemask = GCForeground | GCBackground;
  w->login.hiGC = XtGetGC (gnew, valuemask, &myXGCV);

  myXGCV.foreground = w->login.shdpixel;
  myXGCV.background = w->core.background_pixel;
  valuemask = GCForeground | GCBackground;
  w->login.shdGC = XtGetGC (gnew, valuemask, &myXGCV);

  myXGCV.foreground = w->login.textpixel;
  myXGCV.background = w->core.background_pixel;
  valuemask = GCForeground | GCBackground;
  if (w->login.font)
    {
      myXGCV.font = w->login.font->fid;
      valuemask |= GCFont;
    }
  w->login.textGC = XtGetGC (gnew, valuemask, &myXGCV);

  /* Adding for text background. #### */
  if (w->login.textBgpixel)
    {
      myXGCV.foreground = w->login.textBgpixel;
    }
  else
    {
      myXGCV.foreground = WhitePixel (dpy, screen);
    }
  w->login.textBgGC = XtGetGC (gnew, valuemask, &myXGCV);

  myXGCV.foreground = w->core.background_pixel;
  w->login.bgGC = XtGetGC (gnew, valuemask, &myXGCV);

  myXGCV.foreground = w->login.textpixel ^ w->core.background_pixel;
  myXGCV.function = GXxor;
  xvaluemask = valuemask | GCFunction;
  w->login.xorGC = XtGetGC (gnew, xvaluemask, &myXGCV);

/* Adding xpm logo. #### */
  if (w->login.display_logo)
    {
      w->login.logoGC = XtGetGC (gnew, 0, NULL);
      w->login.xpmcs[0].name = NULL;
      w->login.xpmcs[0].value = "None";
      w->login.xpmcs[0].pixel = w->core.background_pixel;
      w->login.logo_xpma.valuemask = XpmInfos | XpmColorSymbols;
      w->login.logo_xpma.colorsymbols = &w->login.xpmcs[0];
      w->login.logo_xpma.numsymbols = 1;
      XpmCreatePixmapFromData (XtDisplay (w),
			       DefaultRootWindow (XtDisplay (w)),
			       login_icon,	/* Logo pixmap variable name. */
			       &w->login.logopixmap,
			       NULL,
			       &w->login.logo_xpma);
    }

  /*
     Note that the second argument is a GCid -- QueryFont accepts a 
     GCid and returns the currently contained font.
   */

  if (!(w->login.font))
    {
      w->login.font = XQueryFont (XtDisplay (w),
		       XGContextFromGC (XDefaultGCOfScreen (XtScreen (w))));
    }

  xvaluemask = valuemask;
  if (!(w->login.promptFont))
    {
      w->login.promptFont = w->login.font;
    }
  else
    {
      xvaluemask |= GCFont;
    }

  myXGCV.foreground = w->login.promptpixel;
  myXGCV.font = w->login.promptFont->fid;
  w->login.promptGC = XtGetGC (gnew, xvaluemask, &myXGCV);

  /* Adding for prompt embossing. #### */
  myXGCV.foreground = w->login.hipixel;
  w->login.promptHiGC = XtGetGC (gnew, xvaluemask, &myXGCV);

  /* Adding for prompt embossing. #### */
  myXGCV.foreground = w->login.shdpixel;
  w->login.promptShdGC = XtGetGC (gnew, xvaluemask, &myXGCV);

  /* Try to alter the font. #### */
  xvaluemask = valuemask;
  if (!(w->login.greetFont))
    {
      if (!(w->login.greetFont = XLoadQueryFont (XtDisplay (w),
	      "-adobe-helvetica-bold-i-normal--0-360-75-75-p-0-iso8895-1")))
	{
	  w->login.greetFont = w->login.font;
	}
      else
	{
	  xvaluemask |= GCFont;
	}
    }
  else
    {
      xvaluemask |= GCFont;
    }

  myXGCV.foreground = w->login.greetpixel;
  myXGCV.font = w->login.greetFont->fid;
  w->login.greetGC = XtGetGC (gnew, xvaluemask, &myXGCV);

  /* Adding for greeting embossing. #### */
  myXGCV.foreground = w->login.hipixel;
  w->login.greetHiGC = XtGetGC (gnew, valuemask, &myXGCV);

  /* Adding for greeting embossing. #### */
  myXGCV.foreground = w->login.shdpixel;
  w->login.greetShdGC = XtGetGC (gnew, valuemask, &myXGCV);

  xvaluemask = valuemask;
  if (w->login.failFont == NULL)
    {
      w->login.failFont = w->login.font;
    }
  else
    {
      xvaluemask |= GCFont;
    }

  myXGCV.foreground = w->login.failpixel;
  myXGCV.font = w->login.failFont->fid;
  w->login.failGC = XtGetGC (gnew, xvaluemask, &myXGCV);

  w->login.data.name[0] = '\0';
  w->login.data.passwd[0] = '\0';

  /* Adding for '*'. #### */
  w->login.data.bogus[0] = '\0';

  w->login.state = GET_NAME;
  w->login.cursor = 0;
  w->login.failUp = 0;

  if (!(w->core.width))
    {
      w->core.width = max (GREET_W (w), FAIL_W (w)) + PAD_X (w);
    }

  if (w->core.height == 0)
    {
      int fy = FAIL_Y (w);
      int pady = PAD_Y (w);

      w->core.height = fy + pady;	/* for stupid compilers */
    }

  if ((x = w->core.x) == -1)
    {
      x = (int) (XWidthOfScreen (XtScreen (w)) - w->core.width) / 2;
    }
  if ((y = w->core.y) == -1)
    {
      y = (int) (XHeightOfScreen (XtScreen (w)) - w->core.height) / 3;
    }

  XtSetArg (position[0], XtNx, x);
  XtSetArg (position[1], XtNy, y);
  XtSetValues (XtParent (w), position, (Cardinal) 2);
}


static void 
Realize (Widget gw, XtValueMask * valueMask,
	 XSetWindowAttributes * attrs)
{
  XtCreateWindow (gw,
		  (unsigned) InputOutput,
		  (Visual *) CopyFromParent,
		  *valueMask,
		  attrs);
}

static void 
Destroy (Widget gw)
{
  LoginWidget w = (LoginWidget) gw;

  bzero (w->login.data.name, NAME_LEN);
  bzero (w->login.data.passwd, NAME_LEN);

  /* Adding these. */
  bzero (w->login.data.bogus, NAME_LEN);

  XtReleaseGC (gw, w->login.textGC);
  XtReleaseGC (gw, w->login.bgGC);
  XtReleaseGC (gw, w->login.xorGC);
  XtReleaseGC (gw, w->login.promptGC);
  XtReleaseGC (gw, w->login.greetGC);
  XtReleaseGC (gw, w->login.failGC);
  XtReleaseGC (gw, w->login.hiGC);
  XtReleaseGC (gw, w->login.shdGC);

  /* Adding these. */
  XtReleaseGC (gw, w->login.greetHiGC);
  XtReleaseGC (gw, w->login.greetShdGC);
  XtReleaseGC (gw, w->login.promptHiGC);
  XtReleaseGC (gw, w->login.promptShdGC);

  if (w->login.display_logo)
    {
      XFreePixmap (XtDisplay (w), w->login.logopixmap);
    }
}

/* ARGSUSED */
static void 
Redisplay (Widget gw, XEvent * event, Region region)
{
  DrawIt ((LoginWidget) gw);
}

/*ARGSUSED */
static Boolean 
SetValues (Widget current, Widget request, Widget new,
	   ArgList args, Cardinal * num_args)
{
  LoginWidget currentL;
  LoginWidget newL;

  currentL = (LoginWidget) current;
  newL = (LoginWidget) new;
  if (GREETING (currentL) != GREETING (newL))
    {
      return True;
    }
  return False;
}

char defaultLoginTranslations[] =
"\
Ctrl<Key>H:	delete-previous-character() \n\
Ctrl<Key>D:	delete-character() \n\
Ctrl<Key>B:	move-backward-character() \n\
Ctrl<Key>F:	move-forward-character() \n\
Ctrl<Key>A:	move-to-begining() \n\
Ctrl<Key>E:	move-to-end() \n\
Ctrl<Key>K:	erase-to-end-of-line() \n\
Ctrl<Key>U:	erase-line() \n\
Ctrl<Key>X:	erase-line() \n\
Ctrl<Key>C:	restart-session() \n\
Ctrl<Key>\\\\:	abort-session() \n\
:Ctrl<Key>plus:	allow-all-access() \n\
<Key>BackSpace:	delete-previous-character() \n\
<Key>Delete:	delete-previous-character() \n\
<Key>Return:	finish-field() \n\
<Key>:		insert-char() \
";

XtActionsRec loginActionsTable[] =
{
  {"delete-previous-character", DeleteBackwardChar},
  {"delete-character", DeleteForwardChar},
  {"move-backward-character", MoveBackwardChar},
  {"move-forward-character", MoveForwardChar},
  {"move-to-begining", MoveToBegining},
  {"move-to-end", MoveToEnd},
  {"erase-to-end-of-line", EraseToEndOfLine},
  {"erase-line", EraseLine},
  {"finish-field", FinishField},
  {"abort-session", AbortSession},
  {"abort-display", AbortDisplay},
  {"restart-session", RestartSession},
  {"insert-char", InsertChar},
  {"set-session-argument", SetSessionArgument},
  {"allow-all-access", AllowAccess},
};

LoginClassRec loginClassRec =
{
  {				/* core fields */
    /* superclass               */ &widgetClassRec,
    /* class_name               */ "Login",
    /* size                     */ sizeof (LoginRec),
    /* class_initialize         */ NULL,
    /* class_part_initialize    */ NULL,
    /* class_inited             */ FALSE,
    /* initialize               */ Initialize,
    /* initialize_hook          */ NULL,
    /* realize                  */ Realize,
    /* actions                  */ loginActionsTable,
    /* num_actions              */ XtNumber (loginActionsTable),
    /* resources                */ resources,
    /* num_resources            */ XtNumber (resources),
    /* xrm_class                */ NULLQUARK,
    /* compress_motion          */ TRUE,
    /* compress_exposure        */ TRUE,
    /* compress_enterleave      */ TRUE,
    /* visible_interest         */ FALSE,
    /* destroy                  */ Destroy,
    /* resize                   */ NULL,
    /* expose                   */ Redisplay,
    /* set_values               */ SetValues,
    /* set_values_hook          */ NULL,
    /* set_values_almost        */ NULL,
    /* get_values_hook          */ NULL,
    /* accept_focus             */ NULL,
    /* version                  */ XtVersion,
    /* callback_private         */ NULL,
    /* tm_table                 */ defaultLoginTranslations,
    /* query_geometry           */ XtInheritQueryGeometry,
    /* display_accelerator      */ XtInheritDisplayAccelerator,
    /* extension                */ NULL
  }
};

WidgetClass loginWidgetClass = (WidgetClass) & loginClassRec;
