/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
 
#include "xpm.h"
#include "ascp.h"


/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */
/*----------------------------------*/

static FILE *IoFile;

/* The Style. */
/*----------------------------------*/
static GtkWidget *AnimBallParent[2];

static GtkWidget *Animate;
static GtkWidget *AnimateMain;
static GtkWidget *AnimateDelaySpinner;
static GtkWidget *AnimateStepsSpinner;
static GtkWidget *AnimateDelayMainSpinner;
static GtkWidget *AnimateStepsMainSpinner;

static GtkWidget *Balloons; 
static GtkWidget *BalloonFore;
static GtkWidget *BalloonBack;
static GtkWidget *BalloonFont;
static GtkWidget *BalloonDelay; 
static GtkWidget *BalloonBorderColor;
static GtkWidget *BalloonBorderWidth; 
static GtkAdjustment *BalloonYOffset;

static GtkWidget *PushWharf; 
static GtkWidget *DrawBorder; 
static GtkWidget *PushButtons; 

static GtkWidget *RowButton;
static GtkWidget *ForceSize; 
static GtkWidget *RowColLabel;
static GtkWidget *SizeSpinner;
static GtkWidget *ColumnButton;
static GtkWidget *WharfGeo[4];

static GtkWidget *BgColor;
static GtkWidget *TextureColorL;
static GtkWidget *TextureColorR;
static GtkWidget *MaxColourSpinner;
static GtkWidget *TextureOptionMenu;
/* Pixmap, Background, Texture */
static GtkWidget *WharfStyleIcon;
static GtkWidget *TextureParent[3];


static gchar *WharfBgColor;
static gint WharfRowCol=COL;
static gint  WharfTextureType;
static gchar *WharfBalloonFont;
static gchar *WharfBalloonFore;
static gchar *WharfBalloonBack;
static gchar *WharfTextureColorL;
static gchar *WharfTextureColorR;
static gchar *WharfStyleIconName;
static gchar *WharfBalloonBorderColor;
/*----------------------------------*/


/*
 * The WharfEntry. 
 */
/*----------------------------------*/
typedef struct _wharfentry wharfentry;

struct _wharfentry {
	gint nestlevel;
	gboolean dots;
	gchar *name;   
	gchar *icon;
	gchar *command;
};

static gint CurrentRow=0;
static gint NestLevel=0;
static GtkWidget *DotsIcon;
static GtkWidget *WharfEntryName;
static GtkWidget *WharfEntryIcon;
static gboolean EntryClicked=FALSE;
static gchar 	*WharfEntryIconName;
static GtkWidget *WharfEntryCommand;
static wharfentry *CurrentWharfEntry=NULL;
/*----------------------------------*/
static void affect_wharf_entry_button(GtkWidget *, gint);
static gint new_wharf_entry(GtkWidget *, gpointer );
static gint change_wharf_entry(GtkWidget *, gpointer );
static void texture_hide_show(GtkWidget *, gint );
static void set_row_col (GtkWidget *, gpointer *);
static void anim_balloon_hide_show(GtkWidget *, gint);
static void affect_wharf_style_button(GtkWidget *, gint);
static void parse_wharf(gfloat, gfloat);
/*----------------------------------*/

#ifndef GTK_STABLE_VERSION
static GtkCTree *WharfEntryTree; 
static GtkCTreeNode *WharfEntryList;
/*----------------------------------*/
static wharfentry *  init_wharf_entry(gchar *);
static gint wharf_entry_clicked(GtkCTree *, GdkEventButton *, gpointer );
#else
static gint CurrentNestLevel=0;
static GtkWidget *WharfEntryList;
static wharfentry *init_wharf_entry(gchar *, gint);
static gint wharf_entry_clicked(GtkCList *, GdkEventButton *, gpointer );
#endif // GTK_LIB_DEP_CODE


#ifndef GTK_STABLE_VERSION
void get_ctree_info(GtkCTree *ctree, GtkCTreeNode *node)
{
	wharfentry *entry = g_malloc0(256);


	if(GTK_CTREE_ROW(node)->level < NestLevel)
	{
		gint i;
		gint deep;
		gint indent;

		deep =  NestLevel - GTK_CTREE_ROW(node)->level;
		
		for(i=0; i<deep; i++)
		{	

			for(indent=1; indent < NestLevel; indent++)
			{
				fprintf(IoFile,"   ");
			}
			fprintf(IoFile, "*Wharf ~Folders\n");
			--NestLevel;
		}
	}

	
  	if (GTK_CTREE_ROW (node)->is_leaf)
  	{
		;
  	}
  	else
	{
		NestLevel++;
	}
  
	
	entry = (wharfentry *)  gtk_ctree_get_row_data ( GTK_CTREE(ctree), 
		GTK_CTREE_NODE(node)); 

  	if(entry)
  	{
		int indent;

		if( ascp_strncasecmp(entry->command, "Folder", 6))
			 fprintf(IoFile,"   ");

		for(indent=1; indent < NestLevel; indent++)
		{
			fprintf(IoFile,"   ");
		}
		fprintf(IoFile,"*Wharf %s  %s", entry->name, entry->icon);
		if(entry->dots)
			fprintf(IoFile, ",3_dots.xpm ");
		fprintf(IoFile," %-20s \n", entry->command);
  	}
	else
	{
		fclose(IoFile);
		exit(1);
	}


}

#endif // GTK_LIB_DEP_CODE


GtkWidget * ascp_draw_wharf(gfloat min, gfloat max)
{
	/* 
	 * The toplevel table that shall be returned to
     * populate_frame().
	 */
	GtkWidget *tabletop =  gtk_table_new(14, 14, TRUE);


	if(ASCPERROR)
		return gtk_label_new("ascp Error");


	WharfEntryIconName = (gchar *) g_malloc0(64);
	CurrentWharfEntry = (wharfentry *)  g_malloc0(256);
	
	/*
	 *	Create the box and tree for the entries.
	 *  Populate them with the entries.
     */
	{

		GtkWidget *treebox;
		GtkWidget *scrolledwin;
		
		scrolledwin = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
						 GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);


		treebox = gtk_vbox_new(TRUE, 0);

#ifndef GTK_STABLE_VERSION
		WharfEntryTree = GTK_CTREE(gtk_ctree_new(1, 0));

		gtk_clist_set_reorderable (GTK_CLIST(WharfEntryTree), TRUE);
		gtk_ctree_set_line_style (WharfEntryTree, ASCPCONFIG.treelinestyle);
		
      	gtk_clist_set_selection_mode (GTK_CLIST (WharfEntryTree), GTK_SELECTION_SINGLE);

		TREEBGCOLOUR = g_new(GdkColor, 1);

		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), 
			GTK_WIDGET(WharfEntryTree));


      	gtk_signal_connect_after(GTK_OBJECT (WharfEntryTree), "button_press_event",
			GTK_SIGNAL_FUNC (wharf_entry_clicked), NULL);

		gtk_widget_show(GTK_WIDGET(WharfEntryTree));
#else
		
		WharfEntryList = gtk_clist_new(1);
		
		gtk_container_add (GTK_CONTAINER (scrolledwin), GTK_WIDGET(WharfEntryList));

      	gtk_signal_connect_after(GTK_OBJECT (WharfEntryList), "button_press_event",
			GTK_SIGNAL_FUNC (wharf_entry_clicked), NULL);

		gtk_widget_show(GTK_WIDGET(WharfEntryList));
#endif // GTK_LIB_DEP_CODE
					
	  

		gtk_box_pack_start(GTK_BOX(treebox),  GTK_WIDGET(scrolledwin), TRUE, TRUE,0);
		
		if(ASCPCONFIG.wharfentryboxwide)
		{
			gtk_table_attach( GTK_TABLE(tabletop), treebox, 0, 9, 0, 10,
				GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
		}
		else
		{
			gtk_table_attach( GTK_TABLE(tabletop), treebox, 0, 7, 0, 10,
				GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
		}	

		gtk_widget_show(treebox);
		gtk_widget_show(scrolledwin);
	}


	/* 
	 * Create the frames and entry boxes for the names
     * and commands of the entries.
     */
	{
		GtkWidget *frame;


		frame = gtk_frame_new (NULL);
		WharfEntryCommand = gtk_entry_new_with_max_length (100);
		gtk_entry_set_text (GTK_ENTRY (WharfEntryCommand), "");
		gtk_container_add(GTK_CONTAINER(frame), WharfEntryCommand);
		
		gtk_table_attach( GTK_TABLE(tabletop), frame, 0, 14, 10, 12,
			GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
		gtk_widget_show_all(frame);


		frame = gtk_frame_new (NULL);
		WharfEntryName = gtk_entry_new_with_max_length (30);
		gtk_entry_set_text (GTK_ENTRY (WharfEntryName), "");
		gtk_container_add(GTK_CONTAINER(frame), WharfEntryName);

		if(ASCPCONFIG.wharfentryboxwide)
		{	
			gtk_table_attach( GTK_TABLE(tabletop), frame, 9, 14, 0, 3,
				GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 4, 4);
		}
		else
		{
			gtk_table_attach( GTK_TABLE(tabletop), frame, 7, 14, 0, 3,
				GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 4, 4);
		}
		gtk_widget_show_all(frame);
	}



	/* 
	 * Create the frame and the button that will contain 
	 * the icon for the wharf entry.
	 * Set it up to call up a filesel widget.
	 * In addition, create a menu that will popup in response
	 * to second or third button mouse clicks.
     */
	{
		GtkWidget *frame;
		GtkWidget *menu;
		GtkWidget *dottable;
		GtkWidget *menuitem;
		gchar *menumsg[] = {
				"No icon",
				"Add dots",
				"-------------",
				"Default: single icon"
				};
		gint i;

	
		menu = gtk_menu_new();
		
		for(i=0; i < (sizeof(menumsg)/sizeof(*menumsg)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(menumsg[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);
			
			/* 
			 * Disable the stylish looking divider from
			 * activating any callbacks.
			 */
			if( i == (sizeof(menumsg)/sizeof(*menumsg) - 2) )
				gtk_widget_set_sensitive (menuitem, FALSE);
			else ;
	
		gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			GTK_SIGNAL_FUNC(affect_wharf_entry_button), (gpointer) i);
			

		}


		frame = gtk_frame_new (NULL);

		WharfEntryIcon = gtk_button_new();

		gtk_signal_connect_object(GTK_OBJECT(WharfEntryIcon), "button_press_event",
				GTK_SIGNAL_FUNC (ascp_alt_menu), GTK_OBJECT(menu));

		gtk_signal_connect_after(GTK_OBJECT(WharfEntryIcon), "button_press_event",
				GTK_SIGNAL_FUNC (ascp_xpm_browser), WharfEntryIconName);

				
		gtk_container_add(GTK_CONTAINER(frame), WharfEntryIcon);
		gtk_container_border_width (GTK_CONTAINER (WharfEntryIcon), 2);


	   	dottable = gtk_table_new(2,2, TRUE);
		DotsIcon = GTK_WIDGET(ascp_make_pixmap_from_data(dots));
		gtk_table_attach_defaults(GTK_TABLE(dottable), DotsIcon, 0, 1, 0, 1);

		if(ASCPCONFIG.wharfentryboxwide)
		{
			gtk_table_attach_defaults(GTK_TABLE(tabletop), dottable, 10, 11, 9, 10);
			gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 10, 13, 4, 9);
		}
		else
		{
			gtk_table_attach_defaults(GTK_TABLE(tabletop), dottable, 9, 10, 9, 10);
			gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 9, 12, 4, 9);
			//gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 9, 12, 4, 9);
		}
		

		gtk_widget_show(dottable);
		gtk_widget_show_all(frame);

	}



		
	/* 
	 * Create the three command buttons: "New", "Change" & "Delete". 
	 * Also create the alternate menu options.
	 */
	{
		GtkWidget *button;
		GtkWidget *menu;
		GtkWidget *menuitem;
		gchar *menumsg[] = {
				"Clone current entry"
				};
		gint i;

		menu = gtk_menu_new();
		
		for(i=0; i < (sizeof(menumsg)/sizeof(*menumsg)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(menumsg[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);

			/*      
			   gtk_signal_connect_object(GTK_OBJECT(menuitem),
			   	"activate", GTK_SIGNAL_FUNC(put_some_fun_here), FALSE); 
			 */ 
		}
		/*
		for the other buttons:
				for(i=3 ....)
						*/


		button = gtk_button_new_with_label("  Add  ");
		gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			 GTK_SIGNAL_FUNC (ascp_alt_menu), GTK_OBJECT(menu));

		 gtk_signal_connect(GTK_OBJECT(button), "clicked",
			 GTK_SIGNAL_FUNC(new_wharf_entry), NULL); 
		
		gtk_table_attach( GTK_TABLE(tabletop), button, 0, 2, 12, 14,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
		 gtk_widget_show(button);


		
		button = gtk_button_new_with_label(" Change ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(change_wharf_entry), NULL);
		
		gtk_table_attach( GTK_TABLE(tabletop), button, 6, 8, 12, 14,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
		gtk_widget_show(button);


		button = gtk_button_new_with_label("Remove");
			
#ifndef GTK_STABLE_VERSION
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (ascp_ctree_remove_selection), WharfEntryTree);
#else
		
		gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (ascp_clist_remove_selection), WharfEntryList);
			
#endif //  GTK_LIB_DEP_CODE

		gtk_table_attach( GTK_TABLE(tabletop), button, 12, 14, 12, 14,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
		gtk_widget_show(button);
	}


	return tabletop;
}





GtkWidget * ascp_draw_wharfstyle(gfloat min, gfloat max)
{
	/* 
	 * The toplevel table that shall be returned to
     * populate_frame().
	 */
	GtkWidget *tabletop =  gtk_table_new(18, 14, TRUE);

	//GdkColor *color; 
 
	if(ASCPERROR)
		return gtk_label_new("ascp Error");
	

	
	WharfBgColor = (gchar *) g_malloc0(16);
	WharfTextureColorL = (gchar *) g_malloc0(16);
	WharfTextureColorR = (gchar *) g_malloc0(16);
	WharfStyleIconName = (gchar *) g_malloc0(16);

	WharfBalloonFore = (gchar *) g_malloc0(16);
	WharfBalloonBack = (gchar *) g_malloc0(14); 
	WharfBalloonBorderColor =  (gchar *) g_malloc0(16);
	
	WharfBalloonFont = (gchar *) g_malloc0(64);

	/*
	 * Create the frame that will host all the
	 * options related to WharfTextureType.
	 */
	{
		GtkWidget *frame; 
		GtkWidget *table; 
		GtkWidget *menu;
		GtkWidget *menuitem;
		gint j;
		char *types [] = {
				"No texture",
				"Wharf style                         ^-",
				"Horizontal one way              <AF>-_",
				"Horizontal centered                =-=",
				"Vertical one way          ||| | |  | |",
				"Vertical centered         >>>>>><<<<<<",
				"Pixmap                           @^_^@"
				};


		frame = gtk_frame_new (NULL);
		table = gtk_table_new(10, 8, TRUE);

		menu = gtk_menu_new ();
		TextureOptionMenu = gtk_option_menu_new ();

		for(j=0; j < (sizeof(types)/sizeof(*types)); j++)
		{
			menuitem = gtk_menu_item_new_with_label(types[j]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);
			gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
				(GtkSignalFunc) texture_hide_show, (gpointer) j);

			// this is problematic: replaced by the statement above.
			/*
			gtk_signal_connect_object(GTK_OBJECT(menuitem),
				"activate", GTK_SIGNAL_FUNC(texture_hide_show), 
				(gpointer) j);  
				*/

		}
			
		gtk_option_menu_set_menu (GTK_OPTION_MENU (TextureOptionMenu), menu);
			
		gtk_table_attach_defaults(GTK_TABLE(table), TextureOptionMenu, 0, 8, 0, 2);
		gtk_widget_show_all(TextureOptionMenu);

		
		/* The Icon */

		{
			GtkWidget *menu;
			GtkWidget *menuitem;
			gchar *menumsg[] = {
				"None"
				};
			gint i;

			menu = gtk_menu_new();
		
			for(i=0; i < (sizeof(menumsg)/sizeof(*menumsg)); i++)
			{
				menuitem = gtk_menu_item_new_with_label(menumsg[i]);
				gtk_menu_append(GTK_MENU (menu), menuitem);
				gtk_widget_show(menuitem);

			   gtk_signal_connect(GTK_OBJECT(menuitem),
			   	"activate", GTK_SIGNAL_FUNC(affect_wharf_style_button), (gpointer) i); 
			}

			TextureParent[0] = gtk_frame_new (NULL);

        	WharfStyleIcon = gtk_button_new_with_label("\nNone\n");
			gtk_signal_connect_after(GTK_OBJECT(WharfStyleIcon), "button_press_event",
				GTK_SIGNAL_FUNC (ascp_xpm_browser), WharfStyleIconName);
			gtk_signal_connect_object(GTK_OBJECT(WharfStyleIcon), "button_press_event",
				GTK_SIGNAL_FUNC (ascp_alt_menu), GTK_OBJECT(menu));
			gtk_container_border_width (GTK_CONTAINER (WharfStyleIcon), 1);
			gtk_container_add(GTK_CONTAINER(TextureParent[0]), WharfStyleIcon);
			gtk_table_attach_defaults(GTK_TABLE(table), TextureParent[0], 2, 6, 3, 10);
		}


		/* The textures */

		{
			GdkColor *color;
			GtkWidget *ctable;
			GtkWidget *label;
			GtkWidget *cframe;
			GtkWidget *frame2;
			GtkSpinButton *spin;
			GtkAdjustment *adj;

			TextureParent[1] =  gtk_table_new(8, 8, TRUE);

			label = gtk_label_new( "Texture");

			ctable = gtk_table_new(1, 14, TRUE);

			TextureColorL =  gtk_drawing_area_new();
			gtk_widget_set_usize (TextureColorL, 20 , 20);
			strcpy(WharfTextureColorL, "#5FAF11");
			color = g_malloc0(sizeof(GdkColor));
			ascp_char_to_color(WharfTextureColorL, color);
			gtk_object_set_data(GTK_OBJECT(TextureColorL), "color", color);
			gtk_widget_set_events (TextureColorL, GDK_BUTTON_PRESS_MASK);
			gtk_signal_connect (GTK_OBJECT(TextureColorL), "event",
				(GtkSignalFunc) ascp_area_event, (gpointer *) WharfTextureColorL);
			gtk_signal_connect (GTK_OBJECT(TextureColorL), "realize",
				(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
			frame2 = gtk_frame_new (NULL);
			gtk_container_border_width (GTK_CONTAINER (frame2), 2);
			cframe = gtk_frame_new (NULL);
			gtk_container_add (GTK_CONTAINER (frame2), TextureColorL);
			gtk_container_add (GTK_CONTAINER (cframe), frame2);
			//gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), cframe, 3, 5, 1, 4);
			gtk_table_attach_defaults(GTK_TABLE(ctable), cframe, 0, 6, 0, 1);
					// GTK_FILL,  GTK_SHRINK, 0, 0);

			
			TextureColorR =  gtk_drawing_area_new();
			gtk_widget_set_usize (TextureColorR, 20 , 20);
			strcpy(WharfTextureColorR, "#11AF5F");
			color = g_malloc0(sizeof(GdkColor));
			ascp_char_to_color(WharfTextureColorR, color);
			gtk_object_set_data(GTK_OBJECT(TextureColorR), "color", color);
			gtk_widget_set_events (TextureColorR, GDK_BUTTON_PRESS_MASK);
			gtk_signal_connect (GTK_OBJECT(TextureColorR), "event",
				(GtkSignalFunc) ascp_area_event, (gpointer *) WharfTextureColorR);
			gtk_signal_connect (GTK_OBJECT(TextureColorR), "realize",
				(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
			frame2 = gtk_frame_new (NULL);
			gtk_container_border_width (GTK_CONTAINER (frame2), 2);
			cframe = gtk_frame_new (NULL);
			gtk_container_add (GTK_CONTAINER (frame2), TextureColorR);
			gtk_container_add (GTK_CONTAINER (cframe), frame2);
			//gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), cframe, 6, 8, 1, 4);
			//gtk_box_pack_start(GTK_BOX(hbox), cframe, TRUE, FALSE, 4);
			gtk_table_attach_defaults(GTK_TABLE(ctable), cframe, 9, 14, 0, 1);
				//GTK_FILL, GTK_SHRINK, 0, 0);

			gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), ctable, 3, 7, 1, 4);



			gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), label, 0, 3, 2, 3);



			label = gtk_label_new("Steps");
			adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 256, 1, 0, 0);
			MaxColourSpinner = gtk_spin_button_new (adj, 1, 0); 
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (MaxColourSpinner), TRUE);
			spin = GTK_SPIN_BUTTON (MaxColourSpinner);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(MaxColourSpinner), 50); 
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), label, 0, 3, 6, 7);
			gtk_table_attach_defaults(GTK_TABLE(TextureParent[1]), MaxColourSpinner, 4, 7, 5, 8);


			gtk_table_attach_defaults(GTK_TABLE(table), TextureParent[1], 0, 8, 3, 10);
	
		}



		/* The Background */

		{
			GdkColor *color;
			GtkWidget *label;
			GtkWidget *cframe;
			GtkWidget *frame2;
			//GdkColor gdk_color;
			//GdkColormap *colormap;


			TextureParent[2] =  gtk_table_new(8, 8, TRUE);

			cframe = gtk_frame_new (NULL);

			label = gtk_label_new("Background");

			BgColor =  gtk_drawing_area_new();
			strcpy(WharfBgColor, "#41FAF1");

			color = g_malloc0(sizeof(GdkColor));
			ascp_char_to_color(WharfBgColor, color);
			gtk_object_set_data(GTK_OBJECT(BgColor), "color", color);
			gtk_widget_set_events (BgColor, GDK_BUTTON_PRESS_MASK);
			gtk_signal_connect (GTK_OBJECT(BgColor), "event",
				(GtkSignalFunc) ascp_area_event, (gpointer *) WharfBgColor);
			gtk_signal_connect (GTK_OBJECT(BgColor), "realize",
				(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);


			frame2 = gtk_frame_new (NULL);
			gtk_container_border_width (GTK_CONTAINER (frame2), 3);
			gtk_container_add (GTK_CONTAINER (frame2), BgColor);
       		gtk_container_add(GTK_CONTAINER(cframe), frame2);
			
			gtk_table_attach_defaults(GTK_TABLE(TextureParent[2]), label, 0, 4, 3, 6);
			gtk_table_attach_defaults(GTK_TABLE(TextureParent[2]), cframe, 5, 7, 3, 6);


			gtk_table_attach_defaults(GTK_TABLE(table), TextureParent[2], 0, 8, 3, 10);

		}
		

		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_table_attach(GTK_TABLE(tabletop), frame, 0, 6, 0, 10,
			GTK_FILL, GTK_FILL, 0, 0);
		gtk_widget_show(table);
		gtk_widget_show(frame);
		
		WharfTextureType = 0;
		texture_hide_show(frame, WharfTextureType);
		gtk_option_menu_set_history (GTK_OPTION_MENU (TextureOptionMenu), 0);

	}



	
	
	/*
	 * Create the frame that will host all the widgets related to 
	 * WharfGeometry.
	 */ 
	{
		GtkWidget *frame;
		GtkWidget *table;
		 
		frame = gtk_frame_new (NULL);
		table = gtk_table_new(12, 12, TRUE);
		
		
		/* Columns or rows */
		{
			GtkAdjustment *adj;
			GtkWidget 	*cframe;
			GtkSpinButton *spin;
			GtkWidget   *subtable;

			
			cframe = gtk_frame_new (NULL);
			subtable = gtk_table_new( 12, 12 ,TRUE);
			
			RowColLabel = gtk_label_new(WharfRowCol ? "Columns" : "Rows");
			gtk_table_attach_defaults( GTK_TABLE(subtable), 
						RowColLabel, 0, 7, 8, 11 );
			
			ColumnButton = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (ColumnButton), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whvert)));
			gtk_signal_connect (GTK_OBJECT (ColumnButton), "clicked",
				GTK_SIGNAL_FUNC (set_row_col), "Columns" );
			gtk_table_attach_defaults(GTK_TABLE(subtable), ColumnButton, 3, 5, 1, 6);


			RowButton = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (RowButton), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whhoriz)));
			gtk_signal_connect(GTK_OBJECT (RowButton), "clicked",
				GTK_SIGNAL_FUNC (set_row_col), "Rows" );
			gtk_table_attach_defaults(GTK_TABLE(subtable), RowButton, 6, 9, 3, 6);
			
			adj =  (GtkAdjustment * ) gtk_adjustment_new (1, 1, 5, 1, 5, 0);
			SizeSpinner = gtk_spin_button_new (adj, 0, 0);
			spin = GTK_SPIN_BUTTON (SizeSpinner);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			gtk_table_attach_defaults( GTK_TABLE(subtable), SizeSpinner, 7, 11, 8, 11 );
																			 
			gtk_container_add (GTK_CONTAINER (cframe), subtable );

			gtk_table_attach_defaults(GTK_TABLE(table), cframe, 0, 6, 0, 7);
		}
		
		
		/* The location */	
		{
			GtkWidget       *cframe;
			GtkWidget       *subtable;
			 

			cframe = gtk_frame_new (NULL);
			subtable = gtk_table_new(2, 2 , FALSE);
			
			gtk_container_border_width (GTK_CONTAINER (subtable), 1);
			

			WharfGeo[0] = gtk_radio_button_new_with_label(NULL, "NW");
			gtk_table_attach_defaults(GTK_TABLE(subtable), WharfGeo[0], 0, 1, 0, 1);
			
			WharfGeo[1] = gtk_radio_button_new_with_label(
				gtk_radio_button_group(GTK_RADIO_BUTTON(WharfGeo[0])),"NE");
			gtk_table_attach_defaults(GTK_TABLE(subtable), WharfGeo[1], 1, 2, 0, 1);
			
			WharfGeo[2] = gtk_radio_button_new_with_label(
				gtk_radio_button_group(GTK_RADIO_BUTTON(WharfGeo[1])), "SW");
			gtk_table_attach_defaults(GTK_TABLE(subtable), WharfGeo[2], 0, 1, 1, 2);
			
			WharfGeo[3] = gtk_radio_button_new_with_label(
				gtk_radio_button_group(GTK_RADIO_BUTTON(WharfGeo[2])), "SE");
			gtk_table_attach_defaults(GTK_TABLE(subtable), WharfGeo[3], 1, 2, 1, 2 );


			gtk_container_add (GTK_CONTAINER (cframe), subtable );
			gtk_table_attach_defaults(GTK_TABLE(table), cframe, 6, 12, 0, 7);
		}

		
		/* The toggle buttons for misc. options */

		{
			GtkWidget       *cframe;
			GtkWidget       *subtable;

			cframe = gtk_frame_new (NULL);
			subtable = gtk_table_new(2, 2 , TRUE);
			gtk_container_border_width (GTK_CONTAINER (subtable), 0);


			ForceSize = gtk_check_button_new_with_label("Force Size");
			gtk_table_attach_defaults(GTK_TABLE(subtable), ForceSize, 0, 1, 0, 1);

			DrawBorder = gtk_check_button_new_with_label("Draw Border");
			gtk_table_attach_defaults(GTK_TABLE(subtable), DrawBorder, 0, 1, 1, 2);
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(DrawBorder), TRUE);

			PushWharf = gtk_check_button_new_with_label("Push Wharf");
			gtk_table_attach_defaults(GTK_TABLE(subtable), PushWharf, 1, 2, 0, 1);

			
			PushButtons = gtk_check_button_new_with_label("Push Buttons");
			gtk_table_attach_defaults(GTK_TABLE(subtable), PushButtons, 1, 2, 1, 2);
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(PushButtons), TRUE);

			gtk_container_add (GTK_CONTAINER (cframe), subtable );
			gtk_table_attach_defaults(GTK_TABLE(table), cframe, 0, 12, 7, 12);
			
		}

		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 6, 14, 0, 10);
		gtk_widget_show_all(frame);
			
	}

	
	/* 
	 * Create the WharfBalloon and WharfAnimated frames,
	 * as well as their parent frame to select/deselect them.
	 */
	{
		
		GtkWidget *menu;
		GtkWidget *menuitem;
		GtkWidget *optionmenu;
		gint i=0;
		char *types [] = {
				"Animate",
				"Balloons"
				};

		menu = gtk_menu_new ();
		optionmenu = gtk_option_menu_new ();
		
		for(i=0; i < (sizeof(types)/sizeof(*types)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(types[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);
			gtk_signal_connect(GTK_OBJECT(menuitem),
				"activate", GTK_SIGNAL_FUNC(anim_balloon_hide_show), (gpointer) i);
			
		}
		
		
	AnimBallParent[0] = gtk_table_new(1, 2 ,TRUE);
	/* 
	 * Create the frame that will host all the 
	 * options related to WharfAnimateMain
	 */ 
	{
		GtkWidget *table;
		GtkWidget *label;
		GtkWidget *frame;
		GtkSpinButton *spin;
		GtkAdjustment *adj;
		GtkWidget *subtable;
		
		frame = gtk_frame_new (NULL);
		table = gtk_table_new(3, 4 ,TRUE);

		subtable = gtk_table_new(5, 10 ,TRUE);
		
		AnimateMain = gtk_check_button_new_with_label("Animate Wharf");
		gtk_table_attach_defaults(GTK_TABLE(table), AnimateMain, 0, 3, 0, 1);
		gtk_signal_connect(GTK_OBJECT(AnimateMain), "clicked",
			GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  subtable);
		gtk_widget_show_all(AnimateMain);

		
		label = gtk_label_new("Delay");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 999, 1, 0, 0);
		AnimateDelayMainSpinner = gtk_spin_button_new (adj, 1, 0); 
		gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (AnimateDelayMainSpinner), TRUE);
		spin = GTK_SPIN_BUTTON (AnimateDelayMainSpinner);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelayMainSpinner), 2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 0, 5, 0, 2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), AnimateDelayMainSpinner, 5, 9, 0, 2);


		label = gtk_label_new("Steps");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 20, 1, 0, 0);
		AnimateStepsMainSpinner = gtk_spin_button_new (adj, 1, 0); 
		//gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), TRUE);
		spin = GTK_SPIN_BUTTON (AnimateStepsMainSpinner);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateStepsMainSpinner), 5);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 0, 5, 3, 5);
		gtk_table_attach_defaults(GTK_TABLE(subtable), AnimateStepsMainSpinner, 5, 9, 3, 5);

		gtk_table_attach_defaults(GTK_TABLE(table), subtable, 0, 4, 1, 3);

		gtk_container_add(GTK_CONTAINER(frame), table);

		if(!ASCPCONFIG.hide)
		{
			gtk_widget_set_sensitive(subtable, FALSE);
			gtk_widget_show_all(subtable);
		}

		gtk_table_attach_defaults(GTK_TABLE(AnimBallParent[0]), frame, 0, 1, 0, 1);
		gtk_widget_show(table);
		gtk_widget_show(frame);
	}
	


		/*
	     * Create the frame that will host all the 
	     * options related to WharfAnimateFolder
	     */
	 	{
			GtkWidget *table;
			GtkWidget *label;
			GtkWidget *frame;
			GtkSpinButton *spin;
			GtkAdjustment *adj;
			GtkWidget *subtable;
		
			frame = gtk_frame_new (NULL);
			table = gtk_table_new(3, 4 ,TRUE);

			subtable = gtk_table_new(5, 10 ,TRUE);
		
		
			Animate = gtk_check_button_new_with_label("Animate Folders");
			/*
		 	 *  Show or hide the spinbuttons depending on the state 
		 	 *  of the button.
		 	 */ 
			
			gtk_signal_connect(GTK_OBJECT(Animate), "clicked",
				GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  subtable);
			
			gtk_table_attach_defaults(GTK_TABLE(table), Animate, 0, 4, 0, 1);
			gtk_widget_show_all(Animate);

		label = gtk_label_new("Delay");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 999, 1, 0, 0);
		AnimateDelaySpinner = gtk_spin_button_new (adj, 1, 0); 
		gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (AnimateDelaySpinner), TRUE);
		spin = GTK_SPIN_BUTTON (AnimateDelaySpinner);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelaySpinner), 2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 0, 5, 0, 2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), AnimateDelaySpinner, 5, 9, 0, 2);


		label = gtk_label_new("Steps");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 20, 1, 0, 0);
		AnimateStepsSpinner = gtk_spin_button_new (adj, 1, 0); 
		//gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), TRUE);
		spin = GTK_SPIN_BUTTON (AnimateStepsSpinner);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateStepsSpinner), 5); 
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 0, 5, 3, 5);
		gtk_table_attach_defaults(GTK_TABLE(subtable), AnimateStepsSpinner, 5, 9, 3, 5);

		gtk_table_attach_defaults(GTK_TABLE(table), subtable, 0, 4, 1, 3);

		if(!ASCPCONFIG.hide)
		{
			gtk_widget_set_sensitive(subtable, FALSE);
			gtk_widget_show_all(subtable);
		}

		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_widget_show(table);
		gtk_widget_show(frame);

		gtk_table_attach_defaults(GTK_TABLE(AnimBallParent[0]), frame, 1, 2, 0, 1);
	}



	AnimBallParent[1] = gtk_table_new(1, 1 ,TRUE);
		
	/*
	 * Create the frame that will host all the 
	 * options related to WharfBalloons.
	 */
	{
		GtkWidget *table;
		GtkWidget *label;
		GtkWidget *frame;
		GtkWidget *scale;
		GtkWidget *cframe;
		GtkAdjustment *adj;
		GtkSpinButton *spin;
		GtkWidget *subtable;
		GdkColor *color;

		
		frame = gtk_frame_new (NULL);
		table = gtk_table_new(10, 12 ,TRUE);
		

		subtable = gtk_table_new(12, 12 ,TRUE);
		
		Balloons = gtk_check_button_new_with_label("Wharf Balloons");
		gtk_widget_show_all(Balloons);
		 /*
		  * Show or hide the rest of the balloon area
		  * depending on the state of the button.
		  */
		gtk_signal_connect(GTK_OBJECT(Balloons), "clicked",
			GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  subtable);
		 gtk_table_attach_defaults(GTK_TABLE(table), Balloons, 0, 5, 0, 2);
		                
		
		label = gtk_label_new("Border ");
		cframe = gtk_frame_new (NULL);
		BalloonBorderColor  = gtk_drawing_area_new ();
		strcpy(WharfBalloonBorderColor, "#3333FF");
		//strcpy(WharfBalloonBorderColor, "#5FAF11");
		color = g_malloc0(sizeof(GdkColor));
		ascp_char_to_color(WharfBalloonBorderColor, color);
		gtk_object_set_data(GTK_OBJECT(BalloonBorderColor), "color", color);
		gtk_widget_set_events (BalloonBorderColor, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect (GTK_OBJECT(BalloonBorderColor), "event",
			(GtkSignalFunc) ascp_area_event, (gpointer *)  WharfBalloonBorderColor);
		gtk_signal_connect (GTK_OBJECT(BalloonBorderColor), "realize",
			(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
		gtk_container_add (GTK_CONTAINER (cframe), BalloonBorderColor);
		gtk_table_attach_defaults(GTK_TABLE(subtable),label, 0, 2, 1, 4 );
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 3, 4, 1, 4);
		
		
		
		label = gtk_label_new("Foreground");
		cframe = gtk_frame_new (NULL);
		BalloonFore =  gtk_drawing_area_new ();
		strcpy(WharfBalloonFore, "#AF11AF");
		color = g_malloc0(sizeof(GdkColor));
		ascp_char_to_color(WharfBalloonFore, color);
		gtk_object_set_data(GTK_OBJECT(BalloonFore), "color", color);
		gtk_widget_set_events (BalloonFore, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect (GTK_OBJECT(BalloonFore), "event",
			(GtkSignalFunc) ascp_area_event, (gpointer *)  WharfBalloonFore);
		gtk_signal_connect (GTK_OBJECT(BalloonFore), "realize",
			(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
		gtk_container_add (GTK_CONTAINER (cframe), BalloonFore);
		gtk_table_attach_defaults(GTK_TABLE(subtable),label, 0, 3, 5, 8);
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 3, 4, 5, 8);
		 
		

		label = gtk_label_new("Background");
		cframe = gtk_frame_new (NULL);
		BalloonBack = gtk_drawing_area_new();
		strcpy(WharfBalloonBack, "#AF11AF");
		color = g_malloc0(sizeof(GdkColor));
		ascp_char_to_color(WharfBalloonBack, color);
		gtk_object_set_data(GTK_OBJECT(BalloonBack), "color", color);
		gtk_widget_set_events (BalloonBack, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect (GTK_OBJECT(BalloonBack), "event",
			(GtkSignalFunc) ascp_area_event, (gpointer *)  WharfBalloonBack);
		gtk_signal_connect (GTK_OBJECT(BalloonBack), "realize",
			(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
		gtk_container_add (GTK_CONTAINER (cframe), BalloonBack);
		gtk_table_attach_defaults(GTK_TABLE(subtable),label, 0, 3, 9,  12);
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 3, 4, 9, 12);
		 

		label = gtk_label_new("Font");
		cframe = gtk_frame_new (NULL);
		BalloonFont = gtk_button_new_with_label("...");
		gtk_widget_set_sensitive(BalloonFont, FALSE);
		gtk_container_border_width (GTK_CONTAINER (BalloonFont), 1);
		gtk_container_add (GTK_CONTAINER (cframe), BalloonFont);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label , 4, 6, 1, 3);
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 6, 7, 0, 4);

		
		label = gtk_label_new("Width");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 9, 1, 0, 0);
		BalloonBorderWidth = gtk_spin_button_new (adj, 1, 0); 
		spin = GTK_SPIN_BUTTON (BalloonBorderWidth);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonBorderWidth), 1);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 4, 6, 5, 7);
		gtk_table_attach_defaults(GTK_TABLE(subtable),  BalloonBorderWidth, 6, 8, 4, 8);


		label = gtk_label_new("Delay");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 999, 10, 0, 0);
		BalloonDelay = gtk_spin_button_new (adj, 1, 0); 
		gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (BalloonDelay), TRUE);
		spin = GTK_SPIN_BUTTON (BalloonDelay);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 4, 6, 9, 11);
		gtk_table_attach_defaults(GTK_TABLE(subtable), BalloonDelay, 6, 8, 8, 12);

		label = gtk_label_new("Offset");
		BalloonYOffset = (GtkAdjustment *) gtk_adjustment_new (0,  -1, 1, 1, 0, 0);
		scale = gtk_vscale_new (GTK_ADJUSTMENT (BalloonYOffset));
		gtk_scale_set_digits (GTK_SCALE (scale), 0);
		
		if(ASCPCONFIG.offsetwithnum)
		{
			//gtk_table_attach_defaults(GTK_TABLE(subtable), label, 8, 11, 7, 9);
			//gtk_table_attach_defaults(GTK_TABLE(subtable), scale, 11, 12, 0, 12);
		}
		else
		{
			//gtk_table_attach_defaults(GTK_TABLE(subtable), label, 9, 11, 4, 6);
			gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
			//gtk_table_attach_defaults(GTK_TABLE(subtable), scale, 11, 12, 0, 9);
		}
		
		gtk_table_attach_defaults(GTK_TABLE(subtable), scale, 10, 12, 0, 10);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 10, 12, 10, 12);


		gtk_table_attach_defaults(GTK_TABLE(table), subtable, 0, 12, 2, 10);
		  
		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_table_attach_defaults(GTK_TABLE(AnimBallParent[1]), frame, 0, 1, 0, 1);

		if(!ASCPCONFIG.hide)
		{
			gtk_widget_set_sensitive(subtable, FALSE);
			gtk_widget_show_all(subtable);
		}

		gtk_widget_show(table);
		gtk_widget_show(frame);
		}	


	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
	gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), ASCPCONFIG.animballoon);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), optionmenu, 0, 3, 10, 12);
	gtk_widget_show_all(optionmenu);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimBallParent[0], 3, 14, 10,18);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimBallParent[1], 3, 14, 10,18);

	gtk_widget_show(AnimBallParent[(gint) ASCPCONFIG.animballoon]);

	}

	
	/* 
	 * This will work here, provided draw_wharf is called first
	 * then draw_wharfstyle.
	 */
	parse_wharf(min, max);

#ifndef GTK_STABLE_VERSION 
	gtk_ctree_remove(WharfEntryTree, WharfEntryList);
#endif //  GTK_LIB_DEP_CODE

	gtk_widget_show(tabletop);

	return tabletop;
}


static void parse_wharf(gfloat min, gfloat max)
{

	gfloat incr;
	gchar *buffer = (gchar*) g_malloc0(BUFFERSIZE);
	FILE *backupfile;

#ifndef GTK_STABLE_VERSION 
	GtkCTreeNode *parent[10];
	gchar *top[] = {"top"};
	GtkCTreeNode *node = NULL;
#endif //  GTK_LIB_DEP_CODE


	backupfile = ascp_open_file("wharf.ascp", "w");
   	IoFile = ascp_open_file("wharf", "r");

	/* 
	 * A little, erm, fudging on my part:
	 * draw_wharf() and draw_wharfstyle() are _two_ different functions
	 * representing two different pages.
	 * To account for the fact that the there is only one wharf file,
	 * the progress bar is updated to twice its "alloted" amount, 
	 * rather than reading the file _twice_.
	 */
   	incr = (max - min)/FILESIZE;


	ascp_update_status(NULL, "wharf", min); 

	NestLevel = 0;

#ifndef GTK_STABLE_VERSION 
	WharfEntryList = gtk_ctree_insert (WharfEntryTree, NULL, NULL, top,
		5, PIXMAP1, MASK1, PIXMAP2, MASK2, FALSE, FALSE);
	parent[NestLevel] = NULL;
#endif //  GTK_LIB_DEP_CODE

	while (fgets(buffer, BUFFERSIZE, IoFile) != NULL)
	{
		 char* line = buffer;

		/*      
		 * Show our progress per total bytes per line read.
		 */
		ascp_update_status(NULL, NULL, min); 
		min = ( min >= max) ? max : min + incr*strlen(buffer); 

		fputs(line, backupfile);
		
		for ( ; isspace(*line) ; line++);
		if( !ascp_strncasecmp(line, "*Wharf", 6) )
		{
			line += 6;
			
			if( !ascp_strncasecmp(line, "TextureType", 11))
			{	
				int type;

				/* 
				 * Just to satisfy texture_hide_show(), 
				 * a callback.
				 */
				GtkWidget *w=gtk_label_new("not really"); 

				sscanf(line + 11, "%d", &type);
				WharfTextureType = (type > 5) ?  6 : type;
				texture_hide_show(w, WharfTextureType);
				gtk_option_menu_set_history (GTK_OPTION_MENU (TextureOptionMenu),
					(type > 5) ?  6 : type);
			}
			else if( !ascp_strncasecmp(line, "MaxColor", 8))
			{
				int max;
				sscanf(line + 8, "%d", &max);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(MaxColourSpinner), max); 
			}
			else if( !ascp_strncasecmp(line, "TextureColor", 12))
			{
				GdkColor *color;

				sscanf(line + 12, "%s%s", WharfTextureColorL, WharfTextureColorR);
				
				/* set up the colour wells */	
				color = gtk_object_get_data(GTK_OBJECT(TextureColorL), "color");
				ascp_char_to_color(WharfTextureColorL, color);
				color = gtk_object_get_data(GTK_OBJECT(TextureColorR), "color");
				ascp_char_to_color(WharfTextureColorR, color);
			   
			}
			else if( !ascp_strncasecmp(line, "Pixmap", 6))
			{
				if( strlen(line) < 8)
					strcpy(WharfStyleIconName, "ASBBlockWhite.xpm");
				else
					sscanf(line + 6, "%s", WharfStyleIconName);
				
				if( GTK_BIN(WharfStyleIcon)->child)
					gtk_container_remove(GTK_CONTAINER(WharfStyleIcon), 
						GTK_BIN(WharfStyleIcon)->child);
					
				gtk_container_add(GTK_CONTAINER(WharfStyleIcon),
					ascp_make_pixmap(WharfStyleIconName, SINGLE));

				gtk_widget_draw_default(WharfStyleIcon);
				gtk_widget_show_all(WharfStyleIcon);


			}
			else if( !ascp_strncasecmp(line , "BgColor", 7))
			{
				GdkColor *color;

				sscanf(line + 7, "%s", WharfBgColor);
				
				/* set up the colour well */	
				color = gtk_object_get_data(GTK_OBJECT(BgColor), "color");
				ascp_char_to_color(WharfBgColor, color);
			
			}
			
			else if( !ascp_strncasecmp(line, "Animate", 7) && !strstr(line, "Main")) 
			{
				int value;

				if(!ascp_strncasecmp(line, "AnimateDelay", 12)) 
				{
					sscanf(line + 12, "%d", &value);
					gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelaySpinner), value); 
				}
				else if( !ascp_strncasecmp(line, "AnimateSteps", 12)) 
				{
					sscanf(line + 12, "%d", &value);
					gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateStepsSpinner), value); 
				}
				else 
					gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(Animate), TRUE );
			}
			
			else if( !ascp_strncasecmp(line, "AnimateMain", 11))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(AnimateMain), TRUE );
			}
			else if( !ascp_strncasecmp(line, "AnimateDelayMain", 16))
			{
				int value;

				sscanf(line + 16, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelayMainSpinner), value); 
			}
			else if( !ascp_strncasecmp(line, "AnimateStepsMain", 16))
			{
				int value;

				sscanf(line + 16, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateStepsMainSpinner), value); 
			}
			else if( !ascp_strncasecmp(line, "Balloons", 8))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(Balloons), TRUE);
			}
			else if( !ascp_strncasecmp(line, "BalloonBorderColor", 18))
			{
				GdkColor *color;

				sscanf(line + 18, "%s", WharfBalloonBorderColor);

				/* set up the colour well */	
				color = gtk_object_get_data(GTK_OBJECT(BalloonBorderColor), "color");
				ascp_char_to_color(WharfBalloonBorderColor, color);

			}
			else if( !ascp_strncasecmp(line, "BalloonFore", 11))
			{
				GdkColor *color;

				sscanf(line + 11, "%s", WharfBalloonFore );
				
				/* set up the colour well */	
				color = gtk_object_get_data(GTK_OBJECT(BalloonFore), "color");
				ascp_char_to_color(WharfBalloonFore, color);
				
			}
			else if( !ascp_strncasecmp(line, "BalloonBack", 11))
			{
				GdkColor *color;

				sscanf(line + 11, "%s", WharfBalloonBack);
				
				/* set up the colour well */	
				color = gtk_object_get_data(GTK_OBJECT(BalloonBack), "color");
				ascp_char_to_color(WharfBalloonBack, color);
				
			}
			
			else if( !ascp_strncasecmp(line, "BalloonFont", 11))
			{
				sscanf(line + 11, "%s", WharfBalloonFont);
			}
			
			else if( !ascp_strncasecmp(line, "BalloonBorderWidth", 18))
			{
				int value;

				sscanf(line + 18, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonBorderWidth), value); 
			}
			else if( !ascp_strncasecmp(line, "BalloonDelay", 12))
			{
				int value;

				sscanf(line + 12, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonDelay), value); 
			}
			else if( !ascp_strncasecmp(line, "BalloonYOffset", 14))
			{
				int value;

				sscanf(line + 14, "%d", &value);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(BalloonYOffset), value); 
			}
			else if( !ascp_strncasecmp(line, "Geometry", 8))
			{
				gchar *value=g_malloc0(4);

				sscanf(line + 8, "%s", value);

				if( *value == '+' && *(value+2) == '+')
					gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WharfGeo[0]), TRUE);
				else if( *value == '-' && *(value+2) == '+')
					gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WharfGeo[1]), TRUE);
				else if( *value == '+' && *(value+2) == '-')
					gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WharfGeo[2]), TRUE);
				else if( *value == '-' && *(value+2) == '-')
					gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WharfGeo[3]), TRUE);
			}
			else if( !ascp_strncasecmp(line, "NoBorder", 8))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(DrawBorder), FALSE);
			}
			else if( !ascp_strncasecmp(line , "FullPush", 8))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(PushWharf), TRUE);
			}
			else if( !ascp_strncasecmp(line ,"NoPush", 6))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(PushButtons), FALSE);
			}
			else if( !ascp_strncasecmp(line , "ForceSize", 9))
			{
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(ForceSize), TRUE);
			}
			else if( !ascp_strncasecmp(line , "Rows", 4))
			{	
				int value;
				
				WharfRowCol = ROW;
				sscanf(line + 4, "%d", &value);
				gtk_button_clicked(GTK_BUTTON(RowButton)); 
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(SizeSpinner), value); 
			}
			else if( !ascp_strncasecmp(line , "Columns", 7))
			{
				int value;
				
				WharfRowCol = COL;
				sscanf(line + 7, "%d", &value);
				gtk_button_clicked(GTK_BUTTON(ColumnButton)); 
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(SizeSpinner), value); 
			}

			else if( isspace(*line))
			{
				wharfentry *entry = (wharfentry *) g_malloc0(256);

#ifndef GTK_STABLE_VERSION 
				if(ASCPCONFIG.treelinestyle ==  GTK_CTREE_LINES_TABBED)
				{
					if (NestLevel % 3 == 0) 
					{
						TREEBGCOLOUR->red   = 10000 * (NestLevel % 6);
						TREEBGCOLOUR->green = 0;
						TREEBGCOLOUR->blue  = 65535 - ((10000) % 65535); 
					}
					else if (NestLevel % 3 == 1) 
					{
						TREEBGCOLOUR->red   = 10000 * (NestLevel % 6);
						TREEBGCOLOUR->green = 65535 - ((10000) % 65535); 
						TREEBGCOLOUR->blue  = 0;
					}
					else
					{
						TREEBGCOLOUR->red   = 65535 - ((10000) % 65535); 
						TREEBGCOLOUR->green = 0;
						TREEBGCOLOUR->blue  = 10000 * (NestLevel % 6);
					}

					gdk_color_alloc (gtk_widget_get_colormap 
						(GTK_WIDGET(WharfEntryTree)), TREEBGCOLOUR);
				}
#endif //  GTK_LIB_DEP_CODE
				                  
				while (isspace(*line))
					line++;
				
				entry = init_wharf_entry(line
#ifdef GTK_STABLE_VERSION 
, NestLevel
#endif
	);
				 if (entry!= NULL)	
				 {
					gchar *label[] = {entry->name};

					if( !ascp_strncasecmp(entry->command, "Folder", 6))
					{
#ifndef GTK_STABLE_VERSION 

						parent[++NestLevel] = node = gtk_ctree_insert 
								(WharfEntryTree, parent[NestLevel], 
							NULL, label, 5, PIXMAP1, MASK1, PIXMAP2, MASK2, FALSE, FALSE);
						
						gtk_ctree_set_row_data (WharfEntryTree, node, (wharfentry *) entry);

						if(ASCPCONFIG.treelinestyle ==  GTK_CTREE_LINES_TABBED)
							 gtk_ctree_set_background(WharfEntryTree, node, TREEBGCOLOUR);		
						
#else
						gtk_clist_append (GTK_CLIST(WharfEntryList), label);
						gtk_clist_set_shift(GTK_CLIST(WharfEntryList), CurrentRow, 0, 0, NestLevel*20);
						gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
							entry->name, 5, PIXMAP2, MASK2);
						gtk_clist_set_row_data(GTK_CLIST(WharfEntryList), CurrentRow++, (wharfentry *) entry);
						++NestLevel; //will use later to indent

#endif //  GTK_LIB_DEP_CODE

					}
					else if( !ascp_strncasecmp(entry->command, "~Folder", 7))
					{
						 NestLevel--;
					}
					else
					{
#ifndef GTK_STABLE_VERSION 
						node   = gtk_ctree_insert (WharfEntryTree, parent[NestLevel], 
							NULL, label, 5, PIXMAP3, MASK3, PIXMAP3, MASK3, TRUE, FALSE);
						
						gtk_ctree_set_row_data (WharfEntryTree, node, (wharfentry *) entry);
					
						if(ASCPCONFIG.treelinestyle ==  GTK_CTREE_LINES_TABBED)
							 gtk_ctree_set_background(WharfEntryTree, node, TREEBGCOLOUR);		

#else
						gtk_clist_append (GTK_CLIST(WharfEntryList), label);
						gtk_clist_set_shift(GTK_CLIST(WharfEntryList), CurrentRow, 0, 0, NestLevel*20);
						gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
							entry->name, 5, PIXMAP3, MASK3);
						gtk_clist_set_row_data(GTK_CLIST(WharfEntryList), CurrentRow++, (wharfentry *) entry);

#endif //  GTK_LIB_DEP_CODE
					}
				 }
				
			}
			
		}
	}
	g_free(buffer);
	fclose(IoFile);
	fclose(backupfile);

}


static wharfentry *  init_wharf_entry(char *data
#ifdef GTK_STABLE_VERSION 
, gint level
#endif
	)
{
	wharfentry *node;
	char *tmp;
	

	tmp = g_malloc0(strlen(data));
	node = (wharfentry *) g_malloc0(256);
	
	if( node == NULL )
		return (wharfentry *) NULL;
	
	else
	{
		int error = 0;

		node->name = NULL; 	
		node->icon = NULL; 	
		node->command = NULL; 	
#ifdef GTK_STABLE_VERSION 
		node->nestlevel = (gint) level;
#endif
		
		for ( ; isspace(*data) ; data++)
			;
		
		for (tmp = data; *data!= '\0' && !isspace(*tmp) ; tmp++)
			;
		
		if(data == tmp)
			error = 1;
		
		if(!error)
		{
			/* Get the name */
			node->name = g_malloc0(tmp - data + 1);
			strncpy(node->name, data, tmp - data);
			node->name[tmp - data] = '\0';

			for (data = tmp; isspace(*data) ; data++)
				;
		
			for (tmp = data; *tmp != '\0' && !isspace(*tmp) ; tmp++)
				;

			if (data == tmp)
				error = 3;
		}
		
		if (!error)
		{
			/* Get the icon(s) */

			node->icon = g_malloc0(tmp - data + 1);

			strncpy(node->icon, data , tmp - data);
				
			node->icon[tmp - data] = '\0';
				
			if(strstr(node->icon, ","))
			{
				gint i=0;

				while( *(node->icon+i) != '\0' && *(node->icon+i) != ',')
				{
					*(node->icon+i) = *(node->icon+i);
							i++;
				}
					node->icon[i] = '\0';
				node->dots = TRUE;
			}
			else
				node->dots = FALSE;
				
			

			for (data = tmp ; isspace(*data) ; data++)
				;

			for (tmp = data + strlen(data) ; tmp > data && isspace(tmp[-1]) ; tmp--)
				;

			if (data == tmp)
				error = 4;
		}
		
		if (!error)
		{
			/* Get the command */
			node->command = g_malloc0(tmp - data + 1);
			strncpy(node->command, data, tmp - data);
			node->command[tmp - data] = '\0';
		}
		
		if (error)
		{
			if (node->command != NULL)
			{
				g_free(node->command);
				node->command = NULL;
			}
			if (node->icon != NULL)
			{
				g_free(node->icon);
				node->icon = NULL;
			}

			if (node->name != NULL)
			{
				/* Error 3 may not be bad  */
				if (error != 3 || ascp_strncasecmp(node->name, "~Folder", 7))
					g_free(node->name);
				else
					node->command = node->name;

				node->name = NULL;
			}
	
			if (node->command == NULL)
			{
				g_free(node);
				node = NULL;
			}

		}


		return node;
	}
}

	
	
				
static gint wharf_entry_clicked(
#ifndef GTK_STABLE_VERSION
GtkCTree *cwidget,
#else
GtkCList *cwidget,
#endif
GdkEventButton *event, gpointer data)
{
	gint res;
	gint column;
	//GtkCTreeNode *work;
	wharfentry *entry;

	res = gtk_clist_get_selection_info (GTK_CLIST (cwidget), event->x,
		event->y, &CurrentRow, &column);

	if (!res) //&& event->button != 1)
		return FALSE;


	entry = (wharfentry *) g_malloc0(256);
	entry = (wharfentry *)  gtk_clist_get_row_data (GTK_CLIST (cwidget), CurrentRow); 


	if(entry)
	{
		if(entry->name)
		{
			gtk_entry_set_text (GTK_ENTRY (WharfEntryName), entry->name);
		}
		else 
			gtk_entry_set_text (GTK_ENTRY (WharfEntryName), "");

		if(entry->icon)
		{
			if(GTK_BIN(WharfEntryIcon)->child)
				gtk_container_remove(GTK_CONTAINER(WharfEntryIcon), 
					GTK_BIN(WharfEntryIcon)->child);

			gtk_container_add(GTK_CONTAINER(WharfEntryIcon), 
				ascp_make_pixmap(entry->icon, SINGLE));

		
			gtk_widget_draw_default(WharfEntryIcon);
			gtk_widget_show_all(WharfEntryIcon);
		
			if(entry->dots)
				gtk_widget_show_all(DotsIcon);
			else
				gtk_widget_hide_all(DotsIcon);
		}

		if(entry->command)
			gtk_entry_set_text (GTK_ENTRY (WharfEntryCommand), entry->command);
		else 
			gtk_entry_set_text (GTK_ENTRY (WharfEntryCommand), " ");



		strcpy(WharfEntryIconName, entry->icon);
		CurrentWharfEntry = entry;
		
		if(!EntryClicked)
			EntryClicked=TRUE;

		if(!CurrentWharfEntry)
		{ 
			g_print("unable to allocate memory for CurrentWharfEntry\n");
			exit(1);
		}

#ifdef GTK_STABLE_VERSION
		CurrentNestLevel = entry->nestlevel;
#endif

		//g_free(entry);
		
		return TRUE;
	}
	else
	{
		g_print("Can't find such entry %p\n", entry);
		return FALSE;
	}


	return FALSE;
}




void ascp_write_wharf()
{
	IoFile = ascp_open_file("wharf", "w");
	//IoFile = fopen("wharf_out", "w");

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");


	if( GTK_TOGGLE_BUTTON(AnimateMain)->active || GTK_TOGGLE_BUTTON (Animate)->active)  
	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Animation \n\n"); 

		if( GTK_TOGGLE_BUTTON (AnimateMain)->active)  
		{	
			fprintf(IoFile, "*WharfAnimateMain\n"); 
			fprintf(IoFile, "*WharfAnimateDelayMain %d\n",  gtk_spin_button_get_value_as_int 
					( GTK_SPIN_BUTTON (AnimateDelayMainSpinner)));
			fprintf(IoFile, "*WharfAnimateStepsMain %d\n", gtk_spin_button_get_value_as_int 
				( GTK_SPIN_BUTTON (AnimateStepsMainSpinner)));
		}

		if( GTK_TOGGLE_BUTTON (Animate)->active)  
		{
			fprintf(IoFile, "*WharfAnimate\n"); 
			fprintf(IoFile, "*WharfAnimateDelay %d\n",  gtk_spin_button_get_value_as_int 
				( GTK_SPIN_BUTTON (AnimateDelaySpinner)));
			fprintf(IoFile, "*WharfAnimateSteps %d\n", gtk_spin_button_get_value_as_int 
				( GTK_SPIN_BUTTON (AnimateStepsSpinner)));
		}
	}

	if( GTK_TOGGLE_BUTTON(Balloons)->active)  
	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Balloons\n\n"); 
		fprintf(IoFile, "*WharfBalloons\n"); 
		fprintf(IoFile, "*WharfBalloonDelay %d\n", gtk_spin_button_get_value_as_int 
			( GTK_SPIN_BUTTON (BalloonDelay)));
		fprintf(IoFile, "*WharfBalloonBorderWidth %d\n", gtk_spin_button_get_value_as_int 
			( GTK_SPIN_BUTTON (BalloonBorderWidth)));
		fprintf(IoFile, "*WharfBalloonYOffset %d\n", (gint) GTK_ADJUSTMENT(BalloonYOffset)->value);
		fprintf(IoFile, "*WharfBalloonFore %s\n", WharfBalloonFore);
		fprintf(IoFile, "*WharfBalloonBack %s\n", WharfBalloonBack);
		fprintf(IoFile, "*WharfBalloonBorderColor %s\n", WharfBalloonBorderColor);
		fprintf(IoFile, "*WharfBalloonFont "  
						"-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1\n");
	}


	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Buttons\n\n"); 
		if( !GTK_TOGGLE_BUTTON(DrawBorder)->active)  
			fprintf(IoFile, "*WharfNoBorder\n"); 
		if( GTK_TOGGLE_BUTTON(PushWharf)->active)  
			fprintf(IoFile, "*WharfFullPush\n"); 
		if( !GTK_TOGGLE_BUTTON(PushButtons)->active)  
			fprintf(IoFile, "*WharfNoPush\n"); 
	}


	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Geometry \n\n"); 
		if( GTK_TOGGLE_BUTTON(ForceSize)->active)  
			fprintf(IoFile, "*WharfForceSize\n"); 
		fprintf(IoFile, "*%s  %d\n", WharfRowCol ? "WharfColumns" : "WharfRows", 
			gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON (SizeSpinner)));

		if( GTK_TOGGLE_BUTTON(WharfGeo[0])->active)  
			fprintf(IoFile, "*WharfGeometry  +1+1\n"); 
		else if( GTK_TOGGLE_BUTTON(WharfGeo[1])->active)  
			fprintf(IoFile, "*WharfGeometry  -1+1\n"); 
		else if( GTK_TOGGLE_BUTTON(WharfGeo[2])->active)  
			fprintf(IoFile, "*WharfGeometry  +1-1\n"); 
		else if( GTK_TOGGLE_BUTTON(WharfGeo[3])->active)  
			fprintf(IoFile, "*WharfGeometry  -1-1\n"); 

	}
		
	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Texture \n\n"); 
		
		fprintf(IoFile, "*WharfTextureType %d\n", (WharfTextureType > 5) ?  128 : WharfTextureType);

		if(WharfTextureType == 0)
		{
			fprintf(IoFile, "*WharfBgColor %s\n", WharfBgColor);
		}
		else if( WharfTextureType > 0 && WharfTextureType < 6)
		{
			fprintf(IoFile, "*WharfMaxColors %d\n", gtk_spin_button_get_value_as_int 
				( GTK_SPIN_BUTTON (MaxColourSpinner)));
			fprintf(IoFile, "*WharfTextureColor %s %s\n", WharfTextureColorL, WharfTextureColorR);
		}
		else 
		{	
			fprintf(IoFile, "*WharfPixmap %s\n", WharfStyleIconName);
		}
	}
	


	{

		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Entries \n\n"); 

#ifndef GTK_STABLE_VERSION
		NestLevel = 1;
	
		gtk_ctree_pre_recursive(WharfEntryTree, NULL,
			(GtkCTreeFunc) get_ctree_info, NULL);
	
		/* 
	 	 * NestLevel should return 1. 
	 	 * In cases where a folder is the last item in the tree,
	 	 * NestLevel returns > 1.
	 	 * There really is no entry called ~Folder, so 
	 	 * gtk_ctree_pre_recursive() won't catch it.
	 	 * Instead catch the discrepancy here and print as many
	 	 * "~Folders" as needed.
	 	 */
		if(NestLevel > 1)
		{
			gint i;
			gint indent;
			gint deep=NestLevel;
		
			for(i=1; i<NestLevel; i++)
			{	
			
				for(indent=1; indent < deep; indent++)
				{
					fprintf(IoFile, "   ");
				}
			
				--deep;
				fprintf(IoFile, "*Wharf ~Folders\n");
			}
			
			NestLevel = 1;
		}
#else
		{
			wharfentry *entry;
			gint indent;
			gint i=0;
			gint deep;

			NestLevel = 0;

			entry = (wharfentry *) g_malloc0(256);

			while( (entry = (wharfentry *) gtk_clist_get_row_data (GTK_CLIST (WharfEntryList), i++)) ) 
  			{


				if(entry->nestlevel <  NestLevel )
				{
			
					for(indent=(NestLevel-entry->nestlevel); indent > 0 ; indent--)
					{
						fprintf(IoFile, "*Wharf ~Folders\n");
					}
					--NestLevel;
				}
				for(deep=0; deep < NestLevel; deep++)
						fprintf(IoFile, "   ");
		
				fprintf(IoFile,"*Wharf %s  %s", entry->name, entry->icon);
				if(entry->dots)
					fprintf(IoFile, ",3_dots.xpm ");
				fprintf(IoFile," %-20s \n", entry->command);
			
				if(! ascp_strncasecmp(entry->command, "Folder", 6))
						NestLevel++;
			}

			/* 
			 * Catch and append ~Folders as needed
			 */
			deep = NestLevel;
			for(i=0; i<NestLevel; i++)
			{	
			
				for(indent=1; indent < deep; indent++)
				{
					fprintf(IoFile, "   ");
				}
			
				--deep;
				fprintf(IoFile, "*Wharf ~Folders\n");
			}
			
		}

#endif //  GTK_LIB_DEP_CODE

	}

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");

	fclose(IoFile);
}



static gint change_wharf_entry(GtkWidget *button, gpointer data)
{
#ifndef GTK_STABLE_VERSION
	GtkCTreeNode *node;
#endif
	gchar *buffer;

	//entry = (wharfentry *) g_malloc0(256);

#ifndef GTK_STABLE_VERSION
	node = GTK_CTREE_NODE (g_list_nth (GTK_CLIST(WharfEntryTree)->row_list, CurrentRow));
#endif //  GTK_LIB_DEP_CODE

	if(!EntryClicked)
	{
		GtkWidget *button;
		gchar* msg = "  Sorry, but what exactly do you wish to have changed?  \n";

		button =  gtk_button_new_with_label("Close");
		ascp_error_popup("Change Error", msg, button);
		return TRUE;
	}

	buffer = g_malloc0( 3 + strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryName))) 
						+ strlen(WharfEntryIconName)
						+strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryCommand))));

	if(strcmp(CurrentWharfEntry->name, gtk_entry_get_text (GTK_ENTRY(WharfEntryName))))
	{
#ifndef GTK_STABLE_VERSION
		gboolean  isleaf, expanded;
		gchar *text;

		gtk_ctree_get_node_info(WharfEntryTree, node, &text, NULL, 
			NULL, NULL, NULL, NULL, &isleaf, &expanded);
						
		strcpy(CurrentWharfEntry->name, gtk_entry_get_text(GTK_ENTRY(WharfEntryName)));

		if(isleaf)
		{
			gtk_ctree_set_node_info(WharfEntryTree, node, CurrentWharfEntry->name, 5,
				PIXMAP3, MASK3, PIXMAP3, MASK3, isleaf, expanded);
		}
		else
		{
			gtk_ctree_set_node_info(WharfEntryTree, node, CurrentWharfEntry->name, 5,
				PIXMAP1, MASK1, PIXMAP2, MASK2, isleaf, expanded);
		}

#else
		GdkPixmap   *pixmap;
		GdkBitmap   *mask;


		gtk_clist_get_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0,
			NULL, NULL, &pixmap, &mask);

		strcpy(CurrentWharfEntry->name, gtk_entry_get_text(GTK_ENTRY(WharfEntryName)));
		gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
			CurrentWharfEntry->name, 5, pixmap, mask);

#endif //  GTK_LIB_DEP_CODE
	}

	if(strcmp(CurrentWharfEntry->command, gtk_entry_get_text (GTK_ENTRY(WharfEntryCommand))))
	{
		strcpy(CurrentWharfEntry->command, gtk_entry_get_text (GTK_ENTRY(WharfEntryCommand)));

		if( !ascp_strncasecmp(CurrentWharfEntry->command, "Folder", 6))
		{
#ifndef GTK_STABLE_VERSION
			gtk_ctree_set_node_info(WharfEntryTree, node, CurrentWharfEntry->name, 5,
				PIXMAP1, MASK1, PIXMAP2, MASK2, FALSE, FALSE);
#else
			gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
				CurrentWharfEntry->name, 5, PIXMAP2, MASK2);

#endif
		}
		else
		{
#ifndef GTK_STABLE_VERSION
			gtk_ctree_set_node_info(WharfEntryTree, node, CurrentWharfEntry->name, 5,
				PIXMAP3, MASK3, PIXMAP3, MASK3, TRUE, FALSE);
#else
			gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
				CurrentWharfEntry->name, 5, PIXMAP3, MASK3);

#endif
		}
	}


	if(strcmp(CurrentWharfEntry->icon, WharfEntryIconName))
	{
		strcpy(CurrentWharfEntry->icon, WharfEntryIconName);
	}

	CurrentWharfEntry->dots = GTK_WIDGET_VISIBLE(DotsIcon);

		
	return TRUE;
}


static gint new_wharf_entry(GtkWidget *button, gpointer data)
{
	gchar *buffer;
	gchar *context = "";

#ifndef GTK_STABLE_VERSION
	GtkCTreeNode *node = NULL;
#endif //  GTK_LIB_DEP_CODE

	gboolean error=FALSE;
	wharfentry *newentry = (wharfentry *) g_malloc0(256);

	
	if( strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryName))) == 0)
	{
		context = "  It appears that you did not enter a label.  \n";
		error = TRUE;
	}
	if( ascp_strncasecmp(WharfEntryIconName, "-", 1) &&  !strstr(WharfEntryIconName, ".xpm"))
	{
		g_print("ascp_strcmp is %d, and !strstr  is %d\n", 
			(gboolean)ascp_strncasecmp(WharfEntryIconName, "-", 1),  (gboolean)!strstr(WharfEntryIconName, ".xpm"));
		context = "  It appears that you do not have a valid icon.\n";
		error = TRUE;
	}
							
	if( strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryCommand))) == 0)
	{
		context = "  It appears that you did not enter a command.  \n";
		error = TRUE;
	}
							

	buffer = g_malloc0( 3 + strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryName))) +
						  strlen(WharfEntryIconName) + 
					      strlen(gtk_entry_get_text (GTK_ENTRY (WharfEntryCommand))));
	 
	sprintf(buffer, "%s %s %s", gtk_entry_get_text (GTK_ENTRY (WharfEntryName)),
								 WharfEntryIconName, 
					             gtk_entry_get_text (GTK_ENTRY (WharfEntryCommand)));
	 
	if(!error)
		newentry =  init_wharf_entry(buffer
#ifdef GTK_STABLE_VERSION
, 0
#endif
	);
	
	if(newentry == NULL)
	{
		context = "  Unable to allocate memory for new entry.  \n";
		error = TRUE;
	}
	
	if(error)
	{
		GtkWidget *button;
		gchar* msg = "  Sorry, but the entry could not be added:  \n\n %s";
		
		buffer  = g_malloc0(strlen(msg) + strlen(context) + 1);
		sprintf(buffer, msg, context);
		button =  gtk_button_new_with_label("Close");
		ascp_error_popup("Insert Error", buffer, button);
		
		return TRUE;
	}
		
	else
	{
		gchar *label[] = {newentry->name};

#ifndef GTK_STABLE_VERSION
		if( !ascp_strncasecmp(newentry->command, "Folder", 6))
		{
			node = gtk_ctree_insert (WharfEntryTree, NULL, //parent[NestLevel], 
				NULL, label, 5, PIXMAP1, MASK1, PIXMAP2, MASK2, FALSE, FALSE);
		}
		else
		{
			g_print("%s|\n",label[0]);
			node = gtk_ctree_insert (WharfEntryTree, NULL, //parent[NestLevel], 
				NULL, label, 5, PIXMAP3, MASK3, PIXMAP3, MASK3, TRUE, FALSE);
		}
		gtk_ctree_set_row_data (WharfEntryTree, node, (wharfentry *) newentry);
	
#else
		if( !ascp_strncasecmp(newentry->command, "Folder", 6))
		{
			gtk_clist_insert(GTK_CLIST(WharfEntryList), CurrentRow, label);
			gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
				newentry->name, 5, PIXMAP2, MASK2);
		}
		else
		{
			gtk_clist_insert(GTK_CLIST(WharfEntryList), CurrentRow, label);
			gtk_clist_set_pixtext(GTK_CLIST(WharfEntryList), CurrentRow, 0, 
				newentry->name, 5, PIXMAP3, MASK3);
		}

		gtk_clist_set_shift(GTK_CLIST(WharfEntryList), CurrentRow, 0, 0, CurrentNestLevel*20);
		gtk_clist_set_row_data(GTK_CLIST(WharfEntryList), CurrentRow, (wharfentry *) newentry);

#endif //  GTK_LIB_DEP_CODE
	
		return TRUE;
	}

}



static void set_row_col(GtkWidget *widget, gpointer *data)
{
	gtk_label_set(  GTK_LABEL(RowColLabel), (gchar *) data );
	WharfRowCol = strcmp("Rows", (gchar  *) data) ? COL : ROW;
}


		
static void  texture_hide_show(GtkWidget *widget, gint type)
{
	if( type == 0)
	{
		WharfTextureType = type;
		gtk_widget_show_all(TextureParent[2]);
		gtk_widget_hide_all(TextureParent[0]);
		gtk_widget_hide_all(TextureParent[1]);
	}
	else if( type > 0 && type < 6)
	{
		WharfTextureType = type;
		gtk_widget_show_all(TextureParent[1]);
		gtk_widget_hide_all(TextureParent[0]);
		gtk_widget_hide_all(TextureParent[2]);
	}
	else
	{
		WharfTextureType = 128;
		gtk_widget_show_all(TextureParent[0]);
		gtk_widget_hide_all(TextureParent[1]);
		gtk_widget_hide_all(TextureParent[2]);
	}
}



static void anim_balloon_hide_show(GtkWidget *widget, gint which)
{
	if(which == 0)
	{
		gtk_widget_show(AnimBallParent[0]);
		gtk_widget_hide(AnimBallParent[1]);
	}
	else 
	{
		gtk_widget_show(AnimBallParent[1]);
		gtk_widget_hide(AnimBallParent[0]);
	}
}

static void affect_wharf_entry_button(GtkWidget *widget, gint dowhat)
{
	if(dowhat == 0)
	{
		strcpy(WharfEntryIconName, "-");
		gtk_widget_hide(DotsIcon);

		if(GTK_BIN(WharfEntryIcon)->child)
			 gtk_container_remove(GTK_CONTAINER(WharfEntryIcon),GTK_BIN(WharfEntryIcon)->child);


		gtk_container_add(GTK_CONTAINER(WharfEntryIcon), gtk_label_new("\nNone\n"));
		gtk_widget_draw_default(WharfEntryIcon);
		gtk_widget_show_all(WharfEntryIcon);

	}
	else if(dowhat == 1)
	{
		gtk_widget_show(DotsIcon);
	}
	else if(dowhat == 3)
	{
		gtk_widget_hide(DotsIcon);
	}
}

	

static void affect_wharf_style_button(GtkWidget *widget, gint dowhat)
{

	strcpy(WharfStyleIconName, "-");

	if(GTK_BIN(WharfStyleIcon)->child)
		gtk_container_remove(GTK_CONTAINER(WharfStyleIcon),GTK_BIN(WharfStyleIcon)->child);

	gtk_container_add(GTK_CONTAINER(WharfStyleIcon), gtk_label_new("\nNone\n"));
	gtk_widget_draw_default(WharfStyleIcon);
	gtk_widget_show_all(WharfStyleIcon);
}
						  

