
//closed_style = gtk_widget_get_style(notebook);  
//// for the background transparency

//open_style = gtk_widget_get_style(notebook); 
//// of the pixmaps

/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/*
 * Naming Convention:
 *
 * local variables:  localvariables;
 * global variables:  GlobalVariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions;
 * application wide functions:   ascp_foobar;
 *
 */


#include "ascp.h"


/* passing pointers to functions
 * 
 * install_verify (InstallCallback install_callback)
 * {
 * 	 contains this call:
 * 	 (* install_callback) ();
 * 
 * }
 * 
 * when it is called by:
 * install_verify (init);
 * 
 * where init() is defined as:
 * static void * init () 
 * { 
 * 		;  
 * }
 *
 * and InstallCallback is of type:
 * typedef void (* InstallCallback) (void); 
 * 
 */ 



int main (gint argc, gchar **argv)
{
	gchar *rcfile;
#ifdef I18N
	gtk_set_locale();
#endif

	gtk_init (&argc, &argv);	
	
	HOMEDIR= getenv("HOME");
	ASCPERROR = FALSE;
	
	rcfile = g_malloc(BUFFERSIZE);
	sprintf(rcfile,"%s/.gnome/gtkrc",HOMEDIR);
    gtk_rc_parse(rcfile);
	free(rcfile);


#ifdef I18N
	rcfile = ascp_make_path(HOMEDIR, ASHOMEPATH, "ascp/ascprc");
	gtk_rc_parse(rcfile);
	free(rcfile);
#endif

	
	/* 
	 * Set up the user config options of
	 * ascp itself;
	 */
	/* Will add later in ascp_parse*/
	/* 
	 * Has now become a page! This is found in the file ascp.c
	 */
	ascp_parse();

	/*
	 * This involves building the GUI so you'll find it in gui.c.
	 */
	ascp_init();
	
	gtk_main ();

			        
	return 0;

}


void ascp_exit (GtkWidget *widget, GdkEvent *event, gpointer *data)
{
	gtk_main_quit ();
}



void ascp_save_page (GtkWidget *widget, GtkWidget *notebook)
{   
	switch( gtk_notebook_current_page (GTK_NOTEBOOK(notebook)) )
	{
		case 0: ascp_write_base(); break;
		case 1:
		case 2: ascp_write_wharf();  break;
		case 3: ascp_write_database(); break;
		case 4: ascp_write_pager(); break;
		case 5: ascp_write_animate(); break;
		case 6: ascp_write_audio(); break;
		case 7: ascp_write_autoexec(); break;
		
	}
}


void ascp_save_all (GtkWidget *widget, gpointer *blank)
{
	ascp_write_base();
	ascp_write_wharf();  
	ascp_write_database();
	ascp_write_pager();
	ascp_write_animate();
	ascp_write_audio(); 
	ascp_write_autoexec();
}


/* 
 * Get the current page of the notebook, 
 * and feed that to David's help function.
 */
void ascp_help (GtkWidget *widget, GtkWidget *notebook)
{
	gint page;
	gchar *location;
	struct stat filestat;

	location = (gchar *) g_malloc0(64);

	page = (gint) gtk_notebook_current_page (GTK_NOTEBOOK(notebook));

	location = ascp_make_path(HOMEDIR, ASHOMEPATH, "ascp/help");

	if( stat(location, &filestat)  == -1)
	{
		g_free(location);
		location = ascp_make_path(ASSHAREPATH, "", "ascp/help");
	}

	help( page, location);
	g_free(location);
}


gchar * ascp_make_path(gchar *root_path, gchar *subpath, gchar *filename)
{
    gchar* path = (gchar*) g_malloc0(strlen(root_path) 
 		+ strlen(subpath) + strlen(filename) + 3);

	sprintf(path, "%s/%s/%s", root_path, subpath, filename);
	return path;
}


FILE * ascp_open_file(gchar *filename, gchar *action)
{

	gchar *buffer;
	FILE *iofile;
	struct stat filestat;
   
   	buffer = ascp_make_path(HOMEDIR, ASHOMEPATH, filename);
	iofile = fopen (buffer, action);

	if(iofile == NULL)
	{
		g_free(buffer);
		buffer = ascp_make_path(ASSHAREPATH, "", filename);
		iofile = fopen (buffer, "rb");
	}

	if(iofile == NULL)
	{
		GtkWidget *button =  gtk_button_new_with_label("Exit!");
		gchar* msg ="For some reason, the configuration file \"%s\"\n"
					"could not be opened.\n"
					"I am looking in %s/%s/%s\n"
					"and %s/%s.\n\n"
					"Please exit and make sure that you\n"
					"have permissions to read it.";


		buffer = (char*) g_malloc0( strlen(msg) + 3*strlen(filename)
			+ strlen(HOMEDIR) + strlen(ASHOMEPATH) + strlen(ASSHAREPATH) + 2 );

		sprintf(buffer, msg, filename, HOMEDIR, ASHOMEPATH, filename, ASSHAREPATH, filename);
	
		GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default (button);

		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC(ascp_exit), (gpointer) NULL);

		ascp_error_popup("file not found", buffer, button);

	}
	else
	{
		stat(buffer, &filestat);
		FILESIZE = filestat.st_size;
		return iofile;
	}

	/*
	 * We have a problem if control reaches here.
	 * Set the error flag and let the caller deal with it.
	 */
	ASCPERROR = TRUE;
	return NULL;
}


gchar* ascp_strndup(const gchar* str, gint len)
{
	gchar* ptr = NULL; 
	
	if (len > 0) 
	{
		ptr = g_new(gchar, len + 1);
		
		if (ptr != NULL) 	
		{ 
			strncpy(ptr, str, len);
		
			ptr[len] = '\0'; 
		}
	}
	return ptr;
}


gint ascp_strncasecmp(char *s1, char *s2, gint n)
{
	register int c1, c2;
	
	for (;;) 
	{
		if (!n)
			return (0);

		c1 = *s1, c2 = *s2;
		if (!c1 || !c2)
			return (c1 - c2);
		
		if (isupper(c1))
			c1 = 'a' - 1 + (c1 & 31);

		if (isupper(c2))
		c2 = 'a' - 1 + (c2 & 31);

		if (c1 != c2)
			return (c1 - c2);
	
		n--, s1++, s2++;
	}
}

		


