/*
 * gtkHelp : a helper application, intended to be useful to any application.
 *
 * Copyright (C) 1998, David Taylor (dtaylor@cit.nepean.uws.edu.au).
 * You may distribute/use this software under the terms of the GNU 
 * General Public License.
 *
 * Features:
 *   - External loading of man pages.
 *   - HTML-like help file structure... kind of (give me time).
 *   - Remains memory-resident after initial loading... kind of.
 *
 * Notes:
 *   - Please forgive messy/bad coding.  I'm still fumbling with GTK.
 *   - This is only tested on linux.
 *   - I haven't found any bugs.  
 *   - I haven't actively looked for any bugs.
 *   - There are unimplemented features ... give me time.
 *   - Please, if you can, give me some help with this.
 *   - You can be reach me via e-mail/icq/irc:
 *       - E-mail : dtaylor@cit.nepean.uws.edu.au
 *       - IRC    : KnetRider in #afterstep on Efnet.
 *       - ICQ    : 9655092
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "help.h"


/* Help files location */
char *loc;

/* Miscellaneous titles.   */
gchar *helptitle    = "ascp Help";
gchar *abouttitle   = "About"; 
gchar *aboutframe   = "About the AfterStep Control Panel";


/* The relevant man pages. */
gchar *manitems[]   = { "Animate" ,
                        "Audio"   ,
                        "Auto"    ,
                        "Banner"  ,
                        "Cascade" ,
                        "Clean"   ,
                        "Form"    ,
                        "Ident"   ,
                        "Pager"   ,
                        "Save"    ,
                        "Script"  ,
                        "Scroll"  ,
                        "Tile"    ,
                        "Wharf"   ,
                        "WinList" ,
                        "Zharf"   ,
                        "afterstep" };


/* The title of each notebook page. */
gchar *pagetitles[] = { 
						"Paths",
						"Wharf Entries" ,
                        "Wharf Style"   ,
                        "Database"      ,
                        "Pager"         ,
                        "Animate"       ,
						"Audio"         ,
						"Autoexec"      };


/* The files for the online help.   */
gchar *helpfiles[]  = { "paths.hlp"        ,
						"wharfentries.hlp" ,
                        "wharfstyle.hlp"   ,
                        "database.hlp"     ,
                        "pager.hlp"        ,
						"animate.hlp"      ,
                        "audio.hlp"        ,
                        "autoexec.hlp"     };


/* ABOUT page description of ascp.  */
gchar *description  = 
"The AfterStep Control Panel is a control panel for the AfterStep \n" \
"window manager.  ascp is intended to be used as a GUI to         \n" \
"modifiy all of your AfterStep configuration files.                 ";


/* ABOUT page copyright for ascp.   */
gchar *copyright    = 
"ascp Copyright (C) 1998  Nwanua Elumeze.                         \n" \
"nwanua@colorado.edu                                            \n\n" \
"gtkHelp Copyright (c) 1998  David Taylor.                        \n" \
"dtaylor@cit.nepean.uws.edu.au                                  \n\n" \
"Icons Copyright (c) 1997  Marco van Hylckama Vlieg.              \n" \
"marco@windowmaker.org                                          \n\n" \
"These may be distributed under the terms of the GNU General      \n" \
"Public License as specified in the file, COPYING                   ";


/* Pixmaps for online help pages.   */
GdkPixmap *book_open;
GdkPixmap *book_closed;
GdkBitmap *book_open_mask;
GdkBitmap *book_closed_mask;

char * book_open_xpm[] = {
"16 16 4 1",
"       c None s None",
".      c black",
"X      c #808080",
"o      c white",
"                ",
"  ..            ",
" .Xo.    ...    ",
" .Xoo. ..oo.    ",
" .Xooo.Xooo...  ",
" .Xooo.oooo.X.  ",
" .Xooo.Xooo.X.  ",
" .Xooo.oooo.X.  ",
" .Xooo.Xooo.X.  ",
" .Xooo.oooo.X.  ",
"  .Xoo.Xoo..X.  ",
"   .Xo.o..ooX.  ",
"    .X..XXXXX.  ",
"    ..X.......  ",
"     ..         ",
"                "};


char * book_closed_xpm[] = {
"16 16 6 1",
"       c None s None",
".      c black",
"X      c red",
"o      c yellow",
"O      c #808080",
"#      c white",
"                ",
"       ..       ",
"     ..XX.      ",
"   ..XXXXX.     ",
" ..XXXXXXXX.    ",
".ooXXXXXXXXX.   ",
"..ooXXXXXXXXX.  ",
".X.ooXXXXXXXXX. ",
".XX.ooXXXXXX..  ",
" .XX.ooXXX..#O  ",
"  .XX.oo..##OO. ",
"   .XX..##OO..  ",
"    .X.#OO..    ",
"     ..O..      ",
"      ..        ",
"                "};




void help (gint page, gchar *help_loc)
{

    static GtkWidget *window;
    static GtkWidget *notebook;
    GtkWidget *vbox;
    guint i;
    
    loc = help_loc;
            
    if ( window == NULL )  {
        /* Help is being loaded for the first time */

        window = create_window ( );
        
	/* Create holder for notebook and buttons. */
        vbox = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (window), vbox);
        gtk_widget_show (vbox);

        notebook = create_and_pack_notebook ( vbox );

        create_pixmaps ( notebook );

		NUM_PAGES = ((sizeof(helpfiles)) / sizeof(*helpfiles) );

        for ( i = 0; i < NUM_PAGES; i++ )  {
            append_help_page ( notebook, i );            
        }

        append_about_page ( notebook );
        
        create_and_pack_buttons ( window, notebook, vbox );

    }

    gtk_notebook_set_page ( GTK_NOTEBOOK (notebook), page );
    
    gtk_widget_show ( window );
    
    gdk_window_raise ( window->window );
    
}



void close_help( GtkWidget *window, gpointer data )
/*-----------------------------------------------*/
/* Callback to hide the help...                  */
/*-----------------------------------------------*/
{
    gtk_widget_hide ( window );
}



void about_page( GtkWidget *notebook, gpointer data )
/*-----------------------------------------------*/
/* Callback to jump to "About" page...           */
/*-----------------------------------------------*/
{
    gtk_notebook_set_page ( GTK_NOTEBOOK(notebook), NUM_PAGES );
}



void search_text( GtkWidget *text, gchar *str )
/*------------------------------------------------------*/
/* This searches the text widget for a specific string. */
/* If the string is found the location is returned.     */
/* Otherwise, a null pointer is returned.               */
/*------------------------------------------------------*/
{
    /* THIS FEATURE IS UNIMPLEMENTED */
}



void populate_text(GtkWidget *text, gint page)
/*---------------------------------------------------*/
/* This fills the text widget with the contents of a */
/* file specified in helpfiles[page].                */
/*---------------------------------------------------*/
{
    GdkColormap *cmap;
    GdkColor    color, plain_color, hdg_color, warn_color;
    GdkFont     *font;
    
    FILE *infile;
    
    /* Pre-set the available fonts for help text */
    char *plain_font  = "-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*";
    char *italic_font = "-misc-fixed-medium-i-*-*-*-120-*-*-*-*-*-*";
    char *bold_font   = "-misc-fixed-bold-r-*-*-*-120-*-*-*-*-*-*";
    char *sub_font    = "-misc-fixed-bold-r-*-*-*-120-*-*-*-*-*-*";
    char *hdg_font    = "-misc-fixed-bold-r-*-*-*-140-*-*-*-*-*-*";
    char helpfile[256];

    /* Create helpfile string */
    strcpy(helpfile, loc);
    strcat(helpfile, "/");
    strcat(helpfile, helpfiles[page]);

    /* Get the colour map and allocate colours */
    cmap = gdk_colormap_get_system();
    extract_color(&warn_color, 257, 0, 0);
    gdk_color_alloc(cmap, &warn_color);
    extract_color(&hdg_color, 0, 0, 200);
    gdk_color_alloc(cmap, &hdg_color);
    extract_color(&plain_color, 0, 0, 0);
    gdk_color_alloc(cmap, &plain_color);
    
    //fprintf(stderr, "Opening: %s\n", helpfile);
    
    if ( NULL != (infile = fopen(helpfile, "r")) )  {
        char *buffer = (char *) g_malloc0(BUFSIZ);
        while ( !feof(infile) )  {
            (void *) fgets(buffer, BUFSIZ, infile);
            if ( 0 == strncmp(buffer, "<h>", 3) )  {
                /* Main heading.  */
                buffer += 3;
                font  = gdk_font_load (hdg_font);
                color = hdg_color;
            } else
            if ( 0 == strncmp(buffer, "<s>", 3) )  {
                /* Subheading.    */
                buffer += 3;
                font  = gdk_font_load (sub_font);
                color = plain_color;
            } else  
            if ( 0 == strncmp(buffer, "<i>", 3) )  {
                /* Italic text.   */
                buffer += 3;
                font  = gdk_font_load (italic_font);
                color = plain_color;
            } else {
                /* Plain text */
                font  = gdk_font_load (plain_font);
                color = plain_color;
            }
            if ( 0 == strncmp(buffer, "<c>", 3) )  {
                /* Commented text */
                /* Just ignore it */
                /* for now.       */
            } else {
                gtk_text_insert (GTK_TEXT (text), font, &color,
                                 NULL, buffer, strlen(buffer));
            }
        }
        free(buffer);
        fclose(infile);
    }  else  {
        font  = gdk_font_load (bold_font);
        color = warn_color;
        gtk_text_insert (GTK_TEXT (text), font, &color,
                         NULL, "Help file not found!", 20);
    }

}



static gushort convert_color( unsigned c )
/*-------------------------------------------------*/
/* It converts integers to the corresponding hex   */
/* representation... somehow.                      */
/*-------------------------------------------------*/
{ 
    if (c==0) return(0);
    c *= 257;
    return(c > 0xffff) ? 0xffff : c;
}
   


void extract_color(GdkColor *color, unsigned red, 
                   unsigned green, unsigned blue )
/*------------------------------------------------------*/
/* This procedure controls the conversion of RGB color  */
/* codes to icky hexadecimal.                           */
/*------------------------------------------------------*/
{
    color->red   = convert_color(red);
    color->green = convert_color(green);
    color->blue  = convert_color(blue);
}



static void page_switch ( GtkWidget *widget, 
                          GtkNotebookPage *page, 
                          gint page_num )
/*--------------------------------------------------------*/
/* This procedure handles the changing from one page to   */
/* another.  It ensures that the correct pixmap is shown. */
/*--------------------------------------------------------*/
{
    GtkNotebookPage *oldpage;
    GtkWidget       *pixwid;

    oldpage = GTK_NOTEBOOK (widget)->cur_page;

    if (page == oldpage)  return;	/* No need to change anything */

    /* Change the look of the newly selected page */ 
    pixwid = ((GtkBoxChild*)(GTK_BOX (page->tab_label)->children->data))->widget;
    gtk_pixmap_set (GTK_PIXMAP (pixwid), book_open, book_open_mask);
    pixwid = ((GtkBoxChild*) (GTK_BOX (page->menu_label)->children->data))->widget;
    gtk_pixmap_set (GTK_PIXMAP (pixwid), book_open, book_open_mask);
    
    /* Restore the look of the previous page */
    if (oldpage)  {
        pixwid = ((GtkBoxChild*) (GTK_BOX (oldpage->tab_label)->children->data))->widget;
        gtk_pixmap_set (GTK_PIXMAP (pixwid), book_closed, book_closed_mask);
        pixwid = ((GtkBoxChild*) (GTK_BOX (oldpage->menu_label)->children->data))->widget;
        gtk_pixmap_set (GTK_PIXMAP (pixwid), book_closed, book_closed_mask);
    }

}



GtkWidget *create_window ( )
/*---------------------------------------------------*/
/* This procedure creates and configures the window  */
/*---------------------------------------------------*/ 
{
    GtkWidget *window;
    
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize (window, 500, 400);
    gtk_signal_connect ( GTK_OBJECT (window), "destroy",
                         GTK_SIGNAL_FUNC(close_help), NULL);
    gtk_signal_connect ( GTK_OBJECT (window), "delete_event",
                         GTK_SIGNAL_FUNC(close_help), NULL);
    gtk_window_set_title (GTK_WINDOW (window), helptitle);
    gtk_container_border_width (GTK_CONTAINER (window), 5);
    
    return ( window );
}



GtkWidget *create_and_pack_notebook ( GtkWidget *vbox )
/*----------------------------------------------------------*/
/* This procedure configures all settings for the notebook, */
/* including the help pixmaps.                              */
/*----------------------------------------------------------*/
{
    GtkWidget *notebook;
    
    notebook = gtk_notebook_new ();
    gtk_signal_connect ( GTK_OBJECT (notebook), "switch_page",
                         GTK_SIGNAL_FUNC (page_switch), NULL);
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
    gtk_container_border_width (GTK_CONTAINER (notebook), 5);
    gtk_notebook_popup_enable (GTK_NOTEBOOK (notebook));
    gtk_widget_show (notebook);  
    gtk_widget_realize (notebook);
    
    return (notebook);
}



void create_and_pack_buttons ( GtkWidget *win, 
                               GtkWidget *notebook, 
                               GtkWidget *vbox )
/*----------------------------------------------------------*/
/* This procedure adds the "About", "Man Pages" ad "Close"  */
/* close buttons to a vbox, which is packed in a notebook.  */
/*----------------------------------------------------------*/
{
    GtkWidget *hbox;
    GtkWidget *menu;
    GtkWidget *menu_items;
    GtkWidget *button;
    guint     i;
    
    /* Create horizontal box for buttons. */
    hbox = gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
    gtk_container_border_width(GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
        
    /* Create the ABOUT button. */
    button = gtk_button_new_with_label ("About");
    gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC(about_page), 
                               GTK_OBJECT (notebook));
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (button);
    gtk_widget_show (button);

    /* Create the man page menu. */
    menu = gtk_menu_new ();
	NUM_MAN_ITEMS = ( (sizeof(manitems)-sizeof(*manitems)) / sizeof(*manitems) );

    for ( i = 0; i < NUM_MAN_ITEMS; i++ )  {
        menu_items = gtk_menu_item_new_with_label(manitems[i]);
        gtk_menu_append(GTK_MENU (menu), menu_items);
        gtk_signal_connect_object( GTK_OBJECT(menu_items), "activate",
                                   GTK_SIGNAL_FUNC(man_menu_response), 
                                   (gpointer) g_strdup(manitems[i]));
        gtk_widget_show(menu_items);
    }
    button = gtk_button_new_with_label("Man Pages");
    gtk_signal_connect_object ( GTK_OBJECT(button), "event",
                                GTK_SIGNAL_FUNC (man_menu_select), 
                                GTK_OBJECT(menu) );
    gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_widget_show (button);
    
    /* Create the CLOSE button. */
    button = gtk_button_new_with_label ("Close");
    gtk_signal_connect_object ( GTK_OBJECT (button), "clicked",
                                GTK_SIGNAL_FUNC(close_help), 
                                GTK_OBJECT (win));
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (button);
    gtk_widget_show (button);
}



void create_pixmaps ( GtkWidget *notebook )
/*----------------------------------------------------*/
/* This procedure creates the pixmaps to be used for  */
/* the notebook tabs and pop-up menu.                 */
/*----------------------------------------------------*/
{
    book_open   = gdk_pixmap_create_from_xpm_d (notebook->window,
                                                &book_open_mask, 
                                                NULL, 
                                                book_open_xpm);
    book_closed = gdk_pixmap_create_from_xpm_d (notebook->window,
                                                &book_closed_mask,
                                                NULL, 
                                                book_closed_xpm);
}



GtkWidget *create_pixmap_label ( gchar *title )
/*-------------------------------------------------------*/
/* This procedure generates a label which contains text  */
/* and a pixmap.                                         */
/*-------------------------------------------------------*/
{
    GtkWidget *box;
    GtkWidget *label;
    GtkWidget *pixwid;

    box    = gtk_hbox_new (FALSE, 0);
    pixwid = gtk_pixmap_new (book_closed, book_closed_mask);
    gtk_box_pack_start (GTK_BOX (box), pixwid, FALSE, TRUE, 0);
    gtk_misc_set_padding (GTK_MISC (pixwid), 3, 1);
    
    label  = gtk_label_new (title);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, TRUE, 0);
    gtk_widget_show_all (box);
    
    return (box);
}



void insert_help_text ( GtkWidget *table, GtkWidget *text, guint i )
/*----------------------------------------------------------------*/
/* This procedure creates, configures, freezes, populates, thaws, */
/* and then shows the text widget with the appropriate help text. */
/*----------------------------------------------------------------*/
{
    GtkWidget *vscrollbar;
    GdkPixmap *null_pixmap;

    /* Create text widget for the help */
    text = gtk_text_new (NULL, NULL);
    gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
    gtk_text_set_editable(GTK_TEXT (text), FALSE);
    gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
    gtk_widget_show (text);

    gtk_widget_realize (text);
    
    gtk_text_freeze (GTK_TEXT (text));
    
    /* Get rid of those annoying curly wordwrap arrows */
    null_pixmap = gdk_pixmap_new (NULL, 1, 1, 1);
    (GTK_TEXT (text))->line_wrap_bitmap  = null_pixmap;
    (GTK_TEXT (text))->line_arrow_bitmap = null_pixmap;

    populate_text(text, i);
    
    gtk_text_thaw (GTK_TEXT (text));

    vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
    gtk_table_attach ( GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
                       GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_widget_show (vscrollbar);
}



void append_help_page ( GtkWidget *notebook, guint i )
{
    GtkWidget *vbox;
    GtkWidget *text;
    GtkWidget *table;
    GtkWidget *label_box;
    GtkWidget *menu_box;

	/* Just to quiet the compiler and not alarm our users */
	text = NULL;  

    /* Create vertical box holder for table. */
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_border_width (GTK_CONTAINER (vbox), 5);
    gtk_widget_show (vbox);

    /* Create table to hold text and scrollbar. */
    table = gtk_table_new (2, 2, FALSE);
    gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
    gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
    gtk_container_border_width (GTK_CONTAINER (table), 5);
    gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
    gtk_widget_show (table);
            
    label_box = create_pixmap_label ( pagetitles[i] );
    menu_box  = create_pixmap_label ( pagetitles[i] );

    gtk_notebook_append_page_menu ( GTK_NOTEBOOK (notebook), vbox, 
                                    label_box, menu_box );

    insert_help_text ( table, text, i );

}



void append_about_page ( GtkWidget *notebook )
/*---------------------------------------------------------*/
/* This procedure adds the ABOUT page to the notebook.  It */
/* also adds the pixmaps to the notebook and the menu, and */
/* inserts the labels into the frame.                      */
/*---------------------------------------------------------*/ 
{
    GtkWidget *frame;
    GtkWidget *vbox;
    GtkWidget *separator;
    GtkWidget *label;
    GtkWidget *labelbox, *menubox;

    frame = gtk_frame_new ( aboutframe );
    gtk_container_border_width ( GTK_CONTAINER (frame), 5 );
    gtk_widget_show (frame);
    
    labelbox = create_pixmap_label ( abouttitle );
    menubox  = create_pixmap_label ( abouttitle );

    gtk_notebook_append_page_menu ( GTK_NOTEBOOK (notebook), frame, 
                                    labelbox, menubox );
    
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_container_border_width (GTK_CONTAINER (vbox), 5);
    gtk_widget_show (vbox);
        
    label = gtk_label_new ( description );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
    gtk_widget_show (label);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 10);
    gtk_widget_show (separator);

    label = gtk_label_new ( copyright );
    gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
    gtk_widget_show (label);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  
}



gint man_menu_select (GtkWidget *widget, GdkEvent *event)
/*-----------------------------------------------------*/
/* This procedure handles the event that occurs when   */
/* the menu of man pages is clicked on.  It pops up    */
/* the menu ready for selection,                       */
/*-----------------------------------------------------*/
{
    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event;
        gtk_menu_popup (GTK_MENU(widget), NULL, NULL, NULL, NULL,
                        bevent->button, bevent->time);
        /* Tell calling code that we have handled this event */
        return TRUE;
    }
    /* Tell calling code that we have not handled this event */
    return FALSE;
}



void man_menu_response (gchar *manpage)
/*---------------------------------------------------------*/
/* This procedure starts a new process, which executes an  */
/* xterm to display the selected man page.                 */
/*---------------------------------------------------------*/
{
    char *term     = "xterm";
    char *term_loc = "/usr/X11R6/bin/xterm";
    char *man_loc   = "/usr/bin/man";
    if ( fork() == 0 )  {
        if ( -1 == execl(term_loc, term, "-e",
                         man_loc, manpage, "&", 0) )  {
            perror("ERROR> execl man page");
        }
        exit(EXIT_SUCCESS);
    }
}
