/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
				  
#include "xpm.h"
#include "ascp.h"


/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */

/*----------------------------------*/
static FILE *IoFile;
/*----------------------------------*/


GtkWidget *Parent[2];
GtkWidget *Entries[3];

GtkWidget *InitList;
GtkWidget *RestartList;

gint CurrentList;
gint CurrentRow;

static void init_and_append_entry(gchar *, gint);
static gint add_action(GtkWidget *, gpointer);
static gint move_action_up(GtkWidget *, gpointer);
static gint move_action_down(GtkWidget *, gpointer);
static gint remove_action(GtkWidget *, gpointer);
static gint change_action(GtkWidget *, gpointer);
static void parse_autoexec(gfloat, gfloat);
static void init_restart_hide_show(GtkWidget *, gint);
static gint item_selected(GtkWidget *, gint, gint, GdkEventButton *, gpointer data);



GtkWidget * ascp_draw_autoexec(gfloat min, gfloat max)
{
	/*
	 * The toplevel table that shall be returned to
	 * populate_frame().
	 */
	GtkWidget *tabletop =  gtk_table_new(10, 14, TRUE);

	
	if(ASCPERROR)
		return gtk_label_new("ascp Error");

	/*
	 * Create the lists "Init" and "Restart".
	 */
	{
		gchar *titles[] = {"Action", "ID"}; 
		GtkWidget *scrolledwin;

		
		Parent[0] = gtk_frame_new(NULL);

		scrolledwin = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
			GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);

		InitList = gtk_clist_new_with_titles(2, titles);
		gtk_clist_set_column_width (GTK_CLIST(InitList), 0, 110);  
		gtk_clist_set_column_width (GTK_CLIST(InitList), 1, 20); 
		gtk_clist_column_title_passive(GTK_CLIST(InitList), 0);
		gtk_clist_column_title_passive(GTK_CLIST(InitList), 1);
		gtk_signal_connect(GTK_OBJECT(InitList), "select_row",
			GTK_SIGNAL_FUNC(item_selected), NULL);

		
			
#ifdef GTK_STABLE_VERSION
		gtk_container_add(GTK_CONTAINER(scrolledwin), InitList);
#else
		//gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), InitList);
		gtk_container_add(GTK_CONTAINER(scrolledwin), InitList);
#endif
		
		gtk_container_add(GTK_CONTAINER(Parent[0]), scrolledwin);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), Parent[0], 0, 7, 1, 8);

		Parent[1] = gtk_frame_new(NULL);

		RestartList = gtk_clist_new_with_titles(2, titles);
		gtk_clist_set_column_width (GTK_CLIST(RestartList), 0, 110);  
		gtk_clist_set_column_width (GTK_CLIST(RestartList), 1, 20); 
		gtk_clist_column_title_passive(GTK_CLIST(RestartList), 0);
		gtk_clist_column_title_passive(GTK_CLIST(RestartList), 1);
		gtk_signal_connect(GTK_OBJECT(RestartList), "select_row",
			GTK_SIGNAL_FUNC(item_selected), NULL);
	
		scrolledwin = gtk_scrolled_window_new (NULL, NULL);
		
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
			GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);
			
#ifdef GTK_STABLE_VERSION
		gtk_container_add(GTK_CONTAINER(scrolledwin), RestartList);
#else
		//gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), RestartList);
		gtk_container_add(GTK_CONTAINER(scrolledwin), RestartList);
#endif

		gtk_container_add(GTK_CONTAINER(Parent[1]), scrolledwin);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), Parent[1], 0, 7, 1, 8);
		
		

		/*
		
gtk_clist_set_use_drag_icons(GTK_CLIST(RestartList), TRUE); 
		gtk_clist_set_pixmap(GTK_CLIST(RestartList), 0, 1, 
						PIXMAP3, MASK3);
						*/
						
	}

	/*
	 * The up/down buttons.
	 */
	{
		GtkWidget *vbox;
		GtkWidget *button;

		vbox = gtk_vbox_new(TRUE, 0);

		button = gtk_button_new();
		gtk_container_add (GTK_CONTAINER (button),
			GTK_WIDGET(ascp_make_pixmap_from_data(up)));
		gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(move_action_up), NULL);
		gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);


		button = gtk_button_new();
		gtk_container_add (GTK_CONTAINER (button),
			GTK_WIDGET(ascp_make_pixmap_from_data(down)));
		gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(move_action_down), NULL);
		gtk_box_pack_end(GTK_BOX(vbox), button, TRUE, TRUE, 0);


		gtk_table_attach( GTK_TABLE(tabletop), vbox, 7, 8, 4, 7,
			GTK_SHRINK, GTK_SHRINK, 0, 0);
		gtk_widget_show_all(vbox);
	}



	/* 
	 * The option menu to choose from "Init" and "Restart".
	 */
	{
		GtkWidget *menu;
		GtkWidget *menuitem;
		GtkWidget *optionmenu;
		gint i=0;
		char *types [] = {
				"Init",
				"Restart"
				};


		menu = gtk_menu_new ();
		optionmenu = gtk_option_menu_new ();

		for(i=0; i < (sizeof(types)/sizeof(*types)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(types[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);
			gtk_signal_connect(GTK_OBJECT(menuitem), "activate", 
				GTK_SIGNAL_FUNC(init_restart_hide_show) , (gpointer) i);
			
		}
		gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), optionmenu, 0, 3, 0, 1);
		gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), ASCPCONFIG.initrestart);
		gtk_widget_show_all(optionmenu);

	}


	/* 
	 * Create the three corresponding entries.
	 */
	{
		GtkWidget *frame;

		/* ID */
		frame = gtk_frame_new("ID");
		Entries[0] = gtk_entry_new_with_max_length (3);
		gtk_entry_set_text (GTK_ENTRY (Entries[0]), "");
		gtk_container_add(GTK_CONTAINER(frame), Entries[0]);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 12, 13, 1, 3);
		gtk_widget_show_all(frame);


		/* Action */
		frame = gtk_frame_new("Action");
		Entries[1] = gtk_entry_new_with_max_length (10);
		gtk_entry_set_text (GTK_ENTRY (Entries[1]), "");
		gtk_container_add(GTK_CONTAINER(frame), Entries[1]);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 8, 12, 1, 3);
		gtk_widget_show_all(frame);
		

		/* Command */
		frame = gtk_frame_new(NULL);
		Entries[2] = gtk_entry_new_with_max_length (60);
		gtk_entry_set_text (GTK_ENTRY (Entries[2]), "");
		gtk_container_add(GTK_CONTAINER(frame), Entries[2]);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), frame, 0 , 14, 8, 10);
		gtk_widget_show_all(frame);

	}


	/* 
	 * The ubiquitous, manipulative buttons.
	 * 
	 */
	{
		GtkWidget *hbox;
		GtkWidget *vbox;
		GtkWidget *button;


		vbox = gtk_vbox_new(TRUE, 0);
		hbox = gtk_hbox_new(TRUE, 0);

		button = gtk_button_new_with_label("Remove");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(remove_action), NULL);
		gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);



		button = gtk_button_new_with_label("Add");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(add_action), NULL);
		gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);

		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

		button = gtk_button_new_with_label("  Change  ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(change_action), NULL);
		gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);

		gtk_widget_show_all(vbox);

		gtk_table_attach_defaults(GTK_TABLE(tabletop), vbox, 8, 13, 4, 7);



	}

	parse_autoexec(min, max);


	CurrentList = ASCPCONFIG.initrestart;
	init_restart_hide_show(RestartList, ASCPCONFIG.initrestart);
		                    /* ^^^^^^^^^^^ */
		                    /*  Not used   */

	
	gtk_widget_show(tabletop);
	return tabletop;
}



static void parse_autoexec(gfloat min, gfloat max)
{
	gfloat incr;
	gint row=0;
	gchar *buffer = (gchar*) g_malloc0(BUFFERSIZE);
	FILE *backupfile;

	backupfile = ascp_open_file("autoexec.ascp", "w");
	IoFile = ascp_open_file("autoexec", "r");

	incr = (max - min)/FILESIZE;

	ascp_update_status(NULL, "autoexec", min);

	CurrentList = 0;

	while (fgets(buffer, BUFFERSIZE, IoFile) != NULL)
	{
		char* line = buffer;

		/*      
	 	 * Show our progress per total bytes per line read.
	 	 */
		ascp_update_status(NULL, NULL, min); 
		min = ( min >= max) ? max : min + incr*strlen(buffer); 

		fputs(line, backupfile);

		for ( ; isspace(*line) ; line++);

		if( !ascp_strncasecmp(line, "Function", 8) )
		{
			gchar *which = g_malloc(32);

			sscanf(line + 8, "%s", which);


			if( !ascp_strncasecmp(which, "\"InitFunction\"", 14) )
			{
				row=0;
				CurrentList = 0;
			}
			else if( !ascp_strncasecmp(which, "\"RestartFunction\"", 17) )
			{
				row=0;
				CurrentList = 1;
		}

			g_free(which);
		}


		if( !ascp_strncasecmp(line, "Wait", 4) || 
			!ascp_strncasecmp(line, "Exec", 4) ||
			!ascp_strncasecmp(line, "Module", 6))
		{
			init_and_append_entry(line, row++);
		}


	}

	fclose(IoFile);
	fclose(backupfile);
}

static void init_and_append_entry(gchar *line, gint row)
{
	gchar *action;
	gchar *id;
	gchar *command;
	gchar *tmp;
	int error = 0;


	tmp = g_malloc0(strlen(line));

	for ( ; isspace(*line) ; line++)
		;
	
	for (tmp = line; *line!= '\0' && !isspace(*tmp) ; tmp++)
		;

	if(line == tmp)
		error = 1;

	if(!error)
	{
		action = g_malloc0(tmp - line + 1);
		strncpy(action, line,  tmp - line);
		action[tmp - line] = '\0';

		for (line = tmp; isspace(*line) ; line++)
			;

		for (tmp = line; *tmp != '\0' && !isspace(*tmp) ; tmp++)
			;

		if (line == tmp)
			error = 3;
	}

	if(!error)
	{
		id = g_malloc(tmp - line + 1);
		strncpy(id, line,  tmp - line);
		id[tmp - line] = '\0';

		for (line = tmp; isspace(*line) ; line++)
			;

		for (tmp = line; *tmp != '\0' && !isspace(*tmp) ; tmp++)
			;

		if (line == tmp)
			error = 4;
	}
	
	if (!error)
	{
		gchar *label[] = {action,id};
		command = g_malloc0(strlen(line));

		strncpy(command, line, strlen(line)-1);


		if(CurrentList)
		{
			gtk_clist_append (GTK_CLIST(RestartList), label); 
			gtk_clist_set_row_data(GTK_CLIST(RestartList), row, (gchar  *) command);
		}
		else
		{
			gtk_clist_append (GTK_CLIST(InitList), label); 
			gtk_clist_set_row_data(GTK_CLIST(InitList), row, (gchar  *) command);
		}


	}
}

static gint item_selected(GtkWidget  *clist, gint row, gint column,
				GdkEventButton *event, gpointer data)
{
		gchar *text[1] = {g_malloc0(64)};

		gtk_clist_get_text(GTK_CLIST(clist), row, 0, text);
		gtk_entry_set_text (GTK_ENTRY (Entries[1]), text[0]);

		gtk_clist_get_text(GTK_CLIST(clist), row, 1, text);
		gtk_entry_set_text (GTK_ENTRY (Entries[0]), text[0]);
		
		
		gtk_entry_set_text (GTK_ENTRY (Entries[2]), 
			(gchar *)  gtk_clist_get_row_data (GTK_CLIST (clist), row));
			

		CurrentRow = row;
	
		g_print("location is %d within entry clicked \n", CurrentRow);
		return TRUE;
}
	

static gint add_action(GtkWidget *button, gpointer blank)
{
	gchar *text = gtk_entry_get_text(GTK_ENTRY(Entries[2]));

	gchar *label[] = {gtk_entry_get_text(GTK_ENTRY(Entries[1])),
					  gtk_entry_get_text(GTK_ENTRY(Entries[0])) };
	
	g_print("the entry: %s\n", text);

	if(CurrentList)
	{
		gtk_clist_insert(GTK_CLIST(RestartList), CurrentRow, label);
		//gtk_clist_select_row (GTK_CLIST (RestartList), CurrentRow, 0);
		gtk_clist_set_row_data(GTK_CLIST(RestartList), CurrentRow, (gchar *) text);
	}
	else
	{
		gtk_clist_insert(GTK_CLIST(InitList), CurrentRow, label);
		gtk_clist_set_row_data(GTK_CLIST(InitList), CurrentRow, (gchar  *) text);
		//gtk_clist_select_row (GTK_CLIST (InitList), CurrentRow, 0);
	}

	return TRUE;
}

static gint move_action_up(GtkWidget *button, gpointer blank)
{
	
	if(CurrentList)
	{
#ifndef GTK_STABLE_VERSION
		gtk_clist_row_move(GTK_CLIST(RestartList), CurrentRow, CurrentRow-1);
		gtk_clist_select_row (GTK_CLIST (RestartList), CurrentRow-1, 0);
#else
		g_print("no function \"gtk_clist_row_move\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE

	}
	else
	{
#ifndef GTK_STABLE_VERSION
		gtk_clist_row_move(GTK_CLIST(InitList), CurrentRow, CurrentRow-1);
		gtk_clist_select_row (GTK_CLIST (InitList), CurrentRow-1, 0);
#else
		g_print("no function \"gtk_clist_row_move\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE
	}

		return TRUE;
}


static gint move_action_down(GtkWidget *button, gpointer blank)
{
	
	if(CurrentList)
	{
#ifndef GTK_STABLE_VERSION
		gtk_clist_row_move(GTK_CLIST(RestartList), CurrentRow, CurrentRow+1);
		gtk_clist_select_row (GTK_CLIST (RestartList), CurrentRow+1, 0);
#else
		g_print("no function \"gtk_clist_row_move\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE

	}
	else
	{
#ifndef GTK_STABLE_VERSION
		gtk_clist_row_move(GTK_CLIST(InitList), CurrentRow, CurrentRow+1);
		gtk_clist_select_row (GTK_CLIST (InitList), CurrentRow+1, 0);
#else
		g_print("no function \"gtk_clist_row_move\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE
	}

		return TRUE;
}


static gint remove_action(GtkWidget *button, gpointer blank)
{
	if(CurrentList)
	{
#ifndef GTK_STABLE_VERSION
		CurrentRow = GTK_CLIST (RestartList)->focus_row;
#endif
		gtk_clist_remove (GTK_CLIST (RestartList), CurrentRow);
		gtk_clist_select_row (GTK_CLIST (RestartList), CurrentRow, 0);
	}
	else
	{
#ifndef GTK_STABLE_VERSION
		CurrentRow = GTK_CLIST (InitList)->focus_row;
#endif
		gtk_clist_remove (GTK_CLIST (InitList), CurrentRow);
		gtk_clist_select_row (GTK_CLIST (InitList), CurrentRow, 0);
	}

	return TRUE;

}



static gint change_action(GtkWidget *button, gpointer null)
{
	
	if(CurrentList)
	{
#ifndef GTK_STABLE_VERSION
		CurrentRow = GTK_CLIST (RestartList)->focus_row;
#endif
		gtk_clist_set_row_data(GTK_CLIST(RestartList), CurrentRow,
			(gchar  *) gtk_entry_get_text(GTK_ENTRY(Entries[2])));
	}
	else
	{
#ifndef GTK_STABLE_VERSION
		CurrentRow = GTK_CLIST (InitList)->focus_row;
#endif
		gtk_clist_set_row_data(GTK_CLIST(InitList), CurrentRow,
			(gchar  *) gtk_entry_get_text(GTK_ENTRY(Entries[2])));
	}

	g_print("row is %d: %s\n", CurrentRow, gtk_entry_get_text(GTK_ENTRY(Entries[2])));
	return TRUE;
}


void ascp_write_autoexec()
{
	gchar *text = g_malloc0(16);
	gchar *label[2] = {g_malloc0(16), g_malloc0(8)};
	gint i=0;

	IoFile = ascp_open_file("autoexec", "w");

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");

	fprintf(IoFile, "#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Execute on startup :\n\n");

	fprintf(IoFile, "Function \"InitFunction\"\n");
	i=0;
	while( (text = (gchar *) gtk_clist_get_row_data (GTK_CLIST (InitList), i)) )
	{
		gtk_clist_get_text(GTK_CLIST(InitList), i, 0, &label[0]);
		gtk_clist_get_text(GTK_CLIST(InitList), i, 1, &label[1]);
		fprintf(IoFile, "        %-10s %-5s   %s\n", label[0], label[1], text);
		i++;
	}
	fprintf(IoFile, "EndFunction\n");

	fprintf(IoFile, "\n\n");
	fprintf(IoFile, "#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Execute on restart :\n\n");
	fprintf(IoFile, "Function \"RestartFunction\"\n");
	i=0;
	while( (text = (gchar *) gtk_clist_get_row_data (GTK_CLIST (RestartList), i)) )
	{
		gtk_clist_get_text(GTK_CLIST(RestartList), i, 0, &label[0]);
		gtk_clist_get_text(GTK_CLIST(RestartList), i, 1, &label[1]);
		fprintf(IoFile, "        %-10s %-5s   %s\n", label[0], label[1], text);
		i++;
	}
	fprintf(IoFile, "EndFunction\n");
	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");


	fclose(IoFile);

	return;
}



static void init_restart_hide_show(GtkWidget *widget, gint which)
{

	if(which == 0)
	{
		gtk_widget_show_all(Parent[0]);
		gtk_widget_hide(Parent[1]);
		CurrentList = 0;
	}
	else
	{
		gtk_widget_show_all(Parent[1]);
		gtk_widget_hide(Parent[0]);
		CurrentList = 1;
	}
}

	
