
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
				  
#include "xpm.h"
#include "ascp.h"


/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */

/*----------------------------------*/
static FILE *IoFile;
/*----------------------------------*/

GtkWidget *TypeOptionMenu;
gint Type;

GtkWidget *AnimateColor;
GtkWidget *AnimateDelay;
GtkWidget *AnimateWidth;
GtkWidget *AnimateIterations;

GtkWidget *AnimateTwist;
GtkWidget *AnimateZoom;
GtkWidget *AnimateTwistLabel;
GtkWidget *AnimateZoomLabel;


gchar *AnimateColorChar;
/*----------------------------------*/


static void parse_animate(gfloat, gfloat);
static void choose_which_option(GtkWidget *, gint);




GtkWidget * ascp_draw_animate(gfloat min, gfloat max)
{

	GtkWidget *tabletop =  gtk_table_new(14, 10, TRUE);

	if(ASCPERROR)
		 return gtk_label_new("ascp Error");


	/*
	 * Oh, the choices!
	 */
	{
		GtkWidget *menu;
		GtkWidget *subtable;
		GtkWidget *menuitem;
		gint i=0;
		char *types [] = {
				"Random",
				"Flip",
				"Turn",
				"Twist",
				"Zoom",
				"Zoom3D"
				};
				
		subtable =  gtk_table_new(10, 10, TRUE);
		
		menu = gtk_menu_new ();
		TypeOptionMenu = gtk_option_menu_new ();

		for(i=0; i < (sizeof(types)/sizeof(*types)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(types[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);
			gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                (GtkSignalFunc) choose_which_option, (gpointer) i);

            // this is problematic: replaced by the statement above.
			/*
			gtk_signal_connect_object(GTK_OBJECT(menuitem),
				"activate", GTK_SIGNAL_FUNC(choose_which_option), (gpointer ) i);
			*/
		}
		gtk_option_menu_set_menu (GTK_OPTION_MENU (TypeOptionMenu), menu);
		gtk_table_attach_defaults(GTK_TABLE(subtable), TypeOptionMenu, 0, 8, 2, 9);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), subtable, 1, 4, 1, 3);
		gtk_widget_show_all(subtable);
	}


	/* Specifics. */
	{
		GtkAdjustment *adj;
		GtkSpinButton *spin;


		AnimateZoomLabel = gtk_label_new("Zoom");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 9, 1, 0, 0);
		AnimateZoom = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(AnimateZoom);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateZoom), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateZoomLabel, 7, 8, 1, 3);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateZoom, 8, 9, 1, 3);
		gtk_widget_show_all(AnimateZoomLabel);
		gtk_widget_show_all(AnimateZoom);


		AnimateTwistLabel = gtk_label_new("Twist");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 9, 1, 0, 0);
		AnimateTwist = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(AnimateTwist);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateTwist), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateTwistLabel, 7, 8, 3, 6);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateTwist, 8, 9, 3, 6);
		gtk_widget_show_all(AnimateTwistLabel);
		gtk_widget_show_all(AnimateTwist);

	}


	{
		GtkWidget *separator = gtk_hseparator_new ();
		gtk_table_attach_defaults(GTK_TABLE(tabletop), separator, 0, 10, 6, 7);
		gtk_widget_show_all(separator);
	}




	/* General configurations */
	{
		GdkColor *color;
		GtkWidget *label;
		GtkAdjustment *adj;
		GtkSpinButton *spin;
		GtkWidget *cframe;
		GtkWidget *frame2;

		label = gtk_label_new("Width");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, 10, 1, 0, 0);
		AnimateWidth = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(AnimateWidth);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateWidth), 3);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), label, 1, 2, 7, 9);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateWidth, 2, 3, 7, 9);
		gtk_widget_show_all(label);
		gtk_widget_show_all(AnimateWidth);

		


		label = gtk_label_new("Delay");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 6, 1, 0, 0);
		AnimateDelay = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(AnimateDelay);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelay), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), label, 7, 8, 7, 9);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateDelay, 8, 9, 7, 9);
		gtk_widget_show_all(label);
		gtk_widget_show_all(AnimateDelay);


		label = gtk_label_new("Color");
		AnimateColor = gtk_drawing_area_new();
		AnimateColorChar = g_malloc0(16);
		strcpy(AnimateColorChar, "#776688");
		color = g_malloc0(sizeof(GdkColor));
		ascp_char_to_color(AnimateColorChar, color);
		gtk_object_set_data(GTK_OBJECT(AnimateColor), "color", color);
		gtk_widget_set_events (AnimateColor, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect (GTK_OBJECT(AnimateColor), "event",
			(GtkSignalFunc) ascp_area_event, (gpointer *) AnimateColorChar);
		gtk_signal_connect (GTK_OBJECT(AnimateColor), "realize",
			(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), AnimateColor);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), label, 1, 2, 11, 13);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), cframe, 2, 3, 11, 13);
		gtk_widget_show_all(label);
		gtk_widget_show_all(cframe);


		label = gtk_label_new("     Iterations");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 99, 1, 0, 0);
		AnimateIterations = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(AnimateIterations);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateIterations), 25);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (AnimateIterations), TRUE);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), label, 6, 8, 10, 14);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), AnimateIterations, 8, 9, 10, 14);
		gtk_widget_show_all(label);
		gtk_widget_show_all(AnimateIterations);

	
	}


	parse_animate(min, max);

	gtk_widget_show(tabletop);
	return tabletop;
}



static void parse_animate(gfloat min, gfloat max)
{
	gfloat incr;
	gchar *buffer = (gchar*) g_malloc0(BUFFERSIZE);
	FILE *backupfile;
	

	backupfile = ascp_open_file("animate.ascp", "w");
	IoFile = ascp_open_file("animate", "r");

	incr = (max - min)/FILESIZE;

	ascp_update_status(NULL, "animate", min);

	while (fgets(buffer, BUFFERSIZE, IoFile) != NULL)
	{
		char* line = buffer;

		/*      
	 	 * Show our progress per total bytes per line read.
	 	 */
		ascp_update_status(NULL, NULL, min); 
		min = ( min >= max) ? max : min + incr*strlen(buffer); 

		fputs(line, backupfile);

		for ( ; isspace(*line) ; line++);

		if( !ascp_strncasecmp(line, "*Animate", 8) )
		{
			line += 8;
			
			if( !ascp_strncasecmp(line, "Color", 5))
			{
				GdkColor *color;

				sscanf(line + 5, "%s", AnimateColorChar);
				color = gtk_object_get_data(GTK_OBJECT(AnimateColor), "color");
				ascp_char_to_color(AnimateColorChar, color);
			}
			else if ( !ascp_strncasecmp(line, "Delay", 5))
			{
				gint value;

				sscanf(line + 5, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateDelay), value); 
			}
			else if ( !ascp_strncasecmp(line, "Iterations", 10))
			{
				gint value;

				sscanf(line + 10, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateIterations), value); 
			}
			else if ( !ascp_strncasecmp(line, "Width", 5))
			{
				gint value;

				sscanf(line + 5, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateWidth), value); 
			}
			else if ( !ascp_strncasecmp(line, "Twist", 5))
			{
				gint value;

				sscanf(line + 5, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateTwist), value); 
			}
			else if ( !ascp_strncasecmp(line, "Zoom", 4))
			{
				gint value;

				sscanf(line + 4, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(AnimateZoom), value); 
			}
			else if ( !ascp_strncasecmp(line, "Resize", 6))
			{
				gchar  *type = g_malloc0(16);

				sscanf(line + 6, "%s", type);

				if( !ascp_strncasecmp(type, "Random", 6))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 0);
				else if( !ascp_strncasecmp(type, "Flip", 4))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 1);
				else if( !ascp_strncasecmp(type, "Turn", 4))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 2);
				else if( !ascp_strncasecmp(type, "Twist", 5))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 3);
				else if( !ascp_strncasecmp(type, "Zoom3D", 6))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 5);
				else if( !ascp_strncasecmp(type, "Zoom", 4))
					gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu) , 4);

				g_free(type);

			}
				
		}

	}

	fclose(IoFile);
	fclose(backupfile);
}


void ascp_write_animate()
{
	char *types [] = {
				"Random",
				"Flip",
				"Turn",
				"Twist",
				"Zoom",
				"Zoom3D"
				};
	
	IoFile = ascp_open_file("animate", "w");


	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Animate \n\n");

	fprintf(IoFile, "*AnimateColor %s\n", AnimateColorChar);

	fprintf(IoFile, "*AnimateDelay %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateDelay)));

	fprintf(IoFile, "*AnimateIterations %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateIterations)));

	fprintf(IoFile, "*AnimateWidth %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateWidth)));

	fprintf(IoFile, "\n");
	
	if(Type == 0)
	{
		fprintf(IoFile, "*AnimateTwist %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateTwist)));
		fprintf(IoFile, "*AnimateZoom %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateZoom)));
	}
	if(Type == 3)
	{
		fprintf(IoFile, "*AnimateTwist %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateTwist)));
	}
	else if(Type == 4 || Type == 5)
	{
		fprintf(IoFile, "*AnimateZoom %d\n", gtk_spin_button_get_value_as_int
			( GTK_SPIN_BUTTON (AnimateZoom)));
	}

	fprintf(IoFile, "\n");
	

	fprintf(IoFile, "*AnimateResize %s\n", types[ Type<6? Type : 0]);

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");

	fclose(IoFile);

}


static void choose_which_option(GtkWidget *w, gint which)
{

	if(which == 0)
	{
		gtk_widget_set_sensitive(AnimateTwist, TRUE);
		gtk_widget_set_sensitive(AnimateTwistLabel, TRUE);
		gtk_widget_set_sensitive(AnimateZoom, TRUE);
		gtk_widget_set_sensitive(AnimateZoomLabel, TRUE);
	}
	else if(which == 1 || which == 2)
	{
		gtk_widget_set_sensitive(AnimateTwist, FALSE);
		gtk_widget_set_sensitive(AnimateTwistLabel, FALSE);
		gtk_widget_set_sensitive(AnimateZoom, FALSE);
		gtk_widget_set_sensitive(AnimateZoomLabel, FALSE);
	}
	else if(which == 3)
	{
		gtk_widget_set_sensitive(AnimateTwist, TRUE);
		gtk_widget_set_sensitive(AnimateTwistLabel, TRUE);
		gtk_widget_set_sensitive(AnimateZoom, FALSE);
		gtk_widget_set_sensitive(AnimateZoomLabel, FALSE);
	}
	else if(which == 4 || which == 5)
	{
		gtk_widget_set_sensitive(AnimateTwist, FALSE);
		gtk_widget_set_sensitive(AnimateTwistLabel, FALSE);
		gtk_widget_set_sensitive(AnimateZoom, TRUE);
		gtk_widget_set_sensitive(AnimateZoomLabel, TRUE);
	}
	
	Type = which;
}


