
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
				  
#include "xpm.h"
#include "ascp.h"

/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */
/* Stuff for the Style Frame */
GtkWidget	*WinListGradientStart;
GtkWidget	*WinListGradientEnd;
gchar		*WinListGradStartChar;
gchar		*WinListGradEndChar;
GtkWidget	*WinListGradientType;
gchar		*WinListGradTypeName[5] = { "Wharf Style Diagonal",\
										"Horizontal top to bottom",\
										"Horiz top/bottom to center",\
										"Vertical left to right",\
										"Vert top/bottom  to center" };
gint		WinListPixmapType;
gint		WinListFontType;
GtkWidget	*WinListBackFrame[4];
GtkWidget	*WinListPixmapEntry;
GtkWidget	*WinListMaxColors;
GtkWidget	*WinListFontEntry;
gchar		*WinListBackFrameName[4] = {
										"Pixmap",\
										"Gradient",\
										"Solid",\
										"Transparent"
										};

GtkWidget	*WinListBackColor;
gchar		*WinListBackColorChar;
GtkWidget	*WinListTint;
GtkWidget	*WinListTintColor;
gchar		*WinListTintColorChar;

/* Stuff for the Options frame */
GtkWidget 	*WinListFore;
gchar		*WinListForeChar;
GtkWidget 	*WinListBack;
gchar		*WinListBackChar;
GtkWidget	*WinListFont;
GtkWidget	*WinListFontEntry;

/* All those damn check boxes */
GtkWidget	*WinListNoAnchor;
GtkWidget	*WinListUseIconNames;
GtkWidget	*WinListAutoHide;
GtkWidget	*WinListLeftJustify;
GtkWidget	*WinListUseSkipList;

/* Spinnerz etc.  */
GtkWidget	*WinListGeometryH;
GtkWidget	*WinListGeometryV;
GtkWidget	*WinListOrientation;
GtkWidget	*WinListMaxWidth;  /* If zero, do not write out. */

/* Radio Buttons */
GtkWidget 	*WinListOrientationDown;
GtkWidget	*WinListOrientationAccross;

/* The parent frames that will hold each page of the winlist tab */
#define WINLIST_NUM_FRAMES 3
GtkWidget *WinListParent[WINLIST_NUM_FRAMES]; /* Options, Style, Balloons */
gchar *WinListParentName[WINLIST_NUM_FRAMES] = {"Options","Style","Balloons"};

/* WinList spicific functions */
static void winlist_switch_frame(GtkWidget *widget,gint toframe);
static void winlist_background_switch_frame(GtkWidget *widget,gint toframe);
static void winlist_set_pixmap_type(GtkWidget *widget,gint *type)
{ WinListPixmapType = *type; }
static void winlist_set_font_type(GtkWidget *widget,gint *type)
{ WinListFontType = *type; }
static void winlist_set_gradient_type(GtkWidget *widget,gint *type)
{ WinListFontType = *type + 1; }

/*----------------------------------*/
//static FILE *IoFile;
/*----------------------------------*/

GtkWidget * ascp_draw_winlist(gfloat min, gfloat max)
{
	/*      
	 * The toplevel table that shall be returned to
	 * populate_frame().
	 */ 
	GtkWidget *tabletop =  gtk_table_new(20, 20, TRUE);

	if(ASCPERROR)
		return gtk_label_new("ascp Error");
    /*
     * Create the option menu to choose from all six "screens".
     */
    {

        GtkWidget *menu;
        GtkWidget *menuitem;
        GtkWidget *optionmenu;
        gint i=0;
        menu = gtk_menu_new ();
        optionmenu = gtk_option_menu_new ();

        for(i=0; i < WINLIST_NUM_FRAMES; i++)
        {
            menuitem = gtk_menu_item_new_with_label(WinListParentName[i]);
            gtk_menu_append(GTK_MENU (menu), menuitem);
            gtk_widget_show(menuitem);

            gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                (GtkSignalFunc) winlist_switch_frame, (gpointer) i);
        }
        gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(tabletop), optionmenu, 0, 5, 0, 2);
        gtk_widget_show_all(optionmenu);
	}

	/* Now build each parent frame starting with Options (since its first.) */
	
	{
	GtkWidget *cframe;
	GtkWidget *ctable;
	GtkWidget *ptable;
	GtkWidget *label;
	GtkSpinButton *spin;
	GtkAdjustment *adj;


	WinListParent[0] = gtk_frame_new ("Options");

	ptable = gtk_table_new(20,20,TRUE);
	
	/* General Options */
	cframe = gtk_frame_new("General Options");
	ctable = gtk_table_new(21,10,TRUE);
	
	WinListUseIconNames = gtk_check_button_new_with_label("Use Icon Names");
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListUseIconNames,0,10,9,12);
	WinListAutoHide = gtk_check_button_new_with_label("Auto Hide");
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListAutoHide,0,10,12,15);
	WinListLeftJustify = gtk_check_button_new_with_label("Left Justify");
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListLeftJustify,0,10,15,18);
	WinListUseSkipList = gtk_check_button_new_with_label("Use SkipList");
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListUseSkipList,0,10,18,21);
	
	gtk_container_add(GTK_CONTAINER(cframe),ctable);
	gtk_widget_show_all(cframe);
	gtk_table_attach_defaults(GTK_TABLE(ptable),cframe,0,7,3,20);

	/* WinList Geometry */
	cframe = gtk_frame_new("Position");
	ctable = gtk_table_new(15,11,TRUE);
	
	label = gtk_label_new("Vertical");
	gtk_table_attach_defaults(GTK_TABLE(ctable),label,0,5,1,3);

	adj = (GtkAdjustment *) gtk_adjustment_new (0,  -1024, 1024, 1, 0, 0);
	WinListGeometryV= gtk_spin_button_new (adj, 1, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WinListGeometryV), TRUE);
	spin = GTK_SPIN_BUTTON (WinListGeometryV);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(WinListGeometryV), -1);
	gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListGeometryV,1,5,6,7);

	label = gtk_label_new("Horizontal");
	gtk_table_attach_defaults(GTK_TABLE(ctable),label,5,11,1,3);
	
	adj = (GtkAdjustment *) gtk_adjustment_new (0,  -99, 99, 1, 0, 0);
	WinListGeometryH= gtk_spin_button_new (adj, 1, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WinListGeometryH), TRUE);
	spin = GTK_SPIN_BUTTON (WinListGeometryH);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(WinListGeometryH), -1);
	gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListGeometryH,6,10,6,7);
	
	WinListNoAnchor = gtk_check_button_new_with_label("Don't Anchor");
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListNoAnchor,1,10,11,14);
	
	gtk_container_add(GTK_CONTAINER(cframe),ctable);
	gtk_table_attach_defaults(GTK_TABLE(ptable),cframe,14,20,5,15);

	/* Orientation */
	cframe = gtk_frame_new("Orientation");
	ctable = gtk_table_new(2,2,TRUE);
	WinListOrientationDown = gtk_radio_button_new_with_label( NULL, "Down");
	WinListOrientationAccross = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (WinListOrientationDown)) , "Accross");
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (WinListOrientationDown), TRUE);	
	gtk_table_attach_defaults(GTK_TABLE(ctable),
							WinListOrientationDown,0,1,0,2);
	gtk_table_attach_defaults(GTK_TABLE(ctable),
							WinListOrientationAccross,1,2,0,2);
	gtk_container_add(GTK_CONTAINER(cframe),ctable);
	gtk_table_attach_defaults(GTK_TABLE(ptable),cframe,14,20,16,20);

	/* Max Width */

	cframe = gtk_frame_new("Maximum Width");
	ctable = gtk_table_new(2,11,TRUE);

	adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 9999, 2, 0, 0);
	WinListMaxWidth = gtk_spin_button_new (adj, 1, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WinListMaxWidth), TRUE);
	spin = GTK_SPIN_BUTTON (WinListMaxWidth);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(WinListMaxWidth), 640);
	gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
	gtk_table_attach_defaults(GTK_TABLE(ctable),WinListMaxWidth,2,9,0,2);

	gtk_container_add(GTK_CONTAINER(cframe),ctable);
	gtk_table_attach_defaults(GTK_TABLE(ptable),cframe,8,13,15,20);


	/* Add the panel frame to the page parent and show */
	gtk_container_add(GTK_CONTAINER(WinListParent[0]),ptable);
	gtk_widget_show_all(WinListParent[0]);
	gtk_table_attach_defaults(GTK_TABLE(tabletop),WinListParent[0],0,20,3,20);
	}
	{
	/*  The STYLE Page. :) */
	GtkWidget *menu;
	GtkWidget *menuitem;
	GtkWidget *optionmenu;
	GtkSpinButton *spin;
	GtkAdjustment *adj;
	GtkWidget *ctable;
	GtkWidget *ptable;
	GtkWidget *label;
	GtkWidget *button;
    gint i=0;
	gchar buf[32];

	WinListParent[1] = gtk_frame_new ("Style");
	ptable = gtk_table_new(20,20,TRUE);

	label = gtk_label_new("Maximum # of Colors");
	gtk_table_attach_defaults(GTK_TABLE(ptable),label,0,6,12,16);
	adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 1024, 2, 0, 0);
	WinListMaxColors = gtk_spin_button_new (adj, 1, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WinListMaxColors), TRUE);
	spin = GTK_SPIN_BUTTON (WinListMaxColors);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(WinListMaxColors), 1024);
	gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
	gtk_table_attach_defaults(GTK_TABLE(ptable),WinListMaxColors,6,10,12,16);

	WinListFontEntry = gtk_entry_new_with_max_length(128);

	button = gtk_button_new_with_label("WinList Font");
	gtk_signal_connect( GTK_OBJECT(button),
						"clicked",
						GTK_SIGNAL_FUNC(ascp_open_font_dialog),
						WinListFontEntry);
	gtk_container_border_width (GTK_CONTAINER (button), 1);
	gtk_table_attach_defaults(GTK_TABLE(ptable),button,0,4,16,19);
	gtk_table_attach_defaults(GTK_TABLE(ptable),WinListFontEntry,4,12,16,19);

	/* Font Type */
	menu = gtk_menu_new ();
	optionmenu = gtk_option_menu_new ();

	for(i=1; i < 6; i++)
	{	
		sprintf(buf,"%d",i);
		menuitem = gtk_menu_item_new_with_label(buf);
		gtk_menu_append(GTK_MENU (menu), menuitem);
		gtk_widget_show(menuitem);
		gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
			(GtkSignalFunc) winlist_set_font_type,&i);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
	gtk_table_attach_defaults(GTK_TABLE(ptable), optionmenu, 16, 20, 16, 19);
	gtk_widget_show_all(optionmenu);
	label = gtk_label_new("Font Type");
	gtk_table_attach_defaults(GTK_TABLE(ptable),label,12,16,16,19);

	/* The Background Thingie */
    {
        menu = gtk_menu_new ();
        optionmenu = gtk_option_menu_new ();

        for(i=0; i < 4; i++)
        {
            menuitem = gtk_menu_item_new_with_label(WinListBackFrameName[i]);
            gtk_menu_append(GTK_MENU (menu), menuitem);
            gtk_widget_show(menuitem);

            gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                (GtkSignalFunc) winlist_background_switch_frame, (gpointer) i);
        }
        gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(ptable), optionmenu, 0, 5, 0, 3);
        gtk_widget_show_all(optionmenu);
	}
	

	/* Build each background frame */

	/* Pixmap Background Frame  */
	{
        GtkWidget *menu;
        GtkWidget *menuitem;
        GtkWidget *optionmenu;
		GtkWidget *button;
		gchar buf[32];
		
		WinListPixmapEntry = gtk_entry_new_with_max_length(128);
		WinListBackFrame[0] = gtk_frame_new("Pixmap Background");
		ctable = gtk_table_new(6,10,TRUE);
		button = gtk_button_new_with_label("Pixmap");
		gtk_table_attach_defaults(GTK_TABLE(ctable),button,0,2,3,5);
		gtk_signal_connect( GTK_OBJECT(button),
							"clicked",
							GTK_SIGNAL_FUNC(ascp_open_file_dialog),
							WinListPixmapEntry);
		gtk_table_attach_defaults(GTK_TABLE(ctable),WinListPixmapEntry,2,6,3,5);

        menu = gtk_menu_new ();
        optionmenu = gtk_option_menu_new ();

        for(i=1; i < 6; i++)
        {	
			sprintf(buf,"%d",i);
            menuitem = gtk_menu_item_new_with_label(buf);
            gtk_menu_append(GTK_MENU (menu), menuitem);
            gtk_widget_show(menuitem);
            gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                (GtkSignalFunc) winlist_set_pixmap_type,&i);
        }
        gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(ctable), optionmenu, 8, 10, 3, 5);
        gtk_widget_show_all(optionmenu);
		label = gtk_label_new("Pixmap Type");
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,6,8,3,5);

		gtk_container_add(GTK_CONTAINER(WinListBackFrame[0]),ctable);

	}

	/* Gradient Background Frame  */
	{
        GtkWidget *menu;
        GtkWidget *menuitem;
        GtkWidget *optionmenu;
		GtkWidget *label;
		GtkWidget *aframe;
		GtkWidget *bframe;
		gchar buf[32];
		
		WinListBackFrame[1] = gtk_frame_new("Gradient Background");
		ctable = gtk_table_new(11,20,TRUE);
		
		aframe = gtk_frame_new(NULL);
		bframe = gtk_frame_new(NULL);

		label = gtk_label_new("Start Color");
		WinListGradStartChar = g_malloc0(4);
		strcpy(WinListGradStartChar, "#111122");
		WinListGradientStart = ascp_color_selector_new(WinListGradStartChar);
		gtk_container_add(GTK_CONTAINER(bframe),WinListGradientStart);
		gtk_container_add(GTK_CONTAINER(aframe),bframe);
		gtk_table_attach_defaults(GTK_TABLE(ctable),aframe,4,6,0,5);
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,0,4,0,5);

		
		aframe = gtk_frame_new(NULL);
		bframe = gtk_frame_new(NULL);

		label = gtk_label_new("End Color");
		WinListGradEndChar = g_malloc0(4);
		strcpy(WinListGradEndChar, "#111122");
		WinListGradientEnd = ascp_color_selector_new(WinListGradEndChar);
		gtk_container_add(GTK_CONTAINER(bframe),WinListGradientEnd);
		gtk_container_add(GTK_CONTAINER(aframe),bframe);
		gtk_table_attach_defaults(GTK_TABLE(ctable),aframe,4,6,5,10);
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,0,4,5,10);

        menu = gtk_menu_new ();
        optionmenu = gtk_option_menu_new ();

        for(i=1; i < 6; i++)
        {	
			sprintf(buf,"%s",WinListGradTypeName[i]);
            menuitem = gtk_menu_item_new_with_label(buf);
            gtk_menu_append(GTK_MENU (menu), menuitem);
            gtk_widget_show(menuitem);
            gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                (GtkSignalFunc) winlist_set_gradient_type,&i);
        }
        gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
        gtk_table_attach_defaults(GTK_TABLE(ctable), optionmenu, 11, 20, 0, 5);
        gtk_widget_show_all(optionmenu);
		label = gtk_label_new("Gradient Type");
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,7,11,0,5);

		gtk_container_add(GTK_CONTAINER(WinListBackFrame[1]),ctable);
	}

	/* Solid Background Frame */
	{
		GtkWidget *aframe;
		GtkWidget *bframe;
		
		WinListBackFrame[2] = gtk_frame_new("Solid Background");
		
		aframe = gtk_frame_new(NULL);
		bframe = gtk_frame_new(NULL);
		
		ctable = gtk_table_new(10,10,TRUE);
		label = gtk_label_new("Background Color");
		
		WinListBackColorChar = g_malloc0(4);
		strcpy(WinListBackColorChar, "#111122");
		WinListBackColor = ascp_color_selector_new(WinListBackColorChar);
		gtk_container_add(GTK_CONTAINER(bframe),WinListBackColor);
		gtk_container_add(GTK_CONTAINER(aframe),bframe);
		gtk_table_attach_defaults(GTK_TABLE(ctable),aframe,3,4,4,9);
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,0,3,5,8);
		
		
		gtk_container_add(GTK_CONTAINER(WinListBackFrame[2]),ctable);
	}

	/* Transparent Background Frame */
	{
		GtkWidget *aframe;
		GtkWidget *bframe;
		
		WinListBackFrame[3] = gtk_frame_new("Transparent Background");
		
		aframe = gtk_frame_new(NULL);
		bframe = gtk_frame_new(NULL);
		WinListTint = gtk_check_button_new_with_label("Tint Transparency");
		
		ctable = gtk_table_new(10,10,TRUE);
		label = gtk_label_new("Tint Color");
		
		WinListTintColorChar = g_malloc0(4);
		strcpy(WinListTintColorChar, "#000099");
		WinListTintColor = ascp_color_selector_new(WinListTintColorChar);
		gtk_container_add(GTK_CONTAINER(bframe),WinListTintColor);
		gtk_container_add(GTK_CONTAINER(aframe),bframe);
		gtk_table_attach_defaults(GTK_TABLE(ctable),aframe,6,7,4,9);
		gtk_table_attach_defaults(GTK_TABLE(ctable),label,4,6,5,8);
		gtk_table_attach_defaults(GTK_TABLE(ctable),WinListTint,0,4,5,8);
		
		
		gtk_container_add(GTK_CONTAINER(WinListBackFrame[3]),ctable);
	}
	/* Add all the back frames to ptable. */
	for (i=0;i<4;i++)
		gtk_table_attach_defaults(GTK_TABLE(ptable),WinListBackFrame[i],0,20,3,12);

	gtk_container_add(GTK_CONTAINER(WinListParent[1]),ptable);
	gtk_widget_show_all(WinListParent[1]);
	winlist_background_switch_frame(NULL,0);
	gtk_table_attach_defaults(GTK_TABLE(tabletop),WinListParent[1],0,20,3,20);
	}
	{
	/*  The BALLOONS Page. */
	GtkWidget *ptable;
	GtkWidget *label;

	WinListParent[2] = gtk_frame_new ("Balloons");
	ptable = gtk_table_new(20,20,TRUE);
	
	label = gtk_label_new("Balloon");
	gtk_table_attach_defaults(GTK_TABLE(ptable),label,5,15,9,11);

	gtk_container_add(GTK_CONTAINER(WinListParent[2]),ptable);
	gtk_widget_show_all(WinListParent[2]);
	gtk_table_attach_defaults(GTK_TABLE(tabletop),WinListParent[2],0,20,3,20);
	}

	/* Finish up by showing the widget. */
	winlist_switch_frame(NULL,0);
	gtk_widget_show(tabletop);
	return tabletop;
}


static void winlist_background_switch_frame(GtkWidget *widget,gint toframe)
{
    int i;
    for(i= 0; i < 4;i++)
    {
        if(i != toframe)
        {
            gtk_widget_hide(WinListBackFrame[i]);
        }
    gtk_widget_show_all(WinListBackFrame[toframe]);
    }
}


static void winlist_switch_frame(GtkWidget *widget,gint toframe)
{
    int i;
    for(i= 0; i < WINLIST_NUM_FRAMES;i++)
    {
        if(i != toframe)
        {
            gtk_widget_hide(WinListParent[i]);
        }
    gtk_widget_show(WinListParent[toframe]);
    }
}
