
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
				  
#include "xpm.h"


#include "ascp.h"


/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */

/*----------------------------------*/
static GtkWidget *FontDialog;
static GtkWidget *FileDialog;
static FILE *IoFile;
/*----------------------------------*/


GtkWidget * ascp_draw_ascp(gfloat min, gfloat max)
{
	/*      
	 * The toplevel table that shall be returned to
	 * populate_frame().
	 */ 
	GtkWidget *tabletop =  gtk_table_new(14, 14, TRUE);

	if(ASCPERROR)
		return gtk_label_new("ascp Error");

		gtk_table_attach_defaults(GTK_TABLE(tabletop), 
						gtk_label_new("by JUNO"), 5, 9, 8, 10); 
		

	gtk_widget_show_all(tabletop);
	return tabletop;
}


void ascp_parse(void)
{	
	gchar *buffer = (gchar*) g_malloc0(1024);
	FILE *backupfile;

	
	backupfile = ascp_open_file("ascp.ascp", "w");

	IoFile = ascp_open_file("ascp/config", "r");

	if(ASCPERROR)
	{
		GtkWidget *button = gtk_button_new_with_label("Close");

		ascp_error_popup("Config not found\n", "ascp/config", button);

		return;
	}

	/* 
	 * First set up defaults. _Then_ read what the user wants and
	 * change them accordingly.
	 */
	
	

	/* 
	 * This option will be used to determine languages in widgets
	 * as well as for error messages. Not yet implemented.
	 * Valid choices now are: en, fr, jp, sp  you can add more 
	 * by simply appending the enum {en, fr, jp, sp}; in ascp.h
	 */
	ASCPCONFIG.lang = en;  

	/* 
	 * Used to determine if ascp should remember the 
	 * last page configured and jump to it.
	 */
	ASCPCONFIG.rememberpage = FALSE;

	ASCPCONFIG.startpage = 0;
	
	/*
	 * Unless you have different pixmaps in the (8bpp and 16bpp) directories,
	 * I'd leave this at 8 (AfterStep will know the correct ones to use, 
	 * based on your current screen depth).
	 * Loading ~80 16bpp icons takes a long time.
	 */
	
	/* 
	 * Get what bpp the user is in; we'll use that throughout this run.
	 */
	/* Is now runtime :-)*/
	ASCPCONFIG.bpp = 8;


#ifndef GTK_STABLE_VERSION
	ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_NONE;
	//ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_TABBED;
	//ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_DOTTED;
	//ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_SOLID;
#endif
	
	ASCPCONFIG.wharfentryboxwide = FALSE;

	/* Try it and see */
	ASCPCONFIG.offsetwithnum = FALSE;

	/* Start with animation (FALSE) or balloons (TRUE) */
	ASCPCONFIG.animballoon = FALSE;  

	/* Start with Init (FALSE) or Restart (TRUE) */
	ASCPCONFIG.initrestart = FALSE;  

	/* Hide (TRUE) or grey out (FALSE) disabled configs. */
	ASCPCONFIG.hide = FALSE;
	

	while (fgets(buffer, 1024, IoFile) != NULL)
	{
		char* line = buffer;

		fputs(line, backupfile);

		for ( ; isspace(*line) ; line++);


		if( !ascp_strncasecmp(line, "*ASCP", 5) )
		{
			line += 5;

			if( !ascp_strncasecmp(line, "Lang", 4))
			{
				gchar *language = g_malloc(16);

				sscanf(line + 4, "%s", language);

				g_free(language);
			}
			else if( !ascp_strncasecmp(line, "RememberPage", 12))
			{

				ASCPCONFIG.rememberpage = TRUE;

			}
			else if( !ascp_strncasecmp(line, "StartPage", 9))
			{
				sscanf(line + 9, "%d", &ASCPCONFIG.startpage);

				ASCPCONFIG.startpage--;

			}
			else if( !ascp_strncasecmp(line, "Bpp", 3))
			{

				sscanf(line + 3, "%d", &ASCPCONFIG.bpp);

			}
#ifndef GTK_STABLE_VERSION
			else if( !ascp_strncasecmp(line, "TreeLineStyle", 13))
			{
				gchar *style = g_malloc(16);

				sscanf(line + 13, "%s", style);

				if(!ascp_strncasecmp(style, "none", 4))
					ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_NONE;
				else 
				if(!ascp_strncasecmp(style, "solid", 5))
					ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_SOLID;
				else 
				if(!ascp_strncasecmp(style, "dotted", 6))
					ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_DOTTED;
				else 
				if(!ascp_strncasecmp(style, "tabbed", 6))
					ASCPCONFIG.treelinestyle = GTK_CTREE_LINES_TABBED;

				g_free(style);
				
			}
#endif //  GTK_LIB_DEP_CODE
			else if( !ascp_strncasecmp(line, "Wide", 4))
			{
				ASCPCONFIG.wharfentryboxwide = TRUE;
			}
			else if( !ascp_strncasecmp(line, "Offset", 6))
			{
				ASCPCONFIG.offsetwithnum = TRUE;
			}
			else if( !ascp_strncasecmp(line, "AnimBalloon", 11))
			{
				ASCPCONFIG.animballoon = TRUE;
			}
			else if( !ascp_strncasecmp(line, "InitRestart", 11))
			{
				ASCPCONFIG.initrestart = TRUE;
			}
			else if( !ascp_strncasecmp(line, "Hide", 4))
			{
				ASCPCONFIG.hide = TRUE;
			}

		}
	}


	fclose(IoFile);
	fclose(backupfile);
}


void ascp_write_ascp()
{

	IoFile = ascp_open_file("ascp/config", "w");

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");

	fprintf(IoFile, "#----------------------------------------------------------------\n");
	fprintf(IoFile, "#\n");


	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");


	fclose(IoFile);

}



/* Muligan */
	
void gtkutil_destroy(GtkWidget *igad, GtkWidget *dgad)
{
	gtk_widget_destroy(dgad);    
}


void ascp_open_file_dialog ( GtkWidget *button, GtkWidget *entry )
{
	gchar *s;
	FileDialog = gtk_file_selection_new ("File Selection");
				
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (FileDialog)->ok_button),
		"clicked", (GtkSignalFunc) ascp_file_dialog_ok, entry );
					
	/* Connect the cancel_button to destroy the widget */
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(FileDialog)->cancel_button),
		"clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (FileDialog));
						
	s = gtk_entry_get_text(GTK_ENTRY(entry));

	if(s)
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(FileDialog),s);

	gtk_widget_show(FileDialog);
}

void ascp_file_dialog_ok ( GtkWidget *w, GtkWidget *entry )
{
	gchar *filename;
	
	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(FileDialog));
	if(filename && filename[0])
	{
		gtk_entry_set_text(GTK_ENTRY(entry), filename);
			gtk_entry_set_position(GTK_ENTRY(entry),0);
	}
		gtk_widget_destroy(FileDialog);
		FileDialog = NULL;
}

void ascp_open_font_dialog(GtkWidget *button, GtkWidget *entry) 
{
#ifndef GTK_STABLE_VERSION
	GtkWidget *dialog;
	dialog = gtk_font_selection_dialog_new("Select Font");
	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(dialog)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(ascp_font_dialog_ok), entry);
	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG
		(dialog)->cancel_button), "clicked", 
		GTK_SIGNAL_FUNC(gtkutil_destroy), dialog);
	gtk_font_selection_dialog_set_font_name( GTK_FONT_SELECTION_DIALOG(dialog),
	gtk_entry_get_text(GTK_ENTRY(entry)));
	FontDialog = dialog; 
	gtk_widget_show(dialog);
#endif
}


/* Slot for font dialog "OK" button */
void ascp_font_dialog_ok(GtkWidget *ok_button, GtkWidget *entry) 
{
#ifndef GTK_STABLE_VERSION
	gchar *fontname;

	fontname = gtk_font_selection_dialog_get_font_name(
			GTK_FONT_SELECTION_DIALOG(FontDialog));
	if(fontname && fontname[0])
	{
		gtk_entry_set_text(GTK_ENTRY(entry), fontname);
	}
	gtk_widget_destroy(FontDialog);
	FontDialog = NULL;
#endif
}


GtkWidget *ascp_color_selector_new(gchar *color_char)
{  
	GtkWidget *area;
	GdkColor *color;
	int free_char = 0;

	area  = gtk_drawing_area_new();
	color = g_malloc0(sizeof(GdkColor));
	
	if(color_char)
		ascp_char_to_color(color_char, color);
	else
	{
		free_char = 1;
		color_char = g_malloc(16);
		strcpy(color_char,"#000000");
	}

	ascp_char_to_color(color_char,color);
	gtk_object_set_data(GTK_OBJECT(area), "color", color);
	gtk_widget_set_events (area, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect (GTK_OBJECT(area), "event",
		(GtkSignalFunc) ascp_area_event, (gpointer *) color_char);
	gtk_signal_connect (GTK_OBJECT(area), "realize",
		(GtkSignalFunc) ascp_set_background_color, (gpointer *) color);

	return area;
}   



