
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */

/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
 
#include "ascp.h"
#include "xpm.h"
#include <X11/Xlib.h>

/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */
/*----------------------------------*/

/*  The number of desks we should handle. 
 *	Stock as uses 4 so we'll use 4.
 */
#define PAGER_NUM_DESKS 4

static FILE *IoFile;



/*
 * Generalities.
 */
/*----------------------------------*/
static GtkWidget *Balloons;            
static GtkWidget *BalloonParent;            
static GtkWidget *BalloonFore;
static GtkWidget *BalloonBack;
static GtkWidget *BalloonFont;
static GtkWidget *BalloonFontEntry;
static GtkWidget *BalloonBorderWidthSpinner;
static GtkWidget *BalloonBorderColor;
static GtkAdjustment *BalloonYOffset;
static GtkWidget *BalloonDelaySpinner;
static GtkWidget *DesktopScaleSpinner;
static GtkWidget *HiBackColor;
static GtkWidget *HiForeColor;
static GtkWidget *StickyPagerIcon;
static gchar *BalloonForeChar;
static gchar *BalloonBackChar;
static gchar *BalloonFontChar;
static gchar *HiBackColorChar;
static gchar *HiForeColorChar;
static gchar *BalloonBorderColorChar;
/*----------------------------------*/



/*
 * Name specific: Pager.
 */
/*----------------------------------*/


static GtkWidget *Pager;
static GtkWidget *PagerParent;
static GtkWidget *PagerBack;
static GtkWidget *PagerFontEntry;
static GtkWidget *PagerFore;
static GtkWidget *PagerFont;
static GtkWidget *PagerSmallFont;
static GtkWidget *PagerSmallFontEntry;
static GtkWidget *PagerHilight;
static GtkWidget *PagerGeometryV;
static GtkWidget *PagerGeometryH;
static GtkWidget *PagerRedrawBg;
static GtkWidget *PagerTransparent[PAGER_NUM_DESKS];
static GtkWidget *PagerDesktopImage[PAGER_NUM_DESKS];
static GtkAdjustment *PagerAlign;
static GtkWidget *PagerStartIconic;
static GtkWidget *PagerLabelTable[PAGER_NUM_DESKS];
static GtkWidget *PagerRowSpinner;
static GtkWidget *PagerColumnSpinner;
static GtkWidget *PagerTint[PAGER_NUM_DESKS];
static GtkWidget *PagerDesktopImage[PAGER_NUM_DESKS];
static GtkWidget *PagerDesktopImageEntry[PAGER_NUM_DESKS];
static GtkWidget *PagerDesktopImageSel[PAGER_NUM_DESKS];
static GtkWidget *PagerLabel[PAGER_NUM_DESKS];


static gchar *PagerTintChar[PAGER_NUM_DESKS] = {0};
static gchar *PagerBackChar;
static gchar *PagerForeChar;
static gchar *PagerFontChar;
static gchar *PagerSmallFontChar;
static gchar *PagerHilightChar;
static gchar *PagerBackChar;
static gchar *PagerBackChar;


/*----------------------------------*/


/*
 * Name specific: WXYZPager.
 */
/*----------------------------------*/
static GtkWidget *WXYZPager[4];
static GtkWidget *WXYZPagerParent[4];
static GtkWidget *WXYZPagerBack[4];
static GtkWidget *WXYZPagerFore[4];
static GtkWidget *WXYZPagerFont[4];
static GtkWidget *WXYZPagerSmallFont[4];
static GtkWidget *WXYZPagerHilight[4];
static GtkWidget *WXYZPagerGeometryV[4];
static GtkWidget *WXYZPagerGeometryH[4];
static GtkWidget *WXYZPagerRedrawBg[4];
static GtkAdjustment *WXYZPagerAlign[4];
static GtkWidget *WXYZPagerRowSpinner[4];
static GtkWidget *WXYZPagerColumnSpinner[4];

static GtkWidget *WXYZPagerLabel[4];
static GtkWidget *WXYZPagerLabelTable[4];

static gchar *WXYZPagerBackChar[4];
static gchar *WXYZPagerForeChar[4];

#if 0
static gchar *WXYZPagerFontChar[4];
static gchar *WXYZPagerSmallFontChar[4];
#endif

static gchar *WXYZPagerHilightChar[4];
static gchar *WXYZPagerBackChar[4];
static gchar *WXYZPagerBackChar[4];
/*----------------------------------*/

/*-------------------------------*/
/* These blatantly stolen from x-chat and modified.          */
void pager_fontok(GtkWidget *ok_button, GtkWidget *entry);
void pager_open_font_dialog(GtkWidget *button, GtkWidget *entry);


/* 
 * The parents (most likely, frames) that will host them all.
 */
GtkWidget *WhichParent[6];


 

/*----------------------------------*/
static void parse_pager(gfloat, gfloat);
static void choose_which_pager(GtkWidget *, gint);
static void choose_which_pager_entry(GtkWidget *, gint);
/*----------------------------------*/

/*-------------------------------*/


GtkWidget * ascp_draw_pager(gfloat min, gfloat max)
{
	gint wxyz;
	gchar  *wxyzpagerlabel[4] = { 
			"Work", 
			"WWW", 
			"Mail", 
			"Games"
			};

	/*      
	 * The toplevel table that shall be returned to
	 * populate_frame().
	 */ 
	GtkWidget *tabletop =  gtk_table_new(10, 14, TRUE);


	if(ASCPERROR)
		return gtk_label_new("ascp Error");


	/* 
	 * Create the option menu to choose from all six "screens".
	 */
	{

		GtkWidget *menu;
		GtkWidget *menuitem;
		GtkWidget *optionmenu;
		gint i=0;
		char *types [] = {
				"General",
				"Pager",
				"WPager",
				"XPager",
				"YPager",
				"ZPager"
				};
				
		menu = gtk_menu_new ();
		optionmenu = gtk_option_menu_new ();

		for(i=0; i < (sizeof(types)/sizeof(*types)); i++)
		{
			menuitem = gtk_menu_item_new_with_label(types[i]);
			gtk_menu_append(GTK_MENU (menu), menuitem);
			gtk_widget_show(menuitem);

			gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
				(GtkSignalFunc) choose_which_pager, (gpointer) i);
			/*
			gtk_signal_connect_object(GTK_OBJECT(menuitem),
				"activate", GTK_SIGNAL_FUNC(choose_which_pager), (gpointer ) i);
				*/

		
		}
		gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
		gtk_table_attach_defaults(GTK_TABLE(tabletop), optionmenu, 0, 3, 0, 1);
		gtk_widget_show_all(optionmenu);

	}

	


	/*
	 * Create the frame that will host General.
	 * Put it in WhichParent[0], and add _that_ to the tabletop.
	 */
	{
		GtkWidget *label;
		GtkWidget *table;
		GtkWidget *scale;
		GtkWidget *cframe;
		GtkWidget *frame2;
		GtkAdjustment *adj;
		GtkSpinButton *spin;
		GtkWidget *subframe;
		GtkWidget *subtable;
		

		WhichParent[0] = gtk_frame_new (NULL);
		table = gtk_table_new(8, 8, TRUE);

		/* 
		 * General.
		 */

		StickyPagerIcon = gtk_check_button_new_with_label("Sticky");
		gtk_table_attach_defaults(GTK_TABLE(table), StickyPagerIcon, 0, 2, 1, 2);
		

		label = gtk_label_new("        Scale   1/");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 4, 32, 1, 0, 0);
		DesktopScaleSpinner = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(DesktopScaleSpinner);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopScaleSpinner), 24);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(table), label, 2, 4, 1, 2);
		gtk_table_attach_defaults(GTK_TABLE(table), DesktopScaleSpinner, 4, 5, 1, 2);

		subtable = gtk_table_new(4, 14,  TRUE);

		label = gtk_label_new("Fore");
		HiForeColorChar = g_malloc0(4);
		strcpy(HiForeColorChar, "#111122");
		HiForeColor = ascp_color_selector_new(HiForeColorChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), HiForeColor);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 1, 8, 0, 2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 8, 14, 0, 2);

		label = gtk_label_new("Back");
		HiBackColorChar = g_malloc0(4);
		strcpy(HiBackColorChar, "#444499");
		HiBackColor = ascp_color_selector_new(HiBackColorChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), HiBackColor);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(subtable), label, 1, 8, 2, 4);
		gtk_table_attach_defaults(GTK_TABLE(subtable), cframe, 8, 14, 2, 4);


		gtk_table_attach_defaults(GTK_TABLE(table), subtable, 6, 8, 0, 3);


       		 /* 
		  * Balloons.
		  */

		BalloonParent = gtk_table_new(9, 10, TRUE);
		subframe = gtk_frame_new (NULL);

		Balloons = gtk_check_button_new_with_label("Balloons");
		gtk_widget_show_all(Balloons);
		/*
		 * Hide/show or gray out the rest of the configuration
		 * depending on the state of the button.
		 */
		gtk_signal_connect(GTK_OBJECT(Balloons), "clicked",
			GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  BalloonParent);
		gtk_table_attach_defaults(GTK_TABLE(table), Balloons, 0, 2, 3, 4);



		label = gtk_label_new("Border       ");
		BalloonBorderColorChar = g_malloc0(4);
		strcpy(BalloonBorderColorChar, "#221122");
		BalloonBorderColor = ascp_color_selector_new(BalloonBorderColorChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), BalloonBorderColor);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label, 0, 2, 0, 3);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), cframe, 2, 3, 0, 3);


				
		label = gtk_label_new("Foreground");
		BalloonForeChar = g_malloc0(4);
		strcpy(BalloonForeChar, "#111122");
		BalloonFore = ascp_color_selector_new(BalloonForeChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), BalloonFore);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label, 0, 2, 3, 6);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), cframe, 2, 3, 3, 6);

		label = gtk_label_new("Background");
		BalloonBackChar = g_malloc0(4);
		strcpy(BalloonBackChar, "#444499");
		BalloonBack=  ascp_color_selector_new(BalloonBackChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), BalloonBack);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label , 0, 2, 6, 9);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), cframe, 2, 3, 6, 9);




		label = gtk_label_new(" Width");
		adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 9, 1, 0, 0);
		BalloonBorderWidthSpinner = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON (BalloonBorderWidthSpinner);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonBorderWidthSpinner), 1);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label, 3, 4, 0, 3);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent),  BalloonBorderWidthSpinner, 4, 5, 0, 3);
		

		/* A better look for Delay.*/
		{
			GtkWidget *looktable = gtk_table_new(1, 11, TRUE);
		
			label = gtk_label_new("Delay");
			adj = (GtkAdjustment *) gtk_adjustment_new (0,  0, 999, 10, 0, 0);
			BalloonDelaySpinner = gtk_spin_button_new (adj, 1, 0);
			spin = GTK_SPIN_BUTTON (BalloonDelaySpinner);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (BalloonDelaySpinner), TRUE);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonDelaySpinner), 600);

			gtk_table_attach_defaults(GTK_TABLE(looktable), BalloonDelaySpinner, 0, 7, 0, 1);
			gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label, 6, 7, 0, 3);
			gtk_table_attach_defaults(GTK_TABLE(BalloonParent), looktable, 7, 9, 0, 3);
		}

		BalloonFontEntry = gtk_entry_new_with_max_length(128);
		cframe = gtk_frame_new (NULL);
		BalloonFont = gtk_button_new_with_label("Font");
		
		gtk_signal_connect(	GTK_OBJECT(BalloonFont),
							"clicked",
							GTK_SIGNAL_FUNC(ascp_open_font_dialog),
							BalloonFontEntry);
		gtk_container_border_width (GTK_CONTAINER (BalloonFont), 1);
		gtk_container_add (GTK_CONTAINER (cframe), BalloonFont);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), BalloonFontEntry, 5, 9, 6, 9);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), cframe, 3, 5, 6, 9);

		label = gtk_label_new("Offset");
		BalloonYOffset = (GtkAdjustment *) gtk_adjustment_new (0,  -2, 2, 1, 0, 0);
		scale = gtk_vscale_new (GTK_ADJUSTMENT (BalloonYOffset));
		gtk_scale_set_digits (GTK_SCALE (scale), 0);

		if(!ASCPCONFIG.offsetwithnum)
		{
			gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
		}
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), scale, 9, 10, 1, 8);
		gtk_table_attach_defaults(GTK_TABLE(BalloonParent), label, 9, 10, 8, 9);



		gtk_container_add (GTK_CONTAINER (subframe), BalloonParent);
		gtk_table_attach_defaults(GTK_TABLE(table), subframe, 0, 8, 4, 8);

		gtk_container_add (GTK_CONTAINER(WhichParent[0]), table);
		gtk_widget_show_all(WhichParent[0]);

	}



	/*
	 * Create the frame that will host Pager.
	 * Put it in WhichParent[1], and add _that_ to the tabletop.
	 */
	{
		GtkWidget *label;
		GtkWidget *table;
		GtkWidget *cframe;
		GtkWidget *frame2;
		GtkWidget *pframe;
		GtkWidget *ptable;
		GtkAdjustment *adj;
		GtkSpinButton *spin;



		WhichParent[1] = gtk_frame_new (NULL);
		table = gtk_table_new(8, 8, TRUE);

		PagerParent = gtk_table_new(11, 10, TRUE);

		Pager = gtk_check_button_new_with_label("Enable");
		gtk_widget_show_all(Pager);
		/*
		 * Hide/show or gray out the rest of the configuration
		 * depending on the state of the button.
		 */
		gtk_signal_connect(GTK_OBJECT(Pager), "clicked",
			 GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  PagerParent);
		gtk_table_attach_defaults(GTK_TABLE(table), Pager, 0, 2, 0, 1);


		label = gtk_label_new("Highlight    ");
		PagerHilightChar = g_malloc0(4);
		strcpy(PagerHilightChar, "#FFDDCC");
		PagerHilight= ascp_color_selector_new(PagerHilightChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), PagerHilight);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 0, 2, 5, 7);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), cframe, 2, 3, 5, 7);


		label = gtk_label_new("Foreground");
		PagerForeChar = g_malloc0(4);
		strcpy(PagerForeChar, "#221122");
		PagerFore = ascp_color_selector_new(PagerForeChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), PagerFore);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 0, 2, 7, 9);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), cframe, 2, 3, 7, 9);


		label = gtk_label_new("Background");
		PagerBackChar = g_malloc0(4);
		strcpy(PagerBackChar, "#CCDDFF");
		PagerBack= ascp_color_selector_new(PagerBackChar);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), PagerBack);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 0, 2, 9, 11 );
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), cframe, 2, 3, 9, 11);


		label = gtk_label_new(" Rows");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 4, 1, 0, 0);
		PagerRowSpinner = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(PagerRowSpinner);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerRowSpinner), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 3, 5, 7, 9);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), PagerRowSpinner, 5, 6, 7, 9);


		label = gtk_label_new("     Columns");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 4, 1, 0, 0);
		PagerColumnSpinner = gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(PagerColumnSpinner);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerColumnSpinner), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 3, 5, 9, 11);
		gtk_table_attach_defaults(GTK_TABLE(PagerParent), PagerColumnSpinner, 5, 6, 9, 11);



		pframe = gtk_frame_new (NULL);
		ptable = gtk_table_new(1, 1, TRUE);
		/* 
	 	 * Create an option menu to edit one of four labels.
	 	 */
		{
			GtkWidget *menu;
			GtkWidget *label;
			GtkWidget *ctable;
			GtkWidget *menuitem;
			GtkWidget *optionmenu;
			gint i=0;
			gchar *number[] = {
					"0",
					"1",
					"2",
					"3",
					"4",
					"5",
					"6"
					};
		
				
			ctable = gtk_table_new(10, 10, TRUE);

			menu = gtk_menu_new ();

			optionmenu = gtk_option_menu_new ();


			label = gtk_label_new("Desk");
			gtk_table_attach_defaults(GTK_TABLE(ctable), label, 1, 4, 0, 2);


			for(i=0; i < PAGER_NUM_DESKS; i++)
			{     
				menuitem = gtk_menu_item_new_with_label(number[i]);
				PagerLabelTable[i] = gtk_table_new(10, 10, TRUE);
				gtk_menu_append(GTK_MENU (menu), menuitem);
				gtk_widget_show(menuitem);
				gtk_signal_connect(GTK_OBJECT(menuitem), "activate", 
					(GtkSignalFunc) (choose_which_pager_entry), (gpointer ) i);

				PagerTransparent[i] = gtk_check_button_new_with_label("Transparent");
				PagerDesktopImage[i] = gtk_check_button_new_with_label("Desktop Image");
				
				PagerLabel[i] = gtk_entry_new_with_max_length(20);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]),PagerLabel[i], 0, 10, 0, 2);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]),PagerTransparent[i], 0, 10, 2, 4);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]),PagerDesktopImage[i], 0, 10, 6, 8);
				gtk_table_attach_defaults(GTK_TABLE(ctable), PagerLabelTable[i], 0, 10, 2, 10 );
				label = gtk_label_new("Tint Color");

				
				/* something to hold the color */
				PagerTintChar[i] = g_malloc0(4);
				
				/* Temporarily use red instead of whats in the file */
				strcpy(PagerTintChar[i],"#FF0000");
				
				/* Create a button to push the color picker */
				PagerTint[i] = ascp_color_selector_new(PagerTintChar[i]);
			
				PagerDesktopImageSel[i] = gtk_button_new_with_label("Image");
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]),PagerDesktopImageSel[i], 0, 4, 8, 10);
				PagerDesktopImageEntry[i] = gtk_entry_new_with_max_length(256);
				gtk_signal_connect(	GTK_OBJECT(PagerDesktopImageSel[i]),
									"clicked",
									GTK_SIGNAL_FUNC(ascp_open_file_dialog),
									PagerDesktopImageEntry[i]);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]),PagerDesktopImageEntry[i], 4, 10, 8, 10);
				cframe = gtk_frame_new (NULL);
				frame2 = gtk_frame_new (NULL);
				gtk_container_border_width (GTK_CONTAINER (frame2), 2);
				gtk_container_add (GTK_CONTAINER (frame2), PagerTint[i]);
				gtk_container_add(GTK_CONTAINER(cframe), frame2);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]), label, 0, 6, 4, 6);
				gtk_table_attach_defaults(GTK_TABLE(PagerLabelTable[i]), cframe, 6, 9, 4, 6);
			}

			gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
			gtk_table_attach_defaults(GTK_TABLE(ctable), optionmenu, 4, 8, 0, 2);


			gtk_container_border_width (GTK_CONTAINER (pframe), 2);
			gtk_container_add (GTK_CONTAINER (pframe), ctable);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), pframe, 7, 10, 0, 11);
			
		}


		/*
		 * Create the frame for the geometry.
		 */
		{
			GtkWidget *ctable;
			GtkWidget *button;
			GtkSpinButton *spin;
			GtkAdjustment *adj;
			
			ctable = gtk_table_new(17, 17, TRUE);
			pframe = gtk_frame_new(NULL);

			gtk_container_border_width (GTK_CONTAINER (pframe), 2);
			adj = (GtkAdjustment *) gtk_adjustment_new (0,  -99, 99, 1, 0, 0);
			PagerGeometryV = gtk_spin_button_new (adj, 1, 0);
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (PagerGeometryV), TRUE);
			spin = GTK_SPIN_BUTTON (PagerGeometryV);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerGeometryV), -1);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whvert)));
			gtk_table_attach_defaults(GTK_TABLE(ctable), PagerGeometryV, 6, 17, 1, 8);
			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 1, 6, 2, 7);

			adj = (GtkAdjustment *) gtk_adjustment_new (0,  -99, 99, 1, 0, 0);
			PagerGeometryH = gtk_spin_button_new (adj, 1, 0);
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (PagerGeometryH), TRUE);
			spin = GTK_SPIN_BUTTON (PagerGeometryH);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerGeometryH), -1);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whhoriz)));
			gtk_table_attach_defaults(GTK_TABLE(ctable), PagerGeometryH, 8, 16, 10, 16);
			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 1, 8, 10, 16);


			gtk_container_add (GTK_CONTAINER (pframe), ctable );
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), pframe, 4, 6, 0, 5);
		}

		/* The Alignment. */
		{
			GtkWidget *label;
			GtkWidget *scale;

			label = gtk_label_new("Align");
			PagerAlign = (GtkAdjustment *) gtk_adjustment_new (0,  -1, 1, 1, 0, 0);
			scale = gtk_hscale_new (GTK_ADJUSTMENT(PagerAlign));
			gtk_scale_set_digits (GTK_SCALE (scale), 0);
			/*  removed till I can find a place in the dialog to put it. 
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), scale, 4, 6, 0, 2);
			if(ASCPCONFIG.offsetwithnum)
			{
				gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 3, 4, 0, 1);
			}
			else
			{
				gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
				gtk_table_attach_defaults(GTK_TABLE(PagerParent), label, 3, 4, 0, 2);
			}
			*/
		}



		/* The fonts. */
		{
			GtkWidget *cframe;
			
			
			PagerSmallFontEntry = gtk_entry_new_with_max_length(128);
			/*
			cframe = gtk_frame_new(NULL);
			gtk_container_add(GTK_CONTAINER(cframe), PagerSmallFontEntry);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent),cframe, 2, 5, 0, 2);	
			*/
			cframe = gtk_frame_new(NULL);
			PagerSmallFont = gtk_button_new_with_label("...");
			gtk_signal_connect(	GTK_OBJECT(PagerSmallFont), "clicked", 
				GTK_SIGNAL_FUNC(ascp_open_font_dialog), PagerSmallFontEntry);
			gtk_container_border_width (GTK_CONTAINER (PagerSmallFont), 2);
			gtk_container_add(GTK_CONTAINER(cframe), PagerSmallFont);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), 
				gtk_label_new("Small Font  "), 0, 2, 0, 2);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), cframe, 2, 3, 0, 2);

			PagerFontEntry = gtk_entry_new_with_max_length(128);
			/*
			cframe = gtk_frame_new(NULL);
			gtk_container_add(GTK_CONTAINER(cframe), PagerFontEntry);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent),cframe, 2, 5, 2, 4);	
			*/
			
			cframe = gtk_frame_new(NULL);
			PagerFont = gtk_button_new_with_label("...");
			gtk_signal_connect(	GTK_OBJECT(PagerFont), "clicked",
				GTK_SIGNAL_FUNC(ascp_open_font_dialog), PagerFontEntry);
			gtk_container_border_width (GTK_CONTAINER (PagerFont), 2);
			gtk_container_add(GTK_CONTAINER(cframe), PagerFont);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), 
				gtk_label_new("Pager Font"), 0, 2, 2, 4);
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), cframe, 2, 3, 2, 4);


		}


		/* Redraw background; starts iconic.*/
		
		{
			PagerRedrawBg = gtk_check_button_new_with_label("Redraw");
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), PagerRedrawBg, 3, 5, 5, 7);

			PagerStartIconic = gtk_check_button_new_with_label("Iconic");
			gtk_table_attach_defaults(GTK_TABLE(PagerParent), PagerStartIconic, 5, 7, 5, 7);
		}
			

		gtk_table_attach_defaults(GTK_TABLE(table), PagerParent, 0, 8, 1, 8);
		gtk_container_add (GTK_CONTAINER(WhichParent[1]), table);

	}



	/*
	 * Create the frame that will host WXYZPager[4].
	 * Put it in WhichParent[2, 3, 4, & 5], and add _those_ to the tabletop.
	 */
	for(wxyz=0; wxyz<4; wxyz++)
	{
		GtkWidget *label;
		GtkWidget *table;
		GtkWidget *cframe;
		GtkWidget *frame2;
		GtkWidget *pframe;
		GtkWidget *ptable;
		GtkAdjustment *adj;
		GtkSpinButton *spin;



		WhichParent[wxyz + 2] = gtk_frame_new (NULL);
		table = gtk_table_new(8, 8, TRUE);

		WXYZPagerParent[wxyz] = gtk_table_new(10, 10, TRUE);

		WXYZPager[wxyz] = gtk_check_button_new_with_label("Enable");
		gtk_widget_show_all(WXYZPager[wxyz]);
		/*
		 * Hide/show or gray out the rest of the configuration
		 * depending on the state of the button.
		 */
		gtk_signal_connect(GTK_OBJECT(WXYZPager[wxyz]), "clicked",
			 GTK_SIGNAL_FUNC(ascp_checkbutton_hide_show),  WXYZPagerParent[wxyz]);
		gtk_table_attach_defaults(GTK_TABLE(table), WXYZPager[wxyz], 0, 2, 0, 1);

		label = gtk_label_new("Highlight    ");
		WXYZPagerHilightChar [wxyz]= g_malloc0(4);
		strcpy(WXYZPagerHilightChar[wxyz], "#FFDDCC");
		WXYZPagerHilight[wxyz]= ascp_color_selector_new(WXYZPagerHilightChar[wxyz]);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), WXYZPagerHilight[wxyz]);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 0, 2, 4, 6);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), cframe, 2, 3, 4, 6);


		label = gtk_label_new("Foreground");
		WXYZPagerForeChar[wxyz]= g_malloc0(4);
		strcpy(WXYZPagerForeChar[wxyz], "#221122");
		WXYZPagerFore[wxyz]= ascp_color_selector_new(WXYZPagerForeChar[wxyz]);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), WXYZPagerFore[wxyz]);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 0, 2, 6, 8);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), cframe, 2, 3, 6, 8);


		label = gtk_label_new("Background");
		WXYZPagerBackChar [wxyz]= g_malloc0(4);
		strcpy(WXYZPagerBackChar[wxyz], "#CCDDFF");
		WXYZPagerBack[wxyz]= ascp_color_selector_new(WXYZPagerBackChar[wxyz]);
		cframe = gtk_frame_new (NULL);
		frame2 = gtk_frame_new (NULL);
		gtk_container_border_width (GTK_CONTAINER (frame2), 2);
		gtk_container_add (GTK_CONTAINER (frame2), WXYZPagerBack[wxyz]);
		gtk_container_add(GTK_CONTAINER(cframe), frame2);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 0, 2, 8, 10 );
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), cframe, 2, 3, 8, 10);


		label = gtk_label_new(" Rows");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 4, 1, 0, 0);
		WXYZPagerRowSpinner [wxyz]= gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(WXYZPagerRowSpinner[wxyz]);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerRowSpinner[wxyz]), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 3, 5, 6, 8);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), WXYZPagerRowSpinner[wxyz], 5, 6, 6, 8);




		label = gtk_label_new("     Columns");
		adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 4, 1, 0, 0);
		WXYZPagerColumnSpinner[wxyz]= gtk_spin_button_new (adj, 1, 0);
		spin = GTK_SPIN_BUTTON(WXYZPagerColumnSpinner[wxyz]);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerColumnSpinner[wxyz]), 1);
		gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 3, 5,  8, 10);
		gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), WXYZPagerColumnSpinner[wxyz], 5, 6,  8, 10);



		pframe = gtk_frame_new (NULL);
		ptable = gtk_table_new(1, 1, TRUE);
		/* 
	 	 * Create an option menu to edit one of four labels.
	 	 */
		{

			GtkWidget *label;
			GtkWidget *ctable;

			ctable = gtk_table_new(10, 10, TRUE);


			label = gtk_label_new("Desk Label");
			gtk_table_attach_defaults(GTK_TABLE(ctable), label, 1, 8, 0, 4);

			WXYZPagerLabelTable[wxyz] = gtk_frame_new (NULL);
			WXYZPagerLabel[wxyz] = gtk_entry_new_with_max_length(20);
			gtk_entry_set_text (GTK_ENTRY(WXYZPagerLabel[wxyz]), wxyzpagerlabel[wxyz]);
			gtk_container_add (GTK_CONTAINER (WXYZPagerLabelTable[wxyz]), WXYZPagerLabel[wxyz]);
			gtk_table_attach_defaults(GTK_TABLE(ctable), WXYZPagerLabelTable[wxyz], 0, 10, 4, 10);

			//gtk_container_border_width (GTK_CONTAINER (pframe), 2);
			gtk_container_add (GTK_CONTAINER (pframe), ctable);
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), pframe, 7, 10, 2, 6);
			
		}


		/*
		 * Create the frame for the geometry.
		 */
		{
			GtkWidget *ctable;
			GtkWidget *button;
			GtkSpinButton *spin;
			GtkAdjustment *adj;
			
			
			ctable = gtk_table_new(16, 16, TRUE);
			pframe = gtk_frame_new(NULL);

			adj = (GtkAdjustment *) gtk_adjustment_new (0,  -99, 99, 1, 0, 0);
			WXYZPagerGeometryV [wxyz]= gtk_spin_button_new (adj, 1, 0);
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WXYZPagerGeometryV[wxyz]), TRUE);
			spin = GTK_SPIN_BUTTON (PagerGeometryV);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerGeometryV[wxyz]), -1);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whvert)));
			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 3, 5, 1, 8);
			gtk_table_attach_defaults(GTK_TABLE(ctable), WXYZPagerGeometryV[wxyz], 1, 8, 8, 16);


			adj = (GtkAdjustment *) gtk_adjustment_new (0,  -99, 99, 1, 0, 0);
			WXYZPagerGeometryH [wxyz]= gtk_spin_button_new (adj, 1, 0);
			gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (WXYZPagerGeometryH[wxyz]), TRUE);
			spin = GTK_SPIN_BUTTON (WXYZPagerGeometryH[wxyz]);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerGeometryH[wxyz]), -1);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button), 
				GTK_WIDGET(ascp_make_pixmap_from_data(whhoriz)));
			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 10, 13, 2, 7);
			gtk_table_attach_defaults(GTK_TABLE(ctable), WXYZPagerGeometryH[wxyz], 9, 16, 8, 16);



			gtk_container_add (GTK_CONTAINER (pframe), ctable );
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), pframe, 7, 10, 6, 10);

		}

		/* The Alignment. */
		{
			GtkWidget *label;
			GtkWidget *scale;

			label = gtk_label_new("Align");
			WXYZPagerAlign[wxyz] = (GtkAdjustment *) gtk_adjustment_new (0,  -1, 1, 1, 0, 0);
			scale = gtk_hscale_new (GTK_ADJUSTMENT(WXYZPagerAlign[wxyz]));
			gtk_scale_set_digits (GTK_SCALE (scale), 0);
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), scale, 8, 10, 0, 2);

			if(ASCPCONFIG.offsetwithnum)
			{
				gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 7, 8, 1, 2);
			}
			else
			{
				gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
				gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 7, 8, 0, 2);
			}
		}



		/* The fonts. */
		{
			GtkWidget *label;
			GtkWidget *cframe;

			label = gtk_label_new("Small Font ");
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 0, 2, 0, 2);
			cframe = gtk_frame_new(NULL);
			WXYZPagerSmallFont [wxyz]= gtk_button_new_with_label("...");
			gtk_widget_set_sensitive(WXYZPagerSmallFont[wxyz], FALSE);
			gtk_container_border_width (GTK_CONTAINER (WXYZPagerSmallFont[wxyz]), 2);
			gtk_container_add(GTK_CONTAINER(cframe), WXYZPagerSmallFont[wxyz]);
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), cframe, 2, 3, 0, 2);


			label = gtk_label_new("Pager Font");
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), label, 0, 2, 2, 4);
			cframe = gtk_frame_new(NULL);
			WXYZPagerFont [wxyz]= gtk_button_new_with_label("...");
			gtk_widget_set_sensitive(WXYZPagerFont[wxyz], FALSE);
			gtk_container_border_width (GTK_CONTAINER (WXYZPagerFont[wxyz]), 2);
			gtk_container_add(GTK_CONTAINER(cframe), WXYZPagerFont[wxyz]);
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), cframe, 2, 3, 2, 4);


		}


		/* Redraw background. */
		{
			WXYZPagerRedrawBg [wxyz]= gtk_check_button_new_with_label("Redraw");
			gtk_table_attach_defaults(GTK_TABLE(WXYZPagerParent[wxyz]), WXYZPagerRedrawBg[wxyz], 4, 6, 0, 2);
		}
			

		gtk_table_attach_defaults(GTK_TABLE(table), WXYZPagerParent[wxyz], 0, 8, 2, 8);
		gtk_container_add (GTK_CONTAINER(WhichParent[wxyz + 2]), table);

		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(WXYZPager[wxyz]),FALSE);
	}


	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[0], 0, 14, 1, 10);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[1], 0, 14, 1, 10);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[2], 0, 14, 1, 10);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[3], 0, 14, 1, 10);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[4], 0, 14, 1, 10);
	gtk_table_attach_defaults(GTK_TABLE(tabletop), WhichParent[5], 0, 14, 1, 10);

	parse_pager(min, max);

	gtk_widget_show(tabletop);

	return tabletop;
}


static void parse_pager(gfloat min, gfloat max)
{

	gchar *buffer = (gchar*) g_malloc0(1024);
	gfloat incr;
	gint wxyz;
	FILE *backupfile;
	 
	backupfile = ascp_open_file(".ascp", "w");
	
	IoFile =  ascp_open_file("pager", "r");
	incr = (max - min)/FILESIZE;


	ascp_update_status(NULL, "pager", min); 

	while (fgets(buffer, 1024, IoFile) != NULL)
	{
		gchar *line = buffer;
		/*      
		 * Show our progress per line read.
		 */
		ascp_update_status(NULL, NULL, min); 
		min = ( min >= max) ? max : min + incr*strlen(buffer); 

		fputs(line, backupfile);

		for ( ; isspace(*line) ; line++);
		if( !ascp_strncasecmp(line, "StickyPagerIcon", 15) )
		{
			 gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(StickyPagerIcon), TRUE );
		}
		else if( !ascp_strncasecmp(line, "DeskTopScale", 12))
		{
			int value;

			sscanf(line + 12, "%d", &value);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopScaleSpinner), value); 
		}
		else if (!ascp_strncasecmp(line, "HiBackColor", 11) )
		{
			GdkColor *color;

			sscanf(line + 11, "%s", HiBackColorChar);
			color = gtk_object_get_data(GTK_OBJECT(HiBackColor), "color");
			ascp_char_to_color(HiBackColorChar, color);
		}
		else if (!ascp_strncasecmp(line, "HiForeColor", 11) )
		{
			GdkColor *color;

			sscanf(line + 11, "%s", HiForeColorChar);
			color = gtk_object_get_data(GTK_OBJECT(HiForeColor), "color");
			ascp_char_to_color(HiForeColorChar, color);
		}
		else if( !ascp_strncasecmp(line, "Balloons", 8) )
		{
			 gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(Balloons), TRUE );
		}
		else if (!ascp_strncasecmp(line, "BalloonFore", 11) )
		{
			GdkColor *color;

			sscanf(line + 11, "%s", BalloonForeChar );
			color = gtk_object_get_data(GTK_OBJECT(BalloonFore), "color");
			ascp_char_to_color(BalloonForeChar, color);
		}
		else if (!ascp_strncasecmp(line, "BalloonBack", 11) )
		{
			GdkColor *color;

			sscanf(line + 11, "%s", BalloonBackChar );
			color = gtk_object_get_data(GTK_OBJECT(BalloonBack), "color");
			ascp_char_to_color(BalloonBackChar, color);
		}
		else if( !ascp_strncasecmp(line, "BalloonFont", 11))
		{
			line += 11;
			for ( ; isspace(*line) ; line++);
			if (*line)
			{
				BalloonFontChar = g_malloc(128);
				sscanf(line, "%s", BalloonFontChar);
				gtk_entry_set_text (GTK_ENTRY(BalloonFontEntry), BalloonFontChar);
				gtk_entry_set_position (GTK_ENTRY(BalloonFontEntry), 0);
				free(BalloonFontChar);
			}
			else
			{
				gtk_entry_set_text (GTK_ENTRY(BalloonFontEntry), "none");
				gtk_entry_set_position (GTK_ENTRY(BalloonFontEntry), 0);
			}
		}
		else if( !ascp_strncasecmp(line, "BalloonBorderWidth", 18))
		{
			int value;

			sscanf(line + 18, "%d", &value);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonBorderWidthSpinner), value); 
		}
		else if (!ascp_strncasecmp(line, "BalloonBorderColor", 18) )
		{
			GdkColor *color;

			sscanf(line + 18, "%s", BalloonBorderColorChar);
			color = gtk_object_get_data(GTK_OBJECT(BalloonBorderColor), "color");
			ascp_char_to_color(BalloonBorderColorChar, color);
		}
		else if( !ascp_strncasecmp(line, "BalloonDelay", 12))
		{
			int value;

			sscanf(line + 12, "%d", &value);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(BalloonDelaySpinner), value); 
		}
		else if( !ascp_strncasecmp(line, "BalloonYOffset", 14))
		{
			int value;

			sscanf(line + 14, "%d", &value);
			gtk_adjustment_set_value(GTK_ADJUSTMENT(BalloonYOffset), value); 
		}
		else if ( !ascp_strncasecmp(line, "*Pager", 6))
		{
			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(Pager), TRUE);

			if (!ascp_strncasecmp(line + 6, "Back", 4)) 
			{       
				GdkColor *color;

				sscanf(line + 4  + 6, "%s", PagerBackChar);   
				color = gtk_object_get_data(GTK_OBJECT(PagerBack), "color");
				ascp_char_to_color(PagerBackChar, color);
			}
			else if( !ascp_strncasecmp(line + 6, "DesktopImage", 12) )
			{
				int desk;
				gchar infile[1024];
				char *s;
				s = line + 18;
			
				/* Clean all the space the keyword and the key */
				while ((isspace (*s)) && (*s != '\n'))
					s++;
				*(s + strlen (s) - 1) = 0;
				
				/* parse out desk and color*/
				if(!isdigit(*s))
				{
					g_warning("Non-Numeric Desk Identifier in PagerDesktopImage line.\n");
					g_warning("\tLine was: %s\n",line);
					continue;
				}
				sscanf(s,"%d", &desk);
				/* Number of desks constant here!!!! */
				if ( desk > PAGER_NUM_DESKS || desk < 0)
				{
					g_warning("ASCP Can't handle that number of desks.");
					g_warning("\tLine was: %s\n",line);
					continue;
				}

				while(!isspace(*s) && (*s !='\n'))
					s++;
				if(*line == '\n')
				{
					g_warning("Discarding PagerDesktopImage line for desk %d",desk);
					g_warning("\tLine was: %s\n",line);
					continue;
				}
				sscanf(s,"%s",infile);
				gtk_entry_set_text (GTK_ENTRY(PagerDesktopImageEntry[desk]),infile);
				gtk_entry_set_position(GTK_ENTRY(PagerDesktopImageEntry[desk]),0);

				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(PagerDesktopImage[desk]), TRUE );
			}
			else if( !ascp_strncasecmp(line + 6, "Transparent", 11) )
			{
				int desk;
				gchar incolor[128];
				GdkColor *color;
				char *s;
				s = line + 17;
			
				/* Clean all the space the keyword and the key */
				while ((isspace (*s)) && (*s != '\n'))
					s++;
				*(s + strlen (s) - 1) = 0;
				
				/* parse out desk and color*/
				if(!isdigit(*s))
				{
					g_warning("Non-Numeric Desk Identifier in PagerTransparent line.\n");
					g_warning("\tLine was: %s\n",line);
					continue;
				}
				sscanf(s,"%d", &desk);
				/* Number of desks constant here!!!! */
				if ( desk > PAGER_NUM_DESKS || desk < 0)
				{
					g_warning("Non-Numeric Desk Identifier in PagerTransparent line.\n");
					g_warning("\tLine was: %s\n",line);
					continue;
				}

				while(!isspace(*s) && (*s !='\n'))
					s++;
				if(*line == '\n')
				{
					g_warning("Discarding PagerTransparent line for desk %d",desk);
					g_warning("\tLine was: %s\n",line);
					continue;
				}
				if(!PagerTintChar[desk])
					PagerTintChar[desk] = g_malloc(128);
				sscanf(s,"%s",incolor);
				strcpy(PagerTintChar[desk],incolor);
				gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON(PagerTransparent[desk]), TRUE );
				color = gtk_object_get_data(GTK_OBJECT(PagerTint[desk]), "color");
				ascp_char_to_color(PagerTintChar[desk], color);
			}
			else if (!ascp_strncasecmp(line + 6, "Fore", 4)) 
			{       
				GdkColor *color;

				sscanf(line + 4 + 6, "%s", PagerForeChar);   
				color = gtk_object_get_data(GTK_OBJECT(PagerFore), "color");
				ascp_char_to_color(PagerForeChar, color);
			}
			else if (!ascp_strncasecmp(line + 6, "Font", 4))
			{
				PagerFontChar = g_malloc(128);
				sscanf(line + 4 + 6, "%s", PagerFontChar);
				gtk_entry_set_text (GTK_ENTRY(PagerFontEntry), PagerFontChar);
				gtk_entry_set_position (GTK_ENTRY(PagerFontEntry), 0);
				free(PagerFontChar);
			}
			else if (!ascp_strncasecmp(line + 6, "SmallFont", 9)) 
			{
				PagerSmallFontChar = g_malloc(128);
				sscanf(line + 9 + 6, "%s", PagerSmallFontChar); 
				gtk_entry_set_text (GTK_ENTRY(PagerSmallFontEntry), PagerSmallFontChar);
				gtk_entry_set_position (GTK_ENTRY(PagerSmallFontEntry), 0);
				free(PagerSmallFontChar);
			} 
			else if (!ascp_strncasecmp(line + 6, "Hilight ", 8)) 
			{
				GdkColor *color;

				sscanf(line + 6 + 7, "%s", PagerHilightChar);   
				color = gtk_object_get_data(GTK_OBJECT(PagerHilight), "color");
				ascp_char_to_color(PagerHilightChar, color);
			} 
			else if (!ascp_strncasecmp(line + 6, "HilightBorders",14))
			{
			//gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(PagerHilightBorders),
			//								TRUE);
			}
			else if (!ascp_strncasecmp(line + 6, "Geometry", 8)) 
			{
				int g_x,g_y,width,height;
				line += 14;
				/* Clean all the space the keyword and the key */
				while ((isspace (*line)) && (*line != '\n'))
					line++;
				*(line + strlen (line) - 1) = 0;
				/* Calling XPG, g_x is horizontal, g_y is vertical,
					noone cares bout window height and width, fuck em.
				*/
				XParseGeometry (line, &g_x, &g_y, &width, &height);
				
				
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerGeometryV), g_y);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerGeometryH), g_x);
			} 
			else if (!ascp_strncasecmp(line + 6, "RedrawBg", 8)) 
			{
				gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(PagerRedrawBg), TRUE);
			} 
			else if (!ascp_strncasecmp(line + 6, "Align", 5)) 
			{
				gint value;

				sscanf(line + 5 + 6, "%d", &value);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(PagerAlign), value); 
			} 
			else if (!ascp_strncasecmp(line + 6, "Label", 5)) 
			{
				gint i;
				gchar *value = g_malloc(24);

				sscanf(line + 5 + 6, "%d %s", &i, value);
				i = i< PAGER_NUM_DESKS ? i : 0;

				gtk_entry_set_text (GTK_ENTRY (PagerLabel[i]), value);

				g_free(value);
			}
			else if (!ascp_strncasecmp(line + 6, "Rows", 4))
			{
				gint value;

				sscanf(line + 4 + 6, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerRowSpinner), value); 

			}
			else if (!ascp_strncasecmp(line + 6, "Columns", 7)) 
			{
				gint value;

				sscanf(line + 7 + 6, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(PagerColumnSpinner), value); 
			}
		}
		else if ( ((!ascp_strncasecmp(line, "*WPager", 7)) && (wxyz = 1))
			||    ((!ascp_strncasecmp(line, "*XPager", 7)) && (wxyz = 2))
			||    ((!ascp_strncasecmp(line, "*YPager", 7)) && (wxyz = 3))
			||    ((!ascp_strncasecmp(line, "*ZPager", 7)) && (wxyz = 4))) 
		{

			wxyz -= 1;

			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WXYZPager[wxyz]), TRUE);

			if (!ascp_strncasecmp(line + 7, "Back", 4)) 
			{       
				GdkColor *color;

				sscanf(line + 4  + 7, "%s", WXYZPagerBackChar[wxyz]);   
				color = gtk_object_get_data(GTK_OBJECT(WXYZPagerBack[wxyz]), "color");
				ascp_char_to_color(WXYZPagerBackChar[wxyz], color);
			}
			if (!ascp_strncasecmp(line + 7, "Fore", 4)) 
			{       
				GdkColor *color;

				sscanf(line + 4 + 7, "%s", WXYZPagerForeChar[wxyz]);   
				color = gtk_object_get_data(GTK_OBJECT(WXYZPagerFore[wxyz]), "color");
				ascp_char_to_color(WXYZPagerForeChar[wxyz], color);
			}
			else if (!ascp_strncasecmp(line + 7, "Font", 4))
			{
				//sscanf(line + 4 + 7, "%s", WXYZPagerFont[wxyz]);
			}
			else if (!ascp_strncasecmp(line + 7, "SmallFont", 9)) 
			{
				//sscanf(line + 9 + 7, "%s", WXYZPagerSmallFont[wxyz]); 
			} 
			else if (!ascp_strncasecmp(line + 7, "Hilight ", 8)) 
			{
				GdkColor *color;

				sscanf(line + 7 + 7, "%s", WXYZPagerHilightChar[wxyz]);   
				color = gtk_object_get_data(GTK_OBJECT(WXYZPagerHilight[wxyz]), "color");
				ascp_char_to_color(WXYZPagerHilightChar[wxyz], color);
				
			} 
			else if (!ascp_strncasecmp(line + 7, "Geometry", 8)) 
			{
				//hmmm.....
				//sscanf(line + 8 + 7, "%s", WXYZPagerGeometryV, H...[wxyz]);
				//widgets they are.
			} 
			else if (!ascp_strncasecmp(line + 7, "RedrawBg", 8)) 
			{
				gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(WXYZPagerRedrawBg[wxyz]), TRUE);
			} 
			else if (!ascp_strncasecmp(line + 7, "Align", 5)) 
			{
				gint value;

				sscanf(line + 5 + 7, "%d", &value);
				gtk_adjustment_set_value(GTK_ADJUSTMENT(WXYZPagerAlign[wxyz]), value); 
			} 
			else if (!ascp_strncasecmp(line + 7, "Label", 5)) 
			{
				gint i;
				gchar *value = g_malloc(24);

				sscanf(line + 5 + 7, "%d %s", &i, value);
				gtk_entry_set_text (GTK_ENTRY (WXYZPagerLabel[wxyz]), value);

				g_free(value);
			}
			else if (!ascp_strncasecmp(line + 7, "Rows", 4))
			{
				gint value;

				sscanf(line + 4 + 7, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerRowSpinner[wxyz]), value); 

			}
			else if (!ascp_strncasecmp(line + 7, "Columns", 7)) 
			{
				gint value;

				sscanf(line + 7 + 7, "%d", &value);
				gtk_spin_button_set_value(GTK_SPIN_BUTTON(WXYZPagerColumnSpinner[wxyz]), value); 
			}


		}		


		ascp_checkbutton_hide_show(Balloons, BalloonParent);
		ascp_checkbutton_hide_show(Pager, PagerParent);
		{
			int i;
			for(i=0; i<4; i++)
				ascp_checkbutton_hide_show(WXYZPager[i], WXYZPagerParent[i]);
		}

	}

	fclose(IoFile);

	fclose(backupfile);


}

void ascp_write_pager()
{
	gint wxyz;
	gchar type[] = {"WXYZ"};

	IoFile = ascp_open_file("pager", "w");
	/*  Drop all those values into thier respective gchar*'s */
	{
		BalloonFontChar = gtk_entry_get_text (GTK_ENTRY(BalloonFontEntry));
		PagerFontChar = gtk_entry_get_text (GTK_ENTRY(PagerFontEntry));
		PagerSmallFontChar = gtk_entry_get_text (GTK_ENTRY(PagerSmallFontEntry));
	}

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");


	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# General\n\n"); 
	if( GTK_TOGGLE_BUTTON(StickyPagerIcon)->active)  
		fprintf(IoFile, "StickyPagerIcon\n");
	fprintf(IoFile, "HiBackColor %s\n", HiBackColorChar);
	fprintf(IoFile, "HiForeColor %s\n", HiForeColorChar);
	fprintf(IoFile, "DeskTopScale %d\n", gtk_spin_button_get_value_as_int
		( GTK_SPIN_BUTTON (DesktopScaleSpinner)));


	if( GTK_TOGGLE_BUTTON(Balloons)->active)  
	{
		fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
		fprintf(IoFile, "# Balloons\n\n"); 
		fprintf(IoFile, "Balloons\n");
		fprintf(IoFile, "BalloonDelay %d\n", gtk_spin_button_get_value_as_int 
			( GTK_SPIN_BUTTON (BalloonDelaySpinner)));
		fprintf(IoFile, "BalloonBorderWidth %d\n", gtk_spin_button_get_value_as_int 
			( GTK_SPIN_BUTTON (BalloonBorderWidthSpinner)));
		fprintf(IoFile, "BalloonBorderColor %s\n", BalloonBorderColorChar);
		fprintf(IoFile, "BalloonYOffset %d\n", (gint) GTK_ADJUSTMENT(BalloonYOffset)->value);
		fprintf(IoFile, "BalloonFore %s\n", BalloonForeChar);
		fprintf(IoFile, "BalloonBack %s\n", BalloonBackChar);
		fprintf(IoFile, "BalloonFont %s\n", BalloonFontChar);
		
	}


	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Pager-executables name specific options\n\n"); 

	if( GTK_TOGGLE_BUTTON(Pager)->active)  
	{
		gint i=0;

		fprintf(IoFile, "\n#-------------------------\n");
		fprintf(IoFile, "*PagerBack %s\n", PagerBackChar);
		fprintf(IoFile, "*PagerFore %s\n", PagerForeChar);
		fprintf(IoFile, "*PagerFont %s\n",PagerFontChar);
		fprintf(IoFile, "*PagerSmallFont %s\n",PagerSmallFontChar);
		fprintf(IoFile, "*PagerAlign %d\n", (gint) GTK_ADJUSTMENT(PagerAlign)->value);
		fprintf(IoFile, "*PagerHilight %s\n", PagerHilightChar );
		fprintf(IoFile, "*PagerRedrawBg %d\n", (gint)  GTK_TOGGLE_BUTTON(PagerRedrawBg)->active);
		if( GTK_TOGGLE_BUTTON(PagerStartIconic)->active)  
			fprintf(IoFile, "PagerStartIconic\n");
		fprintf(IoFile, "*PagerGeometry ");
		i = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(PagerGeometryH));
		if(i >= 0)
			fprintf(IoFile,"+%d",i);
		else
			fprintf(IoFile,"%d",i);
		i = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(PagerGeometryV));
		if(i >= 0)
			fprintf(IoFile,"+%d\n",i);
		else
			fprintf(IoFile,"%d\n",i);
		/* Run through the pager desks... */
		for(i=0; i< PAGER_NUM_DESKS; i++)
			fprintf(IoFile, "*PagerLabel  %d  %s\n", i, gtk_entry_get_text (GTK_ENTRY(PagerLabel[i])));
		for(i=0; i< PAGER_NUM_DESKS; i++)
			if(GTK_TOGGLE_BUTTON(PagerTransparent[i])->active)
				fprintf(IoFile, "*PagerTransparent %d %s\n", i, PagerTintChar[i]);
		for(i=0; i< PAGER_NUM_DESKS; i++)
			if( GTK_TOGGLE_BUTTON(PagerDesktopImage[i])->active )
				fprintf(IoFile, "*PagerDesktopImage %d %s\n", 
				i, gtk_entry_get_text (GTK_ENTRY(PagerDesktopImageEntry[i])));
		fprintf(IoFile, "*PagerRows %d\n", 
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(PagerRowSpinner)));
		fprintf(IoFile, "*PagerColumns %d\n", 
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(PagerColumnSpinner)));
		
		/*  Yanked the following pagerxpm entries since they don't do anything atm.
		fprintf(IoFile, "*PagerXPM    0  ~/GNUstep/Library/AfterStep/non-configurable/0_background\n");
		fprintf(IoFile, "*PagerXPM    1  ~/GNUstep/Library/AfterStep/non-configurable/1_background\n");
		fprintf(IoFile, "*PagerXPM    2  ~/GNUstep/Library/AfterStep/non-configurable/2_background\n");
		fprintf(IoFile, "*PagerXPM    3  ~/GNUstep/Library/AfterStep/non-configurable/3_background\n");
		*/
	}

	for(wxyz=0; wxyz<4; wxyz++)
	{
		if( GTK_TOGGLE_BUTTON(WXYZPager[wxyz])->active)  
		{
			fprintf(IoFile, "\n#-------------------------\n");
			fprintf(IoFile, "*%cPagerBack %s\n", type[wxyz], WXYZPagerBackChar[wxyz]);
			fprintf(IoFile, "*%cPagerFore %s\n", type[wxyz], WXYZPagerForeChar[wxyz]);
			fprintf(IoFile, "*%cPagerFont -adobe-helvetica-bold-o-*-*-10-*-*-*-*-*-*-*\n", type[wxyz]);
			fprintf(IoFile, "*%cPagerSmallFont 5x8\n", type[wxyz]);
			fprintf(IoFile, "*%cPagerAlign %d\n", type[wxyz], 
				(gint) GTK_ADJUSTMENT(WXYZPagerAlign[wxyz])->value);
			fprintf(IoFile, "*%cPagerHilight %s\n", type[wxyz], WXYZPagerHilightChar[wxyz]);
			fprintf(IoFile, "*%cPagerRedrawBg %d\n", type[wxyz], 
				(gint)  GTK_TOGGLE_BUTTON(WXYZPagerRedrawBg[wxyz])->active);
			fprintf(IoFile, "*%cPagerGeometry %d%d\n", type[wxyz], 
				gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(WXYZPagerGeometryH[wxyz])),
				gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(WXYZPagerGeometryV[wxyz])) ); 
			fprintf(IoFile, "*%cPagerLabel  %d  %s\n", type[wxyz], wxyz, 
				gtk_entry_get_text (GTK_ENTRY(WXYZPagerLabel[wxyz])));
			fprintf(IoFile, "*%cPagerRows %d\n", type[wxyz], 
				gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(WXYZPagerRowSpinner[wxyz])));
			fprintf(IoFile, "*%cPagerColumns %d\n", type[wxyz], 
				gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(WXYZPagerColumnSpinner[wxyz])));
			fprintf(IoFile, 
				"*%cPagerXPM    %d  ~/GNUstep/Library/AfterStep/non-configurable/%d_background\n", 
					type[wxyz], wxyz, wxyz);
		}
	}


	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");


	fclose(IoFile);
}



static void  choose_which_pager (GtkWidget *widget, gint type)
{
	//type = (type > 5) ? 0 : type; 

	if( type == 0)
	{
		gtk_widget_show_all(WhichParent[0]);
		gtk_widget_hide(WhichParent[1]);
		gtk_widget_hide(WhichParent[2]);
		gtk_widget_hide(WhichParent[3]);
		gtk_widget_hide(WhichParent[4]);
		gtk_widget_hide(WhichParent[5]);
	}
	else if( type == 1)
	{
		gtk_widget_show_all(WhichParent[1]);
		gtk_widget_hide(WhichParent[0]);
		gtk_widget_hide(WhichParent[2]);
		gtk_widget_hide(WhichParent[3]);
		gtk_widget_hide(WhichParent[4]);
		gtk_widget_hide(WhichParent[5]);
	}
	else if( type == 2)
	{
		gtk_widget_show_all(WhichParent[2]);
		gtk_widget_hide(WhichParent[0]);
		gtk_widget_hide(WhichParent[1]);
		gtk_widget_hide(WhichParent[3]);
		gtk_widget_hide(WhichParent[4]);
		gtk_widget_hide(WhichParent[5]);
	}	
	else if( type == 3)
	{
		gtk_widget_show_all(WhichParent[3]);
		gtk_widget_hide(WhichParent[0]);
		gtk_widget_hide(WhichParent[1]);
		gtk_widget_hide(WhichParent[2]);
		gtk_widget_hide(WhichParent[4]);
		gtk_widget_hide(WhichParent[5]);
	}
	else if( type == 4)
	{
		gtk_widget_show_all(WhichParent[4]);
		gtk_widget_hide(WhichParent[0]);
		gtk_widget_hide(WhichParent[1]);
		gtk_widget_hide(WhichParent[2]);
		gtk_widget_hide(WhichParent[3]);
		gtk_widget_hide(WhichParent[5]);
	}
	else if( type == 5)
	{
		gtk_widget_show_all(WhichParent[5]);
		gtk_widget_hide(WhichParent[0]);
		gtk_widget_hide(WhichParent[1]);
		gtk_widget_hide(WhichParent[2]);
		gtk_widget_hide(WhichParent[3]);
		gtk_widget_hide(WhichParent[4]);
	}
	else g_error("Invalid or unhandled number of pagers!\n Bug the maintainer to add support for the number of pagers you want.");
}

static void choose_which_pager_entry(GtkWidget *widget,gint type)
{
	int i;
	for(i= 0; i < PAGER_NUM_DESKS;i++)
	{
		if(i != type)
		{
			gtk_widget_hide(PagerLabelTable[i]);
		}
	gtk_widget_show_all(PagerLabelTable[type]);
	}

}
