/*
 * gtkHelp : a helper application, intended to be useful to any application.
 *
 * Copyright (C) 1998, David Taylor.
 *
 * You may distribute/use this software under the terms of the GNU General
 * Public License.
 *
 */


#ifndef __HELP_H__
#define __HELP_H__


/****************/
/* Definitions  */
/****************/

/* methinks this is a bit inflexible */
#if 0
#define  WHARFENTRIES   0	/* A help index for Wharf Entries.	*/
#define  WHARFSTYLE     1	/* A help index for Wharf Style.	*/
#define  DATABASE       2	/* A help index for Database.		*/
#define  PAGER          3	/* A help index for Pager.		*/
#define  NUM_PAGES      8	/* Max. number of notebook pages.	*/
#define  NUM_MAN_ITEMS  17	/* Max. number of man page menu items.	*/
#endif


gint NUM_PAGES;    	/* Max. number of notebook pages.	*/
gint NUM_MAN_ITEMS; /* Max. number of man page menu items.	*/

/****************/
/* Declarations */
/****************/

extern char *book_open_xpm[];
extern char *book_closed_xpm[];


/****************/
/* Prototypes   */
/****************/

/* Global prototype for online help. */
void help(gint, gchar *);

/* Prototypes for routines used within help. */
GtkWidget *create_window  ( );
GtkWidget *create_and_pack_notebook ( GtkWidget * );
GtkWidget *create_pixmap_label  ( gchar * );
//static  void page_switch  ( GtkWidget *, GtkNotebookPage *, gint );
//static  gushort convert_color  ( unsigned );
gchar *strjoin ( gchar *, gchar *);
gint  man_menu_select  ( GtkWidget *, GdkEvent * );
void  create_pixmaps ( GtkWidget * );
void  create_and_pack_buttons ( GtkWidget *, GtkWidget *, GtkWidget * );
void  insert_help_text ( GtkWidget *, GtkWidget *, guint );
void  append_help_page ( GtkWidget *, guint );
void  append_about_page  ( GtkWidget * );
void  man_menu_response  ( gchar * );
void  extract_color  ( GdkColor *, unsigned, unsigned, unsigned );
void  search_text  ( GtkWidget *, gchar * );
void  populate_text  ( GtkWidget *, int );
void  close_help  ( GtkWidget *, gpointer );
void  about_page  ( GtkWidget *, gpointer );


#endif /* __HELP_H__  */
