
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 */
				  
#include "xpm.h"


#include "ascp.h"


/* 
 * Global Variables used within within this file only.
 *
 * The philosophy is: "If a widget can keep a value,
 * there's no need to also have an element to also keep 
 * that value. The widget can be queried or assigned 
 * without writing additional callbacks.".
 */

/*----------------------------------*/
static FILE *IoFile;
gchar  *BaseFile;
/*----------------------------------*/

static GtkWidget *Parent[5];

static GtkWidget *ModulePathList;
static GtkWidget *ModulePathEntry;

static GtkWidget *IconPathList;
static GtkWidget *IconPathEntry;

static GtkWidget *PixmapPathList;
static GtkWidget *PixmapPathEntry;

static GtkWidget *ScriptPathList;
static GtkWidget *ScriptPathEntry;

static GtkWidget *DesktopSizeSpinnerX;
static GtkWidget *DesktopSizeSpinnerY;
static GtkWidget *DesktopScaleSpinner;


static GtkWidget *CurrentEntry;
static gint CurrentRow;

/*----------------------------------*/
static void parse_base(gfloat, gfloat);
static gint move_item_up(GtkWidget *, GtkWidget *);
static gint move_item_down(GtkWidget *, GtkWidget *);
static void choose_which_option(GtkWidget *, gint);
static gint add_item(GtkWidget *, GtkWidget *);
static gint add_item_set_entry_first(GtkWidget *, GtkWidget *);
static gint remove_item(GtkWidget *, GtkWidget *);
static void init_and_append_entry(GtkWidget *, gchar *);
static gint item_selected(GtkWidget *, gint, gint, GdkEventButton *, gpointer * );
/*----------------------------------*/




GtkWidget * ascp_draw_base(gfloat min, gfloat max)
{
	/*      
	 * The toplevel table that shall be returned to
	 * populate_frame().
	 */ 
	GtkWidget *tabletop =  gtk_table_new(24, 29, TRUE);



	if(ASCPERROR)
		return gtk_label_new("ascp Error");

	{
		GtkWidget *frame;
		GtkWidget *scrolledwin;
		GtkWidget *littletable;
		GtkWidget *button;
		GtkWidget *hbox;
		
		gchar *pages[] = {
				"Module Search Paths", 
				"Icon Search Paths", 
				"Pixmap Search Paths", 
				"Script Search Paths",
				"Virtual Desktop"
				};


		/* The optionmenu */
		{
			GtkWidget *menu;
			GtkWidget *menuitem;
			GtkWidget *optionmenu;
			gint i=0;
			char *types [] = {
					"Module",
					"Icon",
					"Pixmap",
					"Script",
					"Virtual"
					};
		
			menu = gtk_menu_new ();
			optionmenu = gtk_option_menu_new ();

			for(i=0; i < (sizeof(types)/sizeof(*types)); i++)
			{
				menuitem = gtk_menu_item_new_with_label(types[i]);
				gtk_menu_append(GTK_MENU (menu), menuitem);
				gtk_widget_show(menuitem);

				gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
					(GtkSignalFunc) choose_which_option, (gpointer) i);

			}

			gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
			gtk_table_attach_defaults(GTK_TABLE(tabletop), optionmenu, 0, 6, 0, 3);
			gtk_widget_show_all(optionmenu);
			gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu) , 0);

		}


		/* The module page */
		{

			Parent[0] =  gtk_table_new(1, 1, TRUE);

			frame = gtk_frame_new(pages[0]);
			littletable =  gtk_table_new(14, 14, TRUE);
			scrolledwin = gtk_scrolled_window_new (NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
				GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);

			ModulePathList = gtk_clist_new(1);
			ModulePathEntry = gtk_entry_new_with_max_length(100);
#ifndef GTK_STABLE_VERSION 
			gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), ModulePathList);
#else
			gtk_container_add(GTK_CONTAINER(scrolledwin), ModulePathList);
#endif

			gtk_table_attach_defaults( GTK_TABLE(littletable), scrolledwin, 0, 14, 0, 9);

			button = gtk_button_new_with_label(" Remove ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(remove_item), (gpointer *) ModulePathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 0, 6, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);


			hbox = gtk_hbox_new(TRUE, 0);

			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(up)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_up), (gpointer *) ModulePathList);
			gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);


			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(down)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_down), (gpointer *) ModulePathList);
			gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, TRUE, 0);

			gtk_table_attach( GTK_TABLE(littletable), hbox, 6, 8, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);



			button = gtk_button_new_with_label("    Add     ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item_set_entry_first), (gpointer *) ModulePathEntry);
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item), (gpointer *) ModulePathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 8, 14, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);


			gtk_entry_set_text (GTK_ENTRY (ModulePathEntry), "");
			gtk_table_attach_defaults( GTK_TABLE(littletable), ModulePathEntry, 1, 13, 11, 14);

			gtk_signal_connect(GTK_OBJECT(ModulePathList), "select_row",
				 GTK_SIGNAL_FUNC(item_selected), (gpointer *)ModulePathEntry);

			gtk_container_add(GTK_CONTAINER(frame), littletable);
			gtk_table_attach_defaults( GTK_TABLE(Parent[0]), frame, 0, 1, 0, 1);

		}



		/* The icon page */
		{

			Parent[1] =  gtk_table_new(1, 1, TRUE);

			frame = gtk_frame_new(pages[1]);
			littletable =  gtk_table_new(14, 14, TRUE);
			scrolledwin = gtk_scrolled_window_new (NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
				GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);

			IconPathList = gtk_clist_new(1);
			IconPathEntry = gtk_entry_new_with_max_length(100);
#ifndef GTK_STABLE_VERSION
			gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), IconPathList);
#else
			gtk_container_add(GTK_CONTAINER(scrolledwin), IconPathList);
#endif
			gtk_table_attach_defaults( GTK_TABLE(littletable), scrolledwin, 0, 14, 0, 9);

			button = gtk_button_new_with_label(" Remove ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(remove_item), (gpointer *) IconPathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 0, 6, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);


			hbox = gtk_hbox_new(TRUE, 0);

			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(up)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_up), (gpointer *) IconPathList);
			gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);


			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(down)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_down), (gpointer *) IconPathList);
			gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, TRUE, 0);

			gtk_table_attach( GTK_TABLE(littletable), hbox, 6, 8, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);


			button = gtk_button_new_with_label("    Add     ");
			gtk_table_attach( GTK_TABLE(littletable), button, 8, 14, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item_set_entry_first), (gpointer *) IconPathEntry);
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item), (gpointer *) IconPathList);



			gtk_entry_set_text (GTK_ENTRY (IconPathEntry), "");
			gtk_table_attach_defaults( GTK_TABLE(littletable), IconPathEntry, 1, 13, 11, 14);

			gtk_signal_connect(GTK_OBJECT(IconPathList), "select_row",
				 GTK_SIGNAL_FUNC(item_selected), (gpointer *)IconPathEntry);

			gtk_container_add(GTK_CONTAINER(frame), littletable);
			gtk_table_attach_defaults( GTK_TABLE(Parent[1]), frame, 0, 1, 0, 1);

		}


		/* The pixmap page */
		{

			Parent[2] =  gtk_table_new(1, 1, TRUE);
			frame = gtk_frame_new(pages[2]);
			littletable =  gtk_table_new(14, 14, TRUE);
			scrolledwin = gtk_scrolled_window_new (NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
				GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);

			PixmapPathEntry = gtk_entry_new_with_max_length(100);
			gtk_entry_set_text (GTK_ENTRY (PixmapPathEntry), "");

			PIXMAPPATHLIST = PixmapPathList = gtk_clist_new(1);
			gtk_signal_connect(GTK_OBJECT(PixmapPathList), "select_row",
				 GTK_SIGNAL_FUNC(item_selected), (gpointer *)PixmapPathEntry);


#ifndef GTK_STABLE_VERSION
			gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), PixmapPathList);
#else
			gtk_container_add(GTK_CONTAINER(scrolledwin), PixmapPathList);
#endif
			gtk_table_attach_defaults( GTK_TABLE(littletable), scrolledwin, 0, 14, 0, 9);

			button = gtk_button_new_with_label(" Remove ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				 GTK_SIGNAL_FUNC(remove_item), (gpointer *) PixmapPathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 0, 6, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);



			hbox = gtk_hbox_new(TRUE, 0);

			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(up)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_up), (gpointer *) PixmapPathList);
			gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);


			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(down)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_down), (gpointer *) PixmapPathList);
			gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, TRUE, 0);

			gtk_table_attach( GTK_TABLE(littletable), hbox, 6, 8, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);

			button = gtk_button_new_with_label("    Add     ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				 GTK_SIGNAL_FUNC(add_item_set_entry_first), (gpointer *) PixmapPathEntry);
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				 GTK_SIGNAL_FUNC(add_item), (gpointer *) PixmapPathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 8, 14, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);

			gtk_table_attach_defaults( GTK_TABLE(littletable), PixmapPathEntry, 1, 13, 11, 14);

			gtk_container_add(GTK_CONTAINER(frame), littletable);
			gtk_table_attach_defaults( GTK_TABLE(Parent[2]), frame, 0, 1, 0, 1);
			

		}


		/* The script page */
		{

			Parent[3] =  gtk_table_new(1, 1, TRUE);

			frame = gtk_frame_new(pages[3]);
			littletable =  gtk_table_new(14, 14, TRUE);
			scrolledwin = gtk_scrolled_window_new (NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),
				GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);

			ScriptPathEntry = gtk_entry_new_with_max_length(100);
			gtk_entry_set_text (GTK_ENTRY (ScriptPathEntry), "");

			ScriptPathList = gtk_clist_new(1);
			gtk_signal_connect(GTK_OBJECT(ScriptPathList), "select_row",
				 GTK_SIGNAL_FUNC(item_selected), (gpointer *) ScriptPathEntry);

#ifndef GTK_STABLE_VERSION
			gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwin), ScriptPathList);
#else
			gtk_container_add(GTK_CONTAINER(scrolledwin), ScriptPathList);
#endif
			gtk_table_attach_defaults( GTK_TABLE(littletable), scrolledwin, 0, 14, 0, 9);

			button = gtk_button_new_with_label(" Remove ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(remove_item), (gpointer *) ScriptPathList);

			gtk_table_attach( GTK_TABLE(littletable), button, 0, 6, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);



			hbox = gtk_hbox_new(TRUE, 0);

			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(up)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_up), (gpointer *) ScriptPathList);
			gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);


			button = gtk_button_new();
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(down)));
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(move_item_down), (gpointer *) ScriptPathList);
			gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, TRUE, 0);

			gtk_table_attach( GTK_TABLE(littletable), hbox, 6, 8, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);

			button = gtk_button_new_with_label("    Add     ");
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item_set_entry_first), (gpointer *) ScriptPathEntry);
			gtk_signal_connect(GTK_OBJECT(button), "clicked", 
				GTK_SIGNAL_FUNC(add_item), (gpointer *) ScriptPathList);
			gtk_table_attach( GTK_TABLE(littletable), button, 8, 14, 9, 12,
				GTK_SHRINK, GTK_SHRINK, 0, 0);

				
			gtk_table_attach_defaults( GTK_TABLE(littletable), ScriptPathEntry, 1, 13, 11, 14);

			gtk_container_add(GTK_CONTAINER(frame), littletable);
			gtk_table_attach_defaults( GTK_TABLE(Parent[3]), frame, 0, 1, 0, 1);

		}


		/* The virtual desktop page */
		{
			GtkWidget *button;
			GtkWidget *ctable;
			GtkWidget *cframe;
			GtkAdjustment *adj;
			GtkSpinButton *spin;
			GtkWidget *label;

			Parent[4] =  gtk_table_new(1, 1, TRUE);

			frame = gtk_frame_new(pages[4]);
			littletable =  gtk_table_new(13, 14, TRUE);


			cframe = gtk_frame_new(NULL);
			ctable = gtk_table_new(14, 14, TRUE);

			label = gtk_label_new("Desktop Size");
			gtk_table_attach_defaults( GTK_TABLE(ctable), label, 0, 14, 0, 4);

			/* DesktopSize (X) */
			adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, 4, 1, 0, 0);
			DesktopSizeSpinnerX = gtk_spin_button_new (adj, 1, 0);
			spin = GTK_SPIN_BUTTON(DesktopSizeSpinnerX);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopSizeSpinnerX), 2);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(whhoriz)));

			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 1, 4, 6, 9);
			gtk_table_attach_defaults(GTK_TABLE(ctable), DesktopSizeSpinnerX, 1, 5, 10, 13);
			
			/* ------ */


			/* DesktopSize (Y) */
			adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, 4, 1, 0, 0);
			DesktopSizeSpinnerY = gtk_spin_button_new (adj, 1, 0);
			spin = GTK_SPIN_BUTTON(DesktopSizeSpinnerY);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopSizeSpinnerY), 2);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			button = gtk_button_new();
			gtk_widget_set_sensitive(button, FALSE);
			gtk_container_add (GTK_CONTAINER (button),
				GTK_WIDGET(ascp_make_pixmap_from_data(whvert)));
			gtk_table_attach_defaults(GTK_TABLE(ctable), button, 10, 12, 6, 9);
			gtk_table_attach_defaults(GTK_TABLE(ctable), DesktopSizeSpinnerY, 10, 14, 10, 13);


			label = gtk_label_new("X");
			gtk_table_attach_defaults(GTK_TABLE(ctable), label, 6, 8, 10, 13);

			gtk_container_add(GTK_CONTAINER(cframe), ctable);
			gtk_table_attach_defaults(GTK_TABLE(littletable), cframe, 5, 10, 6, 13);


			
			/* DesktopScale */
			label = gtk_label_new("Scale:   1/");
			adj = (GtkAdjustment *) gtk_adjustment_new (0, 4, 32, 1, 0, 0);
			DesktopScaleSpinner = gtk_spin_button_new (adj, 1, 0);
			spin = GTK_SPIN_BUTTON(DesktopScaleSpinner);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopScaleSpinner), 24);
			gtk_spin_button_set_update_policy (spin, GTK_UPDATE_ALWAYS);
			gtk_table_attach_defaults(GTK_TABLE(littletable), label, 5, 8, 2, 4);
			gtk_table_attach_defaults(GTK_TABLE(littletable), DesktopScaleSpinner, 8, 10, 2, 4);
			
			gtk_container_add(GTK_CONTAINER(frame), littletable);
			gtk_table_attach_defaults( GTK_TABLE(Parent[4]), frame, 0, 1, 0, 1);

		}


		gtk_table_attach_defaults( GTK_TABLE(tabletop), Parent[0], 1, 28, 3, 24);
		gtk_table_attach_defaults( GTK_TABLE(tabletop), Parent[1], 1, 28, 3, 24);
		gtk_table_attach_defaults( GTK_TABLE(tabletop), Parent[2], 1, 28, 3, 24);
		gtk_table_attach_defaults( GTK_TABLE(tabletop), Parent[3], 1, 28, 3, 24);
		gtk_table_attach_defaults( GTK_TABLE(tabletop), Parent[4], 1, 28, 3, 24);



	}


	parse_base(min, max);


	gtk_widget_show_all(Parent[0]);

	gtk_widget_show(tabletop);
	return tabletop;
}


static void parse_base(gfloat min, gfloat max)
{
	gfloat incr;
	gchar *buffer = (gchar*) g_malloc0(1024);
	FILE *backupfile;

	BaseFile =  g_malloc(16);

	sprintf(BaseFile, "base.%dbpp", ASCPCONFIG.bpp);

	backupfile = ascp_open_file("base.ascp", "w");
	IoFile = ascp_open_file(BaseFile, "r");

	incr = (max - min)/FILESIZE;

	ascp_update_status(NULL, "base", min);

	while (fgets(buffer, 1024, IoFile) != NULL)
	{
		char* line = buffer;

		/*      
	 	 * Show our progress per total bytes per line read.
	 	 */
		ascp_update_status(NULL, NULL, min); 
		min = ( min >= max) ? max : min + incr*strlen(buffer); 

		fputs(line, backupfile);

		for ( ; isspace(*line) ; line++);


		if( !ascp_strncasecmp(line, "ModulePath", 10) )
		{
			line += 10;
			init_and_append_entry(ModulePathList, line);
		}
		else  if( !ascp_strncasecmp(line, "IconPath", 8) )
		{
			line += 8;
			init_and_append_entry(IconPathList, line);
		}
		else  if( !ascp_strncasecmp(line, "PixmapPath", 10) )
		{
			line += 10;
			init_and_append_entry(PixmapPathList, line);
		}
		else  if( !ascp_strncasecmp(line, "*ScriptPath", 11) )
		{
			line += 11;
			init_and_append_entry(ScriptPathList, line);
		}
		
		else  if( !ascp_strncasecmp(line, "DeskTopSize", 11) )
		{
			
			gchar *size = g_malloc(16);
			
			sscanf(line + 11, "%s", size);

			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopSizeSpinnerX), (gint) size[0] - 48);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopSizeSpinnerY), (gint) size[2] - 48);

			

			g_free(size);
		}
		else  if( !ascp_strncasecmp(line, "DeskTopScale", 12) )
		{
			gint value;

			sscanf(line + 12, "%d", &value);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(DesktopScaleSpinner), value);
		}
		


	}

	g_free(buffer);
	fclose(IoFile);
	fclose(backupfile);
}

static void init_and_append_entry(GtkWidget *list, gchar *line)
{
	gchar *entry;


	/* get to first path */
	for( ; isspace(*line) ; line++)
		;


	/* break this bad boy into tokens */

	entry = strtok(line, ":");
	{
		gchar *label[] = {entry};
		gtk_clist_append (GTK_CLIST(list), label);
		//g_print("%s\n", entry);
	}

	

	while( (entry = strtok(NULL, ":")) != NULL)
	{
		gchar *label[] = {entry};
		gtk_clist_append (GTK_CLIST(list), label);
	 	//g_print("%s\n", entry);
	}

	

}


static void  choose_which_option (GtkWidget *widget, gint type)
{
	if(type == 0)
	{
		gtk_widget_show_all(Parent[0]);
		gtk_widget_hide(Parent[1]);
		gtk_widget_hide(Parent[2]);
		gtk_widget_hide(Parent[3]);
		gtk_widget_hide(Parent[4]);
	}
	else if(type == 1)
	{
		gtk_widget_show_all(Parent[1]);
		gtk_widget_hide(Parent[0]);
		gtk_widget_hide(Parent[2]);
		gtk_widget_hide(Parent[3]);
		gtk_widget_hide(Parent[4]);
	}

	else if(type == 2)
	{
		gtk_widget_show_all(Parent[2]);
		gtk_widget_hide(Parent[0]);
		gtk_widget_hide(Parent[1]);
		gtk_widget_hide(Parent[3]);
		gtk_widget_hide(Parent[4]);
	}
	else if(type == 3)
	{
		gtk_widget_show_all(Parent[3]);
		gtk_widget_hide(Parent[0]);
		gtk_widget_hide(Parent[1]);
		gtk_widget_hide(Parent[2]);
		gtk_widget_hide(Parent[4]);
	}
	else if(type == 4)
	{
		gtk_widget_show_all(Parent[4]);
		gtk_widget_hide(Parent[0]);
		gtk_widget_hide(Parent[1]);
		gtk_widget_hide(Parent[2]);
		gtk_widget_hide(Parent[3]);
	}
	
}


gint item_selected(GtkWidget   *clist, gint row, gint column,
		GdkEventButton *event, gpointer *entry)
{
	gchar *text[1] = {g_malloc0(16)};

	gtk_clist_get_text(GTK_CLIST(clist), row, column, text);

	gtk_entry_set_text(GTK_ENTRY (entry), text[0]);

	CurrentRow = row;

	/* g_free causes seg faults ?? */
	//g_free(text);
	return TRUE;
}

/* 
 * Do some minor houskeeping to set the proper entry first :-)
 */
static gint add_item_set_entry_first(GtkWidget *button, GtkWidget *entry)
{
	CurrentEntry = entry;
	return TRUE;
}

static gint add_item(GtkWidget *button, GtkWidget *clist)
{
	gchar *text[1] = {gtk_entry_get_text(GTK_ENTRY(CurrentEntry))};
	gtk_clist_append(GTK_CLIST(clist), text);

	return TRUE;
}



static gint remove_item(GtkWidget *button, GtkWidget *clist)
{
#ifndef GTK_STABLE_VERSION
	CurrentRow = GTK_CLIST (clist)->focus_row;
	gtk_clist_remove (GTK_CLIST (clist), CurrentRow);
	gtk_clist_select_row (GTK_CLIST (clist), CurrentRow, 0);
#else
	g_print("no focus_row member in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE

	return TRUE;
}


static gint move_item_up(GtkWidget *button, GtkWidget *clist)
{
#ifndef GTK_STABLE_VERSION
	gtk_clist_row_move(GTK_CLIST(clist), CurrentRow, CurrentRow-1);
	gtk_clist_select_row (GTK_CLIST (clist), CurrentRow-1, 0);
#else 
	g_print("no function \"gtk_clist_select_row\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE

	

	return TRUE;
}

static gint move_item_down(GtkWidget *button, GtkWidget *clist)
{
#ifndef GTK_STABLE_VERSION
	gtk_clist_row_move(GTK_CLIST(clist), CurrentRow, CurrentRow+1);
	gtk_clist_select_row (GTK_CLIST (clist), CurrentRow+1, 0);
#else 
	g_print("no function \"gtk_clist_select_row\" in STABLE yet\n");
#endif //  GTK_LIB_DEP_CODE

	return TRUE;
}

void ascp_write_base()
{
	gchar *buffer = g_malloc0(256);
	gint row;
	gchar *path[1] = {g_malloc0(256)};
	

	IoFile = ascp_open_file(BaseFile, "w");

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# This file was written by %s\n", ASCPVERSION);
	fprintf(IoFile, "#----------------------------------------------------------------\n\n");


	fprintf(IoFile, "#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Directories\n\n");

	row = 0;
	fprintf(IoFile, "ModulePath              ");
	buffer[0] = '\0';
	while(gtk_clist_get_text(GTK_CLIST(ModulePathList), row++, 0, path))
	{
		strcat(buffer, path[0]);
		strcat(buffer, ":");
	}
	buffer[strlen(buffer)-1] = '\n';
	fprintf(IoFile, "%s", buffer);
		

	row = 0;
	fprintf(IoFile, "IconPath              ");
	buffer[0] = '\0';
	while(gtk_clist_get_text(GTK_CLIST(IconPathList), row++, 0, path))
	{
		strcat(buffer, path[0]);
		strcat(buffer, ":");
	}
	buffer[strlen(buffer)-1] = '\n';
	fprintf(IoFile, "%s", buffer);
		

	row = 0;
	fprintf(IoFile, "PixmapPath              ");
	buffer[0] = '\0';
	while(gtk_clist_get_text(GTK_CLIST(PixmapPathList), row++, 0, path))
	{
		strcat(buffer, path[0]);
		strcat(buffer, ":");
	}
	buffer[strlen(buffer)-1] = '\n';
	fprintf(IoFile, "%s", buffer);
		
	
	row = 0;
	fprintf(IoFile, "*ScriptPath              ");
	buffer[0] = '\0';
	while(gtk_clist_get_text(GTK_CLIST(ScriptPathList), row++, 0, path))
	{
		strcat(buffer, path[0]);
		strcat(buffer, ":");
	}
	buffer[strlen(buffer)-1] = '\n';
	fprintf(IoFile, "%s", buffer);
	fprintf(IoFile, "\n\n");
		
	
	fprintf(IoFile, "#----------------------------------------------------------------\n");
	fprintf(IoFile, "# Virtual Desktop\n\n");
	
	fprintf(IoFile, "DeskTopSize %dx%d\n", 
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (DesktopSizeSpinnerX)),
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (DesktopSizeSpinnerY)) );

	fprintf(IoFile, "DeskTopScale %d\n", 
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (DesktopScaleSpinner)) );
	

	fprintf(IoFile, "\n\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "# And that's all ascp wrote");
	fprintf(IoFile, "\n#----------------------------------------------------------------\n");
	fprintf(IoFile, "\n\n");

	
	
	/* why does free() segsegv with *path[0]  and *buffer? */
	//g_free(buffer);
	//g_free(path);
	
	fclose(IoFile);

}



