
/*
 *  ascp: a control panel for the AfterStep window manager
 *  Copyright (C) 1998  Nwanua Elumeze
 *
 *  You may distribute under the terms of the GNU General Public
 *  License as specified in the file, COPYING.
 *
 */


/* 
 * Naming Convention:
 *  
 * global variables:  GlobalVariables;
 * local variables:  localvariables;
 * application wide global variables:  APPWIDEGLOBVAR;
 *
 * local functions : regular_functions; 
 * application wide functions:   ascp_foobar;
 *
 * Functions defined in this file can be found in 
 * either gui.c or main.c only, unless the name of the
 * function contains _draw_ or _write_.
 * eg: ascp_draw_wharf() will be in wharf.c
 * and ascp_write_database() will be in database.c
 */





#ifndef ascp_h
#define ascp_h


#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <dirent.h>
#include <gtk/gtk.h>
#include <sys/stat.h>


#include "../configure.h"
#include "help.h"



#define		ASCPVERSION  "ascp-1.0.2"
#define	 	HINTICON  "ascp.xpm"

#define streq(str1, str2)        (strcmp ((str1), (str2)) == 0)

#ifndef GTK_STABLE_VERSION 

/* GTK+ Version */
#if (GTK_MAJOR_VERSION * 100 + GTK_MINOR_VERSION * 10 + GTK_MICRO_VERSION) >= 112
#define gtk_ctree_insert	gtk_ctree_insert_node
#define gtk_ctree_remove	gtk_ctree_remove_node
#define gtk_ctree_get_row_data	gtk_ctree_node_get_row_data
#define gtk_ctree_set_row_data	gtk_ctree_node_set_row_data
#define gtk_ctree_set_background	gtk_ctree_node_set_background
#define gtk_ctree_set_text	gtk_ctree_node_set_text
#endif

#endif //GTK_STABLE_VERSION



gchar 		*HOMEDIR;
GtkWidget 	*TOPLEVELWINDOW;
GtkWidget 	*BROWSERWINDOW;
GtkWidget 	*PIXMAPPATHLIST;
gint		ASCPERROR;
glong		FILESIZE;
GdkColor    *TREEBGCOLOUR;

enum {ROW, COL};
enum {SINGLE, BROWSE};

typedef struct _colorwell colorwell;

struct _colorwell {
	GtkWidget *drawingarea;
	GtkColorSelection *colorsel;
	 };



/*
 * These are to be associated with the mini pixmaps
 * in trees, etc.
 */
/*---------------------------------------*/
GdkPixmap *PIXMAP1;
GdkPixmap *PIXMAP2;
GdkPixmap *PIXMAP3;
GdkBitmap *MASK1; 
GdkBitmap *MASK2; 
GdkBitmap *MASK3; 
GdkColor  TRANSPARENT;
/*---------------------------------------*/


/* 
 * Misc. functions that are called by many for a 
 * wide variety of reasons.
 */
/*---------------------------------------*/
void ascp_init (void);
void ascp_parse (void);
void ascp_set_wm_hints(void);
void ascp_help (GtkWidget *, GtkWidget *);
gchar* ascp_strndup(const gchar*, gint);
gint ascp_strncasecmp(char *, char *, gint);
void ascp_save_all (GtkWidget *, gpointer *);
void ascp_save_page (GtkWidget *, GtkWidget *);
void ascp_update_status(gchar *, gchar *, gfloat);
void ascp_exit (GtkWidget *, GdkEvent *, gpointer *);
void ascp_error_popup(gchar *, gchar *, GtkWidget *);

/* Slot for font dialog "OK" button */
/* Muligan */
void ascp_font_dialog_ok(GtkWidget *ok_button, GtkWidget *entry);
void ascp_open_font_dialog(GtkWidget *button, GtkWidget *entry);
void ascp_file_dialog_ok ( GtkWidget *fs, GtkWidget *entry );
void ascp_open_file_dialog ( GtkWidget *button, GtkWidget *entry );
GtkWidget *ascp_color_selector_new(gchar *default_color);


GtkWidget  *ascp_make_pixmap_from_data(gchar **);
GtkWidget  *ascp_make_pixmap(gchar *, gint);


void ascp_set_background_color (GtkWidget *, GdkColor *);
void ascp_char_to_color(const gchar *, GdkColor *);
void  ascp_get_color(GtkWidget *,  gchar *);
void ascp_color_changed_cb (GtkWidget *, colorwell *);
gint ascp_area_event (GtkWidget *, GdkEvent *, gpointer *);


gint ascp_alt_menu (GtkWidget *, GdkEvent *);
//gint ascp_checkbutton_hide_show(GtkWidget *, GdkEvent *, GtkWidget *);
gint ascp_checkbutton_hide_show(GtkWidget *, GtkWidget *);
gint ascp_xpm_browser(GtkWidget *, GdkEvent *, gchar *);
gint ascp_change_xpm(GtkWidget *, GdkEvent *, gchar *);


#ifndef GTK_STABLE_VERSION
/* 
 * These functions are all related to the GtkCTree widget.
 */
/*---------------------------------------*/
void ascp_ctree_after_press (GtkCTree *, gpointer );
void ascp_ctree_after_move (GtkCTree *, GtkCTreeNode *, 
		GtkCTreeNode *, GtkCTreeNode *, gpointer );
gint ascp_ctree_button_press (GtkCTree *, GdkEventButton *, gpointer );
gint ascp_ctree_button_release (GtkCTree *, GdkEventButton *, gpointer);
void ascp_ctree_remove_selection (GtkWidget *, GtkCTree *);
/*---------------------------------------*/
#endif //GTK_STABLE_VERSION


/*
 * The general functions are related to the GtkCList Widget 
 */
/*---------------------------------------*/
void ascp_clist_remove_selection (GtkWidget *, GtkCList *);

/*---------------------------------------*/

FILE * ascp_open_file(gchar *, gchar *);
gchar * ascp_make_path(gchar *, gchar *, gchar *);


GtkWidget * ascp_draw_base (gfloat, gfloat);
GtkWidget * ascp_draw_wharf (gfloat, gfloat);
GtkWidget * ascp_draw_wharfstyle (gfloat, gfloat);
GtkWidget * ascp_draw_database(gfloat, gfloat);
GtkWidget * ascp_draw_pager (gfloat, gfloat);
GtkWidget * ascp_draw_audio(gfloat, gfloat);
GtkWidget * ascp_draw_animate (gfloat, gfloat);
GtkWidget * ascp_draw_autoexec(gfloat, gfloat);
GtkWidget * ascp_draw_winlist(gfloat, gfloat);

void  ascp_write_base(void);
void  ascp_write_wharf(void);
void  ascp_write_database(void);
void  ascp_write_pager(void);
void  ascp_write_audio(void);
void  ascp_write_animate(void);
void  ascp_write_autoexec(void);
void  ascp_write_winlist(void);



/* ascp user-configurable options */

enum {en, fr, jp, sp};

typedef struct _ascpconf ascpconf;

struct _ascpconf {
	gboolean animballoon;
	gboolean initrestart;
	gboolean rememberpage;
	gboolean offsetwithnum;

	gint lang;  /*  Try switching these two lines 8-?  */
	gint bpp;   /*  Something to do with enum {en, fr, jp, sp}; ? */  
	
	gint startpage;
	gint treelinestyle;
	gint hide; /*  Hide or simply grey out disabled configs. */
	gint wharfentryboxwide;
}; 

ascpconf ASCPCONFIG;

#endif
