/* ===========================================================================
 * AScd: the AfterStep and WindowMaker CD player
 * gui_wings.c: window handling using WINGs toolkit
 * ===========================================================================
 * Copyright (c) 1999 Denis Bourez and Rob Malda. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Denis Bourez & Rob Malda
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY DENIS BOUREZ AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL DENIS BOUREZ, ROB MALDA OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * ===========================================================================
 */

#ifdef WMK

#include <WINGs.h>

WMScreen *scr;

/* the main window */

WMWindow *win;

WMButton *b_title;

WMPopUpButton *pop, *pop2, *pop3;

WMButton *b_autoplay;
WMButton *b_autorepeat;
WMButton *b_ignoreavoid;
WMTextField *b_device;

WMSlider *b_volume;

WMButton *b_scroll;
WMButton *b_artist;
WMButton *b_upper;

WMTextField *b_cuetime;
WMTextField *b_fadestep;

WMTextField *b_minvol;
WMTextField *b_maxvol;
WMTextField *b_mutedvol;

WMButton *b_mode1;
WMButton *b_mode2;
WMButton *b_mode3;
WMButton *b_mode4;

WMButton *b_save;
WMButton *b_quit;
WMButton *b_close;
WMButton *b_about;

/* the database window */

WMWindow *dbwin;

WMTextField *db_artist;
WMTextField *db_title;
WMTextField *db_track;
WMButton *db_avoid;
WMButton *db_close;
WMButton *db_prev;
WMButton *db_next;
WMWidget *db_tlabel;

/* the 'about' window */

WMWindow *aboutwin;

/* misc */

int en_vue = FALSE;
int db_en_vue = FALSE;
int about_en_vue = FALSE;
int pistes = 0;

int db_curtrack = 1;

/*int old_track = 0;*/

void close_win(WMWidget *self, void *data) {
    WMCloseWindow(win);
    en_vue = FALSE;
    muted_volume = atoi(WMGetTextFieldText(b_mutedvol));
    min_volume = atoi(WMGetTextFieldText(b_minvol));
    max_volume = atoi(WMGetTextFieldText(b_maxvol));
    cue_time = atoi(WMGetTextFieldText(b_cuetime));
    fade_step = atoi(WMGetTextFieldText(b_fadestep));
}

void close_aboutwin(WMWidget *self, void *data) {
    WMCloseWindow(aboutwin);
    about_en_vue = FALSE;
}

void close_dbwin(WMWidget *self, void *data) {
    char txt[127];
    char txt2 [127];

    WMCloseWindow(dbwin);
    strcpy(cd->artist, WMGetTextFieldText(db_artist));
    strcpy(cd->cdname, WMGetTextFieldText(db_title));
    if (strlen(WMGetTextFieldText(db_track)) > 0) {
	cd->trk[db_curtrack - 1].songname = malloc(strlen(WMGetTextFieldText(db_track)) + 1);
	strcpy(cd->trk[db_curtrack - 1].songname, WMGetTextFieldText(db_track)); 
    }

    save();
    load();

    if (cd->artist != NULL) {
	strcpy(txt, cd->artist);
	if (strcmp(txt, "") == 0) strcpy(txt, "unknown artist");
    } else {
	strcpy(txt, "unknown artist");
    }
	    
    strcat(txt, "\n");
    
    if (cd->cdname != NULL) {
	strcpy(txt2, cd->cdname);
	if (strcmp(txt2, "") == 0) strcpy(txt2, "unknown album");
    } else {
	strcpy(txt2, "unknown album");
    }
    
    strcat(txt, txt2);
    WMSetButtonText(b_title, txt);
    
    db_en_vue = FALSE;
}

void quit_ascd(WMWidget *self, void *data) {
    exit(0);
}

void save_cb(WMWidget *self, void *data) {
    muted_volume = atoi(WMGetTextFieldText(b_mutedvol));
    min_volume = atoi(WMGetTextFieldText(b_minvol));
    max_volume = atoi(WMGetTextFieldText(b_maxvol));
    cue_time = atoi(WMGetTextFieldText(b_cuetime));
    fade_step = atoi(WMGetTextFieldText(b_fadestep));
    cd_device = WMGetTextFieldText(b_device);
    save_rc_file();
}

void track_select(WMWidget *self, void *data) {
    show_db_pos = 0;
    direct_track =  WMGetPopUpButtonSelectedItem(self) + 1;
    cd_control(DIRECTTRACK);
    old_track = 0;
    if (cur_cdmode == WM_CDM_STOPPED) cd_control(PLAY);
}

void mode1_cb(WMWidget *self, void *data) {
    if (WMGetButtonSelected(b_mode1)) {
	WMSetButtonSelected((b_mode2), FALSE);
    } else {
	WMSetButtonSelected((b_mode2), TRUE);
    }

    if (WMGetButtonSelected(b_mode1)) {
	if (WMGetButtonSelected(b_mode3)) time_mode = 0;
	else time_mode = 1;
    } else {
	if (WMGetButtonSelected(b_mode3)) time_mode = 2;
	else time_mode = 3;
    }
}

void mode2_cb(WMWidget *self, void *data) {
    if (WMGetButtonSelected(b_mode2)) {
	WMSetButtonSelected((b_mode1), FALSE);
    } else {
	WMSetButtonSelected((b_mode1), TRUE);
    }

    if (WMGetButtonSelected(b_mode1)) {
	if (WMGetButtonSelected(b_mode3)) time_mode = 0;
	else time_mode = 1;
    } else {
	if (WMGetButtonSelected(b_mode3)) time_mode = 2;
	else time_mode = 3;
    }
}

void mode3_cb(WMWidget *self, void *data) {
    if (WMGetButtonSelected(b_mode3)) {
	WMSetButtonSelected((b_mode4), FALSE);
    } else {
	WMSetButtonSelected((b_mode4), TRUE);
    }

    if (WMGetButtonSelected(b_mode1)) {
	if (WMGetButtonSelected(b_mode3)) time_mode = 0;
	else time_mode = 1;
    } else {
	if (WMGetButtonSelected(b_mode3)) time_mode = 2;
	else time_mode = 3;
    }
}

void mode4_cb(WMWidget *self, void *data) {
    if (WMGetButtonSelected(b_mode4)) {
	WMSetButtonSelected((b_mode3), FALSE);
    } else {
	WMSetButtonSelected((b_mode3), TRUE);
    }

    if (WMGetButtonSelected(b_mode1)) {
	if (WMGetButtonSelected(b_mode3)) time_mode = 0;
	else time_mode = 1;
    } else {
	if (WMGetButtonSelected(b_mode3)) time_mode = 2;
	else time_mode = 3;
    }
}

void autoplay_cb(WMWidget *self, void *data) {
    if (autoplay) autoplay = 0;
    else autoplay = 1;

    if (WMGetButtonSelected(b_mode1)) {
	if (WMGetButtonSelected(b_mode3)) time_mode = 0;
	else time_mode = 1;
    } else {
	if (WMGetButtonSelected(b_mode3)) time_mode = 2;
	else time_mode = 3;
    }
}

void autorepeat_cb(WMWidget *self, void *data) {
    if (autorepeat) autorepeat = 0;
    else autorepeat = 1;
}

void ignoreavoid_cb(WMWidget *self, void *data) {
    if (ignore_avoid) ignore_avoid = 0;
    else ignore_avoid = 1;
}

void upper_cb(WMWidget *self, void *data) {
    if (force_upper) force_upper = 0;
    else force_upper = 1;
}

void scroll_cb(WMWidget *self, void *data) {
    if (show_db) show_db = 0;
    else show_db = 1;
}

void artist_cb(WMWidget *self, void *data) {
    if (show_artist) show_artist = 0;
    else show_artist = 1;
}

void volume_cb(WMWidget *self, void *data) {
    if (cur_cdmode != WM_CDM_EJECTED) {
	volume = WMGetSliderValue(self);
	cd_volume(volume, 10, max_volume);
    }
}

/* --------------------------------------------------- */

void create_about_window(WMScreen *scr) {
    char txt[256];
    WMWidget *fr, *fr2, *fr3, *fr4;
    WMWidget *lb1, *lb2, *lb3, *lb4;
    WMWidget *infos;
    WMFont *font;

    aboutwin = WMCreateWindow(scr, "AScd-about");
    WMSetWindowCloseAction(aboutwin, close_aboutwin, NULL);
    WMSetWindowTitle(aboutwin, "Info");
    WMResizeWidget(aboutwin, 340, 100);

    lb1 = WMCreateLabel(aboutwin);
    WMResizeWidget(lb1, 35, 20);
    WMMoveWidget(lb1, 10, 10);
    font = WMBoldSystemFontOfSize(scr, 12);
    if (font) {
	WMSetLabelFont(lb1, font);
	WMReleaseFont(font);
    }
    WMSetLabelText(lb1, "AScd");

    lb2 = WMCreateLabel(aboutwin);
    WMResizeWidget(lb2, 200, 20);
    WMMoveWidget(lb2, 50, 10);
    sprintf(txt, "release %s", VERSION);
    WMSetLabelText(lb2, txt);

    lb3 = WMCreateLabel(aboutwin);
    WMResizeWidget(lb3, 280, 40);
    WMMoveWidget(lb3, 50, 30);
    font = WMSystemFontOfSize(scr, 10);
    if (font) {
	WMSetLabelFont(lb3, font);
	WMReleaseFont(font);
    }
    sprintf(txt, "(c) 1997-1999 Denis Bourez and Rob Malda\nContact: denis@rsn.fdn.fr\nURL: http://worldserver.oleane.com/rsn/ascd-en.html");
    WMSetLabelText(lb3, txt);

    lb4 = WMCreateLabel(aboutwin);
    WMResizeWidget(lb4, 280, 20);
    WMMoveWidget(lb4, 50, 70);
    font = WMSystemFontOfSize(scr, 10);
    if (font) {
	WMSetLabelFont(lb4, font);
	WMReleaseFont(font);
    }
    sprintf(txt, "Subsystems: CD Control %s + %s", cd_control_version(),  wm_libver_string());
    WMSetLabelText(lb4, txt);

    WMRealizeWidget(aboutwin);
}

void about_window(WMScreen *scr) {
    int i;
    char txt[127];

    if (! about_en_vue) {
	WMRealizeWidget(aboutwin);
	WMMapSubwidgets(aboutwin);
	WMMapWidget(aboutwin);
	about_en_vue = TRUE;
    } else {
	WMCloseWindow(aboutwin);
	about_en_vue = FALSE;
    }
}

/* --------------------------------------------------- */

void db_prev_cb(WMWidget *self, void *data) {
    char txt[127];
    char txt2 [127];

    strcpy(cd->artist, WMGetTextFieldText(db_artist));
    strcpy(cd->cdname, WMGetTextFieldText(db_title));
    if (strlen(WMGetTextFieldText(db_track)) > 0) {
	cd->trk[db_curtrack - 1].songname = malloc(strlen(WMGetTextFieldText(db_track)) + 1);
	strcpy(cd->trk[db_curtrack - 1].songname, WMGetTextFieldText(db_track));
    }
    save();
    load();

    if (db_curtrack == 1) db_curtrack = cur_ntracks;
    else db_curtrack--;
    sprintf(txt, "Tk %d:", db_curtrack);
    WMSetLabelText(db_tlabel, txt);

    if (cd->trk[db_curtrack - 1].songname != NULL) {
	sprintf(txt,  cd->trk[db_curtrack - 1].songname);
    } else {
	sprintf(txt, "");
    }
    WMSetTextFieldText(db_track, txt);

    if (cd->trk[db_curtrack - 1].avoid) {
	WMSetButtonSelected(db_avoid, TRUE);
    } else {
	WMSetButtonSelected(db_avoid, FALSE);
    }    
    
    WMRealizeWidget(dbwin);
}

void db_next_cb(WMWidget *self, void *data) {
    char txt[127];
    char txt2 [127];

    strcpy(cd->artist, WMGetTextFieldText(db_artist));
    strcpy(cd->cdname, WMGetTextFieldText(db_title));
    if (strlen(WMGetTextFieldText(db_track)) > 0) {
	cd->trk[db_curtrack - 1].songname = malloc(strlen(WMGetTextFieldText(db_track)) + 1);
	strcpy(cd->trk[db_curtrack - 1].songname, WMGetTextFieldText(db_track));
    }
    save();
    load();

    if (db_curtrack == cur_ntracks) db_curtrack = 1;
    else db_curtrack++;
    sprintf(txt, "Tk %d:", db_curtrack);
    WMSetLabelText(db_tlabel, txt);

    if (cd->trk[db_curtrack - 1].songname != NULL) {
	sprintf(txt,  cd->trk[db_curtrack - 1].songname);
    } else {
	sprintf(txt, "");
    }
    WMSetTextFieldText(db_track, txt);

    if (cd->trk[db_curtrack - 1].avoid) {
	WMSetButtonSelected(db_avoid, TRUE);
    } else {
	WMSetButtonSelected(db_avoid, FALSE);
    }
    
    WMRealizeWidget(dbwin);
}

void db_avoid_cb(WMWidget *self, void *data) {
    if (cd->trk[db_curtrack - 1].avoid) {
	cd->trk[db_curtrack - 1].avoid = 0;
    } else {
	cd->trk[db_curtrack - 1].avoid = 1;
    }
    save();
    load();
}

void create_db_window(WMScreen *scr) {
    char txt[80];
    WMWidget *fr, *fr2, *fr3, *fr4;
    WMWidget *lb1, *lb2;
    WMWidget *infos;

    dbwin = WMCreateWindow(scr, "AScd-db");
    WMSetWindowCloseAction(dbwin, close_dbwin, NULL);
    WMSetWindowTitle(dbwin, "Database edition");
    WMResizeWidget(dbwin, 340, 155);

    lb1 = WMCreateLabel(dbwin);
    WMResizeWidget(lb1, 50, 20);
    WMMoveWidget(lb1, 10, 10);
    WMSetLabelText(lb1, "Artist:");

    db_artist = WMCreateTextField(dbwin);
    WMMoveWidget(db_artist, 70, 10);
    WMResizeWidget(db_artist, 255, 20);

    lb2 = WMCreateLabel(dbwin);
    WMResizeWidget(lb2, 50, 20);
    WMMoveWidget(lb2, 10, 30);
    WMSetLabelText(lb2, "Title:");

    db_title = WMCreateTextField(dbwin);
    WMMoveWidget(db_title, 70, 30);
    WMResizeWidget(db_title, 255, 20);

    db_tlabel = WMCreateLabel(dbwin);
    WMResizeWidget(db_tlabel, 50, 20);
    WMMoveWidget(db_tlabel, 10, 70);
    sprintf(txt, "Tk %d:", db_curtrack);
    WMSetLabelText(db_tlabel, txt);

    db_track = WMCreateTextField(dbwin);
    WMMoveWidget(db_track, 70, 70);
    WMResizeWidget(db_track, 255, 20);

    db_avoid = WMCreateButton(dbwin, WBTSwitch);
    WMMoveWidget(db_avoid, 70, 95);
    WMResizeWidget(db_avoid, 235, 20);
    WMSetButtonText(db_avoid, "don't play this track");
    WMSetButtonAction(db_avoid, db_avoid_cb, NULL);

    /* --- */

    db_prev = WMCreateButton(dbwin, 0);
    WMResizeWidget(db_prev, 110, 30);
    WMMoveWidget(db_prev, 10, 120);
    WMSetButtonText(db_prev, "Previous Track");
    WMSetButtonAction(db_prev, db_prev_cb, NULL);

    db_next = WMCreateButton(dbwin, 0);
    WMResizeWidget(db_next, 110, 30);
    WMMoveWidget(db_next, 125, 120);
    WMSetButtonText(db_next, "Next Track");
    WMSetButtonAction(db_next, db_next_cb, NULL);

    db_close = WMCreateButton(dbwin, 0);
    WMResizeWidget(db_close, 50, 30);
    WMMoveWidget(db_close, 260, 120);
    WMSetButtonText(db_close, "Close");
    WMSetButtonAction(db_close, close_dbwin, NULL);

    WMRealizeWidget(dbwin);
}

void db_window(WMScreen *scr) {
    int i;
    char txt[127];

    if (! db_en_vue) {
	if (cur_cdmode == WM_CDM_EJECTED) return;

	load();
	if (cd->artist != NULL) strcpy(txt, cd->artist);
	else strcpy(txt, "");
	WMSetTextFieldText(db_artist, txt);

	if (cd->cdname != NULL) strcpy(txt, cd->cdname);
	else strcpy(txt, "");
	WMSetTextFieldText(db_title, txt);

	if (cd->trk[db_curtrack - 1].songname != NULL) {
	    sprintf(txt,  cd->trk[db_curtrack - 1].songname);
	} else {
	    sprintf(txt, "");
	}
	WMSetTextFieldText(db_track, txt);

	if (cd->trk[db_curtrack - 1].avoid) {
	    WMSetButtonSelected(db_avoid, TRUE);
	} else {
	    WMSetButtonSelected(db_avoid, FALSE);
	}

	WMRealizeWidget(dbwin);
	WMMapSubwidgets(dbwin);
	WMMapWidget(dbwin);
	db_en_vue = TRUE;
    } else {
	WMCloseWindow(dbwin);
	db_en_vue = FALSE;
    }
}

void db_cb(WMWidget *self, void *data) {
    char txt[127];
    sprintf(txt, "Tk %d:", db_curtrack);
    WMSetLabelText(db_tlabel, txt);
    /*WMRealizeWidget(dbwin);*/
    db_window(scr);
}

void about_cb(WMWidget *self, void *data) {
    about_window(scr);
}

void create_big_window(WMScreen *scr) {
    char txt[80];
    WMWidget *fr, *fr2, *fr3, *fr4, *fr5;
    WMWidget *lb1, *lb2, *lb3, *lb4, *lb5, *lb6;
    WMWidget *infos;

    win = WMCreateWindow(scr, "AScd");
    WMSetWindowCloseAction(win, close_win, NULL);
    WMSetWindowTitle(win, "AScd");
    WMResizeWidget(win, 320, 355);

    b_title = WMCreateButton(win, 0);
    WMResizeWidget(b_title, 300, 40);
    WMMoveWidget(b_title, 10, 5);
    WMSetButtonText(b_title, "1\n2");
    WMSetButtonAction(b_title, db_cb, NULL);

    pop = WMCreatePopUpButton(win);
    WMResizeWidget(pop, 300, 20);
    WMMoveWidget(pop, 10, 55);
    WMSetPopUpButtonPullsDown(pop, True);
    WMSetPopUpButtonText(pop, "Tracks");
    WMAddPopUpButtonItem(pop, "1");
    WMSetPopUpButtonAction(pop, track_select, NULL); 

    fr = WMCreateFrame(win);
    WMMoveWidget(fr, 10, 80);
    WMResizeWidget(fr, 110, 125);
    WMSetFrameTitle(fr, "Playback:");

    b_autoplay = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_autoplay, 20, 95);
    WMResizeWidget(b_autoplay, 90, 20);
    WMSetButtonText(b_autoplay, "autoplay");
    WMSetButtonAction(b_autoplay, autoplay_cb, NULL);

    b_autorepeat = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_autorepeat, 20, 115);
    WMResizeWidget(b_autorepeat, 90, 20);
    WMSetButtonText(b_autorepeat, "autorepeat");
    WMSetButtonAction(b_autorepeat, autorepeat_cb, NULL);

    b_ignoreavoid = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_ignoreavoid, 20, 135);
    WMResizeWidget(b_ignoreavoid, 90, 20);
    WMSetButtonText(b_ignoreavoid, "apply skips");
    WMSetButtonAction(b_ignoreavoid, ignoreavoid_cb, NULL);

    lb6 = WMCreateLabel(win);
    WMResizeWidget(lb6, 80, 20);
    WMMoveWidget(lb6, 20, 155);
    WMSetLabelText(lb6, "CD Device:");

    b_device = WMCreateTextField(win);
    WMResizeWidget(b_device, 85, 20);
    WMMoveWidget(b_device, 20, 175);


    fr3 = WMCreateFrame(win);
    WMMoveWidget(fr3, 130, 80);
    WMResizeWidget(fr3, 180, 125);
    WMSetFrameTitle(fr3, "Misc:");

    b_scroll = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_scroll, 140, 95);
    WMResizeWidget(b_scroll, 130, 20);
    WMSetButtonText(b_scroll, "scroll song names");
    WMSetButtonAction(b_scroll, scroll_cb, NULL);

    b_artist = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_artist, 140, 115);
    WMResizeWidget(b_artist, 130, 20);
    WMSetButtonText(b_artist, "add artist name");
    WMSetButtonAction(b_artist, artist_cb, NULL);

    b_upper = WMCreateButton(win, WBTSwitch);
    WMMoveWidget(b_upper, 140, 135);
    WMResizeWidget(b_upper, 130, 20);
    WMSetButtonText(b_upper, "force uppercase");
    WMSetButtonAction(b_upper, upper_cb, NULL);

    lb2 = WMCreateLabel(win);
    WMResizeWidget(lb2, 70, 20);
    WMMoveWidget(lb2, 140, 175);
    WMSetLabelText(lb2, "Cue Time");

    b_cuetime = WMCreateTextField(win);
    WMResizeWidget(b_cuetime, 25, 20);
    WMMoveWidget(b_cuetime, 205, 175);

    lb3 = WMCreateLabel(win);
    WMResizeWidget(lb3, 33, 20);
    WMMoveWidget(lb3, 238, 175);
    WMSetLabelText(lb3, "Fade");

    b_fadestep = WMCreateTextField(win);
    WMResizeWidget(b_fadestep, 25, 20);
    WMMoveWidget(b_fadestep, 275, 175);

    /* the volume */

    fr4 = WMCreateFrame(win);
    WMMoveWidget(fr4, 10, 210);
    WMResizeWidget(fr4, 300, 75);
    WMSetFrameTitle(fr4, "Volume:");

    lb4 = WMCreateLabel(win);
    WMResizeWidget(lb4, 35, 20);
    WMMoveWidget(lb4, 20, 230);
    WMSetLabelText(lb4, "From");

    b_minvol = WMCreateTextField(win);
    WMResizeWidget(b_minvol, 40, 20);
    WMMoveWidget(b_minvol, 60, 230);

    lb5 = WMCreateLabel(win);
    WMResizeWidget(lb5, 30, 20);
    WMMoveWidget(lb5, 103, 230);
    WMSetLabelText(lb5, "to");

    b_maxvol = WMCreateTextField(win);
    WMResizeWidget(b_maxvol, 40, 20);
    WMMoveWidget(b_maxvol, 123, 230);

    lb1 = WMCreateLabel(win);
    WMResizeWidget(lb1, 40, 20);
    WMMoveWidget(lb1, 215, 230);
    WMSetLabelText(lb1, "Muted");

    b_mutedvol = WMCreateTextField(win);
    WMResizeWidget(b_mutedvol, 40, 20);
    WMMoveWidget(b_mutedvol, 260, 230);

    b_volume = WMCreateSlider(win);
    WMResizeWidget(b_volume, 280, 16);
    WMMoveWidget(b_volume, 20, 257);
    WMSetSliderKnobThickness(b_volume, 22);
    WMSetSliderAction(b_volume, volume_cb, NULL);

    /* the counter modes */

    fr5 = WMCreateFrame(win);
    WMMoveWidget(fr5, 10, 290);
    WMResizeWidget(fr5, 190, 60);
    WMSetFrameTitle(fr5, "Counter Mode:");

    b_mode1 = WMCreateButton(win, WBTRadio);
    WMMoveWidget(b_mode1, 20, 305);
    WMResizeWidget(b_mode1, 55, 20);
    WMSetButtonText(b_mode1, "Track");
    WMSetButtonAction(b_mode1, mode1_cb, NULL);

    b_mode2 = WMCreateButton(win, WBTRadio);
    WMMoveWidget(b_mode2, 20, 325);
    WMResizeWidget(b_mode2, 55, 20);
    WMSetButtonText(b_mode2, "CD");
    WMSetButtonAction(b_mode2, mode2_cb, NULL);

    b_mode3 = WMCreateButton(win, WBTRadio);
    WMMoveWidget(b_mode3, 90, 305);
    WMResizeWidget(b_mode3, 85, 20);
    WMSetButtonText(b_mode3, "Ellapsed");
    WMSetButtonAction(b_mode3, mode3_cb, NULL);

    b_mode4 = WMCreateButton(win, WBTRadio);
    WMMoveWidget(b_mode4, 90, 325);
    WMResizeWidget(b_mode4, 85, 20);
    WMSetButtonText(b_mode4, "Remaining");
    WMSetButtonAction(b_mode4, mode4_cb, NULL);

    /* the global buttons */

    b_save = WMCreateButton(win, 0);
    WMResizeWidget(b_save, 50, 25);
    WMMoveWidget(b_save, 205, 325);
    WMSetButtonText(b_save, "Save");
    WMSetButtonAction(b_save, save_cb, NULL);

    b_about = WMCreateButton(win, 0);
    WMResizeWidget(b_about, 50, 25);
    WMMoveWidget(b_about, 205, 295);
    WMSetButtonText(b_about, "About");
    WMSetButtonAction(b_about, about_cb, NULL);

    b_save = WMCreateButton(win, 0);
    WMResizeWidget(b_save, 50, 25);
    WMMoveWidget(b_save, 260, 295);
    WMSetButtonText(b_save, "Quit");
    WMSetButtonAction(b_save, quit_ascd, NULL);

    b_close = WMCreateButton(win, 0);
    WMResizeWidget(b_close, 50, 25);
    WMMoveWidget(b_close, 260, 325);
    WMSetButtonText(b_close, "Close");
    WMSetButtonAction(b_close, close_win, NULL);

    /* finished, draw everything */

    WMRealizeWidget(win);

    /*
    WMMapSubwidgets(win);
    WMMapWidget(win);
    */

}

void update_track() {
    int i;
    char txt[127];
    char txt2[127];

    if (en_vue) {
	if (cur_cdmode != WM_CDM_EJECTED) {

	    if (cd->artist != NULL) {
		strcpy(txt, cd->artist);
		if (strcmp(txt, "") == 0) strcpy(txt, "unknown artist");
	    } else {
		strcpy(txt, "unknown artist");
	    }
	    
	    strcat(txt, "\n");

	    if (cd->cdname != NULL) {
		strcpy(txt2, cd->cdname);
		if (strcmp(txt2, "") == 0) strcpy(txt2, "unknown album");
	    } else {
		strcpy(txt2, "unknown album");
	    }

	    strcat(txt, txt2);
	    WMSetButtonText(b_title, txt);

	    for (i = WMGetPopUpButtonNumberOfItems(pop); i >= 0; i --) {
		WMRemovePopUpButtonItem(pop, i);
	    }

	    for (i = 0; i < cur_ntracks; i++) {
		sprintf(txt, "%2d ", i + 1);
		if (cd->trk[i].songname != NULL) strcat(txt,  cd->trk[i].songname);
		WMAddPopUpButtonItem(pop, txt);
	    }

	pistes = cur_ntracks;

	if (cd->trk[cur_track - 1].songname != NULL) {
	    sprintf(txt, "%s", cd->trk[cur_track - 1].songname);
	    if (strcmp(txt, "") == 0) sprintf(txt, "Track %d", cur_track);
	    WMSetPopUpButtonText(pop, txt);
	} else {
	    sprintf(txt, "Track %d", cur_track);
	    WMSetPopUpButtonText(pop, txt);
	}

	}
    }
}

void big_window(WMScreen *scr) {
    int i;
    char txt[127];
    char txt2[127];

    if (! en_vue) {

	if (cur_cdmode == WM_CDM_EJECTED) return;

	sprintf(txt, "%d", cue_time);
	WMSetTextFieldText(b_cuetime, txt);
	sprintf(txt, "%d", fade_step);
	WMSetTextFieldText(b_fadestep, txt);
	sprintf(txt, "%d", min_volume);
	WMSetTextFieldText(b_minvol, txt);
	sprintf(txt, "%d", max_volume);
	WMSetTextFieldText(b_maxvol, txt);
	sprintf(txt, "%d", muted_volume);
	WMSetTextFieldText(b_mutedvol, txt);

	WMSetTextFieldText(b_device, cd_device);
	
	WMSetSliderMinValue(b_volume, min_volume);
	WMSetSliderMaxValue(b_volume, max_volume);
	WMSetSliderValue(b_volume, volume);

	for (i = WMGetPopUpButtonNumberOfItems(pop); i >= 0; i --) {
	    WMRemovePopUpButtonItem(pop, i);
	}


	if (cd->artist != NULL) {
	    strcpy(txt, cd->artist);
	    if (strcmp(txt, "") == 0) strcpy(txt, "unknown artist");
	} else {
	    strcpy(txt, "unknown artist");
	}
	
	strcat(txt, "\n");
	
	if (cd->cdname != NULL) {
	    strcpy(txt2, cd->cdname);
	    if (strcmp(txt2, "") == 0) strcpy(txt2, "unknown album");
	} else {
	    strcpy(txt2, "unknown album");
	}
	
	strcat(txt, txt2);
	WMSetButtonText(b_title, txt);
	
	for (i = 0; i < cur_ntracks; i++) {
	    sprintf(txt, "%2d ", i + 1);
	    if (cd->trk[i].songname != NULL) strcat(txt,  cd->trk[i].songname);
	    WMAddPopUpButtonItem(pop, txt);
	}
	
	if (cd->trk[cur_track - 1].songname != NULL) {
	    sprintf(txt, "%s", cd->trk[cur_track - 1].songname);
	    if (strcmp(txt, "") == 0) sprintf(txt, "Track %d", cur_track);
	    WMSetPopUpButtonText(pop, txt);
	} else {
	    sprintf(txt, "Track %d", cur_track);
	    WMSetPopUpButtonText(pop, txt);
	}

	pistes = cur_ntracks;

	if (autoplay) {
	    WMSetButtonSelected(b_autoplay, TRUE);
	} else {
	    WMSetButtonSelected(b_autoplay, FALSE);
	}

	if (autorepeat) {
	    WMSetButtonSelected(b_autorepeat, TRUE);
	} else {
	    WMSetButtonSelected(b_autorepeat, FALSE);
	}

	if (show_db) {
	    WMSetButtonSelected(b_scroll, TRUE);
	} else {
	    WMSetButtonSelected(b_scroll, FALSE);
	}

	if (show_artist) {
	    WMSetButtonSelected(b_artist, TRUE);
	} else {
	    WMSetButtonSelected(b_artist, FALSE);
	}

	if (ignore_avoid) {
	    WMSetButtonSelected(b_ignoreavoid, FALSE);
	} else {
	    WMSetButtonSelected(b_ignoreavoid, TRUE);
	}

	if (force_upper) {
	    WMSetButtonSelected(b_upper, TRUE);
	} else {
	    WMSetButtonSelected(b_upper, FALSE);
	}

	switch(time_mode) {
	case 0:
	    WMSetButtonSelected((b_mode1), TRUE);
	    WMSetButtonSelected((b_mode2), FALSE);
	    WMSetButtonSelected((b_mode3), TRUE);
	    WMSetButtonSelected((b_mode4), FALSE);
	    break;
	case 1:
	    WMSetButtonSelected((b_mode1), TRUE);
	    WMSetButtonSelected((b_mode2), FALSE);
	    WMSetButtonSelected((b_mode4), TRUE);
	    WMSetButtonSelected((b_mode3), FALSE);
	    break;
	case 2:
	    WMSetButtonSelected((b_mode2), TRUE);
	    WMSetButtonSelected((b_mode1), FALSE);
	    WMSetButtonSelected((b_mode3), TRUE);
	    WMSetButtonSelected((b_mode4), FALSE);
	    break;
	default:
	    WMSetButtonSelected((b_mode2), TRUE);
	    WMSetButtonSelected((b_mode1), FALSE);
	    WMSetButtonSelected((b_mode4), TRUE);
	    WMSetButtonSelected((b_mode3), FALSE);
	    break;
	}

	WMRealizeWidget(win);
	WMMapSubwidgets(win);
	WMMapWidget(win);

	en_vue = TRUE;
    } else {
	WMCloseWindow(win);
	muted_volume = atoi(WMGetTextFieldText(b_mutedvol));
	min_volume = atoi(WMGetTextFieldText(b_minvol));
	max_volume = atoi(WMGetTextFieldText(b_maxvol));
	cue_time = atoi(WMGetTextFieldText(b_cuetime));
	fade_step = atoi(WMGetTextFieldText(b_fadestep));
	en_vue = FALSE;
    }
}

#endif
