.TH asapm 1 "25 Nov 1999" "Version 2.8"
.UC
.SH NAME
\fBasapm\fP \- the AfterStep APM monitor
.SH SYNOPSIS
.B asapm
[-h] [-H] [-V]
        [-rc \fIresource file\fP]
        [-iconic] [-withdrawn] [-standout]
        [-position \fI[+|-]x[+|-]y\fP]
        [-syslevels] [-systime]
        [-dev \fIdevice\fP] [-fail]
        [-u \fIupdate rate\fP]
        [-display \fIdisplay\fP]
        [-status \fIcolor\fP]
        [-green \fIcolor\fP]
        [-yellow \fIcolor\fP]
        [-red \fIcolor\fP]
        [-lower \fIcolor\fP]
        [-upper \fIcolor\fP]
.SH DESCRIPTION
The \fBasapm\fP is a X11 application that acts as
an Advanced Power Management system
monitor for laptop and notebook PCs running Linux, FreeBSD, or NetBSD.
The \fBasapm\fP provides a distinctive Afterstep
window manager look and feel and features multiple
options to allow the customization.

Basically, the tool shows you the following:
.PP
- The bar-like indicator of the charge left in the battery
  which appears on the left side and is battery-shaped.
  The bottom part shows the charge left in the battery.
  The colors may be customized.
.PP
- The top line works as a pair of indicators. You see 
  there a battery outline which is "green" when the 
  battery status is high, "yellow" when the battery status 
  is low, and "red" when the battery status is critical. 
  The colors may be customized. The definition of the 
  high, low, critical status may be mine :-) or APM 
  daemon's - you can choose.  The AC plug outline is black 
  while you run the computer on the battery and it turns 
  "green" when your computer is connected to the mains.
  The plug will turn red while the battery is charging
  and return back to green when the battery is full.
.PP
- The second line is the charge left in the battery in 
  percent. If the APM daemon does not return a good value 
  for it, the display is disabled.
.PP
- The third line is the estimate of the time left before 
  the complete discharge of the battery. This estimate is 
  either provided by the APM daemon or is calculated by 
  this tool itself. When there is no estimate available 
  the display is disabled.

Not all APM systems support the estimation of the 
lifetime of the battery. If it is supported it is
shown. Otherwise the \fBasapm\fP tool will try to
do its best to estimate the time by itself. This will
work only when the computer is running on the battery.
If the computer is connected to the mains the display
is disabled. When the \fBasapm\fP starts in such a situation, it 
will disable the display for the time until the first change
in the battery charge is detected. Then the tool
will calculate the elapsed time and try to predict
how long it will take before the battery goes flat.
The value displayed is \fInot\fP precise so don't rely
too much on this. And if you do not like it you can
switch it off with the -systime option.

The resource files may specify some of the command-line
options. The logic of \fBasapm\fP is simple: first it parses 
the resource file at the default location (~/.asapmrc)
if it exists and then goes to parse the command line parsing.
Therefore any options on the command line override the
corresponding options in the resource file. Unfortunately
there is no complete correspondence between what you can
specify on the command line and in the configuration file.
When one of the parameters on the command line is -rc which
specifies an alternative location for the resource file,
\fBasapm\fP resets all options and goes to parse that resource
file. After parsing it, \fBasapm\fP returns and re-parses 
the command line.

.SH CONFIGURATION OPTIONS
.IP "-h or -H"
.RS
prints a short description and usage message.
.RE
.IP "-V"
.RS
Version control. Prints out the version of the program.
.RE
.IP "-rc resource file"
.RS
Specifies the alternative location for the resource file.
The default location is ~/.asapmrc. If the alternative
file is specified, the default location is parsed first,
then the defaults are restored for everything except
the reactions and the alternative file is read. I know this
is weird - care to change?
.RE
.IP "-position [+|-]x[+|-]y"
.RS
Displays the window at the specified location
on the screen. This works as standard X Windows
geometry option.
.RE
.IP "-iconic"
.RS
Starts the \fBasapm\fP application in the iconized mode.
The icon has the same appearance with the main
window.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
.RE
.IP "-withdrawn"
.RS
Starts the \fBasapm\fP application in the withdrawn mode.
This option is necessary to be able to dock the
\fBasapm\fP in the WindowMaker dock.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
\fBasapm\fP ignores the -iconic option when started
in withdrawn mode.
.RE
.IP "-standout"
.RS
This changes the appearance of the \fBasapm\fP display from
"pushed-in" to "popped-out". The first is the default look.
The "popped-out" look is also a bit darker then the "pushed-in"
and according to some looks much better in WindowMaker's dock.
Give it a try in any case.
.RE
.IP "-syslevels"
.RS
This will make \fBasapm\fP to pay attention to what the
APM daemon says about high/low/critical state of the 
battery and reflect those levels by changing the labels
to the appropriate color. 

By default, \fBasapm\fP would consider levels of power
below 40% as low and below 20% as critical because I
personally like it that way :-). I want to notice well
in advance that the power is running low and not only
when the APM daemon starts \fIwall\fP'ing you about it.
On my machine I get beeps, the hardware battery indicator
starts flashing and APM daemon sends messages to all
windows when the power status changes to "low".
You know, all the bells and whistles are on and now
you want the tool to change the indicator to yellow.
What's the point? Anyway, if you really want it -
this is the option.

There is a good application to this option though. When
APM reports the status of the battery being something
inconsistent with the percent charge reported you may
use it to get a better picture of what is going on.
I can imagine that by some glitch APM reports the charge
of the battery 100% but the battery state being critical.
Then this option will allow \fBasapm\fP to reflect this
status. It may be possible that your APM does not report
the charge percentage but does report the status of the
battery too. This option allows you to see the status
of the battery again.
.RE
.IP "-systime"
.RS
Some APM daemons/BIOSes do not supply the time left
until the complete discharge of the battery. Mine is
one of those. By default, \fBasapm\fP detects that
the APM daemon does not return a good value and tries
to estimate the time itself. It is an estimation based
on the time that passed between the two last changes
of the power status. 

You can use this option to make \fBasapm\fP use the 
time only if it is supplied by the daemon and not 
attempt any calculations itself.
The display for the time left will be disabled all 
the time if the feature is not supported
by the daemon then.

This option does not change the behaviour of \fBasapm\fP
if the APM daemon and BIOS support the notion of time
left until the complete discharge of the battery.
.RE
.IP "-dev <device>"
.RS
Using this option you can specify the location of the file
that serves the APM information on your system. The default
location of the APM device on Linux systems is /proc/apm
and on FreeBSD and NetBSD systems it is /dev/apm device.
.RE
.IP "-fail"
.RS
By default \fBasapm\fP does not quit if an error happens
during reading the APM device file. It prints a warning
and continues. Most of the time all display parts will
be disabled too. This option tells \fBasapm\fP to quit
immediately if an error was encountered. I recommend 
specifying this option when you run from AfterStep Wharf
because the output of \fBasapm\fP can fill up your log
file if troubles happen and you probably want notice it.

However, if you experience occasional glitches in the
working of APM daemon (unheard of) or you want to see
what APM looks like while not having APM on your machine
this option will help.
.RE
.IP "-u <update rate>"
.RS
Changes the polling rate for accessing the APM
data.
The update rate is specified in seconds. The value
of 1 is the minimum. Default value is 1 second.
.RE
.IP "-status <color>"
.RS
Changes the color of the time-left and percentile
indicators for asapm.  The default color is also
LightSeaGreen.
.RE
.IP "-green <color>"
.RS
Changes the color of the "green" image of the
battery and power plug when those are in "green"
condition. By default the "green" condition is
when the charge of the battery is above 40%.
The default color is LightSeaGreen.
.RE
.IP "-yellow <color>"
.RS
Changes the color of the "yellow" image of the
battery. The "yellow" image corresponds to low
charge left state and by default is
when the charge of the battery is
above 20% but below 40%. The default is DarkGold.
.RE
.IP "-red <color>"
.RS
Changes the color of the "red" image of the
battery. The "red" image corresponds to critical
battery charge state and by default is
when the charge of the battery is
below 20%. The default is a kind of red.
.RE
.IP "-lower <color>"
.RS
Changes the color of the bottom side of the indicator
that indicates the battery charge left. The indicator
is the battery-shaped image on the left. The default 
is a kind of blue.
.RE
.IP "-upper <color>"
.RS
Changes the color of the top side of the battery indicator
that indicates, well, you know, the used up part
of the battery charge.  The default is a kind of red.
.RE
.IP "-display <name>"
.RS
The name of the display to start the window in.
It works just as X Windows display option.
.RE
.SH RESOURCE FILE SYNTAX
.IP "fail"
.RS
Force the tool to quit when an error is detected while
accessing the APM device. Equivalent to the command line
"-fail" option.
.RE
.IP "nofail"
.RS
The opposite of "fail". This is the default behaviour.
.RE
.IP "device <name>"
.RS
Use the alternative APM device to read the information.
Equivalent to the "-dev" command-line option.
.RE
.IP "SysLevels"
.RS
Use the information the APM daemon provides concerning
the level of the power being high/low/critical. Equivalent
to the "-syslevels" command line option.
.RE
.IP "NoSysLevels"
.RS
Use my own definition of the low/critical levels of power
as being less or equal to 40%/20% respectively.
.RE
.IP "SysTime"
.RS
Don't attempt to calculate the time to live for the battery
even if the APM daemon does not supply any value. Equivalent
to the -systime command line option.
.RE
.IP "NoSysTime"
.RS
Opposite of "SysTime". Calculate our own values for the remaining
time on the battery power when APM daemon does not supply any
value.
.RE
.IP "ColorDepth 8/16"
.RS
Force the given color depth. Specify 16 or 8. \fBasapm\fP does
automagically detect the display's color depth and will run in
the correct mode but this is handy if you want to force it run
with different look than the default for your color depth.
\fBasapm\fP uses more than 32 colors in 16bpp and around 12
in 8bpp. This is the equivalent of the command line "-bpp"
option.
.RE
.IP "ACOn <command>"
.RS
Execute the given command when the APM daemon reports the AC
power being switched on. You may want to execute here things that
make your computer consume more power.
.RE
.IP "ACOff <command>"
.RS
Execute the specified command when the APM daemon says the AC
was switched off (= we are running on some kind of battery).
You may want to execute commands here that make your computer
more power-conscious and save some power.
.RE
.IP "PowerDown <command>"
.RS
This command is executed every time the battery power level
decreases. Nothing really useful.
.RE
.IP "PowerUp <command>"
.RS
This command is executed every time the battery power level
increases. Not really useful.
.RE
.IP "DownTo <percent> <command>"
.RS
Execute the given command when the power level drops to the
given level. The level must be exact, the command is not executed
on the "lower or equal" basis. This is the option I wanted.
I make it suspend my computer when the power drops to 10%.
Now I can forget to switch it off ;-)
These commands may be given multiple times in the rc file.
.RE
.IP "UpTo <percent> <command>"
.RS
Executes the command when the power level reaches up to the
given level. I cannot think of any useful application for this.
These commands may be given multiple times in the rc file.
.RE
.IP "Status <color>"
.RS
The color for the time-left and percentile indicators for
battery strength.  The equivalent of the "-status" command
line option.
.RE
.IP "Green <color>"
.RS
The color for the battery symbol when the power level is
reasonably high.  The equivalent of the "-green" command
line option.
.RE
.IP "Yellow <color>"
.RS
The color for the battery symbol when the power level is low.
The equivalent of the "-yellow" command line option.
.RE
.IP "Red <color>"
.RS
The color for the battery symbol when the power level is critical.
The equivalent of the "-red" command line option.
.RE
.IP "Lower <color>"
.RS
The color for the power left indicator. This is the equivalent
of the "-lower" command line option.
.RE
.IP "Upper <color>"
.RS
The color for the "empty" part of the battery indicator. This
is the equivalent for the "-upper" command line option.
.RE
.SH INVOCATION
\fBasapm\fP can be called in different ways.  The most 
common invocation is the command line:
.nf

	user@host[1]% asapm -u 2 -left green -right yellow &

.fi
Another way to call \fBasapm\fP is from the window manager:
.nf

	*Wharf "asapm" nil Swallow "asapm" /usr/local/bin/asapm -fail &

.fi
This line, when placed in the \fIwharf\fP file in the users Afterstep
configuration directory will cause \fBasapm\fP to be a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

If you run WindowMaker then you should use the "-withdrawn"
option:
.nf

	user@host[1]% asapm -withdrawn -standout &

.fi
and then drag the icon to the dock.
.SH BUGS
My programs do not have bugs, they just develop random
features ;-)
.PP
Well, there are limitations. All the strings for the
color names, display name, and the geometry have the
length limit of 50 characters (terminating zero included). 
The string copying routine cuts the names that are longer.
The limit on the APM device name is 256 characters.
.PP
The number of hours I can show for the lifetime of the battery
left is limited by the space. The maximum is 99:59 and that is
what it shows when the time left is even more. I doubt that
you have a battery that survives longer though :-)
.PP
The total number of reactions specified with the "UpTo" and "DownTo"
resource file switches is limited to ten.
.SH FILES
.I /proc/apm /dev/apm
.SH "SEE ALSO"
.BR apm (1), apmd (8)
.SH COPYRIGHTS
Copyright (c) 1998-99  Albert Dorofeev <Albert@mail.dma.be>

Distributed under GNU General Public License v2 ; 
see LICENSE file for more informations.
.SH AUTHORS
Albert "Tigr" Dorofeev <Albert@mail.dma.be>

See the README file for credits.
.sp
