#!/usr/bin/perl
require 5.004;
use strict;

# These are the only two variables that might (read: shouldnt) need to be configured
# IN the script.  The rest of the configuration should be done in your ~/.asDrinksrc

my $startdir = "$ENV{\"HOME\"}/GNUstep/Library/AfterStep/start/";
my $tempfile = "$ENV{\"HOME\"}/.tempasDrinksfile";

my %config;
my $config = "$ENV{HOME}/.asDrinksrc";
open(CONFIG, $config);

 while (<CONFIG>) {
        chomp;
        next if /^\s*\#/;
        next unless /=/;
        my ($key, $value) = split(/=/, $_, 2);
        $value =~ s/(\$(\w+))/$config{$2}/g;

        $config{$key} = $value;
            }
close(CONFIG);


my $viewer = $config{viewer};
my $netscape = $config{netscape};
my $lynx = $config{lynx};
my $drinksdir = $config{asDrinks_directory};
my $ltdir = $config{linuxtoday_directory};
my $slashdir = $config{slashdot_directory};
my $fmdir = $config{freshmeat_directory};
my $segdir = $config{segfault_directory};
my $tunedir = $config{tuneup_directory};
my $appsdir = $config{linuxapps_directory};
my @which = ($config{slashdot},$config{freshmeat},$config{segfault},$config{linuxtoday},$config{userfriendly},$config{tuneup},$config{linuxapps});
my $ufieimage = $config{ufie_image};
my $bindir = $config{bin_directory};
my $update = $config{update};


#############################################################################
# Variables

my ($pattern, $symbol, $fromstart, $fromend, $mini, $asv1, $asv2, $startline, $length, $urlline, $topicline, $argument, $file, $start, $adder, $end, $count, $temp, @letters, $dir, $kick, $i, $buffer, $remote, $flag, $line, $num, $version, $as_version, $title, $url, $fmflag);

@letters = qw(a b c d e f g h i j k l m n o p q r s t);
$kick = '\n\n';
$i = 0;
$version = "1.9.3";

#############################################################################




#############################################################################
# Actual start of the script.

# First, get command line args (like --slash)

sub print_usage {
  warn "\nasDrinks $version:  Usage:\n
	--slash         Get Slashdot headlines.
	--fm            Get Freshmeat headlines.
	--seg           Get Segfault headlines.
	--lt            Get Linux Today headlines.
	--uf		Get User Friendly comic.
	--tuneup 	Get linux.com Tuneup tips.
	--apps		Get LinuxApps headlines.

	--news          Only get news (no comics).
	--noupdate      Get news, but don't update the startmenu.
	--none          Don't get any news, just update the startmenu.
	--help          Display this.\n";
 die "\n";
}

if (scalar(@ARGV > 9)) {
  warn "Incorrect number of arguments, $ARGV\n";
  print_usage();
}


# Determine what the person asked for
# This is, by far, the worst piece of perl ive EVER seen

if (scalar(@ARGV) == 1) {
 ($argument) = @ARGV;
 if ($argument eq '--noupdate') {
	$i = 1;
 } if ($argument eq '--none') {
	update_menu($as_version, $bindir, $temp);
 } 
}

if (scalar(@ARGV) >= 1 && $i != 1) {
	blank();
}
$i = 0;

while (scalar(@ARGV) >= 1) {
	$argument = shift(@ARGV);
	if ($argument eq '--help') {
		print_usage();	
	} elsif ($argument eq '--slash') {
		$which[0] = (1);
	} elsif ($argument eq '--fm') {
    		$which[1] = (1);
	} elsif ($argument eq '--seg') {
    		$which[2] = (1);
	} elsif ($argument eq '--lt') {
    		$which[3] = (1);
	} elsif ($argument eq '--uf') {
    		$which[4] = (1);
	} elsif ($argument eq '--tune') {
		$which[5] = (1);
	} elsif ($argument eq '--apps') {
		$which[6] = (1);
	} elsif ($argument eq '--news') {
    		$which[0] = (1);
    		$which[1] = (1);
    		$which[2] = (1);
    		$which[3] = (1);
		$which[5] = (1);
		$which[6] = (1);
	} elsif ($argument eq '--noupdate') {
		$update = 0;
	} elsif ($argument eq '--none') {
		print_usage();
	} else {
		print_usage();
	}
}

# Get the news.

if ($which[0] == 1) {
 print "Getting Slashdot headlines.\n";
 slashdot();
}
if ($which[1] == 1) {
 print "Getting Freshmeat headlines.\n";
 freshmeat();
}
if ($which[2] == 1) {
 print "Getting Segfault headlines.\n";
 segfault();
}
if ($which[3] == 1) {
 print "Getting Linux Today headlines.\n";
 linuxtoday();
}
if ($which[5] == 1) {
 print "Getting linux.com Tuneup tips.\n";
 tuneup();
}
if ($which[6] == 1) {
 print "Getting LinuxApps headlines.\n";
 linuxapps();
}

# not yet *grin*
#
#if ($which[7] == 1) {
# print "Getting After-Y2k comic.\n";
#y2k();
#}

if ($which[4] == 1) {
 print "Getting User Friendly Comic.\n";
 uf();
}
  

# Update the menu, maybe

if ($update == 1) {
 update_menu($as_version, $bindir, $temp);
}

unlink("$tempfile");
exit;

#############################################################################


#############################################################################
# Many thanks to Dagmar for help here

sub uf {
 $dir = "$startdir$drinksdir";
 checkdir($dir);
 $mini = "mini-ufie.xpm";
 my ($image, $imagetag);
 $imagetag = 0;
 open(INFILE, "$lynx -source http://www.userfriendly.org/static/|");
 while (<INFILE>) {
  next if $image;


  if (/.*(IMG ALT\=\"Latest Strip\" width\=576 BORDER\=0 SRC\=\"http:\/\/www.userfriendly.org\/cartoons\/archives\/.+<\/A>).*/) {
   $imagetag = $1;
   if ($imagetag =~ /.* ALT\s*=\s*"Latest Strip" .*/i) {
    if ($imagetag =~ /.*(\/cartoons\/archives\/.+f).*/i) {
     $image = $1;
     $image =~ s/xuf/uf/;
     system("$lynx -source http://www.userfriendly.org$image > $ufieimage");
    }
   }
  }
 }
    close(INFILE); 
    open (OUTFILE, ">zzuf"); 
   	 print OUTFILE "Exec \"Latest U.F.\" exec $viewer $ufieimage &\nMiniPixmap \"$mini\"\n";
    close(OUTFILE);
    rename("zzuf","$startdir$drinksdir/zzuf");

 return;
}

#
#############################################################################



#############################################################################

sub linuxtoday {
 $start = -2;
 $adder = 4;
 $end = 12;
 $startline = 5;
 $length = 5;
 $urlline = 3;
 $topicline = 2;
 $dir = $startdir.$drinksdir.$ltdir; 
 $remote = 'linuxtoday.com';
 $file = "/lthead.txt";
 $mini = 'mini-lt.xpm';
 checkdir($dir);
 file_news($mini, @letters, $start, $adder, $end, $dir, $remote, $file, $startline, $length, $urlline, $topicline); 
 return;
}

#
#############################################################################


#############################################################################

sub slashdot {
 $dir = $startdir.$drinksdir.$slashdir;
 $remote = 'www.slashdot.org';
 $file = '/slashdot.xml';
 $mini = 'mini-slashdot.xpm';
 $start = 0;
 $adder = 1;
 $end = 10;
 checkdir($dir);
 stupid_slashdot_news($remote, $file, $mini, $dir, $start,  $adder, $end);
 return;
}

#
#############################################################################


#############################################################################

sub freshmeat {
 $start = -1;
 $adder = 3;
 $end = 10;
 $startline = 1;
 $length = 4;
 $urlline = 3;
 $topicline = 1;
 $fmflag =1;
 $dir = "$startdir$drinksdir$fmdir";
 $remote = 'freshmeat.net';
 $file = '/backend/recentnews.txt';
 $mini = 'mini-freshmeat.xpm';
 checkdir($dir);
 file_news($mini, @letters, $start, $adder, $end, $dir, $remote, $file, $startline, $length, $urlline, $topicline, $fmflag);
 return;
}

#
#############################################################################

sub tuneup {
 $start = -2;
 $adder = 5;
 $end = 10;
 $startline = 1;
 $length = 6;
 $urlline = 4;
 $topicline = 1;
 $fmflag =1;
 $dir = "$startdir$drinksdir$tunedir";
 $remote = 'linux.com';
 $file = '/tuneup/listtips.phtml/as.txt';
 $mini = '';
 checkdir($dir);
 file_news($mini, @letters, $start, $adder, $end, $dir, $remote, $file, $startline, $length, $urlline, $topicline, $fmflag);
 return;
}
############################################################################



sub linuxapps {
 $start = -1;
 $adder = 3;
 $end = 10;
 $startline = 1;
 $length = 4;
 $urlline = 3;
 $topicline = 1;
 $fmflag =1;
 $dir = "$startdir$drinksdir$appsdir";
 $remote = 'linuxapps.com';
 $file = '/backend/basic.txt';
 $mini = '';
 checkdir($dir);
 file_news($mini, @letters, $start, $adder, $end, $dir, $remote, $file, $startline, $length, $urlline, $topicline, $fmflag);
 return;
}
############################################################################
	       

sub segfault {
 $start = -5; 
 $adder = 7;
 $end = 20;
 $startline = 11;
 $length = 8;
 $urlline = 3;
 $topicline = 2;
 $dir = $startdir.$drinksdir.$segdir;
 $remote = 'segfault.org';
 $file = '/stories.txt';
 $mini = 'mini-segfault.xpm';
 checkdir($dir);
 file_news($mini, @letters, $start, $adder, $end, $dir, $remote, $file, $startline, $length, $urlline, $topicline);
 return;
}

#
#############################################################################


#############################################################################
# Get News from a file 

sub file_news {

 system("$lynx -source http://$remote$file > $tempfile");

 open(INFILE, "$tempfile");
 $i = 0;
 $flag = 0;
 $num = 0;

 $temp = 0;
 my $extrafm;

 while (defined($line = <INFILE>)) {
	$i++;
	$temp++;

	if (($temp == 1) && ($fmflag == 1)) { 
		chomp($line); 
		$buffer = $line; 
	}

	if ($flag == 1) {
		$num++;
		if ($i == $length) { $i = 1; }
		if ($i == $urlline) {
			chop($line);
			$buffer =~ s/\"/\'/gi;
			$buffer =~ s/\<cite\>/\'/g;
			$buffer =~ s/\<\/cite\>/\'/g;
			open(FILE, ">$num");
				print FILE "Exec \"$buffer\" exec $netscape -remote 'openURL($line)' &\n MiniPixmap \"$mini\" \n";
			close(FILE);
		rename("$num","$dir/$num");
		} 
		if ($i == $topicline) {
			chop($line);                
			$buffer = $line;
  		}
	}

	if (($i == $startline) && ($flag == 0)) {
                $i = 1;
                $flag = 1;
        }


}
 

 close(INFILE); 


 
 $count = 0;
  
 while ($count != $end) {
  	$start = $start + $adder;
	$temp = $letters[$count];
 	$count++;

  	unlink("$dir$temp");
  	rename("$dir$start","$dir$temp");

  	if ($count == $end) {
   		return;
  	}  
 }


}

############################################################################
# Stupid Slashdot News

sub stupid_slashdot_news {
 open(INFILE, "$lynx -source http://$remote$file|");
 $title = 0;
 $url = 0;
 $i = 0;
 $num = 0;
 $temp;
 while (<INFILE>) {
  next if $temp;
  if (/.*(\<story\>).*/) {
	$title = 1;	
	next;
  }
  if ($title == 1) {
	if (/.*(\<title\>.+\<\/title\>).*/) {
		$buffer = $1;
		$buffer =~ s/\<title\>//;
		$buffer =~ s/\<\/title\>//;
		$title = 0;
		$url = 1;
		next;
        }
  }
  if ($url == 1) {
	if (/.*(\<url\>.+\<\/url\>).*/) {
                $line = $1;
                $line =~ s/\<url\>//;
                $line =~ s/\<\/url\>//;
		$url = 0;
		$i = 1;
	}
  }
  if ($i == 1) {
	$num++;
        $buffer =~ s/\"/\'/gi;
        $buffer =~ s/\<cite\>/\'/g;
        $buffer =~ s/\<\/cite\>/\'/g;
	$buffer =~ s/\&amp\;/and/g;
        open(FILE, ">$num");
         print FILE "Exec \"$buffer\" exec $netscape -remote 'openURL($line)' &\n MiniPixmap \"$mini\" \n";
        close(FILE);
        rename("$num","$dir/$num");
	$i = 0;;
	next;
  }
  $temp;
 }
 close(INFILE);

 $count = 0;

 while ($count != $end) {
        $start = $start + $adder;
        $temp = $letters[$count];
        $count++;

        unlink("$dir$temp");
        rename("$dir$start","$dir$temp");

        if ($count == $end) {
                return;
	}
 }
}





###############################################################################
sub update_menu {
 	
 $as_version = system("$bindir/afterstep --version > $tempfile");

 open(FILE, "<$tempfile");
	 while(defined($temp = <FILE>)) {
        	$as_version = $temp;
 	 }
 close(FILE);
 
 $asv1 = $as_version;
 $asv2 = $as_version;

 substr($asv1, 0, 20) = "";
 substr($asv1, 1, length($asv1)-2) = "";
 chomp($asv1);
 substr($asv2, 0, 22) = "";
 chomp($asv2);
 if ($asv1 >= 7 && $asv2 >= 55) {
	print "Updating Startmenu with AfterStep version 1.$asv1.$asv2\n"; 

# The best AfterStep Module type thing EVER!
# Thanks to Ethan!

	system("$bindir/ascommand.pl \'QuickRestart \"\" startmenu\'");

 }
 exit;
}


###############################################################################

sub checkdir {

 if (-w $dir) {
  return;
 }
 die "Error: no $dir or no write permisions.";
}



###############################################################################
sub blank {

 $count = 0;
 $temp = scalar(@which);;

 while ($count != $temp) {
	$which[$count] = (0);
	$count++;
 }
 return;
}

#################################################################################

