/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;

public class ViewMenu
extends ExtensionPopupMenu {
    private static final long serialVersionUID = -6295434374221271825L;
    private static final String MENU_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.label");
    private static final String ANTI_ALIASING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.antiAliasing");
    private static final String SHOW_LINE_NUMBERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showLineNumbers");
    private static final String CODE_FOLDING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.codeFolding");
    private static final String WORD_WRAP = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.wordWrap");
    private static final String HIGHLIGHT_CURRENT_LINE = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.highlightCurrentLine");
    private static final String FADE_CURRENT_HIGHLIGHT_LINE = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.fadeCurrentHighlightLine");
    private static final String SHOW_WHITESPACE_CHARACTERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showWhitespaceCharacters");
    private static final String SHOW_NEWLINE_CHARACTERS = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.showNewlineCharacters");
    private static final String MARK_OCCURRENCES = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.markOccurrences");
    private static final String ROUNDED_SELECTION_EDGES = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.roundedSelectionEdges");
    private static final String BRACKET_MATCHING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.bracketMatching");
    private static final String ANIMATED_BRACKET_MATCHING = Constant.messages.getString("http.panel.view.syntaxtext.popup.view.animatedBracketMatching");
    private JCheckBoxMenuItem antiAliasingOption = this.createAndAddOption(new ChangeAntiAliasingAction(ANTI_ALIASING), this);
    private JCheckBoxMenuItem lineNumbersOption = this.createAndAddOption(new ChangeLineNumbersAction(SHOW_LINE_NUMBERS), this);
    private JCheckBoxMenuItem codeFoldingAction = this.createAndAddOption(new ChangeCodeFoldingAction(CODE_FOLDING), this);
    private JCheckBoxMenuItem wordWrapOption = this.createAndAddOption(new ChangeWordWrapAction(WORD_WRAP), this);
    private JCheckBoxMenuItem highlightCurrentLineOption;
    private JCheckBoxMenuItem fadeCurrentHighlightLineOption;
    private JCheckBoxMenuItem showWhitespacesOption;
    private JCheckBoxMenuItem showNewlinesOption;
    private JCheckBoxMenuItem markOccurrencesOption;
    private JCheckBoxMenuItem roundedSelectionEdgesOption;
    private JCheckBoxMenuItem bracketMatchingOption;
    private JCheckBoxMenuItem animatedBracketMatchingOption;

    public ViewMenu() {
        super(MENU_LABEL);
        this.addSeparator();
        this.highlightCurrentLineOption = this.createAndAddOption(new ChangeHighlightCurrentLineAction(HIGHLIGHT_CURRENT_LINE), this);
        this.fadeCurrentHighlightLineOption = this.createAndAddOption(new ChangeFadeCurrentHighlightLineAction(FADE_CURRENT_HIGHLIGHT_LINE), this);
        this.addSeparator();
        this.showWhitespacesOption = this.createAndAddOption(new ChangeShowWhitespacesAction(SHOW_WHITESPACE_CHARACTERS), this);
        this.showNewlinesOption = this.createAndAddOption(new ChangeShowNewlinesAction(SHOW_NEWLINE_CHARACTERS), this);
        this.addSeparator();
        this.markOccurrencesOption = this.createAndAddOption(new ChangeMarkOccurrencesAction(MARK_OCCURRENCES), this);
        this.addSeparator();
        this.roundedSelectionEdgesOption = this.createAndAddOption(new ChangeRoundedSelectionEdgesAction(ROUNDED_SELECTION_EDGES), this);
        this.addSeparator();
        this.bracketMatchingOption = this.createAndAddOption(new ChangeBracketMatchingAction(BRACKET_MATCHING), this);
        this.animatedBracketMatchingOption = this.createAndAddOption(new ChangeAnimatedBracketMatchingAction(ANIMATED_BRACKET_MATCHING), this);
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof HttpPanelSyntaxHighlightTextArea) {
            HttpPanelSyntaxHighlightTextArea httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)invoker;
            this.updateState(httpPanelTextArea);
            return true;
        }
        return false;
    }

    public void updateState(HttpPanelSyntaxHighlightTextArea httpPanelTextArea) {
        this.antiAliasingOption.setSelected(httpPanelTextArea.getAntiAliasingEnabled());
        boolean selected = false;
        boolean enabled = false;
        Container c = httpPanelTextArea.getParent();
        if (c instanceof JViewport && (c = c.getParent()) instanceof RTextScrollPane) {
            enabled = true;
            RTextScrollPane scrollPane = (RTextScrollPane)c;
            selected = scrollPane.getLineNumbersEnabled();
        }
        this.lineNumbersOption.setVisible(enabled);
        this.lineNumbersOption.setSelected(selected);
        this.wordWrapOption.setSelected(httpPanelTextArea.getLineWrap());
        this.codeFoldingAction.setVisible(enabled && httpPanelTextArea.isCodeFoldingAllowed());
        this.codeFoldingAction.setSelected(httpPanelTextArea.isCodeFoldingEnabled());
        this.highlightCurrentLineOption.setSelected(httpPanelTextArea.getHighlightCurrentLine());
        this.fadeCurrentHighlightLineOption.setSelected(httpPanelTextArea.getFadeCurrentLineHighlight());
        this.showWhitespacesOption.setSelected(httpPanelTextArea.isWhitespaceVisible());
        this.showNewlinesOption.setSelected(httpPanelTextArea.getEOLMarkersVisible());
        this.markOccurrencesOption.setSelected(httpPanelTextArea.getMarkOccurrences());
        this.roundedSelectionEdgesOption.setSelected(httpPanelTextArea.getRoundedSelectionEdges());
        this.bracketMatchingOption.setSelected(httpPanelTextArea.isBracketMatchingEnabled());
        this.animatedBracketMatchingOption.setSelected(httpPanelTextArea.getAnimateBracketMatching());
    }

    private JCheckBoxMenuItem createAndAddOption(TextAction action, JMenu menu) {
        JCheckBoxMenuItem option = new JCheckBoxMenuItem(action);
        option.setSelected(false);
        menu.add(option);
        return option;
    }

    private static class ChangeAnimatedBracketMatchingAction
    extends TextAction {
        private static final long serialVersionUID = -4394901099442863189L;

        public ChangeAnimatedBracketMatchingAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setAnimateBracketMatching(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getAnimateBracketMatching());
            }
        }
    }

    private static class ChangeBracketMatchingAction
    extends TextAction {
        private static final long serialVersionUID = 7913147909802331579L;

        public ChangeBracketMatchingAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setBracketMatchingEnabled(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).isBracketMatchingEnabled());
            }
        }
    }

    private static class ChangeRoundedSelectionEdgesAction
    extends TextAction {
        private static final long serialVersionUID = 6117454234529550001L;

        public ChangeRoundedSelectionEdgesAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setRoundedSelectionEdges(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getRoundedSelectionEdges());
            }
        }
    }

    private static class ChangeMarkOccurrencesAction
    extends TextAction {
        private static final long serialVersionUID = 4264667901630036382L;

        public ChangeMarkOccurrencesAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setMarkOccurrences(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getMarkOccurrences());
            }
        }
    }

    private static class ChangeShowNewlinesAction
    extends TextAction {
        private static final long serialVersionUID = -4769295127472728093L;

        public ChangeShowNewlinesAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setEOLMarkersVisible(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getEOLMarkersVisible());
            }
        }
    }

    private static class ChangeShowWhitespacesAction
    extends TextAction {
        private static final long serialVersionUID = 1658351146973083837L;

        public ChangeShowWhitespacesAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setWhitespaceVisible(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).isWhitespaceVisible());
            }
        }
    }

    private static class ChangeFadeCurrentHighlightLineAction
    extends TextAction {
        private static final long serialVersionUID = -1430399597611245037L;

        public ChangeFadeCurrentHighlightLineAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setFadeCurrentLineHighlight(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getFadeCurrentLineHighlight());
            }
        }
    }

    private static class ChangeHighlightCurrentLineAction
    extends TextAction {
        private static final long serialVersionUID = -1464472023983865781L;

        public ChangeHighlightCurrentLineAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setHighlightCurrentLine(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getHighlightCurrentLine());
            }
        }
    }

    private static class ChangeWordWrapAction
    extends TextAction {
        private static final long serialVersionUID = -8654200226170189435L;

        public ChangeWordWrapAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setLineWrap(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getLineWrap());
            }
        }
    }

    private static class ChangeCodeFoldingAction
    extends TextAction {
        private static final long serialVersionUID = 8169545961043587586L;

        public ChangeCodeFoldingAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
            Container c;
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea && (c = (httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getParent()) instanceof JViewport && (c = c.getParent()) instanceof RTextScrollPane) {
                RTextScrollPane scrollPane = (RTextScrollPane)c;
                scrollPane.setFoldIndicatorEnabled(!httpPanelTextArea.isCodeFoldingEnabled());
                httpPanelTextArea.setCodeFoldingEnabled(!httpPanelTextArea.isCodeFoldingEnabled());
            }
        }
    }

    private static class ChangeLineNumbersAction
    extends TextAction {
        private static final long serialVersionUID = 7253500343033234417L;

        public ChangeLineNumbersAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
            Container c;
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea && (c = (httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getParent()) instanceof JViewport && (c = c.getParent()) instanceof RTextScrollPane) {
                RTextScrollPane scrollPane;
                scrollPane.setLineNumbersEnabled(!(scrollPane = (RTextScrollPane)c).getLineNumbersEnabled());
            }
        }
    }

    private static class ChangeAntiAliasingAction
    extends TextAction {
        private static final long serialVersionUID = 5408392183841188837L;

        public ChangeAntiAliasingAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent textComponent = this.getTextComponent(e);
            if (textComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea;
                httpPanelTextArea.setAntiAliasingEnabled(!(httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)textComponent).getAntiAliasingEnabled());
            }
        }
    }
}

