/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.fontchooser.FontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.gui.plaf.FontChooserUI;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserPreviewPanel;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserSelectionPanel;

public class PaletteFontChooserUI
extends FontChooserUI {
    private FontCollectionNode familyListParent;
    private FontFamilyNode faceListParent;
    private JFontChooser fontChooser;
    private PaletteFontChooserSelectionPanel selectionPanel;
    private PaletteFontChooserPreviewPanel previewPanel;
    private SelectionPanelHandler selectionPanelHandler;
    private FontChooserHandler chooserHandler;
    private int isUpdating;

    public PaletteFontChooserUI(JFontChooser jFontChooser) {
        this.fontChooser = jFontChooser;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        PaletteFontChooserUI paletteFontChooserUI = new PaletteFontChooserUI((JFontChooser)jComponent);
        return paletteFontChooserUI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installComponents(this.fontChooser);
        this.installListeners(this.fontChooser);
    }

    protected void installComponents(JFontChooser jFontChooser) {
        jFontChooser.removeAll();
        jFontChooser.setLayout(new BorderLayout());
        this.selectionPanel = new PaletteFontChooserSelectionPanel();
        jFontChooser.add((Component)this.selectionPanel, "Center");
        this.previewPanel = new PaletteFontChooserPreviewPanel();
        jFontChooser.add((Component)this.previewPanel, "North");
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        this.updateCollectionList();
        this.updateFamilyList();
        this.updateFaceList();
        this.updatePreview();
    }

    protected void installListeners(JFontChooser jFontChooser) {
        this.selectionPanelHandler = new SelectionPanelHandler();
        this.selectionPanel.getCollectionList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().addMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addMouseListener(this.selectionPanelHandler);
        this.chooserHandler = new FontChooserHandler();
        this.fontChooser.addPropertyChangeListener(this.chooserHandler);
        if (this.fontChooser.getModel() != null) {
            this.fontChooser.getModel().addTreeModelListener(this.chooserHandler);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.fontChooser);
        this.uninstallComponents(this.fontChooser);
    }

    protected void uninstallComponents(JFontChooser jFontChooser) {
        this.fontChooser.removeAll();
    }

    protected void uninstallListeners(JFontChooser jFontChooser) {
        this.fontChooser.removePropertyChangeListener(this.chooserHandler);
        this.selectionPanel.getCollectionList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().removeMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeMouseListener(this.selectionPanelHandler);
        if (this.fontChooser.getModel() != null) {
            this.fontChooser.getModel().removeTreeModelListener(this.chooserHandler);
        }
        this.chooserHandler = null;
        this.selectionPanelHandler = null;
    }

    private void updateCollectionList() {
        ++this.isUpdating;
        JList jList = this.selectionPanel.getCollectionList();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeAllElements();
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        Object object = fontChooserModel.getRoot();
        int n = fontChooserModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(fontChooserModel.getChild(object, i));
        }
        TreePath treePath = this.fontChooser.getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 2) {
            jList.clearSelection();
        } else {
            jList.setSelectedIndex(((TreeNode)treePath.getPathComponent(0)).getIndex((TreeNode)treePath.getPathComponent(1)));
            jList.scrollRectToVisible(jList.getCellBounds(jList.getSelectedIndex(), jList.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updateFamilyList() {
        ++this.isUpdating;
        JList jList = this.selectionPanel.getFamilyList();
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        FontCollectionNode fontCollectionNode = null;
        TreePath treePath = this.fontChooser.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 1) {
            fontCollectionNode = (FontCollectionNode)treePath.getPathComponent(1);
        }
        if (fontCollectionNode != this.familyListParent) {
            DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            defaultListModel.removeAllElements();
            this.familyListParent = fontCollectionNode;
            if (this.familyListParent != null) {
                int n = fontChooserModel.getChildCount(this.familyListParent);
                for (int i = 0; i < n; ++i) {
                    defaultListModel.addElement(fontChooserModel.getChild(this.familyListParent, i));
                }
            }
        }
        if (treePath == null || treePath.getPathCount() < 3) {
            jList.clearSelection();
        } else {
            jList.setSelectedIndex(((TreeNode)treePath.getPathComponent(1)).getIndex((TreeNode)treePath.getPathComponent(2)));
            jList.scrollRectToVisible(jList.getCellBounds(jList.getSelectedIndex(), jList.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updateFaceList() {
        ++this.isUpdating;
        JList jList = this.selectionPanel.getFaceList();
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        FontFamilyNode fontFamilyNode = null;
        TreePath treePath = this.fontChooser.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 2) {
            fontFamilyNode = (FontFamilyNode)treePath.getPathComponent(2);
        }
        if (fontFamilyNode != this.faceListParent) {
            DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            defaultListModel.removeAllElements();
            this.faceListParent = fontFamilyNode;
            if (this.faceListParent != null) {
                int n = fontChooserModel.getChildCount(this.faceListParent);
                for (int i = 0; i < n; ++i) {
                    defaultListModel.addElement(fontChooserModel.getChild(this.faceListParent, i));
                }
            }
        }
        if (treePath == null || treePath.getPathCount() < 4) {
            jList.clearSelection();
        } else {
            jList.setSelectedIndex(((TreeNode)treePath.getPathComponent(2)).getIndex((TreeNode)treePath.getPathComponent(3)));
            jList.scrollRectToVisible(jList.getCellBounds(jList.getSelectedIndex(), jList.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updatePreview() {
        ++this.isUpdating;
        this.previewPanel.setSelectedFont(this.fontChooser.getSelectedFont());
        --this.isUpdating;
    }

    private void doCollectionChanged() {
        FontFaceNode fontFaceNode;
        FontFamilyNode fontFamilyNode;
        FontCollectionNode fontCollectionNode;
        block12: {
            JList jList = this.selectionPanel.getCollectionList();
            TreePath treePath = this.fontChooser.getSelectionPath();
            FontCollectionNode fontCollectionNode2 = treePath != null && treePath.getPathCount() > 1 ? (FontCollectionNode)treePath.getPathComponent(1) : null;
            FontFamilyNode fontFamilyNode2 = treePath != null && treePath.getPathCount() > 2 ? (FontFamilyNode)treePath.getPathComponent(2) : null;
            FontFaceNode fontFaceNode2 = treePath != null && treePath.getPathCount() > 3 ? (FontFaceNode)treePath.getPathComponent(3) : null;
            fontCollectionNode = (FontCollectionNode)jList.getSelectedValue();
            fontFamilyNode = null;
            fontFaceNode = null;
            if ((fontFamilyNode2 == null || fontFaceNode2 == null) && this.fontChooser.getSelectedFont() != null) {
                fontFaceNode2 = new FontFaceNode(this.fontChooser.getSelectedFont());
                fontFamilyNode2 = new FontFamilyNode(this.fontChooser.getSelectedFont().getFamily());
            }
            if (fontCollectionNode != null && fontFamilyNode2 != null) {
                int n = fontCollectionNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    FontFamilyNode fontFamilyNode3 = fontCollectionNode.getChildAt(i);
                    if (fontFamilyNode3.compareTo(fontFamilyNode2) != 0) continue;
                    fontFamilyNode = fontFamilyNode3;
                    break;
                }
            }
            if (fontFamilyNode != null && fontFaceNode2 != null) {
                for (FontFaceNode fontFaceNode3 : fontFamilyNode.faces()) {
                    if (fontFaceNode3.compareTo(fontFaceNode2) != 0) continue;
                    fontFaceNode = fontFaceNode3;
                    break;
                }
            } else if (fontFaceNode == null && fontFamilyNode2 != null && fontFaceNode2 != null) {
                for (FontFamilyNode fontFamilyNode4 : fontCollectionNode.families()) {
                    for (FontFaceNode fontFaceNode4 : fontFamilyNode4.faces()) {
                        if (fontFaceNode4.compareTo(fontFaceNode2) != 0) continue;
                        fontFaceNode = fontFaceNode4;
                        fontFamilyNode = (FontFamilyNode)fontFaceNode4.getParent();
                        break block12;
                    }
                }
            }
        }
        if (fontCollectionNode != null) {
            if (fontFamilyNode == null && fontCollectionNode.getChildCount() > 0) {
                fontFamilyNode = fontCollectionNode.getChildAt(0);
            }
            if (fontFamilyNode != null && fontFaceNode == null && fontFamilyNode.getChildCount() > 0) {
                fontFaceNode = fontFamilyNode.getChildAt(0);
            }
        }
        this.setNewSelectionPath(fontCollectionNode, fontFamilyNode, fontFaceNode);
    }

    private void doFamilyChanged() {
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        JList jList = this.selectionPanel.getFamilyList();
        TreePath treePath = this.fontChooser.getSelectionPath();
        FontCollectionNode fontCollectionNode = treePath != null && treePath.getPathCount() > 1 ? (FontCollectionNode)treePath.getPathComponent(1) : null;
        FontFamilyNode fontFamilyNode = treePath != null && treePath.getPathCount() > 2 ? (FontFamilyNode)treePath.getPathComponent(2) : null;
        FontFaceNode fontFaceNode = treePath != null && treePath.getPathCount() > 3 ? (FontFaceNode)treePath.getPathComponent(3) : null;
        FontCollectionNode fontCollectionNode2 = fontCollectionNode;
        FontFamilyNode fontFamilyNode2 = (FontFamilyNode)jList.getSelectedValue();
        FontFaceNode fontFaceNode2 = null;
        if (fontFamilyNode2 != null && fontFaceNode != null) {
            int n = fontFamilyNode2.getChildCount();
            for (int i = 0; i < n; ++i) {
                FontFaceNode fontFaceNode3 = fontFamilyNode2.getChildAt(i);
                if (fontFaceNode3.compareTo(fontFaceNode) != 0) continue;
                fontFaceNode2 = fontFaceNode3;
                break;
            }
        }
        if (fontCollectionNode2 != null) {
            if (fontFamilyNode2 == null && fontCollectionNode2.getChildCount() > 0) {
                fontFamilyNode2 = fontCollectionNode2.getChildAt(0);
            }
            if (fontFamilyNode2 != null && fontFaceNode2 == null && fontFamilyNode2.getChildCount() > 0) {
                fontFaceNode2 = fontFamilyNode2.getChildAt(0);
            }
        }
        this.setNewSelectionPath(fontCollectionNode2, fontFamilyNode2, fontFaceNode2);
    }

    private void doFaceChanged() {
        JList jList = this.selectionPanel.getFaceList();
        TreePath treePath = this.fontChooser.getSelectionPath();
        FontCollectionNode fontCollectionNode = treePath != null && treePath.getPathCount() > 1 ? (FontCollectionNode)treePath.getPathComponent(1) : null;
        FontFamilyNode fontFamilyNode = treePath != null && treePath.getPathCount() > 2 ? (FontFamilyNode)treePath.getPathComponent(2) : null;
        FontFaceNode fontFaceNode = treePath != null && treePath.getPathCount() > 3 ? (FontFaceNode)treePath.getPathComponent(3) : null;
        FontCollectionNode fontCollectionNode2 = fontCollectionNode;
        FontFamilyNode fontFamilyNode2 = fontFamilyNode;
        FontFaceNode fontFaceNode2 = (FontFaceNode)jList.getSelectedValue();
        this.setNewSelectionPath(fontCollectionNode2, fontFamilyNode2, fontFaceNode2);
    }

    private void setNewSelectionPath(FontCollectionNode fontCollectionNode, FontFamilyNode fontFamilyNode, FontFaceNode fontFaceNode) {
        FontChooserModel fontChooserModel = this.fontChooser.getModel();
        TreePath treePath = fontFaceNode != null ? new TreePath(new Object[]{fontChooserModel.getRoot(), fontCollectionNode, fontFamilyNode, fontFaceNode}) : (fontFamilyNode != null ? new TreePath(new Object[]{fontChooserModel.getRoot(), fontCollectionNode, fontFamilyNode}) : (fontCollectionNode != null ? new TreePath(new Object[]{fontChooserModel.getRoot(), fontCollectionNode}) : new TreePath(fontChooserModel.getRoot())));
        this.fontChooser.setSelectionPath(treePath);
    }

    private class FontChooserHandler
    implements PropertyChangeListener,
    TreeModelListener {
        private FontChooserHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "selectionPath") {
                PaletteFontChooserUI.this.updateCollectionList();
                PaletteFontChooserUI.this.updateFamilyList();
                PaletteFontChooserUI.this.updateFaceList();
            } else if (string == "selectedFont") {
                PaletteFontChooserUI.this.updatePreview();
            } else if (string == "model") {
                FontChooserModel fontChooserModel = (FontChooserModel)propertyChangeEvent.getOldValue();
                if (fontChooserModel != null) {
                    fontChooserModel.removeTreeModelListener(this);
                }
                if ((fontChooserModel = (FontChooserModel)propertyChangeEvent.getNewValue()) != null) {
                    fontChooserModel.addTreeModelListener(this);
                }
                PaletteFontChooserUI.this.updateCollectionList();
                PaletteFontChooserUI.this.updateFamilyList();
                PaletteFontChooserUI.this.updateFaceList();
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }
    }

    private class SelectionPanelHandler
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private SelectionPanelHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PaletteFontChooserUI.this.isUpdating == 0) {
                Object object = listSelectionEvent.getSource();
                if (object == PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                    PaletteFontChooserUI.this.doCollectionChanged();
                } else if (object == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                    PaletteFontChooserUI.this.doFamilyChanged();
                } else if (object == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                    PaletteFontChooserUI.this.doFaceChanged();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (object != PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                        if (object == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                            PaletteFontChooserUI.this.selectionPanel.getCollectionList().requestFocus();
                        } else if (object == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                            PaletteFontChooserUI.this.selectionPanel.getFamilyList().requestFocus();
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (object == PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                        PaletteFontChooserUI.this.selectionPanel.getFamilyList().requestFocus();
                    } else if (object == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                        PaletteFontChooserUI.this.selectionPanel.getFaceList().requestFocus();
                    } else if (object == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                        // empty if block
                    }
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    PaletteFontChooserUI.this.fontChooser.cancelSelection();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    PaletteFontChooserUI.this.fontChooser.approveSelection();
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                PaletteFontChooserUI.this.fontChooser.approveSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

