/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest.root.colibri.shutdown;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.rest.RestApis;
import org.jitsi.videobridge.rest.annotations.EnabledByConfig;

@Path(value="/colibri/shutdown")
@EnabledByConfig(value=RestApis.SHUTDOWN)
public class Shutdown {
    @Inject
    protected Videobridge videobridge;

    @POST
    @Consumes(value={"application/json"})
    public Response shutdown(ShutdownJson shutdown, @Context HttpServletRequest request) {
        try {
            this.videobridge.shutdown(shutdown.isGraceful);
            return Response.ok().build();
        }
        catch (Throwable t2) {
            return Response.status(500).build();
        }
    }

    public static class ShutdownJson {
        @JsonProperty(value="graceful-shutdown", required=true)
        private Boolean isGraceful;

        @JsonCreator
        public ShutdownJson(@JsonProperty(value="graceful-shutdown", required=true) Boolean isGraceful) {
            this.isGraceful = isGraceful;
        }
    }
}

