/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.concurrent.LinkedBlockingQueue;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.StringInternalOption;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.WorkerLimits;

public class TaskPathProjectEvaluator
implements ProjectConfigurer {
    private static final StringInternalOption PARALLEL_CONFIGURATION_SCHEDULER = new StringInternalOption("org.gradle.internal.isolated-projects.scheduler", "jit");
    private final BuildCancellationToken cancellationToken;
    private final BuildOperationExecutor buildOperationExecutor;
    private final WorkerLimits workerLimits;
    private final InternalOptions internalOptions;

    public TaskPathProjectEvaluator(BuildCancellationToken cancellationToken, BuildOperationExecutor buildOperationExecutor, WorkerLimits workerLimits, InternalOptions internalOptions) {
        this.cancellationToken = cancellationToken;
        this.buildOperationExecutor = buildOperationExecutor;
        this.workerLimits = workerLimits;
        this.internalOptions = internalOptions;
    }

    @Override
    public void configure(ProjectInternal project) {
        project.getOwner().ensureConfigured();
    }

    @Override
    public void configureFully(ProjectState projectState) {
        projectState.ensureConfigured();
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        projectState.ensureTasksDiscovered();
    }

    @Override
    public void configureHierarchy(ProjectInternal project) {
        this.configure(project);
        for (Project sub : project.getSubprojects()) {
            this.configure((ProjectInternal)sub);
        }
    }

    @Override
    public void configureHierarchyInParallel(ProjectInternal project) {
        assert (project.getParent() == null) : "Parallel configuration must start from root!";
        if (this.maxWorkerCount() < 2) {
            this.configureHierarchy(project);
            return;
        }
        ProjectState root = project.getOwner();
        if (!root.hasChildren()) {
            root.ensureConfigured();
            return;
        }
        String strategy = this.schedulingStrategy();
        if (strategy.equals("jit")) {
            this.scheduleProjectsJustInTime(root);
        } else {
            this.scheduleProjectsAheadOfTime(project);
        }
    }

    private String schedulingStrategy() {
        return (String)this.internalOptions.getOption((InternalOption)PARALLEL_CONFIGURATION_SCHEDULER).get();
    }

    private void scheduleProjectsAheadOfTime(ProjectInternal root) {
        this.runAllWithAccessToProjectState((Action<BuildOperationQueue<RunnableBuildOperation>>)((Action)queue -> {
            for (Project p : root.getAllprojects()) {
                queue.add((BuildOperation)this.configureOperationFor(p));
            }
        }));
    }

    private void scheduleProjectsJustInTime(ProjectState root) {
        assert (this.maxWorkerCount() > 1) : "Parallel traversal requires more than one worker!";
        this.runAllWithAccessToProjectState((Action<BuildOperationQueue<RunnableBuildOperation>>)((Action)queue -> {
            int pending;
            LinkedBlockingQueue<ProjectState> readyQueue = new LinkedBlockingQueue<ProjectState>();
            queue.add((BuildOperation)TaskPathProjectEvaluator.traverseProject(root, readyQueue));
            int n = pending = root.hasChildren() ? 1 : 0;
            while (pending > 0) {
                ProjectState next;
                try {
                    next = readyQueue.take();
                    --pending;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                for (ProjectState child : next.getUnorderedChildProjects()) {
                    queue.add((BuildOperation)TaskPathProjectEvaluator.traverseProject(child, readyQueue));
                    if (!child.hasChildren()) continue;
                    ++pending;
                }
            }
        }));
    }

    private static RunnableBuildOperation traverseProject(final ProjectState project, final LinkedBlockingQueue<ProjectState> readyQueue) {
        return new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                try {
                    project.ensureSelfConfigured();
                }
                finally {
                    if (project.hasChildren()) {
                        readyQueue.add(project);
                    }
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Parallelize configuration");
            }
        };
    }

    private void runAllWithAccessToProjectState(Action<BuildOperationQueue<RunnableBuildOperation>> buildOperationQueueAction) {
        try {
            this.buildOperationExecutor.runAllWithAccessToProjectState(buildOperationQueueAction);
        }
        catch (MultipleBuildOperationFailures e) {
            if (e.getCauses().size() == 1) {
                throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)e.getCauses().get(0)));
            }
            throw e;
        }
    }

    private RunnableBuildOperation configureOperationFor(final Project p) {
        return new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                TaskPathProjectEvaluator.this.configure((ProjectInternal)p);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Configure project " + p.getName()));
            }
        };
    }

    private int maxWorkerCount() {
        return this.workerLimits.getMaxWorkerCount();
    }
}

