/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StrippedNode;
import net.sf.saxon.pattern.NodeKindTest;

public class StrippedDocument
extends StrippedNode
implements DocumentInfo {
    private Stripper stripper;
    private boolean preservesSpace;

    public StrippedDocument(DocumentInfo doc, Stripper stripper) {
        this.node = doc;
        this.parent = null;
        this.docWrapper = this;
        this.stripper = stripper;
        this.preservesSpace = StrippedDocument.findPreserveSpace(doc);
    }

    public StrippedNode wrap(NodeInfo node) {
        return this.makeWrapper(node, this, null);
    }

    public Stripper getStripper() {
        return this.stripper;
    }

    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    public int getDocumentNumber() {
        return this.node.getDocumentNumber();
    }

    public NodeInfo selectID(String id) {
        NodeInfo n = ((DocumentInfo)this.node).selectID(id);
        if (n == null) {
            return null;
        }
        return this.makeWrapper(n, this, null);
    }

    public Iterator getUnparsedEntityNames() {
        return ((DocumentInfo)this.node).getUnparsedEntityNames();
    }

    public String[] getUnparsedEntity(String name) {
        return ((DocumentInfo)this.node).getUnparsedEntity(name);
    }

    private static boolean findPreserveSpace(DocumentInfo doc) {
        NodeInfo node;
        String val;
        AxisIterator iter = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
        do {
            if ((node = (NodeInfo)iter.next()) != null) continue;
            return false;
        } while (!"preserve".equals(val = node.getAttributeValue(386)));
        return true;
    }

    public boolean containsPreserveSpace() {
        return this.preservesSpace;
    }
}

