/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * ceil(-2.0lf) => -2.0lf
 * ceil(-0.6666666666666667lf) => -0.0lf
 * ceil(0.6666666666666665lf) => 1.0lf
 * ceil(2.0lf) => 2.0lf
 */
#version 400

void main()
{
  double[distance(ceil(-2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array0;
  double[distance(ceil(-0.6666666666666667lf), -0.0lf) <= 0.0lf ? 1 : -1] array1;
  double[distance(ceil(0.6666666666666665lf), 1.0lf) <= 1e-05lf ? 1 : -1] array2;
  double[distance(ceil(2.0lf), 2.0lf) <= 2e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
