/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (- 0u) => 0u
 * (- 6u) => 4294967290u
 * (- 12u) => 4294967284u
 * (- 32u) => 4294967264u
 * (- 74u) => 4294967222u
 */
#version 130

void main()
{
  float[(- 0u) == 0u ? 1 : -1] array0;
  float[(- 6u) == 4294967290u ? 1 : -1] array1;
  float[(- 12u) == 4294967284u ? 1 : -1] array2;
  float[(- 32u) == 4294967264u ? 1 : -1] array3;
  float[(- 74u) == 4294967222u ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
