# About

Web interface for Oracle VirtualBox (https://www.virtualbox.org/)

## Roadmap

- [ ] Ensure feature parity with VirtualBox 7.2 minus Oracle Cloud features
- [x] PHP 8.4 compatibility
- [x] jQuery and jQuery UI updates
- [ ] Create a release process where javascript and CSS are minified and releses do not contain unnecessary build artifacts

## Project history and credits

October 2025

VirtualBox 7.2 support and various bugfixes.

April 2025

Project adopted by Anonie Muss. Updated from https://github.com/studnitskiy/phpvirtualbox.

October 2024

VirtualBox 7.1 support for x86 hosts only, no ARM hosts support.


2022 updated by *[Bartek Sz.](https://github.com/BartekSz95)* and various contributors.

2017-2021 maintained by Smart Guide Pty Ltd (tudor at smartguide dot com dot au) with support from various contributors.

2010-2015 created and maintained by Ian Moore (imoore76 at yahoo dot com).

FREE, WITHOUT WARRANTY:

All files of this program (phpVirtualBox) are distributed under the
terms contained in the LICENSE.txt file in this folder unless otherwise
specified in an individual source file. By using this software, you are
agreeing to the terms contained therein. If you have not received and read
the license file, or do not agree with its conditions, please cease using
this software immediately and remove any copies you may have in your
possession.

# Requirements

- PHP 8.X - **Older versions are not considered.**

- Webserver (eg. Apache HTTPD, nginx)

- VirtualBox 7.2.x

# Installation from ZIP file

1) Download ZIP file from the project site on GitHub - use Code > Download ZIP.
2) Unzip the ZIP file into a folder accessible by your web server.
3) Rename config.php-example to config.php and edit as needed.

Read the wiki for more information : https://github.com/phpvirtualbox/phpvirtualbox/wiki

# Post installation

Default login is (**username**/**password**): *admin*/*admin*

Please report bugs/feature requests to GitHub:
https://github.com/phpvirtualbox/phpvirtualbox/issues

# Password Recovery

Rename the file recovery.php-disabled to recovery.php, navigate to it in your web browser, and follow the instructions presented.
