/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.utilities;

import ciir.umass.edu.utilities.RankLibError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExpressionEvaluator {
    private static String[] operators = new String[]{"+", "-", "*", "/", "^"};
    private static String[] functions = new String[]{"log", "ln", "log2", "exp", "sqrt", "neg"};
    private static HashMap<String, Integer> priority = null;

    public static void main(String[] args) {
        ExpressionEvaluator ev = new ExpressionEvaluator();
        String exp = "sqrt(16)/exp(4^2)";
        System.out.println(ev.getRPN(exp) + "");
        System.out.println(ev.eval(exp) + "");
    }

    private boolean isOperator(String token) {
        for (int i = 0; i < operators.length; ++i) {
            if (token.compareTo(operators[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isFunction(String token) {
        for (int i = 0; i < functions.length; ++i) {
            if (token.compareTo(functions[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private Queue toPostFix(String expression) {
        expression = expression.replace(" ", "");
        Queue output = new Queue();
        Stack op = new Stack();
        String lastReadToken = "";
        for (int i = 0; i < expression.length(); ++i) {
            String token = expression.charAt(i) + "";
            if (token.compareTo("(") == 0) {
                op.push(token);
            } else if (token.compareTo(")") == 0) {
                boolean foundOpen = false;
                while (op.size() > 0 && !foundOpen) {
                    String last = op.pop();
                    if (last.compareTo("(") != 0) {
                        output.enqueue(last);
                        continue;
                    }
                    foundOpen = true;
                }
                if (!foundOpen) {
                    throw RankLibError.create("Error: Invalid expression: \"" + expression + "\". Parentheses mismatched.");
                }
            } else if (this.isOperator(token)) {
                if (lastReadToken.compareTo("(") == 0 || this.isOperator(lastReadToken)) {
                    if (token.compareTo("-") == 0) {
                        op.push("neg");
                    }
                } else {
                    if (op.size() > 0) {
                        String last = op.pop();
                        if (last.compareTo("(") == 0) {
                            op.push(last);
                        } else if (priority.get(token) > priority.get(last)) {
                            op.push(last);
                        } else if (priority.get(token) < priority.get(last)) {
                            output.enqueue(last);
                        } else if (token.compareTo("^") == 0) {
                            op.push(last);
                        } else {
                            output.enqueue(last);
                        }
                    }
                    op.push(token);
                }
            } else {
                String next;
                int j;
                for (j = i + 1; j < expression.length() && (next = expression.charAt(j) + "").compareTo(")") != 0 && next.compareTo("(") != 0 && !this.isOperator(next); ++j) {
                    token = token + next;
                }
                i = j - 1;
                if (this.isFunction(token)) {
                    if (j == expression.length()) {
                        throw RankLibError.create("Error: Invalid expression: \"" + expression + "\". Function specification requires parentheses.");
                    }
                    if (expression.charAt(j) != '(') {
                        throw RankLibError.create("Error: Invalid expression: \"" + expression + "\". Function specification requires parentheses.");
                    }
                    op.push(token);
                } else {
                    try {
                        Double.parseDouble(token);
                    }
                    catch (Exception ex) {
                        throw RankLibError.create("Error: \"" + token + "\" is not a valid token.");
                    }
                    output.enqueue(token);
                }
            }
            lastReadToken = token;
        }
        while (op.size() > 0) {
            String last = op.pop();
            if (last.compareTo("(") == 0) {
                throw RankLibError.create("Error: Invalid expression: \"" + expression + "\". Parentheses mismatched.");
            }
            output.enqueue(last);
        }
        return output;
    }

    public ExpressionEvaluator() {
        if (priority == null) {
            priority = new HashMap();
            priority.put("+", 2);
            priority.put("-", 2);
            priority.put("*", 3);
            priority.put("/", 3);
            priority.put("^", 4);
            priority.put("neg", 5);
            priority.put("log", 6);
            priority.put("ln", 6);
            priority.put("sqrt", 6);
        }
    }

    public String getRPN(String expression) {
        return this.toPostFix(expression).toString();
    }

    public double eval(String expression) {
        Queue output = this.toPostFix(expression);
        double[] eval = new double[output.size()];
        int cp = 0;
        try {
            while (output.size() > 0) {
                String token = output.dequeue();
                double v = 0.0;
                if (this.isOperator(token)) {
                    if (token.compareTo("+") == 0) {
                        v = eval[cp - 2] + eval[cp - 1];
                    } else if (token.compareTo("-") == 0) {
                        v = eval[cp - 2] + eval[cp - 1];
                    } else if (token.compareTo("*") == 0) {
                        v = eval[cp - 2] * eval[cp - 1];
                    } else if (token.compareTo("/") == 0) {
                        v = eval[cp - 2] / eval[cp - 1];
                    } else if (token.compareTo("^") == 0) {
                        v = Math.pow(eval[cp - 2], eval[cp - 1]);
                    }
                    eval[cp - 2] = v;
                    --cp;
                    continue;
                }
                if (this.isFunction(token)) {
                    if (token.compareTo("log") == 0) {
                        if (eval[cp - 1] < 0.0) {
                            throw RankLibError.create("Error: expression " + expression + " involves taking log of a non-positive number");
                        }
                        v = Math.log10(eval[cp - 1]);
                    } else if (token.compareTo("ln") == 0) {
                        if (eval[cp - 1] < 0.0) {
                            throw RankLibError.create("Error: expression " + expression + " involves taking log of a non-positive number");
                        }
                        v = Math.log(eval[cp - 1]);
                    } else if (token.compareTo("log2") == 0) {
                        if (eval[cp - 1] < 0.0) {
                            throw RankLibError.create("Error: expression " + expression + " involves taking log of a non-positive number");
                        }
                        v = Math.log(eval[cp - 1]) / Math.log(2.0);
                    } else if (token.compareTo("exp") == 0) {
                        v = Math.exp(eval[cp - 1]);
                    } else if (token.compareTo("sqrt") == 0) {
                        if (eval[cp - 1] < 0.0) {
                            throw RankLibError.create("Error: expression " + expression + " involves taking square root of a negative number");
                        }
                        v = Math.sqrt(eval[cp - 1]);
                    } else if (token.compareTo("neg") == 0) {
                        v = -eval[cp - 1];
                    }
                    eval[cp - 1] = v;
                    continue;
                }
                eval[cp++] = Double.parseDouble(token);
            }
            if (cp != 1) {
                throw RankLibError.create("Error: invalid expression: " + expression);
            }
        }
        catch (Exception ex) {
            throw RankLibError.create("Unknown error in ExpressionEvaluator::eval() with \"" + expression + "\"", ex);
        }
        return eval[cp - 1];
    }

    class Queue {
        private List<String> l = new ArrayList<String>();

        Queue() {
        }

        public void enqueue(String s) {
            this.l.add(s);
        }

        public String dequeue() {
            if (this.l.size() == 0) {
                return "";
            }
            String s = this.l.get(0);
            this.l.remove(0);
            return s;
        }

        public int size() {
            return this.l.size();
        }

        public String toString() {
            String output = "";
            for (int i = 0; i < this.l.size(); ++i) {
                output = output + this.l.get(i) + " ";
            }
            return output.trim();
        }
    }

    class Stack {
        private List<String> l = new ArrayList<String>();

        Stack() {
        }

        public void push(String s) {
            this.l.add(s);
        }

        public String pop() {
            if (this.l.size() == 0) {
                return "";
            }
            String s = this.l.get(this.l.size() - 1);
            this.l.remove(this.l.size() - 1);
            return s;
        }

        public int size() {
            return this.l.size();
        }

        public String toString() {
            String output = "";
            for (int i = this.l.size() - 1; i >= 0; --i) {
                output = output + this.l.get(i) + " ";
            }
            return output.trim();
        }
    }
}

