/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteExperimentTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final ExperimentDao experimentDao;

    @Inject
    public DeleteExperimentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ExperimentDao experimentDao) {
        super("cluster:admin/opensearch/search_relevance/experiment/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.experimentDao = experimentDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, ActionListener<DeleteResponse> listener) {
        try {
            String experimentId = request.getId();
            if (experimentId == null || experimentId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment ID cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.experimentDao.deleteExperiment(experimentId, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

