/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.rest.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.annotation.RuleAction;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.module.provider.AnnotationActionModuleTypeHelper;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.automation.util.ModuleBuilder;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.core.dto.ConfigDescriptionDTOMapper;
import org.openhab.core.config.core.dto.ConfigDescriptionParameterDTO;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingActions;
import org.openhab.core.thing.binding.ThingActionsScope;
import org.openhab.core.thing.binding.ThingHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="actions")
@Tag(name="actions")
@Component
@JaxrsResource
@JaxrsName(value="actions")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ThingActionsResource
implements RESTResource {
    public static final String PATH_THINGS = "actions";
    private final LocaleService localeService;
    private final ModuleTypeRegistry moduleTypeRegistry;
    private final ActionInputsHelper actionInputsHelper;
    private final AnnotationActionModuleTypeHelper annotationActionModuleTypeHelper;
    Map<ThingUID, Map<String, List<String>>> thingActionsMap = new ConcurrentHashMap<ThingUID, Map<String, List<String>>>();
    private List<ModuleHandlerFactory> moduleHandlerFactories = new ArrayList<ModuleHandlerFactory>();

    @Activate
    public ThingActionsResource(@Reference LocaleService localeService, @Reference ModuleTypeRegistry moduleTypeRegistry, @Reference ActionInputsHelper actionInputsHelper, @Reference AnnotationActionModuleTypeHelper annotationActionModuleTypeHelper) {
        this.localeService = localeService;
        this.moduleTypeRegistry = moduleTypeRegistry;
        this.actionInputsHelper = actionInputsHelper;
        this.annotationActionModuleTypeHelper = annotationActionModuleTypeHelper;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void addThingActions(ThingActions thingActions) {
        ThingHandler handler = thingActions.getThingHandler();
        String scope = this.getScope(thingActions);
        if (handler != null && scope != null) {
            ThingUID thingUID = handler.getThing().getUID();
            Method[] methods = thingActions.getClass().getDeclaredMethods();
            ArrayList<String> actionUIDs = new ArrayList<String>();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(RuleAction.class)) {
                    actionUIDs.add(this.annotationActionModuleTypeHelper.getModuleIdFromMethod(scope, method));
                }
                ++n2;
            }
            if (actionUIDs.isEmpty()) {
                return;
            }
            this.thingActionsMap.computeIfAbsent(thingUID, thingUid -> new ConcurrentHashMap()).put(scope, actionUIDs);
        }
    }

    public void removeThingActions(ThingActions thingActions) {
        ThingUID thingUID;
        Map<String, List<String>> actionMap;
        ThingHandler handler = thingActions.getThingHandler();
        String scope = this.getScope(thingActions);
        if (handler != null && scope != null && (actionMap = this.thingActionsMap.get(thingUID = handler.getThing().getUID())) != null) {
            actionMap.remove(scope);
            if (actionMap.isEmpty()) {
                this.thingActionsMap.remove(thingUID);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.moduleHandlerFactories.add(moduleHandlerFactory);
    }

    protected void removeModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.moduleHandlerFactories.remove(moduleHandlerFactory);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{thingUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getAvailableActionsForThing", summary="Get all available actions for provided thing UID", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ThingActionDTO.class), uniqueItems=true))}), @ApiResponse(responseCode="404", description="No actions found.")})
    public Response getActions(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        ThingUID aThingUID = new ThingUID(thingUID);
        ArrayList<ThingActionDTO> actions = new ArrayList<ThingActionDTO>();
        Map<String, List<String>> thingActionsMap = this.thingActionsMap.get(aThingUID);
        if (thingActionsMap == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (Map.Entry<String, List<String>> thingActionsEntry : thingActionsMap.entrySet()) {
            for (String actionUID : thingActionsEntry.getValue()) {
                ActionType actionType = (ActionType)this.moduleTypeRegistry.get(actionUID, locale);
                if (actionType == null) continue;
                ArrayList<ConfigDescriptionParameter> inputParameters = new ArrayList<ConfigDescriptionParameter>();
                for (ConfigDescriptionParameter parameter : actionType.getConfigurationDescriptions()) {
                    if (!actionType.getInputs().stream().anyMatch(i -> i.getName().equals(parameter.getName()))) continue;
                    inputParameters.add(parameter);
                }
                if (inputParameters.isEmpty() && !actionType.getInputs().isEmpty()) {
                    inputParameters = null;
                }
                ThingActionDTO actionDTO = new ThingActionDTO();
                actionDTO.actionUid = actionType.getUID();
                actionDTO.description = actionType.getDescription();
                actionDTO.label = actionType.getLabel();
                actionDTO.inputs = actionType.getInputs();
                actionDTO.inputConfigDescriptions = inputParameters == null ? null : ConfigDescriptionDTOMapper.mapParameters(inputParameters);
                actionDTO.outputs = actionType.getOutputs();
                actionDTO.visibility = actionType.getVisibility();
                actions.add(actionDTO);
            }
        }
        return Response.ok().entity((Object)new Stream2JSONInputStream(actions.stream())).build();
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{thingUID}/{actionUid: [a-zA-Z0-9]+(\\-[a-zA-Z0-9]+)?\\.[a-zA-Z0-9]+(%23[A-Fa-f0-9]+)?}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="executeThingAction", summary="Executes a thing action.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="404", description="Action not found"), @ApiResponse(responseCode="500", description="Creation of action handler or execution failed")})
    public Response executeThingAction(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @PathParam(value="actionUid") @Parameter(description="action type UID (including scope, separated by '.')") String actionTypeUid, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @Parameter(description="action inputs as map (parameter name as key / argument as value)") Map<String, Object> actionInputs) {
        ActionType actionType = (ActionType)this.moduleTypeRegistry.get((Object)actionTypeUid);
        if (actionType == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String ruleUID = UUID.randomUUID().toString();
        Configuration configuration = new Configuration();
        configuration.put("config", (Object)thingUID);
        Action action = ((ActionBuilder)((ActionBuilder)((ActionBuilder)ModuleBuilder.createAction().withConfiguration(configuration)).withId(UUID.randomUUID().toString())).withTypeUID(actionTypeUid)).build();
        ModuleHandlerFactory moduleHandlerFactory = this.moduleHandlerFactories.stream().filter(f -> f.getTypes().contains(actionTypeUid)).findFirst().orElse(null);
        if (moduleHandlerFactory == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        ActionHandler handler = (ActionHandler)moduleHandlerFactory.getHandler((Module)action, ruleUID);
        if (handler == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        try {
            Map<K, @Nullable V> returnValue = Objects.requireNonNullElse(handler.execute(this.actionInputsHelper.mapSerializedInputsToActionInputs(actionType, actionInputs)), Map.of());
            moduleHandlerFactory.ungetHandler((Module)action, ruleUID, (ModuleHandler)handler);
            return Response.ok(returnValue).build();
        }
        catch (Exception e) {
            moduleHandlerFactory.ungetHandler((Module)action, ruleUID, (ModuleHandler)handler);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).build();
        }
    }

    private @Nullable String getScope(ThingActions actions) {
        ThingActionsScope scopeAnnotation = actions.getClass().getAnnotation(ThingActionsScope.class);
        if (scopeAnnotation == null) {
            return null;
        }
        return scopeAnnotation.name();
    }

    private static class ThingActionDTO {
        public String actionUid = "";
        public @Nullable String label;
        public @Nullable String description;
        public @Nullable Visibility visibility;
        public List<Input> inputs = new ArrayList<Input>();
        public @Nullable List<ConfigDescriptionParameterDTO> inputConfigDescriptions;
        public List<Output> outputs = new ArrayList<Output>();

        private ThingActionDTO() {
        }
    }
}

