/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.provider.file.AbstractFileProvider;
import org.openhab.core.service.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AutomationWatchService
implements WatchService.WatchEventListener {
    private final WatchService watchService;
    private final Path watchingDir;
    private AbstractFileProvider provider;
    private final Logger logger = LoggerFactory.getLogger(AutomationWatchService.class);

    public AutomationWatchService(AbstractFileProvider provider, WatchService watchService, String watchingDir) {
        this.watchService = watchService;
        this.watchingDir = Path.of(watchingDir, new String[0]);
        this.provider = provider;
    }

    public void activate() {
        this.watchService.registerListener((WatchService.WatchEventListener)this, this.watchingDir);
    }

    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public Path getSourcePath() {
        return this.watchingDir;
    }

    public void processWatchEvent(WatchService.Kind kind, Path fullPath) {
        try {
            if (kind == WatchService.Kind.DELETE) {
                this.provider.removeResources(fullPath.toFile());
            } else if (!(Files.isHidden(fullPath) || kind != WatchService.Kind.CREATE && kind != WatchService.Kind.MODIFY)) {
                this.provider.importResources(fullPath.toFile());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to process automation watch event {} for \"{}\": {}", new Object[]{kind, fullPath, e.getMessage()});
            this.logger.trace("", (Throwable)e);
        }
    }
}

