/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.proxy;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.openhab.core.ui.internal.proxy.ProxyServletService;

public class AsyncProxyServlet
extends org.eclipse.jetty.proxy.AsyncProxyServlet {
    private static final long serialVersionUID = -4716754591953017795L;
    private final ProxyServletService service;

    AsyncProxyServlet(ProxyServletService service) {
        this.service = service;
    }

    public String getServletInfo() {
        return "Proxy (async)";
    }

    protected HttpClient newHttpClient() {
        return new HttpClient((SslContextFactory)new SslContextFactory.Client());
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        if (this.service.proxyingVideoWidget(clientRequest)) {
            proxyRequest.timeout(0L, TimeUnit.MILLISECONDS);
            proxyResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            proxyResponse.setHeader("Pragma", "no-cache");
            proxyResponse.setHeader("Expires", "0");
        }
        super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
    }

    protected void copyRequestHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.copyRequestHeaders(clientRequest, proxyRequest);
        this.service.maybeAppendAuthHeader(this.service.uriFromRequest(clientRequest), proxyRequest);
    }

    protected String rewriteTarget(HttpServletRequest request) {
        return Objects.toString(this.service.uriFromRequest(request), null);
    }

    protected void onProxyRewriteFailed(HttpServletRequest request, HttpServletResponse response) {
        this.service.sendError(request, response);
    }
}

