/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jupnp.model.ExpirationDetails;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryItems;
import org.jupnp.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteItems
extends RegistryItems<RemoteDevice, RemoteGENASubscription> {
    private final Logger logger = LoggerFactory.getLogger(Registry.class);

    RemoteItems(RegistryImpl registry) {
        super(registry);
    }

    @Override
    void add(RemoteDevice device) {
        Resource[] resources;
        if (this.update((RemoteDeviceIdentity)device.getIdentity())) {
            this.logger.trace("Ignoring addition, device already registered: {}", (Object)device);
            return;
        }
        for (Resource deviceResource : resources = this.getResources(device)) {
            this.logger.trace("Validating remote device resource; {}", (Object)deviceResource);
            if (this.registry.getResource(deviceResource.getPathQuery()) == null) continue;
            throw new RegistrationException("URI namespace conflict with already registered resource: " + String.valueOf(deviceResource));
        }
        for (Resource validatedResource : resources) {
            this.registry.addResource(validatedResource);
            this.logger.trace("Added remote device resource: {}", (Object)validatedResource);
        }
        Integer maxAgeSeconds = null;
        if (this.registry.getConfiguration() != null) {
            maxAgeSeconds = this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds();
        }
        if (maxAgeSeconds == null) {
            maxAgeSeconds = ((RemoteDeviceIdentity)device.getIdentity()).getMaxAgeSeconds();
        }
        RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), device, maxAgeSeconds);
        this.logger.trace("Adding hydrated remote device to registry with {} seconds expiration: {}", (Object)item.getExpirationDetails().getMaxAgeSeconds(), (Object)device);
        this.getDeviceItems().add(item);
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("-------------------------- START Registry Namespace -----------------------------------\n");
            for (Resource resource : this.registry.getResources()) {
                sb.append(resource).append("\n");
            }
            sb.append("-------------------------- END Registry Namespace -----------------------------------");
            this.logger.trace(sb.toString());
        }
        this.logger.trace("Completely hydrated remote device graph available, calling listeners: {}", (Object)device);
        for (RegistryListener listener : this.registry.getListeners()) {
            this.registry.getConfiguration().getRemoteListenerExecutor().execute(() -> listener.remoteDeviceAdded(this.registry, device));
        }
    }

    boolean update(RemoteDeviceIdentity rdIdentity) {
        for (LocalDevice localDevice : this.registry.getLocalDevices()) {
            if (localDevice.findDevice(rdIdentity.getUdn()) == null) continue;
            this.logger.trace("Ignoring update, a local device graph contains UDN");
            return true;
        }
        RemoteDevice registeredRemoteDevice = (RemoteDevice)this.get(rdIdentity.getUdn(), false);
        if (registeredRemoteDevice != null) {
            URL remoteDescriptorUrl;
            URL descriptorUrl;
            RemoteDeviceIdentity remoteDeviceIdentity = (RemoteDeviceIdentity)registeredRemoteDevice.getIdentity();
            if (remoteDeviceIdentity != null && (descriptorUrl = rdIdentity.getDescriptorURL()) != null & (remoteDescriptorUrl = remoteDeviceIdentity.getDescriptorURL()) != null && !descriptorUrl.getHost().equals(remoteDescriptorUrl.getHost())) {
                this.logger.trace("IP adress has changed - removing the registered device");
                this.remove(registeredRemoteDevice);
                return false;
            }
            if (!registeredRemoteDevice.isRoot()) {
                this.logger.trace("Updating root device of embedded: {}", (Object)registeredRemoteDevice);
                registeredRemoteDevice = registeredRemoteDevice.getRoot();
            }
            RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)registeredRemoteDevice.getIdentity()).getUdn(), registeredRemoteDevice, this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() != null ? this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() : rdIdentity.getMaxAgeSeconds());
            this.logger.trace("Updating expiration of: {}", (Object)registeredRemoteDevice);
            this.getDeviceItems().remove(item);
            this.getDeviceItems().add(item);
            this.logger.trace("Remote device updated, calling listeners: {}", (Object)registeredRemoteDevice);
            for (RegistryListener listener : this.registry.getListeners()) {
                this.registry.getConfiguration().getRemoteListenerExecutor().execute(() -> listener.remoteDeviceUpdated(this.registry, (RemoteDevice)item.getItem()));
            }
            return true;
        }
        return false;
    }

    @Override
    boolean remove(RemoteDevice remoteDevice) {
        return this.remove(remoteDevice, false);
    }

    boolean remove(RemoteDevice remoteDevice, boolean shuttingDown) throws RegistrationException {
        RemoteDevice registeredDevice = (RemoteDevice)this.get(((RemoteDeviceIdentity)remoteDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            this.logger.trace("Removing remote device from registry: {}", (Object)remoteDevice);
            for (Resource deviceResource : this.getResources(registeredDevice)) {
                if (!this.registry.removeResource(deviceResource)) continue;
                this.logger.trace("Unregistered resource: {}", (Object)deviceResource);
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                RegistryItem outgoingSubscription = it.next();
                UDN subscriptionForUDN = ((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)((RemoteGENASubscription)outgoingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                this.logger.trace("Removing outgoing subscription: {}", (Object)outgoingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRemoteListenerExecutor().execute(() -> ((RemoteGENASubscription)outgoingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED, null));
            }
            if (!shuttingDown) {
                for (RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRemoteListenerExecutor().execute(() -> listener.remoteDeviceRemoved(this.registry, registeredDevice));
                }
            }
            this.getDeviceItems().remove(new RegistryItem(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn()));
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        RemoteDevice[] allDevices;
        for (RemoteDevice device : allDevices = this.get().toArray(new RemoteDevice[this.get().size()])) {
            this.remove(device, shuttingDown);
        }
    }

    void start() {
    }

    @Override
    void maintain() {
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashMap<UDN, RemoteDevice> expiredRemoteDevices = new HashMap<UDN, RemoteDevice>();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            this.logger.trace("Device '{}' expires in seconds: {}", remoteItem.getItem(), (Object)remoteItem.getExpirationDetails().getSecondsUntilExpiration());
            if (!remoteItem.getExpirationDetails().hasExpired(false)) continue;
            expiredRemoteDevices.put(remoteItem.getKey(), (RemoteDevice)remoteItem.getItem());
        }
        for (RemoteDevice remoteDevice : expiredRemoteDevices.values()) {
            this.logger.trace("Removing expired: {}", (Object)remoteDevice);
            this.remove(remoteDevice);
        }
        HashSet<RemoteGENASubscription> expiredOutgoingSubscriptions = new HashSet<RemoteGENASubscription>();
        for (RegistryItem item : this.getSubscriptionItems()) {
            ExpirationDetails expirationDetails = item.getExpirationDetails();
            if (expirationDetails.getRenewAttempts() >= 1 || !expirationDetails.hasExpired(true)) continue;
            expiredOutgoingSubscriptions.add((RemoteGENASubscription)item.getItem());
            expirationDetails.renewAttempted();
        }
        for (RemoteGENASubscription subscription : expiredOutgoingSubscriptions) {
            this.logger.trace("Renewing outgoing subscription: {}", (Object)subscription);
            this.renewOutgoingSubscription(subscription);
        }
    }

    public void resume() {
        this.logger.trace("Updating remote device expiration timestamps on resume");
        ArrayList<RemoteDeviceIdentity> toUpdate = new ArrayList<RemoteDeviceIdentity>();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            toUpdate.add((RemoteDeviceIdentity)((RemoteDevice)remoteItem.getItem()).getIdentity());
        }
        for (RemoteDeviceIdentity identity : toUpdate) {
            this.update(identity);
        }
    }

    @Override
    void shutdown() {
        this.logger.trace("Cancelling all outgoing subscriptions to remote devices during shutdown");
        ArrayList<RemoteGENASubscription> remoteSubscriptions = new ArrayList<RemoteGENASubscription>();
        for (RegistryItem item : this.getSubscriptionItems()) {
            remoteSubscriptions.add((RemoteGENASubscription)item.getItem());
        }
        for (RemoteGENASubscription remoteSubscription : remoteSubscriptions) {
            this.registry.getProtocolFactory().createSendingUnsubscribe(remoteSubscription).run();
        }
        this.logger.trace("Removing all remote devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void renewOutgoingSubscription(RemoteGENASubscription subscription) {
        this.registry.executeAsyncProtocol(this.registry.getProtocolFactory().createSendingRenewal(subscription));
    }
}

