/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters;

import io.quarkus.vertx.http.runtime.filters.Filter;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Filters {
    private List<Filter> listOfFilters = new CopyOnWriteArrayList<Filter>();

    public Filters register(Handler<RoutingContext> handler, int priority) {
        this.listOfFilters.add(new SimpleFilter(handler, priority));
        return this;
    }

    public List<Filter> getFilters() {
        return new ArrayList<Filter>(this.listOfFilters);
    }

    public static class SimpleFilter
    implements Filter {
        private Handler<RoutingContext> handler;
        private int priority;
        private boolean isFailureHandler = false;

        public SimpleFilter() {
        }

        public SimpleFilter(Handler<RoutingContext> handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        public SimpleFilter(Handler<RoutingContext> handler, int priority, boolean isFailureHandler) {
            this.handler = handler;
            this.priority = priority;
            this.isFailureHandler = isFailureHandler;
        }

        public void setHandler(Handler<RoutingContext> handler) {
            this.handler = handler;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        @Override
        public Handler<RoutingContext> getHandler() {
            return this.handler;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public boolean isFailureHandler() {
            return this.isFailureHandler;
        }

        public void setFailureHandler(boolean failureHandler) {
            this.isFailureHandler = failureHandler;
        }
    }
}

