/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.start.graph.Node;
import org.eclipse.jetty.start.graph.Predicate;
import org.eclipse.jetty.start.graph.Selection;

public class CriteriaSetPredicate
implements Predicate {
    private final Set<String> criteriaSet = new HashSet<String>();

    public CriteriaSetPredicate(String ... criterias) {
        for (String name : criterias) {
            this.criteriaSet.add(name);
        }
    }

    @Override
    public boolean match(Node<?> node) {
        Set<Selection> selections = node.getSelections();
        if (selections == null) {
            return false;
        }
        Set<String> actualCriterias = node.getSelectedCriteriaSet();
        if (actualCriterias.size() != this.criteriaSet.size()) {
            return false;
        }
        for (String actualCriteria : actualCriterias) {
            if (this.criteriaSet.contains(actualCriteria)) continue;
            return false;
        }
        return true;
    }
}

