/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import jakarta.inject.Inject;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.model.User;
import org.traccar.schedule.SingleScheduleTask;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class TaskDeleteTemporary
extends SingleScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDeleteTemporary.class);
    private static final long CHECK_PERIOD_HOURS = 1L;
    private final Storage storage;

    @Inject
    public TaskDeleteTemporary(Storage storage) {
        this.storage = storage;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.HOURS);
    }

    @Override
    public void run() {
        try {
            this.storage.removeObject(User.class, new Request(new Condition.And(new Condition.Equals("temporary", true), new Condition.Compare("expirationTime", "<", new Date()))));
        }
        catch (StorageException e) {
            LOGGER.warn("Failed to delete temporary users", (Throwable)e);
        }
    }
}

