/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.RemoteConfigErrorCode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RemoteConfigServiceErrorResponse
extends GenericJson {
    private static final Map<String, RemoteConfigErrorCode> RC_ERROR_CODES = ImmutableMap.builder().put((Object)"INTERNAL", (Object)RemoteConfigErrorCode.INTERNAL).put((Object)"INVALID_ARGUMENT", (Object)RemoteConfigErrorCode.INVALID_ARGUMENT).put((Object)"FAILED_PRECONDITION", (Object)RemoteConfigErrorCode.FAILED_PRECONDITION).put((Object)"UNAUTHENTICATED", (Object)RemoteConfigErrorCode.UNAUTHENTICATED).put((Object)"ALREADY_EXISTS", (Object)RemoteConfigErrorCode.ALREADY_EXISTS).put((Object)"VALIDATION_ERROR", (Object)RemoteConfigErrorCode.VALIDATION_ERROR).put((Object)"VERSION_MISMATCH", (Object)RemoteConfigErrorCode.VERSION_MISMATCH).build();
    private static final Pattern RC_ERROR_CODE_PATTERN = Pattern.compile("^\\[(\\w+)\\]:.*$");
    @Key(value="error")
    private Map<String, Object> error;

    @Nullable
    public RemoteConfigErrorCode getRemoteConfigErrorCode() {
        if (this.error == null) {
            return null;
        }
        String message = (String)this.error.get("message");
        if (Strings.isNullOrEmpty((String)message)) {
            return null;
        }
        Matcher errorMatcher = RC_ERROR_CODE_PATTERN.matcher(message);
        if (errorMatcher.find()) {
            String errorCode = errorMatcher.group(1);
            return RC_ERROR_CODES.get(errorCode);
        }
        return null;
    }
}

