/*
 * Decompiled with CFR 0.152.
 */
package liqp.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.nodes.AtomNode;
import liqp.nodes.BlockNode;
import liqp.nodes.LNode;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;
import liqp.tags.Tag;

class For
extends Tag {
    private static final String OFFSET = "offset";
    private static final String LIMIT = "limit";
    static final String FORLOOP = "forloop";
    static final String LENGTH = "length";
    static final String INDEX = "index";
    static final String INDEX0 = "index0";
    static final String RINDEX = "rindex";
    static final String RINDEX0 = "rindex0";
    static final String FIRST = "first";
    static final String LAST = "last";
    static final String NAME = "name";
    static final String PARENTLOOP = "parentloop";

    For() {
    }

    @Override
    public Object render(TemplateContext context, LNode ... nodes) {
        boolean array = super.asBoolean(nodes[0].render(context));
        String id = super.asString(nodes[1].render(context), context);
        String tagName = id + "-" + nodes[5].render(context);
        boolean reversed = super.asBoolean(nodes[6].render(context));
        TemplateContext nestedContext = new TemplateContext(context);
        Object rendered = array ? this.renderArray(id, nestedContext, tagName, reversed, nodes) : this.renderRange(id, nestedContext, tagName, reversed, nodes);
        return rendered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object renderArray(String id, TemplateContext context, String tagName, boolean reversed, LNode ... tokens) {
        StringBuilder builder = new StringBuilder();
        Object data = tokens[2].render(context);
        if (AtomNode.isEmpty(data) || "".equals(data)) {
            data = new ArrayList();
        }
        Map<String, Integer> attributes = this.getAttributes(7, context, tagName, tokens);
        int from = attributes.get(OFFSET);
        int limit = attributes.get(LIMIT);
        if (data instanceof Inspectable) {
            LiquidSupport evaluated = context.renderSettings.evaluate(context.parseSettings.mapper, data);
            data = evaluated.toLiquid();
        }
        if (data instanceof Map) {
            data = this.mapAsArray((Map)data);
        }
        Object[] array = super.asArray(data, context);
        LNode block = tokens[3];
        LNode blockIfEmptyOrNull = tokens[4];
        if (array == null || array.length == 0) {
            return blockIfEmptyOrNull == null ? null : blockIfEmptyOrNull.render(context);
        }
        int to = limit > -1 ? Math.min(from + limit, array.length) : array.length;
        from = Math.min(from, array.length);
        int length = to - from;
        List<Object> arrayList = Arrays.asList(array).subList(from, to);
        if (reversed) {
            ArrayList<Object> listCopy = new ArrayList<Object>(arrayList);
            Collections.reverse(listCopy);
            arrayList = listCopy;
        }
        Object registry = context.getRegistry("for");
        registry.put((String)tagName, from + length);
        ForLoopDrop forLoopDrop = this.createLoopDropInStack(context, tagName, length);
        try {
            for (Object o : arrayList) {
                context.incrementIterations();
                context.put(id, o);
                boolean isBreak = this.renderForLoopBody(context, builder, ((BlockNode)block).getChildren());
                forLoopDrop.increment();
                if (!isBreak) continue;
                break;
            }
        }
        finally {
            this.popLoopDropFromStack(context);
        }
        return builder.toString();
    }

    private ForLoopDrop createLoopDropInStack(TemplateContext context, String tagName, int length) {
        Stack<ForLoopDrop> stack = this.getParentForloopDropStack(context);
        ForLoopDrop parent = null;
        if (!stack.empty()) {
            parent = stack.peek();
        }
        ForLoopDrop forLoopDrop = new ForLoopDrop(tagName, length, parent);
        stack.push(forLoopDrop);
        context.put(FORLOOP, forLoopDrop);
        return forLoopDrop;
    }

    public void popLoopDropFromStack(TemplateContext context) {
        Stack<ForLoopDrop> stack = this.getParentForloopDropStack(context);
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    private boolean renderForLoopBody(TemplateContext context, StringBuilder builder, List<LNode> children) {
        boolean isBreak = false;
        for (LNode node : children) {
            Object value = node.render(context);
            if (value == null) continue;
            if (value == LValue.CONTINUE) break;
            if (value == LValue.BREAK) {
                isBreak = true;
                break;
            }
            if (super.isArray(value)) {
                Object[] arr;
                for (Object obj : arr = super.asArray(value, context)) {
                    builder.append(String.valueOf(obj));
                }
                continue;
            }
            builder.append(super.asString(value, context));
        }
        return isBreak;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object renderRange(String id, TemplateContext context, String tagName, boolean reversed, LNode ... tokens) {
        StringBuilder builder = new StringBuilder();
        Map<String, Integer> attributes = this.getAttributes(7, context, tagName, tokens);
        int offset = attributes.get(OFFSET);
        int limit = attributes.get(LIMIT);
        LNode block = tokens[4];
        int from = super.asNumber(tokens[2].render(context)).intValue();
        int to = super.asNumber(tokens[3].render(context)).intValue();
        int effectiveTo = limit < 0 ? to : Math.min(to, from + limit - 1);
        int length = to - from;
        ForLoopDrop forLoopDrop = this.createLoopDropInStack(context, tagName, length);
        try {
            for (int i = from + offset; i <= effectiveTo; ++i) {
                int realI = reversed ? effectiveTo - (i - from - offset) : i;
                context.incrementIterations();
                context.put(id, realI);
                boolean isBreak = this.renderForLoopBody(context, builder, ((BlockNode)block).getChildren());
                forLoopDrop.increment();
                if (!isBreak) continue;
                break;
            }
        }
        finally {
            this.popLoopDropFromStack(context);
        }
        return builder.toString();
    }

    private Stack<ForLoopDrop> getParentForloopDropStack(TemplateContext context) {
        Object registry = context.getRegistry("for_stack");
        Stack stack = (Stack)registry.get("for_stack");
        if (stack == null) {
            stack = new Stack();
            registry.put((String)"for_stack", stack);
        }
        return stack;
    }

    private Map<String, Integer> getAttributes(int fromIndex, TemplateContext context, String tagName, LNode ... tokens) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put(OFFSET, 0);
        attributes.put(LIMIT, -1);
        for (int i = fromIndex; i < tokens.length; ++i) {
            LNode token = tokens[i];
            Object[] attribute = super.asArray(token.render(context), context);
            if (OFFSET.equals(super.asString(attribute[0], context)) && attribute[1] == LValue.CONTINUE) {
                Object offsets = context.getRegistry("for");
                attributes.put(OFFSET, (Integer)offsets.get(tagName));
                continue;
            }
            try {
                attributes.put(super.asString(attribute[0], context), super.asNumber(attribute[1]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributes;
    }

    public static class ForLoopDrop
    implements LiquidSupport {
        private final Map<String, Object> map = new HashMap<String, Object>();
        private final ForLoopDrop parentloop;
        private int index;
        private int length;

        public ForLoopDrop(String forName, int length, ForLoopDrop parent) {
            this.map.put(For.NAME, forName);
            this.length = length;
            this.index = 0;
            this.parentloop = parent;
        }

        @Override
        public Map<String, Object> toLiquid() {
            this.map.put(For.LENGTH, this.length);
            this.map.put(For.INDEX, this.index + 1);
            this.map.put(For.INDEX0, this.index);
            this.map.put(For.RINDEX, this.length - this.index);
            this.map.put(For.RINDEX0, this.length - this.index - 1);
            boolean first = this.index == 0;
            boolean last = this.index == this.length - 1;
            this.map.put(For.FIRST, first);
            this.map.put(For.LAST, last);
            if (this.parentloop != null) {
                this.map.put(For.PARENTLOOP, this.parentloop);
            }
            return this.map;
        }

        public void increment() {
            ++this.index;
        }
    }
}

