# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.aaa.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class FeaturesWithProperties(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.features_with_properties'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FeaturesWithPropertiesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self):
        """
        List all the RBAC features and their properties.


        :rtype: :class:`com.vmware.nsx.model_client.FeaturePermissionListResult`
        :return: com.vmware.nsx.model.FeaturePermissionListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list', None)
class RegistrationToken(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.registration_token'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RegistrationTokenStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self):
        """
        The privileges of the registration token will be the same as the
        caller.


        :rtype: :class:`com.vmware.nsx.model_client.RegistrationToken`
        :return: com.vmware.nsx.model.RegistrationToken
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create', None)

    def delete(self,
               token,
               ):
        """
        Delete registration access token 
        Use API POST /api/v1/aaa/registration-token/delete

        .. deprecated:: unknown

        :type  token: :class:`str`
        :param token: Registration token (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.aaa.RegistrationToken.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'token': token,
                            })

    def get(self,
            token,
            ):
        """
        Get registration access token 
        Use API POST /api/v1/aaa/registration-token/retrieve

        .. deprecated:: unknown

        :type  token: :class:`str`
        :param token: Registration token (required)
        :rtype: :class:`com.vmware.nsx.model_client.RegistrationToken`
        :return: com.vmware.nsx.model.RegistrationToken
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.aaa.RegistrationToken.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'token': token,
                            })
class RoleBindings(VapiInterface):
    """
    
    """
    DELETE_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETE_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.delete`.

    """
    DELETESTALEBINDINGS_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method
    :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.deletestalebindings`.

    """
    DELETESTALEBINDINGS_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.deletestalebindings`.

    """
    GET_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    GET_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.get`.

    """
    LIST_IDENTITY_SOURCE_TYPE_VIDM = "VIDM"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_IDENTITY_SOURCE_TYPE_LDAP = "LDAP"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_IDENTITY_SOURCE_TYPE_OIDC = "OIDC"
    """
    Possible value for ``identitySourceType`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_REMOTE_USER = "remote_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_REMOTE_GROUP = "remote_group"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_LOCAL_USER = "local_user"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """
    LIST_TYPE_PRINCIPAL_IDENTITY = "principal_identity"
    """
    Possible value for ``type`` of method :func:`RoleBindings.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.role_bindings'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RoleBindingsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               role_binding,
               ):
        """
        This API is used to assign a user/group any role(s) of choice. It is
        recommended to use the new property roles_for_paths instead of roles.
        When using the roles_for_paths, set the read_roles_for_paths as true.
        User has union of all the roles assigned to it on a particular path and
        its sub-tree. User name is dealt case-insensitively.

        :type  role_binding: :class:`com.vmware.nsx.model_client.RoleBinding`
        :param role_binding: (required)
        :rtype: :class:`com.vmware.nsx.model_client.RoleBinding`
        :return: com.vmware.nsx.model.RoleBinding
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'role_binding': role_binding,
                            })

    def delete(self,
               binding_id,
               cursor=None,
               identity_source_id=None,
               identity_source_type=None,
               included_fields=None,
               name=None,
               page_size=None,
               path=None,
               role=None,
               root_path=None,
               sort_ascending=None,
               sort_by=None,
               type=None,
               ):
        """
        Delete the user/group's role assignment. If the path is provided then
        deletes only the roles_for_paths that matches the path. If path is
        provided for the last roles_for_paths then the whole role binding is
        deleted provided it is not that of a local user.

        :type  binding_id: :class:`str`
        :param binding_id: User/Group's id (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'binding_id': binding_id,
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def deletestalebindings(self,
                            cursor=None,
                            identity_source_id=None,
                            identity_source_type=None,
                            included_fields=None,
                            name=None,
                            page_size=None,
                            path=None,
                            role=None,
                            root_path=None,
                            sort_ascending=None,
                            sort_by=None,
                            type=None,
                            ):
        """
        Delete all stale role assignments

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('deletestalebindings',
                            {
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def get(self,
            binding_id,
            cursor=None,
            identity_source_id=None,
            identity_source_type=None,
            included_fields=None,
            name=None,
            page_size=None,
            path=None,
            role=None,
            root_path=None,
            sort_ascending=None,
            sort_by=None,
            type=None,
            ):
        """
        Get user/group's role information

        :type  binding_id: :class:`str`
        :param binding_id: User/Group's id (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :rtype: :class:`com.vmware.nsx.model_client.RoleBinding`
        :return: com.vmware.nsx.model.RoleBinding
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'binding_id': binding_id,
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def list(self,
             cursor=None,
             identity_source_id=None,
             identity_source_type=None,
             included_fields=None,
             name=None,
             page_size=None,
             path=None,
             role=None,
             root_path=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Get all users and groups with their roles. If the root_path is provided
        then only return role bindings that start-with or are sub-trees of the
        provided root path. Also filter the roles_for_paths such that only
        those roles_for_paths appear that start-with or are sub-tree of the
        provided root path.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  identity_source_id: :class:`str` or ``None``
        :param identity_source_id: Identity source ID (optional)
        :type  identity_source_type: :class:`str` or ``None``
        :param identity_source_type: Identity source type (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  name: :class:`str` or ``None``
        :param name: User/Group name (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  path: :class:`str` or ``None``
        :param path: Exact path of the context (optional)
        :type  role: :class:`str` or ``None``
        :param role: Role ID (optional)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type (optional)
        :rtype: :class:`com.vmware.nsx.model_client.RoleBindingListResult`
        :return: com.vmware.nsx.model.RoleBindingListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'identity_source_id': identity_source_id,
                            'identity_source_type': identity_source_type,
                            'included_fields': included_fields,
                            'name': name,
                            'page_size': page_size,
                            'path': path,
                            'role': role,
                            'root_path': root_path,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def update(self,
               binding_id,
               role_binding,
               ):
        """
        This API is used to update a user/group any role(s) of choice. It is
        recommended to use the new property roles_for_paths instead of roles.
        When using the roles_for_paths, set the read_roles_for_paths as true.
        User has union of all the roles assigned to it on a particular path and
        its sub-tree. User name is dealt case-insensitively. This API will
        merge the existing roles_for_paths with the newly provided
        roles_for_paths excluding roles_for_paths those are marked for
        deletion.

        :type  binding_id: :class:`str`
        :param binding_id: User/Group's id (required)
        :type  role_binding: :class:`com.vmware.nsx.model_client.RoleBinding`
        :param role_binding: (required)
        :rtype: :class:`com.vmware.nsx.model_client.RoleBinding`
        :return: com.vmware.nsx.model.RoleBinding
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'binding_id': binding_id,
                            'role_binding': role_binding,
                            })
class Roles(VapiInterface):
    """
    
    """
    LIST_SCOPE_ROOT = "ROOT"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_ORG = "ORG"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_PROJECT = "PROJECT"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """
    LIST_SCOPE_VPC = "VPC"
    """
    Possible value for ``scope`` of method :func:`Roles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.roles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RolesStub)
        self._VAPI_OPERATION_IDS = {}


    def clone(self,
              role,
              new_role,
              ):
        """
        The role with id <role> is cloned and the new id, name and description
        are the ones provided in the request body.

        :type  role: :class:`str`
        :param role: Role id (required)
        :type  new_role: :class:`com.vmware.nsx.model_client.NewRole`
        :param new_role: (required)
        :rtype: :class:`com.vmware.nsx.model_client.NewRole`
        :return: com.vmware.nsx.model.NewRole
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('clone',
                            {
                            'role': role,
                            'new_role': new_role,
                            })

    def delete(self,
               role,
               ):
        """
        If a role is assigned to a role binding then the deletion of the role
        is not allowed. Precanned roles cannot be deleted.

        :type  role: :class:`str`
        :param role: Custom role id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'role': role,
                            })

    def get(self,
            role,
            ):
        """
        Get role information

        :type  role: :class:`str`
        :param role: Role id (required)
        :rtype: :class:`com.vmware.nsx.model_client.RoleWithFeatures`
        :return: com.vmware.nsx.model.RoleWithFeatures
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'role': role,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             scope=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get information about all roles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  scope: :class:`str` or ``None``
        :param scope: List only the roles which are applicable for this scope. (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx.model_client.RoleListResult`
        :return: com.vmware.nsx.model.RoleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'scope': scope,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def update(self,
               role,
               role_with_features,
               ):
        """
        Creates a new role with id as <role> if there does not exist any role
        with id <role>, else updates the existing role. Permissions for
        features marked is_internal as true will be ignored if provided in
        request payload. These features' permission are set internally.

        :type  role: :class:`str`
        :param role: Custom role id (required)
        :type  role_with_features: :class:`com.vmware.nsx.model_client.RoleWithFeatures`
        :param role_with_features: (required)
        :rtype: :class:`com.vmware.nsx.model_client.RoleWithFeatures`
        :return: com.vmware.nsx.model.RoleWithFeatures
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'role': role,
                            'role_with_features': role_with_features,
                            })

    def validate(self,
                 feature_permission_array,
                 ):
        """
        Validate the permissions of an incoming role. Also, recommend the
        permissions which need to be corrected.

        :type  feature_permission_array: :class:`com.vmware.nsx.model_client.FeaturePermissionArray`
        :param feature_permission_array: (required)
        :rtype: :class:`com.vmware.nsx.model_client.RecommendedFeaturePermissionListResult`
        :return: com.vmware.nsx.model.RecommendedFeaturePermissionListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('validate',
                            {
                            'feature_permission_array': feature_permission_array,
                            })
class RolesWithFeaturePermissions(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.roles_with_feature_permissions'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RolesWithFeaturePermissionsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get information about all roles with features and their permissions

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx.model_client.RoleWithFeaturesListResult`
        :return: com.vmware.nsx.model.RoleWithFeaturesListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class UserInfo(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.aaa.user_info'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UserInfoStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            provide_flat_listing=None,
            root_path=None,
            ):
        """
        This API will return the name and role information of the user invoking
        this API request. This API is available for all NSX users no matter
        their authentication method (Local account, VIDM, LDAP etc). The
        permissions parameter of the NsxRole has been deprecated. The request
        parameter root_path has been introduced for multi-tenancy to get user's
        role at any path that the user desires. The response will contain the
        roles_for_paths to indicate roles at various paths.

        :type  provide_flat_listing: :class:`bool` or ``None``
        :param provide_flat_listing: Whether the output provides flat listing of all roles at each level
            or not (optional, default to false)
        :type  root_path: :class:`str` or ``None``
        :param root_path: Prefix path of the context (optional)
        :rtype: :class:`com.vmware.nsx.model_client.UserInfo`
        :return: com.vmware.nsx.model.UserInfo
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'provide_flat_listing': provide_flat_listing,
                            'root_path': root_path,
                            })
class _FeaturesWithPropertiesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {})
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/features-with-properties',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'FeaturePermissionListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.features_with_properties',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RegistrationTokenStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {})
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/aaa/registration-token',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'token': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/aaa/registration-token/{token}',
            path_variables={
                'token': 'token',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'token': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/registration-token/{token}',
            path_variables={
                'token': 'token',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RegistrationToken'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RegistrationToken'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.registration_token',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RoleBindingsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'role_binding': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBinding'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/aaa/role-bindings',
            request_body_parameter='role_binding',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'binding_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/aaa/role-bindings/{binding-id}',
            path_variables={
                'binding_id': 'binding-id',
            },
             header_parameters={
                                       },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for deletestalebindings operation
        deletestalebindings_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        deletestalebindings_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        deletestalebindings_input_value_validator_list = [
        ]
        deletestalebindings_output_validator_list = [
        ]
        deletestalebindings_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/aaa/role-bindings?action=delete_stale_bindings',
            path_variables={
            },
             header_parameters={
                                     },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'binding_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/role-bindings/{binding-id}',
            path_variables={
                'binding_id': 'binding-id',
            },
             header_parameters={
                                       },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'identity_source_id': type.OptionalType(type.StringType()),
            'identity_source_type': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'name': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'path': type.OptionalType(type.StringType()),
            'role': type.OptionalType(type.StringType()),
            'root_path': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/role-bindings',
            path_variables={
            },
             header_parameters={
                                     },
            query_parameters={
                'cursor': 'cursor',
                'identity_source_id': 'identity_source_id',
                'identity_source_type': 'identity_source_type',
                'included_fields': 'included_fields',
                'name': 'name',
                'page_size': 'page_size',
                'path': 'path',
                'role': 'role',
                'root_path': 'root_path',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'binding_id': type.StringType(),
            'role_binding': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBinding'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/aaa/role-bindings/{binding-id}',
            request_body_parameter='role_binding',
            path_variables={
                'binding_id': 'binding-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBinding'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'deletestalebindings': {
                'input_type': deletestalebindings_input_type,
                'output_type': type.VoidType(),
                'errors': deletestalebindings_error_dict,
                'input_value_validator_list': deletestalebindings_input_value_validator_list,
                'output_validator_list': deletestalebindings_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBinding'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBindingListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleBinding'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'deletestalebindings': deletestalebindings_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.role_bindings',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RolesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for clone operation
        clone_input_type = type.StructType('operation-input', {
            'role': type.StringType(),
            'new_role': type.ReferenceType('com.vmware.nsx.model_client', 'NewRole'),
        })
        clone_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        clone_input_value_validator_list = [
        ]
        clone_output_validator_list = [
        ]
        clone_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/aaa/roles/{role}?action=clone',
            request_body_parameter='new_role',
            path_variables={
                'role': 'role',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'role': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/aaa/roles/{role}',
            path_variables={
                'role': 'role',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'role': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/roles/{role}',
            path_variables={
                'role': 'role',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'scope': type.OptionalType(type.StringType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/roles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'scope': 'scope',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'role': type.StringType(),
            'role_with_features': type.ReferenceType('com.vmware.nsx.model_client', 'RoleWithFeatures'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/aaa/roles/{role}',
            request_body_parameter='role_with_features',
            path_variables={
                'role': 'role',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for validate operation
        validate_input_type = type.StructType('operation-input', {
            'feature_permission_array': type.ReferenceType('com.vmware.nsx.model_client', 'FeaturePermissionArray'),
        })
        validate_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        validate_input_value_validator_list = [
        ]
        validate_output_validator_list = [
        ]
        validate_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/aaa/roles?action=validate',
            request_body_parameter='feature_permission_array',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'clone': {
                'input_type': clone_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'NewRole'),
                'errors': clone_error_dict,
                'input_value_validator_list': clone_input_value_validator_list,
                'output_validator_list': clone_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleWithFeatures'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleWithFeatures'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'validate': {
                'input_type': validate_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RecommendedFeaturePermissionListResult'),
                'errors': validate_error_dict,
                'input_value_validator_list': validate_input_value_validator_list,
                'output_validator_list': validate_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'clone': clone_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'update': update_rest_metadata,
            'validate': validate_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.roles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RolesWithFeaturePermissionsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/roles-with-feature-permissions',
            path_variables={
            },
             header_parameters={
                       },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RoleWithFeaturesListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.roles_with_feature_permissions',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UserInfoStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'provide_flat_listing': type.OptionalType(type.BooleanType()),
            'root_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/aaa/user-info',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'provide_flat_listing': 'provide_flat_listing',
                'root_path': 'root_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'UserInfo'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.aaa.user_info',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'FeaturesWithProperties': FeaturesWithProperties,
        'RegistrationToken': RegistrationToken,
        'RoleBindings': RoleBindings,
        'Roles': Roles,
        'RolesWithFeaturePermissions': RolesWithFeaturePermissions,
        'UserInfo': UserInfo,
        'registration_token': 'com.vmware.nsx.aaa.registration_token_client.StubFactory',
        'roles': 'com.vmware.nsx.aaa.roles_client.StubFactory',
        'vidm': 'com.vmware.nsx.aaa.vidm_client.StubFactory',
    }

