/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public final class DNSOutgoing
extends DNSMessage {
    public static boolean USE_DOMAIN_NAME_COMPRESSION = true;
    Map<String, Integer> _names = new HashMap<String, Integer>();
    private final int _maxUDPPayload;
    private final MessageOutputStream _questionsBytes;
    private final MessageOutputStream _answersBytes;
    private final MessageOutputStream _authoritativeAnswersBytes;
    private final MessageOutputStream _additionalsAnswersBytes;
    private static final int HEADER_SIZE = 12;
    private InetSocketAddress _destination;

    public DNSOutgoing(int flags) {
        this(flags, true, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast) {
        this(flags, multicast, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast, int senderUDPPayload) {
        super(flags, 0, multicast);
        this._maxUDPPayload = senderUDPPayload > 0 ? senderUDPPayload : 1460;
        this._questionsBytes = new MessageOutputStream(senderUDPPayload, this);
        this._answersBytes = new MessageOutputStream(senderUDPPayload, this);
        this._authoritativeAnswersBytes = new MessageOutputStream(senderUDPPayload, this);
        this._additionalsAnswersBytes = new MessageOutputStream(senderUDPPayload, this);
    }

    public InetSocketAddress getDestination() {
        return this._destination;
    }

    public void setDestination(InetSocketAddress destination) {
        this._destination = destination;
    }

    public int availableSpace() {
        return this._maxUDPPayload - 12 - this._questionsBytes.size() - this._answersBytes.size() - this._authoritativeAnswersBytes.size() - this._additionalsAnswersBytes.size();
    }

    public void addQuestion(DNSQuestion rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeQuestion(rec);
        byte[] byteArray = record.toByteArray();
        record.close();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._questions.add(rec);
        this._questionsBytes.write(byteArray, 0, byteArray.length);
    }

    public void addAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (in == null || !rec.suppressedBy(in)) {
            this.addAnswer(rec, 0L);
        }
    }

    public void addAnswer(DNSRecord rec, long now) throws IOException {
        if (!(rec == null || now != 0L && rec.isExpired(now))) {
            MessageOutputStream record = new MessageOutputStream(512, this);
            record.writeRecord(rec, now);
            byte[] byteArray = record.toByteArray();
            record.close();
            if (byteArray.length < this.availableSpace()) {
                this._answers.add(rec);
                this._answersBytes.write(byteArray, 0, byteArray.length);
            } else {
                throw new IOException("message full");
            }
        }
    }

    public void addAuthorativeAnswer(DNSRecord rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeRecord(rec, 0L);
        byte[] byteArray = record.toByteArray();
        record.close();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._authoritativeAnswers.add(rec);
        this._authoritativeAnswersBytes.write(byteArray, 0, byteArray.length);
    }

    public void addAdditionalAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeRecord(rec, 0L);
        byte[] byteArray = record.toByteArray();
        record.close();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this._additionals.add(rec);
        this._additionalsAnswersBytes.write(byteArray, 0, byteArray.length);
    }

    public byte[] data() {
        long now = System.currentTimeMillis();
        this._names.clear();
        MessageOutputStream message = new MessageOutputStream(this._maxUDPPayload, this);
        message.writeShort(this._multicast ? 0 : this.getId());
        message.writeShort(this.getFlags());
        message.writeShort(this.getNumberOfQuestions());
        message.writeShort(this.getNumberOfAnswers());
        message.writeShort(this.getNumberOfAuthorities());
        message.writeShort(this.getNumberOfAdditionals());
        for (DNSQuestion question : this._questions) {
            message.writeQuestion(question);
        }
        for (DNSRecord record : this._answers) {
            message.writeRecord(record, now);
        }
        for (DNSRecord record : this._authoritativeAnswers) {
            message.writeRecord(record, now);
        }
        for (DNSRecord record : this._additionals) {
            message.writeRecord(record, now);
        }
        byte[] result = message.toByteArray();
        try {
            message.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    String print(boolean dump) {
        StringBuilder sb = new StringBuilder(this.toString());
        if (dump) {
            sb.append("\n");
            sb.append(this.print(this.data()));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isQuery() ? "dns[query:" : "dns[response:");
        sb.append(" id=0x");
        sb.append(Integer.toHexString(this.getId()));
        if (this.getFlags() != 0) {
            sb.append(", flags=0x");
            sb.append(Integer.toHexString(this.getFlags()));
            if (this.isResponse()) {
                sb.append(":r");
            }
            if (this.isAuthoritativeAnswer()) {
                sb.append(":aa");
            }
            if (this.isTruncated()) {
                sb.append(":tc");
            }
        }
        sb.append(this.print());
        sb.append("\nnames=");
        sb.append(this._names);
        sb.append("]");
        return sb.toString();
    }

    public int getMaxUDPPayload() {
        return this._maxUDPPayload;
    }

    public static class MessageOutputStream
    extends ByteArrayOutputStream {
        private final DNSOutgoing _out;
        private final int _offset;

        MessageOutputStream(int size, DNSOutgoing out) {
            this(size, out, 0);
        }

        MessageOutputStream(int size, DNSOutgoing out, int offset) {
            super(size);
            this._out = out;
            this._offset = offset;
        }

        void writeByte(int value) {
            this.write(value & 0xFF);
        }

        void writeBytes(String str, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.writeByte(str.charAt(off + i));
            }
        }

        @Override
        public void writeBytes(byte[] data) {
            if (data != null) {
                this.writeBytes(data, 0, data.length);
            }
        }

        void writeBytes(byte[] data, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.writeByte(data[off + i]);
            }
        }

        void writeShort(int value) {
            this.writeByte(value >> 8);
            this.writeByte(value);
        }

        void writeInt(int value) {
            this.writeShort(value >> 16);
            this.writeShort(value);
        }

        void writeUTF(String str, int off, int len) {
            char ch;
            int i;
            int utflen = 0;
            for (i = 0; i < len; ++i) {
                ch = str.charAt(off + i);
                if (ch >= '\u0001' && ch <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (ch > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            this.writeByte(utflen);
            for (i = 0; i < len; ++i) {
                ch = str.charAt(off + i);
                if (ch >= '\u0001' && ch <= '\u007f') {
                    this.writeByte(ch);
                    continue;
                }
                if (ch > '\u07ff') {
                    this.writeByte(0xE0 | ch >> 12 & 0xF);
                    this.writeByte(0x80 | ch >> 6 & 0x3F);
                    this.writeByte(0x80 | ch >> 0 & 0x3F);
                    continue;
                }
                this.writeByte(0xC0 | ch >> 6 & 0x1F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            }
        }

        void writeName(String name) {
            this.writeName(name, true);
        }

        void writeName(String name, boolean useCompression) {
            String aName = name;
            while (true) {
                int n;
                if ((n = MessageOutputStream.indexOfSeparator(aName)) < 0) {
                    n = aName.length();
                }
                if (n <= 0) {
                    this.writeByte(0);
                    return;
                }
                String label = aName.substring(0, n).replace("\\.", ".");
                if (useCompression && USE_DOMAIN_NAME_COMPRESSION) {
                    Integer offset = this._out._names.get(aName);
                    if (offset != null) {
                        int val = offset;
                        this.writeByte(val >> 8 | 0xC0);
                        this.writeByte(val & 0xFF);
                        return;
                    }
                    this._out._names.put(aName, this.size() + this._offset);
                    this.writeUTF(label, 0, label.length());
                } else {
                    this.writeUTF(label, 0, label.length());
                }
                if (!(aName = aName.substring(n)).startsWith(".")) continue;
                aName = aName.substring(1);
            }
        }

        private static int indexOfSeparator(String aName) {
            int offset = 0;
            int n = 0;
            while ((n = aName.indexOf(46, offset)) >= 0) {
                if (n == 0 || aName.charAt(n - 1) != '\\') {
                    return n;
                }
                offset = n + 1;
            }
            return -1;
        }

        void writeQuestion(DNSQuestion question) {
            this.writeName(question.getName());
            this.writeShort(question.getRecordType().indexValue());
            this.writeShort(question.getRecordClass().indexValue());
        }

        void writeRecord(DNSRecord rec, long now) {
            this.writeName(rec.getName());
            this.writeShort(rec.getRecordType().indexValue());
            this.writeShort(rec.getRecordClass().indexValue() | (rec.isUnique() && this._out.isMulticast() ? 32768 : 0));
            this.writeInt(now == 0L ? rec.getTTL() : rec.getRemainingTTL(now));
            MessageOutputStream record = new MessageOutputStream(512, this._out, this._offset + this.size() + 2);
            rec.write(record);
            byte[] byteArray = record.toByteArray();
            this.writeShort(byteArray.length);
            this.write(byteArray, 0, byteArray.length);
        }
    }
}

