/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

abstract class ByteListTranscoder {
    protected ByteList src;
    protected int srcEnd;
    protected int charStart;
    protected int pos;
    private int quoteStart = -1;

    ByteListTranscoder() {
    }

    protected void init(ByteList byteList) {
        this.init(byteList, 0, byteList.length());
    }

    protected void init(ByteList byteList, int n, int n2) {
        this.src = byteList;
        this.pos = n;
        this.charStart = n;
        this.srcEnd = n2;
    }

    protected boolean hasNext() {
        return this.pos < this.srcEnd;
    }

    private char next() {
        return this.src.charAt(this.pos++);
    }

    protected int readUtf8Char(ThreadContext threadContext) {
        this.charStart = this.pos;
        char c = this.next();
        if (c <= '\u007f') {
            return c;
        }
        if (c <= '\u00bf') {
            throw this.invalidUtf8(threadContext);
        }
        if (c <= '\u00df') {
            this.ensureMin(threadContext, 1);
            int n = (c & 0x1F) << 6 | this.nextPart(threadContext);
            if (n < 128) {
                throw this.invalidUtf8(threadContext);
            }
            return n;
        }
        if (c <= '\u00ef') {
            this.ensureMin(threadContext, 2);
            int n = (c & 0xF) << 12 | this.nextPart(threadContext) << 6 | this.nextPart(threadContext);
            if (n < 2048) {
                throw this.invalidUtf8(threadContext);
            }
            return n;
        }
        if (c <= '\u00f7') {
            this.ensureMin(threadContext, 3);
            int n = (c & 7) << 18 | this.nextPart(threadContext) << 12 | this.nextPart(threadContext) << 6 | this.nextPart(threadContext);
            if (!Character.isValidCodePoint(n)) {
                throw this.invalidUtf8(threadContext);
            }
            return n;
        }
        throw this.invalidUtf8(threadContext);
    }

    protected int readASCIIChar() {
        this.charStart = this.pos;
        return this.next();
    }

    protected void ensureMin(ThreadContext threadContext, int n) {
        if (this.pos + n > this.srcEnd) {
            throw this.incompleteUtf8(threadContext);
        }
    }

    private int nextPart(ThreadContext threadContext) {
        char c = this.next();
        if ((c & 0xC0) != 128) {
            throw this.invalidUtf8(threadContext);
        }
        return c & 0x3F;
    }

    protected void quoteStart() {
        if (this.quoteStart == -1) {
            this.quoteStart = this.charStart;
        }
    }

    protected void quoteStop(int n) throws IOException {
        if (this.quoteStart != -1) {
            this.append(this.src.unsafeBytes(), this.src.begin() + this.quoteStart, n - this.quoteStart);
            this.quoteStart = -1;
        }
    }

    protected abstract void append(int var1) throws IOException;

    protected abstract void append(byte[] var1, int var2, int var3) throws IOException;

    protected abstract RaiseException invalidUtf8(ThreadContext var1);

    protected RaiseException incompleteUtf8(ThreadContext threadContext) {
        return this.invalidUtf8(threadContext);
    }
}

