/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.match;

import java.util.Iterator;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchNode;

public class MatchEngine {
    private static final Map<String, IMatchable.MatchProperties> stat_properties = Map.of("type", IMatchable.MatchProperties.STATEMENT_TYPE, "ret", IMatchable.MatchProperties.STATEMENT_RET, "position", IMatchable.MatchProperties.STATEMENT_POSITION, "statsize", IMatchable.MatchProperties.STATEMENT_STATSIZE, "exprsize", IMatchable.MatchProperties.STATEMENT_EXPRSIZE, "iftype", IMatchable.MatchProperties.STATEMENT_IFTYPE);
    private static final Map<String, IMatchable.MatchProperties> expr_properties = Map.ofEntries(Map.entry("type", IMatchable.MatchProperties.EXPRENT_TYPE), Map.entry("ret", IMatchable.MatchProperties.EXPRENT_RET), Map.entry("position", IMatchable.MatchProperties.EXPRENT_POSITION), Map.entry("functype", IMatchable.MatchProperties.EXPRENT_FUNCTYPE), Map.entry("exittype", IMatchable.MatchProperties.EXPRENT_EXITTYPE), Map.entry("consttype", IMatchable.MatchProperties.EXPRENT_CONSTTYPE), Map.entry("constvalue", IMatchable.MatchProperties.EXPRENT_CONSTVALUE), Map.entry("invclass", IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS), Map.entry("signature", IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE), Map.entry("parameter", IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER), Map.entry("index", IMatchable.MatchProperties.EXPRENT_VAR_INDEX), Map.entry("name", IMatchable.MatchProperties.EXPRENT_FIELD_NAME));
    private static final Map<String, Statement.StatementType> stat_type = Map.of("if", Statement.StatementType.IF, "do", Statement.StatementType.DO, "switch", Statement.StatementType.SWITCH, "trycatch", Statement.StatementType.TRY_CATCH, "basicblock", Statement.StatementType.BASIC_BLOCK, "sequence", Statement.StatementType.SEQUENCE);
    private static final Map<String, Integer> expr_type = Map.ofEntries(Map.entry("array", 1), Map.entry("assignment", 2), Map.entry("constant", 3), Map.entry("exit", 4), Map.entry("field", 5), Map.entry("function", 6), Map.entry("if", 7), Map.entry("invocation", 8), Map.entry("monitor", 9), Map.entry("new", 10), Map.entry("switch", 11), Map.entry("var", 12), Map.entry("annotation", 13), Map.entry("assert", 14));
    private static final Map<String, Integer> expr_func_type = Map.of("eq", 42);
    private static final Map<String, Integer> expr_exit_type = Map.of("return", 0, "throw", 1);
    private static final Map<String, Integer> stat_if_type = Map.of("if", 0, "ifelse", 1);
    private static final Map<String, VarType> expr_const_type = Map.of("null", VarType.VARTYPE_NULL, "string", VarType.VARTYPE_STRING);
    private final MatchNode rootNode;
    private final Map<String, Object> variables;

    /*
     * Exception decompiling
     */
    public MatchEngine(String description) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:67)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredBlockStatement.transformStructuredChildren(AbstractStructuredBlockStatement.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean match(IMatchable object) {
        this.variables.clear();
        return this.match(this.rootNode, object);
    }

    private boolean match(MatchNode matchNode, IMatchable object) {
        if (!object.match(matchNode, this)) {
            return false;
        }
        int expr_index = 0;
        int stat_index = 0;
        Iterator<MatchNode> iterator = matchNode.getChildren().iterator();
        while (iterator.hasNext()) {
            MatchNode childNode;
            boolean isStatement = (childNode = iterator.next()).getType() == 0;
            IMatchable childObject = object.findObject(childNode, isStatement ? stat_index : expr_index);
            if (childObject == null || !this.match(childNode, childObject)) {
                return false;
            }
            if (isStatement) {
                ++stat_index;
                continue;
            }
            ++expr_index;
        }
        return true;
    }

    public boolean checkAndSetVariableValue(String name, Object value) {
        Object old_value = this.variables.get(name);
        if (old_value != null) {
            return old_value.equals(value);
        }
        this.variables.put(name, value);
        return true;
    }

    public Object getVariableValue(String name) {
        return this.variables.get(name);
    }
}

