/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.FeatureSuggestersManager;
import training.featuresSuggester.TextFragment;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.settings.FeatureSuggesterSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018J\f\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bR$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Ltraining/featuresSuggester/SuggestingUtils;", "", "<init>", "()V", "value", "", "forceShowSuggestions", "getForceShowSuggestions", "()Z", "setForceShowSuggestions", "(Z)V", "isActionsProcessingEnabled", "project", "Lcom/intellij/openapi/project/Project;", "handleAction", "", "action", "Ltraining/featuresSuggester/actions/Action;", "findBreakpointOnPosition", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "asString", "", "Ljava/awt/datatransfer/Transferable;", "getSelection", "Ltraining/featuresSuggester/TextFragment;", "Lcom/intellij/openapi/editor/Editor;", "intellij.featuresTrainer"})
public final class SuggestingUtils {
    @NotNull
    public static final SuggestingUtils INSTANCE = new SuggestingUtils();

    private SuggestingUtils() {
    }

    public final boolean getForceShowSuggestions() {
        return Registry.Companion.is("feature.suggester.force.show.suggestions", false);
    }

    public final void setForceShowSuggestions(boolean value) {
        Registry.Companion.get("feature.suggester.force.show.suggestions").setValue(value);
    }

    public final boolean isActionsProcessingEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !project.isDisposed() && !DumbService.Companion.isDumb(project) && FeatureSuggesterSettings.Companion.instance().isAnySuggesterEnabled();
    }

    public final void handleAction(@NotNull Project project, @NotNull Action action) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (!this.isActionsProcessingEnabled(project)) break block1;
            FeatureSuggestersManager featureSuggestersManager = (FeatureSuggestersManager)project.getService(FeatureSuggestersManager.class);
            if (featureSuggestersManager != null) {
                featureSuggestersManager.actionPerformed(action);
            }
        }
    }

    @Nullable
    public final XBreakpoint<?> findBreakpointOnPosition(@NotNull Project project, @NotNull XSourcePosition position) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
            if (xDebuggerManager == null || (xDebuggerManager = xDebuggerManager.getBreakpointManager()) == null) {
                return null;
            }
            XDebuggerManager breakpointManager = xDebuggerManager;
            XBreakpoint[] xBreakpointArray = breakpointManager.getAllBreakpoints();
            Intrinsics.checkNotNullExpressionValue((Object)xBreakpointArray, (String)"getAllBreakpoints(...)");
            for (Object object2 : (Object[])xBreakpointArray) {
                XBreakpoint b = (XBreakpoint)object2;
                boolean bl = false;
                if (!(b instanceof XLineBreakpoint && Intrinsics.areEqual((Object)((XLineBreakpoint)b).getFileUrl(), (Object)position.getFile().getUrl()) && ((XLineBreakpoint)b).getLine() == position.getLine())) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (XBreakpoint)object;
    }

    @Nullable
    public final String asString(@NotNull Transferable $this$asString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        try {
            object = $this$asString.getTransferData(DataFlavor.stringFlavor);
            object = object instanceof String ? (String)object : null;
        }
        catch (IOException ex) {
            object = null;
        }
        catch (UnsupportedFlavorException ex) {
            object = null;
        }
        return object;
    }

    @Nullable
    public final TextFragment getSelection(@NotNull Editor $this$getSelection) {
        TextFragment textFragment;
        Intrinsics.checkNotNullParameter((Object)$this$getSelection, (String)"<this>");
        SelectionModel $this$getSelection_u24lambda_u240 = $this$getSelection.getSelectionModel();
        boolean bl = false;
        if ($this$getSelection_u24lambda_u240.getSelectedText() != null) {
            int n = $this$getSelection_u24lambda_u240.getSelectionStart();
            int n2 = $this$getSelection_u24lambda_u240.getSelectionEnd();
            String string = $this$getSelection_u24lambda_u240.getSelectedText();
            Intrinsics.checkNotNull((Object)string);
            textFragment = new TextFragment(n, n2, string);
        } else {
            textFragment = null;
        }
        return textFragment;
    }
}

