/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.Session;

public class MonarchSession
extends Session {
    private static final Logger logger = Logger.getLogger(MonarchSession.class.getName());
    private final ServerPlayer serverPlayer;
    private final Monarch.MonarchAction action;
    private final int tax;
    private Goods goods = null;
    private List<AbstractUnit> mercenaries = null;
    private final int price;

    public MonarchSession(ServerPlayer serverPlayer, Monarch.MonarchAction action, int tax, Goods goods) {
        super(MonarchSession.makeSessionKey(MonarchSession.class, serverPlayer.getId(), ""));
        this.serverPlayer = serverPlayer;
        this.action = action;
        this.tax = tax;
        this.goods = goods;
        this.mercenaries = null;
        this.price = 0;
    }

    public MonarchSession(ServerPlayer serverPlayer, Monarch.MonarchAction action, List<AbstractUnit> mercenaries, int price) {
        super(MonarchSession.makeSessionKey(MonarchSession.class, serverPlayer.getId(), ""));
        this.serverPlayer = serverPlayer;
        this.action = action;
        this.tax = 0;
        this.goods = null;
        this.mercenaries = mercenaries;
        this.price = price;
    }

    private void completeInternal(Boolean result, ChangeSet cs) {
        switch (this.action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                if (result == null) {
                    this.serverPlayer.ignoreTax(this.tax, this.goods, cs);
                    break;
                }
                this.serverPlayer.csRaiseTax(this.tax, this.goods, result, cs);
                break;
            }
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                if (result == null) {
                    this.serverPlayer.ignoreMercenaries(cs);
                    break;
                }
                if (!result.booleanValue()) break;
                this.serverPlayer.csAddMercenaries(this.mercenaries, this.price, null, cs);
                break;
            }
        }
    }

    public boolean complete(boolean result, ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(result, cs);
        }
        return ret;
    }

    @Override
    public boolean complete(ChangeSet cs) {
        boolean ret = super.complete(cs);
        if (!ret) {
            this.completeInternal(null, cs);
        }
        return ret;
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public int getTax() {
        return this.tax;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public List<AbstractUnit> getMercenaries() {
        return this.mercenaries;
    }

    public int getPrice() {
        return this.price;
    }
}

