/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service;

import com.amazon.aes.service.RegionMapping;
import com.amazon.aes.service.RegionMappingFactory;
import com.amazon.aes.util.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public abstract class RegionMappingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMapping createRegionMappingFromFile(RegionMappingFactory regionMappingFactory, File file, String charsetName) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charsetName);
        try {
            RegionMapping regionMapping = regionMappingFactory.createRegionMapping(reader);
            return regionMapping;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMapping createRegionMappingFromUrl(RegionMappingFactory regionMappingFactory, String url) throws IOException {
        HttpClient httpClient = HttpUtils.getClient();
        GetMethod getMethod = new GetMethod(url);
        getMethod.setFollowRedirects(true);
        int code = httpClient.executeMethod((HttpMethod)getMethod);
        if (code != 200) {
            throw new IOException("Could not fetch mapping. HTTP code: " + code);
        }
        String charset = getMethod.getResponseCharSet();
        if (charset == null) {
            charset = "ISO8859_1";
        }
        InputStreamReader reader = new InputStreamReader(getMethod.getResponseBodyAsStream(), charset);
        try {
            RegionMapping regionMapping = regionMappingFactory.createRegionMapping(reader);
            return regionMapping;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

