/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal.bridges;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.ops4j.pax.logging.log4j2.internal.spi.PaxLoggingEventImpl;
import org.ops4j.pax.logging.spi.support.PaxAppenderProxy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Plugin(name="PaxOsgi", category="Core", elementType="appender", printObject=true)
public class PaxOsgiAppender
extends AbstractAppender {
    private final String filter;
    private PaxAppenderProxy proxy;

    public PaxOsgiAppender(String name, String filter) {
        super(name, null, null, true, Property.EMPTY_ARRAY);
        this.filter = filter == null || filter.isEmpty() ? "*" : filter;
    }

    @PluginFactory
    public static PaxOsgiAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="filter") String filter, @PluginConfiguration Configuration config) {
        if (name == null) {
            StatusLogger.getLogger().error("No name provided for PaxOsgiAppender");
            return null;
        }
        return new PaxOsgiAppender(name, filter);
    }

    @Override
    public void start() {
        BundleContext bundleContext = null;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            bundleContext = bundle.getBundleContext();
        }
        if (bundleContext == null) {
            throw new IllegalStateException("Can't determine BundleContext to use for PaxOsgiAppender");
        }
        this.proxy = new PaxAppenderProxy(bundleContext, this.filter);
        this.proxy.open();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.proxy != null) {
            this.proxy.close();
            this.proxy = null;
        }
    }

    @Override
    public void append(LogEvent event) {
        PaxAppenderProxy p = this.proxy;
        if (p != null) {
            p.doAppend(new PaxLoggingEventImpl(event));
        }
    }
}

