/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class MessageTypeAdapter
extends TypeAdapter<Message> {
    private static Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private final MessageJsonHandler handler;
    private final Gson gson;

    public MessageTypeAdapter(MessageJsonHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message read(JsonReader in) throws IOException, JsonIOException, JsonSyntaxException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String jsonrpc = null;
        String method = null;
        Either<String, Number> id = null;
        Object rawParams = null;
        Object rawResult = null;
        ResponseError responseError = null;
        try {
            block18: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "jsonrpc": {
                        jsonrpc = in.nextString();
                        continue block18;
                    }
                    case "id": {
                        if (in.peek() == JsonToken.NUMBER) {
                            id = Either.forRight(in.nextInt());
                            continue block18;
                        }
                        id = Either.forLeft(in.nextString());
                        continue block18;
                    }
                    case "method": {
                        method = in.nextString();
                        continue block18;
                    }
                    case "params": {
                        rawParams = this.parseParams(in, method);
                        continue block18;
                    }
                    case "result": {
                        rawResult = this.parseResult(in, id != null ? id.get().toString() : null);
                        continue block18;
                    }
                    case "error": {
                        responseError = (ResponseError)this.gson.fromJson(in, ResponseError.class);
                        continue block18;
                    }
                }
                in.skipValue();
            }
            Object params = this.parseParams(rawParams, method);
            Object result = this.parseResult(rawResult, id != null ? id.get().toString() : null);
            in.endObject();
            return this.createMessage(jsonrpc, id, method, params, result, responseError);
        }
        catch (JsonSyntaxException | MalformedJsonException | EOFException exception) {
            if (id == null && method == null) {
                throw exception;
            }
            Message message = this.createMessage(jsonrpc, id, method, rawParams, rawResult, responseError);
            MessageIssue issue = new MessageIssue("Message could not be parsed.", ResponseErrorCode.ParseError.getValue(), (Exception)exception);
            throw new MessageIssueException(message, issue);
        }
    }

    protected Object parseResult(JsonReader in, String id) throws JsonIOException, JsonSyntaxException {
        JsonRpcMethod jsonRpcMethod;
        String resolvedMethod;
        Type type = null;
        MethodProvider methodProvider = this.handler.getMethodProvider();
        if (methodProvider != null && id != null && (resolvedMethod = methodProvider.resolveMethod(id)) != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(resolvedMethod)) != null) {
            type = jsonRpcMethod.getReturnType();
            if (jsonRpcMethod.getReturnTypeAdapterFactory() != null) {
                TypeAdapter typeAdapter = jsonRpcMethod.getReturnTypeAdapterFactory().create(this.gson, TypeToken.get((Type)type));
                try {
                    if (typeAdapter != null) {
                        return typeAdapter.read(in);
                    }
                }
                catch (IOException exception) {
                    throw new JsonIOException((Throwable)exception);
                }
            }
        }
        return this.fromJson(in, type);
    }

    protected Object parseResult(Object result, String id) throws JsonSyntaxException {
        if (result instanceof JsonElement) {
            JsonRpcMethod jsonRpcMethod;
            String resolvedMethod;
            Type type = null;
            MethodProvider methodProvider = this.handler.getMethodProvider();
            if (methodProvider != null && (resolvedMethod = methodProvider.resolveMethod(id)) != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(resolvedMethod)) != null) {
                TypeAdapter typeAdapter;
                type = jsonRpcMethod.getReturnType();
                if (jsonRpcMethod.getReturnTypeAdapterFactory() != null && (typeAdapter = jsonRpcMethod.getReturnTypeAdapterFactory().create(this.gson, TypeToken.get((Type)type))) != null) {
                    return typeAdapter.fromJsonTree((JsonElement)result);
                }
            }
            return this.fromJson((JsonElement)result, type);
        }
        return result;
    }

    protected Object parseParams(JsonReader in, String method) throws IOException, JsonIOException {
        JsonToken next = in.peek();
        if (next == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Type[] parameterTypes = this.getParameterTypes(method);
        if (parameterTypes.length == 1) {
            if (next == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                Object singleParameter = this.fromJson(in, parameterTypes[0]);
                in.endArray();
                return singleParameter;
            }
            return this.fromJson(in, parameterTypes[0]);
        }
        if (parameterTypes.length > 1 && next == JsonToken.BEGIN_ARRAY) {
            ArrayList<Object> parameters = new ArrayList<Object>(parameterTypes.length);
            int index = 0;
            in.beginArray();
            while (in.hasNext()) {
                Type parameterType = index < parameterTypes.length ? parameterTypes[index] : null;
                Object parameter = this.fromJson(in, parameterType);
                parameters.add(parameter);
                ++index;
            }
            in.endArray();
            while (index < parameterTypes.length) {
                parameters.add(null);
                ++index;
            }
            return parameters;
        }
        JsonElement rawParams = JsonParser.parseReader((JsonReader)in);
        if (method != null && parameterTypes.length == 0 && (rawParams.isJsonArray() && rawParams.getAsJsonArray().size() == 0 || rawParams.isJsonObject() && rawParams.getAsJsonObject().size() == 0)) {
            return null;
        }
        return rawParams;
    }

    protected Object parseParams(Object params, String method) {
        if (this.isNull(params)) {
            return null;
        }
        if (!(params instanceof JsonElement)) {
            return params;
        }
        JsonElement rawParams = (JsonElement)params;
        Type[] parameterTypes = this.getParameterTypes(method);
        if (parameterTypes.length == 1) {
            return this.fromJson(rawParams, parameterTypes[0]);
        }
        if (parameterTypes.length > 1 && rawParams instanceof JsonArray) {
            JsonArray array = (JsonArray)rawParams;
            ArrayList<Object> parameters = new ArrayList<Object>(Math.max(array.size(), parameterTypes.length));
            int index = 0;
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                Type parameterType = index < parameterTypes.length ? parameterTypes[index] : null;
                Object parameter = this.fromJson((JsonElement)iterator.next(), parameterType);
                parameters.add(parameter);
                ++index;
            }
            while (index < parameterTypes.length) {
                parameters.add(null);
                ++index;
            }
            return parameters;
        }
        if (method != null && parameterTypes.length == 0 && (rawParams.isJsonArray() && rawParams.getAsJsonArray().size() == 0 || rawParams.isJsonObject() && rawParams.getAsJsonObject().size() == 0)) {
            return null;
        }
        return rawParams;
    }

    protected Object fromJson(JsonReader in, Type type) throws JsonIOException {
        if (this.isNullOrVoidType(type)) {
            return JsonParser.parseReader((JsonReader)in);
        }
        return this.gson.fromJson(in, type);
    }

    protected Object fromJson(JsonElement element, Type type) {
        if (this.isNull(element)) {
            return null;
        }
        if (this.isNullOrVoidType(type)) {
            return null;
        }
        Object value = this.gson.fromJson(element, type);
        if (this.isNull(value)) {
            return null;
        }
        return value;
    }

    protected boolean isNull(Object value) {
        return value == null || value instanceof JsonNull;
    }

    protected boolean isNullOrVoidType(Type type) {
        return type == null || Void.class == type;
    }

    protected Type[] getParameterTypes(String method) {
        JsonRpcMethod jsonRpcMethod;
        if (method != null && (jsonRpcMethod = this.handler.getJsonRpcMethod(method)) != null) {
            return jsonRpcMethod.getParameterTypes();
        }
        return EMPTY_TYPE_ARRAY;
    }

    protected Message createMessage(String jsonrpc, Either<String, Number> id, String method, Object params, Object responseResult, ResponseError responseError) throws JsonParseException {
        if (id != null && method != null) {
            RequestMessage message = new RequestMessage();
            message.setJsonHandler(this.handler);
            message.setJsonrpc(jsonrpc);
            message.setRawId(id);
            message.setMethod(method);
            message.setParams(params);
            return message;
        }
        if (id != null) {
            ResponseMessage message = new ResponseMessage();
            message.setJsonHandler(this.handler);
            message.setJsonrpc(jsonrpc);
            message.setRawId(id);
            if (responseError != null) {
                message.setError(responseError);
            } else {
                message.setResult(responseResult);
            }
            return message;
        }
        if (method != null) {
            NotificationMessage message = new NotificationMessage();
            message.setJsonHandler(this.handler);
            message.setJsonrpc(jsonrpc);
            message.setMethod(method);
            message.setParams(params);
            return message;
        }
        throw new JsonParseException("Unable to identify the input message.");
    }

    public void write(JsonWriter out, Message message) throws IOException {
        out.beginObject();
        out.name("jsonrpc");
        out.value(message.getJsonrpc() == null ? "2.0" : message.getJsonrpc());
        if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            out.name("id");
            this.writeId(out, requestMessage.getRawId());
            out.name("method");
            out.value(requestMessage.getMethod());
            out.name("params");
            Object params = requestMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.handleParameter(out, params, requestMessage.getMethod());
            }
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            out.name("id");
            this.writeId(out, responseMessage.getRawId());
            if (responseMessage.getError() != null) {
                out.name("error");
                this.gson.toJson((Object)responseMessage.getError(), ResponseError.class, out);
            } else {
                out.name("result");
                Object result = responseMessage.getResult();
                if (result == null) {
                    this.writeNullValue(out);
                } else {
                    this.gson.toJson(result, result.getClass(), out);
                }
            }
        } else if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            out.name("method");
            out.value(notificationMessage.getMethod());
            out.name("params");
            Object params = notificationMessage.getParams();
            if (params == null) {
                this.writeNullValue(out);
            } else {
                this.handleParameter(out, params, notificationMessage.getMethod());
            }
        }
        out.endObject();
    }

    protected void handleParameter(JsonWriter out, Object params, String method) {
        boolean needsWrap;
        boolean isSingleArray = this.getParameterTypes(method).length == 1 && Collection.class.isInstance(params) || params.getClass().isArray();
        boolean bl = needsWrap = isSingleArray || params instanceof String || MessageTypeAdapter.isWrapperType(params.getClass()) || MessageTypeAdapter.isPrimitive(((Object)((Object)this)).getClass());
        if (needsWrap) {
            this.gson.toJson(List.of(params), List.class, out);
        } else {
            this.gson.toJson(params, params.getClass(), out);
        }
    }

    protected void writeId(JsonWriter out, Either<String, Number> id) throws IOException {
        if (id == null) {
            this.writeNullValue(out);
        } else if (id.isLeft()) {
            out.value(id.getLeft());
        } else if (id.isRight()) {
            out.value(id.getRight());
        }
    }

    protected void writeNullValue(JsonWriter out) throws IOException {
        boolean previousSerializeNulls = out.getSerializeNulls();
        out.setSerializeNulls(true);
        out.nullValue();
        out.setSerializeNulls(previousSerializeNulls);
    }

    private static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    private static boolean isWrapperType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final MessageJsonHandler handler;

        public Factory(MessageJsonHandler handler) {
            this.handler = handler;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Message.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new MessageTypeAdapter(this.handler, gson);
        }
    }
}

