/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.maven.dependency.ArtifactCoords;

public class PlatformInfo {
    private final ArtifactCoords imported;
    private final ArtifactCoords recommended;

    public PlatformInfo(ArtifactCoords imported, ArtifactCoords recommended) {
        this.imported = imported;
        this.recommended = recommended;
    }

    public ArtifactCoords getImported() {
        return this.imported;
    }

    public ArtifactCoords getRecommended() {
        return this.recommended;
    }

    public boolean isVersionUpdateRecommended() {
        return this.imported != null && this.recommended != null && !this.imported.getVersion().equals(this.recommended.getVersion());
    }

    public String getRecommendedVersion() {
        return this.recommended == null ? null : this.recommended.getVersion();
    }

    public boolean isImported() {
        return this.imported != null;
    }

    public boolean isToBeImported() {
        return this.imported == null && this.recommended != null;
    }

    public ArtifactCoords getRecommendedCoords() {
        return this.recommended == null ? this.imported : this.recommended;
    }

    public String getRecommendedProviderKey() {
        if (this.recommended != null) {
            return ExtensionProvider.key(this.recommended, true);
        }
        return ExtensionProvider.key(this.imported, true);
    }
}

