/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Primitive;
import com.ca.commons.security.asn1.Sequence;
import java.io.Serializable;

public class Context
extends ASN1Object
implements Serializable {
    private ASN1Object value;
    private boolean implicit;
    private int tag;

    public Context() {
    }

    public Context(int t, boolean imp, ASN1Object o) {
        this.asn1Type = ASN1Type.ContextSpecific;
        this.byteArray = null;
        this.tag = t;
        this.implicit = imp;
        if (o instanceof Primitive) {
            this.value = o;
        } else if (o instanceof Sequence) {
            this.value = o;
        } else if (o instanceof Context) {
            this.value = o;
        } else {
            throw new IllegalArgumentException("invalid ContextSpecific underlying object");
        }
    }

    public void init(ASN1Type type) {
        this.asn1Type = type;
        this.byteArray = null;
        this.implicit = false;
        this.tag = 0;
        this.value = null;
    }

    public void setValue(Object o) {
        if (!(o instanceof Context)) {
            throw new IllegalArgumentException("incompatible type");
        }
        Context obj = (Context)o;
        this.tag = obj.getTag();
        this.value = (ASN1Object)obj.getValue();
        this.implicit = obj.implicit();
    }

    public Object getValue() {
        return this.value;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean implicit() {
        return this.implicit;
    }

    public String toString() {
        String s = super.toString();
        s = s + "\n\tcontext specific tag [" + this.tag + "] implicit? " + this.implicit;
        s = s + "\n\tunderlying type: " + this.value.toString();
        return s;
    }
}

