/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.formatting;

import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.capabilities.Capability;

public final class CapabilitiesDescriber {
    private CapabilitiesDescriber() {
    }

    public static String describeCapabilitiesWithTitle(Collection<? extends Capability> capabilities) {
        StringBuilder sb = new StringBuilder("capabilit");
        if (capabilities.size() > 1) {
            sb.append("ies ");
        } else {
            sb.append("y ");
        }
        sb.append(CapabilitiesDescriber.describeCapabilities(capabilities));
        return sb.toString();
    }

    public static String describeCapabilities(Collection<? extends Capability> capabilities) {
        return capabilities.stream().map(CapabilitiesDescriber::describeCapability).sorted().collect(Collectors.joining(" and "));
    }

    private static String describeCapability(Capability c) {
        String version = c.getVersion();
        if (version != null) {
            return '\'' + c.getGroup() + ":" + c.getName() + ":" + c.getVersion() + '\'';
        }
        return '\'' + c.getGroup() + ":" + c.getName() + '\'';
    }
}

