/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.GraphicsBox;
import org.scilab.forge.jlatexmath.ParseOption;
import org.scilab.forge.jlatexmath.ResizeAtom;
import org.scilab.forge.jlatexmath.RotateAtom;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphicsAtom
extends Atom {
    private Image a;
    private BufferedImage a;
    private Label a;
    private int d;
    private int e;
    private Atom a;
    private boolean a = true;
    private int f = -1;

    public GraphicsAtom(String string, String string2) {
        Serializable serializable;
        File file = new File(string);
        if (!file.exists()) {
            try {
                serializable = new URL(string);
                this.a = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            }
            catch (MalformedURLException malformedURLException) {
                this.a = null;
            }
        } else {
            this.a = Toolkit.getDefaultToolkit().getImage(string);
        }
        if (this.a != null) {
            this.a = new Label();
            serializable = new MediaTracker(this.a);
            ((MediaTracker)serializable).addImage(this.a, 0);
            try {
                ((MediaTracker)serializable).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                this.a = null;
            }
        }
        this.draw();
        this.buildAtom(string2);
    }

    protected void buildAtom(String string) {
        this.a = this;
        Map map = ParseOption.parseMap(string);
        if (map.containsKey("width") || map.containsKey("height")) {
            this.a = new ResizeAtom(this.a, (String)map.get("width"), (String)map.get("height"), map.containsKey("keepaspectratio"));
        }
        if (map.containsKey("scale")) {
            double d = Double.parseDouble((String)map.get("scale"));
            this.a = new ScaleAtom(this.a, d, d);
        }
        if (map.containsKey("angle") || map.containsKey("origin")) {
            this.a = new RotateAtom(this.a, (String)map.get("angle"), (String)map.get("origin"));
        }
        if (map.containsKey("interpolation")) {
            String string2 = (String)map.get("interpolation");
            if (string2.equalsIgnoreCase("bilinear")) {
                this.f = 0;
            } else if (string2.equalsIgnoreCase("bicubic")) {
                this.f = 2;
            } else if (string2.equalsIgnoreCase("nearest_neighbor")) {
                this.f = 1;
            }
        }
    }

    public void draw() {
        if (this.a != null) {
            this.d = this.a.getWidth(this.a);
            this.e = this.a.getHeight(this.a);
            this.a = new BufferedImage(this.d, this.e, 2);
            Graphics2D graphics2D = this.a.createGraphics();
            graphics2D.drawImage(this.a, 0, 0, null);
            graphics2D.dispose();
        }
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.a != null) {
            if (this.a) {
                this.a = false;
                return this.a.createBox(teXEnvironment);
            }
            teXEnvironment.a = true;
            float f = (float)this.d * SpaceAtom.getFactor(2, teXEnvironment);
            float f2 = (float)this.e * SpaceAtom.getFactor(2, teXEnvironment);
            return new GraphicsBox(this.a, f, f2, teXEnvironment.getSize(), this.f);
        }
        return new TeXFormula((String)"\\text{ No such image file ! }").a.createBox(teXEnvironment);
    }
}

