/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPSchema;

public class XMPSchemaAdapter {
    private static DateFormat pseudoISO8601DateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
    protected Metadata meta;
    private XMPSchema schema;

    public XMPSchemaAdapter(Metadata meta, XMPSchema schema) {
        if (meta == null) {
            throw new NullPointerException("Parameter meta must not be null");
        }
        if (schema == null) {
            throw new NullPointerException("Parameter schema must not be null");
        }
        this.meta = meta;
        this.schema = schema;
    }

    public XMPSchema getSchema() {
        return this.schema;
    }

    protected QName getQName(String propName) {
        return new QName(this.getSchema().getNamespace(), propName);
    }

    private void addStringToArray(String propName, String value, XMPArrayType arrayType) {
        QName name = this.getQName(propName);
        XMPProperty prop = this.meta.getProperty(name);
        if (prop == null) {
            XMPArray array = new XMPArray(arrayType);
            array.add(value);
            prop = new XMPProperty(name, array);
            this.meta.setProperty(prop);
        } else {
            prop.convertSimpleValueToArray(arrayType);
            prop.getArrayValue().add(value);
        }
    }

    protected void addStringToSeq(String propName, String value) {
        this.addStringToArray(propName, value, XMPArrayType.SEQ);
    }

    protected void addStringToBag(String propName, String value) {
        this.addStringToArray(propName, value, XMPArrayType.BAG);
    }

    public static String formatISO8601Date(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int offset = cal.get(15);
        Date dt1 = new Date(dt.getTime() + (long)(offset += cal.get(16)));
        StringBuffer sb = new StringBuffer(pseudoISO8601DateFormat.format(dt1));
        if ((offset /= 60000) == 0) {
            sb.append('Z');
        } else {
            int zoneOffsetHours = offset / 60;
            int zoneOffsetMinutes = Math.abs(offset % 60);
            if (zoneOffsetHours > 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (zoneOffsetHours < 10) {
                sb.append('0');
            }
            sb.append(zoneOffsetHours);
            sb.append(':');
            if (zoneOffsetMinutes < 10) {
                sb.append('0');
            }
            sb.append(zoneOffsetMinutes);
        }
        return sb.toString();
    }

    public static Date parseISO8601Date(String dt) {
        Date d;
        String parsablePart;
        int offset = 0;
        if (dt.endsWith("Z")) {
            parsablePart = dt.substring(0, dt.length() - 1);
        } else {
            int neg = 1;
            int pos = dt.lastIndexOf(43);
            if (pos < 0) {
                pos = dt.lastIndexOf(45);
                neg = -1;
            }
            if (pos >= 0) {
                String timeZonePart = dt.substring(pos);
                parsablePart = dt.substring(0, pos);
                offset = Integer.parseInt(timeZonePart.substring(1, 3)) * 60;
                offset += Integer.parseInt(timeZonePart.substring(4, 6));
                offset *= neg;
            } else {
                parsablePart = dt;
            }
        }
        try {
            d = pseudoISO8601DateFormat.parse(parsablePart);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid ISO 8601 date format: " + dt);
        }
        d.setTime(d.getTime() - (long)(offset * 60 * 1000));
        return d;
    }

    protected void addDateToSeq(String propName, Date value) {
        String dt = XMPSchemaAdapter.formatISO8601Date(value);
        this.addStringToSeq(propName, dt);
    }

    protected void setDateValue(String propName, Date value) {
        String dt = XMPSchemaAdapter.formatISO8601Date(value);
        this.setValue(propName, dt);
    }

    protected Date getDateValue(String propName) {
        String dt = this.getValue(propName);
        if (dt == null) {
            return null;
        }
        return XMPSchemaAdapter.parseISO8601Date(dt);
    }

    protected void setLangAlt(String propName, String lang, String value) {
        QName name;
        XMPProperty prop;
        if (lang == null) {
            lang = "x-default";
        }
        if ((prop = this.meta.getProperty(name = this.getQName(propName))) == null) {
            XMPArray array = new XMPArray(XMPArrayType.ALT);
            array.add(value, lang);
            prop = new XMPProperty(name, array);
            this.meta.setProperty(prop);
        } else {
            prop.convertSimpleValueToArray(XMPArrayType.ALT);
            this.removeLangAlt(lang, propName);
            prop.getArrayValue().add(value, lang);
        }
    }

    protected void setValue(String propName, String value) {
        QName name = this.getQName(propName);
        XMPProperty prop = this.meta.getProperty(name);
        if (prop == null) {
            prop = new XMPProperty(name, value);
            this.meta.setProperty(prop);
        } else {
            prop.setValue(value);
        }
    }

    protected String getValue(String propName) {
        QName name = this.getQName(propName);
        XMPProperty prop = this.meta.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue().toString();
    }

    protected void removeLangAlt(String lang, String propName) {
        XMPProperty prop = this.meta.getProperty(this.getQName(propName));
        if (prop != null && lang != null) {
            XMPArray array = prop.getArrayValue();
            if (array != null) {
                array.removeLangValue(lang);
            } else if (lang.equals(prop.getXMLLang())) {
                prop.setValue(null);
                prop.setXMLLang(null);
            }
        }
    }

    protected String getLangAlt(String lang, String propName) {
        XMPProperty prop = this.meta.getProperty(this.getQName(propName));
        if (prop == null) {
            return null;
        }
        XMPArray array = prop.getArrayValue();
        if (array != null) {
            return array.getLangValue(lang);
        }
        return prop.getValue().toString();
    }

    protected Object[] getObjectArray(String propName) {
        XMPProperty prop = this.meta.getProperty(this.getQName(propName));
        if (prop == null) {
            return null;
        }
        XMPArray array = prop.getArrayValue();
        if (array != null) {
            return array.toObjectArray();
        }
        return new Object[]{prop.getValue()};
    }

    protected String[] getStringArray(String propName) {
        Object[] arr = this.getObjectArray(propName);
        if (arr == null) {
            return null;
        }
        String[] res = new String[arr.length];
        int c = res.length;
        for (int i = 0; i < c; ++i) {
            res[i] = arr[i].toString();
        }
        return res;
    }

    static {
        pseudoISO8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

