/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.dialogs;

import de.escape.quincunx.gimmicks.DoubleTextField;
import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.PhysicalLength;
import de.escape.quincunx.i18n.RPanel;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;

public class LengthChooser
extends RPanel {
    public static final LengthUnit[] DEFAULT_UNITS = new LengthUnit[]{LengthUnit.MILLIMETER, LengthUnit.INCH};
    public static final String PROPERTY_UNIT = "UNIT";
    public static final String PROPERTY_VALUE = "VALUE";
    public static final String PROPERTY_VALIDITY = "VALIDITY";
    private DoubleTextField inputField;
    private Choice unitChoice;
    private int lastIndex;
    private Label unitLabel;
    private LengthUnit[] units;
    private double lastValue;
    private boolean lastValid;
    private PropertyChangeSupport myChangeSupport;

    public LengthChooser() {
        this(null, DEFAULT_UNITS[0], DEFAULT_UNITS);
    }

    private void initInputField(PhysicalLength length, LengthUnit unit) {
        this.lastValue = length != null ? length.getLength(unit) : 0.0;
        this.inputField = new DoubleTextField(this.lastValue);
        this.inputField.addTextListener(new 1());
        this.add("Center", this.inputField);
        this.lastValid = this.inputField.isValid();
    }

    private void setValid(boolean valid) {
        if (valid != this.lastValid) {
            this.lastValid = valid;
            this.firePropertyChange(PROPERTY_VALIDITY, !valid ? Boolean.TRUE : Boolean.FALSE, valid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public LengthChooser(PhysicalLength length, LengthUnit unit) {
        super(new BorderLayout());
        this.units = new LengthUnit[]{unit};
        this.initInputField(length, unit);
        this.unitLabel = new Label(unit.toString());
        this.add("East", this.unitLabel);
    }

    public LengthChooser(PhysicalLength length, LengthUnit unit, LengthUnit[] unitsChoice) {
        super(new BorderLayout());
        this.units = unitsChoice;
        this.initInputField(length, unit);
        this.unitChoice = new Choice();
        int u = 0;
        while (u < unitsChoice.length) {
            this.unitChoice.add(unitsChoice[u].toString());
            ++u;
        }
        this.setUnit(unit);
        this.unitChoice.addItemListener(new 2());
        this.add("East", this.unitChoice);
    }

    public void setLength(PhysicalLength length) {
        this.inputField.setValue(length.getLength(this.units[this.lastIndex]));
    }

    public PhysicalLength getLength() {
        try {
            if (this.inputField.isValid()) {
                return new PhysicalLength(this.inputField.getValue(), this.units[this.lastIndex]);
            }
        }
        catch (ParseException parseException) {}
        return null;
    }

    public void setUnit(LengthUnit unit) {
        if (this.unitLabel != null) {
            this.unitLabel.setText(unit.toString());
            try {
                this.lastValue = this.inputField.getValue();
            }
            catch (ParseException parseException) {}
            this.inputField.setValue(unit.otherToUnit(this.lastValue, this.units[0]));
            this.units[0] = unit;
        } else {
            int u = 0;
            while (u < this.units.length) {
                if (this.units[u].equals(unit)) {
                    this.unitChoice.select(u);
                    return;
                }
                ++u;
            }
            LengthUnit[] temp = new LengthUnit[this.units.length + 1];
            System.arraycopy(this.units, 0, temp, 0, this.units.length);
            temp[this.units.length] = unit;
            this.units = temp;
            this.unitChoice.add(unit.toString());
            this.unitChoice.select(this.units.length - 1);
        }
    }

    public LengthUnit getUnit() {
        if (this.unitChoice == null) {
            return this.units[0];
        }
        return this.units[this.unitChoice.getSelectedIndex()];
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.myChangeSupport == null) {
            this.myChangeSupport = new PropertyChangeSupport(this);
        }
        this.myChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.myChangeSupport == null) {
            return;
        }
        this.myChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeSupport myChangeSupport = this.myChangeSupport;
        if (myChangeSupport == null) {
            return;
        }
        myChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    public boolean isValid() {
        return this.inputField.isValid();
    }

    private final class 1
    implements TextListener {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void textValueChanged(TextEvent e) {
            if (LengthChooser.this.inputField.isValid()) {
                LengthChooser.this.setValid(true);
                try {
                    double value = LengthChooser.this.inputField.getValue();
                    if (value == LengthChooser.this.lastValue) return;
                    LengthUnit einheit = LengthChooser.this.getUnit();
                    LengthChooser.this.firePropertyChange(LengthChooser.PROPERTY_VALUE, new PhysicalLength(LengthChooser.this.lastValue, einheit), new PhysicalLength(value, einheit));
                    LengthChooser.this.lastValue = value;
                    return;
                }
                catch (ParseException x) {
                    throw new InternalError("Unexpected Exception: " + x);
                }
            } else {
                LengthChooser.this.setValid(false);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            int index = LengthChooser.this.unitChoice.getSelectedIndex();
            if (index != LengthChooser.this.lastIndex) {
                LengthChooser.this.firePropertyChange(LengthChooser.PROPERTY_UNIT, LengthChooser.this.units[LengthChooser.this.lastIndex], LengthChooser.this.units[index]);
                try {
                    LengthChooser.this.lastValue = LengthChooser.this.inputField.getValue();
                }
                catch (ParseException parseException) {}
                LengthChooser.this.inputField.setValue(LengthChooser.this.units[index].otherToUnit(LengthChooser.this.lastValue, LengthChooser.this.units[LengthChooser.this.lastIndex]));
                LengthChooser.this.lastIndex = index;
            }
        }

        /* synthetic */ 2() {
        }
    }
}

