/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 + 0.0) => 0.0
 * (0.0 + -1.33) => -1.33
 * (0.0 + 0.85) => 0.85
 * (-1.33 + 0.0) => -1.33
 * (-1.33 + -1.33) => -2.66
 * (-1.33 + 0.85) => -0.48000002
 * (0.85 + 0.0) => 0.85
 * (0.85 + -1.33) => -0.48000002
 * (0.85 + 0.85) => 1.7
 */
#version 150

void main()
{
  float[distance((0.0 + 0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance((0.0 + -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array1;
  float[distance((0.0 + 0.85), 0.85) <= 8.5e-06 ? 1 : -1] array2;
  float[distance((-1.33 + 0.0), -1.33) <= 1.33e-05 ? 1 : -1] array3;
  float[distance((-1.33 + -1.33), -2.66) <= 2.66e-05 ? 1 : -1] array4;
  float[distance((-1.33 + 0.85), -0.48000002) <= 4.8e-06 ? 1 : -1] array5;
  float[distance((0.85 + 0.0), 0.85) <= 8.5e-06 ? 1 : -1] array6;
  float[distance((0.85 + -1.33), -0.48000002) <= 4.8e-06 ? 1 : -1] array7;
  float[distance((0.85 + 0.85), 1.7) <= 1.7e-05 ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
